/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.unit.scdatahandle;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.helper.multisystemjoint.business.ScDataMultiJointChannelMetaHelper;
import kd.scm.common.helper.multisystemjoint.entity.ScDataMultiJointChannelInfo;
import kd.scm.common.helper.scdatahandle.ScDataHandleResult;
import kd.scm.common.helper.scdatahandle.channel.ScChannelHandleService;
import kd.scm.common.helper.scdatahandle.channel.ScDataHandleChannelServiceTypes;

public final class ScDataHandleServiceHelperUnitTest {
    private static Log log = LogFactory.getLog((String)ScDataHandleServiceHelperUnitTest.class.getName());

    public static ScDataHandleResult executeHandle(String dataHandleKey, DynamicObject[] dataEntities, String connectErp) {
        ScDataMultiJointChannelInfo channelNumber = ScDataHandleServiceHelperUnitTest.getChannelNumber(connectErp);
        ScChannelHandleService scChannelHandleService = ScDataHandleServiceHelperUnitTest.initializeService(channelNumber, dataHandleKey, dataEntities);
        ScDataHandleResult scDataHandleResult = new ScDataHandleResult();
        try {
            scChannelHandleService.excute(dataEntities);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return scDataHandleResult;
    }

    private static ScDataMultiJointChannelInfo getChannelNumber(String connectErp) {
        ScDataMultiJointChannelInfo scDataChannelInfo = null;
        DynamicObject scdatachannel = BusinessDataServiceHelper.loadSingleFromCache((String)"pbd_scdatachannel", (QFilter[])new QFilter[]{new QFilter("connecterp", "=", (Object)connectErp).and(new QFilter("enable", "=", (Object)"1"))});
        if (scdatachannel != null) {
            scDataChannelInfo = new ScDataMultiJointChannelInfo();
            scDataChannelInfo.setChannelId(scdatachannel.getString("id"));
            scDataChannelInfo.setChannelNumber(scdatachannel.getString("number"));
            scDataChannelInfo.setChannelClass(scdatachannel.getString("channelclass"));
            DynamicObject isclink = scdatachannel.getDynamicObject("isclink");
            if (isclink != null) {
                scDataChannelInfo.setIscLink(Long.valueOf(isclink.getLong("id")));
                scDataChannelInfo.setDatabaseType(isclink.getString("database_type"));
            }
            scDataChannelInfo.setConnecterp(scdatachannel.getString("connecterp"));
            ScDataMultiJointChannelMetaHelper.putScDataChannelInfoCache((String)scDataChannelInfo.getChannelNumber(), (ScDataMultiJointChannelInfo)scDataChannelInfo);
        }
        return scDataChannelInfo == null ? ScDataMultiJointChannelMetaHelper.getScDataChannelInfo((String)"") : scDataChannelInfo;
    }

    private static ScChannelHandleService initializeService(ScDataMultiJointChannelInfo channelNumber, String dataChannelKey, DynamicObject[] dataEntities) {
        ScChannelHandleService scChannelHandleService = (ScChannelHandleService)ScDataHandleChannelServiceTypes.createEntityOperate((ScDataMultiJointChannelInfo)channelNumber);
        ScDataMultiJointChannelInfo scDataChannelInfo = ScDataMultiJointChannelMetaHelper.getScDataChannelInfo((String)channelNumber.getChannelNumber());
        scChannelHandleService.initialize(scDataChannelInfo, dataChannelKey, dataEntities);
        return scChannelHandleService;
    }
}

