/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.plugin;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.SecureRandom;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.web.actions.utils.FilePathUtil;
import kd.scm.common.ORMUtil;
import kd.scm.common.util.QueryRecordUtil;
import kd.scm.common.util.SrmCommonUtil;

public class SupplierFastChgEdit
extends AbstractBillPlugIn {
    private Log log = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());
    public static final String FAST_SUBCHANGE_TAG = "supchange_id";
    private static final String PROVINCE = "province";
    private static final String CTIY = "city";
    private static final FileService fileService = FileServiceFactory.getAttachmentFileService();
    private static final TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();

    public void afterLoadData(EventObject e) {
        DynamicObjectCollection picRows;
        super.afterLoadData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object supchange_id = formShowParameter.getCustomParams().get(FAST_SUBCHANGE_TAG);
        if (Objects.isNull(supchange_id)) {
            return;
        }
        String entityName = this.getModel().getDataEntity().getDataEntityType().getName();
        DynamicObjectCollection rows = this.getEntryentity(supchange_id, entityName, "entryentity");
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if (!CollectionUtils.isEmpty((Collection)rows)) {
            HashMap<String, HashMap<String, DynamicObject>> newEntryRowMap = new HashMap<String, HashMap<String, DynamicObject>>(16);
            for (DynamicObject row : rows) {
                String entryname = row.getString("entryname").trim();
                String fieldname = row.getString("fieldname");
                String seq = row.getString("srcentryid").trim();
                String srcbillentryid = row.getString("srcbillentryid").trim();
                String infoType = row.getString("infoType");
                String other = row.getString("other");
                Object value = this.bulidValue(dataEntity, infoType, row, entryname, fieldname);
                if ("1".equals(srcbillentryid) && StringUtils.isNotBlank((CharSequence)entryname)) {
                    srcbillentryid = this.getRealEntryId(dataEntity, entryname, seq);
                }
                Object newvalue = this.bulidNewValue(value, infoType, row);
                String key = seq + "-" + srcbillentryid;
                this.setChgValue(newEntryRowMap, entryname, fieldname, newvalue, key, entityName, other);
                if (!"M".equals(infoType) || StringUtils.isEmpty((CharSequence)entryname)) continue;
                this.setEnterMuBaseDateModel(entryname, fieldname);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(picRows = this.getEntryentity(supchange_id, entityName, "picchangedentry")))) {
            for (DynamicObject picRow : picRows) {
                String afterpicture = picRow.getString("afterpicture");
                String pictureno = picRow.getString("pictureno");
                this.getModel().setValue(pictureno, (Object)afterpicture);
            }
        }
        this.setAttachment(supchange_id, "attachmentpanel");
        this.setAttachment(supchange_id, "attachmentpanel1");
        this.setAttachment(supchange_id, "companyequitystructureatt");
        try {
            String selects = "id,number,entryentity1.newattachment";
            String field = "entryentity1.newattachment";
            Set<String> newAttachFields = this.getConfigFieldsSet(selects, field);
            for (String newAttachField : newAttachFields) {
                this.setAttachment(supchange_id, newAttachField);
            }
        }
        catch (Exception ex) {
            this.log.info("\u7ee7\u7eed\u53d8\u66f4copy\u9644\u4ef6\u65f6\u8bfb\u53d6\u914d\u7f6e\u5f02\u5e38" + ex.getMessage());
        }
        this.entryRowDelete();
    }

    private String getRealEntryId(DynamicObject dataEntity, String entryName, String seq) {
        String entryId = "0";
        if (StringUtils.isBlank((CharSequence)entryName)) {
            return entryId;
        }
        DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection(entryName);
        for (DynamicObject entryRow : entry) {
            String seq1 = entryRow.getString("seq");
            if (!StringUtils.isNotBlank((CharSequence)seq1) || !seq1.equals(seq)) continue;
            entryId = entryRow.getString("id");
            break;
        }
        return entryId;
    }

    private Set<String> getConfigFieldsSet(String selects, String field) {
        HashSet<String> result = new HashSet<String>(16);
        DynamicObjectCollection query = this.queryConfig(selects);
        for (DynamicObject entryRow : query) {
            String fieldname = entryRow.getString(field);
            if (!StringUtils.isNotBlank((CharSequence)fieldname)) continue;
            result.add(fieldname);
        }
        return result;
    }

    private DynamicObjectCollection queryConfig(String selects) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"pbd_supchgcfmparam", (String)selects, (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")});
        return query;
    }

    private void entryRowDelete() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DataEntityPropertyCollection entityproperties = dataEntity.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : entityproperties) {
            if (!(property instanceof EntryProp)) continue;
            this.deleteNullEntryRow(dataEntity, property.getName());
        }
    }

    private void deleteNullEntryRow(DynamicObject dataEntity, String entryName) {
        DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection(entryName);
        if (!entry.isEmpty()) {
            DynamicObject row = (DynamicObject)entry.get(0);
            DataEntityPropertyCollection properties = row.getDynamicObjectType().getProperties();
            HashSet<String> fieldsName = new HashSet<String>(16);
            for (IDataEntityProperty property : properties) {
                String name;
                if (property instanceof BooleanProp || "id".equals(name = property.getName()) || "seq".equals(name)) continue;
                if (name.contains("_id")) {
                    name = name.replace("_id", "");
                }
                fieldsName.add(name);
            }
            MainEntityType mainType = (MainEntityType)dataEntity.getDataEntityType();
            EntryProp entryProp = (EntryProp)mainType.getProperties().get((Object)entryName);
            String key = entryProp.getKeyFieldId();
            Iterator iterator = entry.iterator();
            while (iterator.hasNext()) {
                boolean isNull = true;
                DynamicObject next = (DynamicObject)iterator.next();
                if (key == null) {
                    for (String field : fieldsName) {
                        Object o = next.get(field);
                        if (o == null || !(!(o instanceof MulBasedataDynamicObjectCollection) && !(o instanceof DynamicObjectCollection) && StringUtils.isNotBlank((CharSequence)o.toString()) || o instanceof MulBasedataDynamicObjectCollection && ((MulBasedataDynamicObjectCollection)o).size() != 0) && (!(o instanceof DynamicObjectCollection) || ((DynamicObjectCollection)o).size() == 0)) continue;
                        isNull = false;
                        break;
                    }
                    if (!isNull) continue;
                    iterator.remove();
                    continue;
                }
                Object keyFieldValue = next.get(key);
                if (keyFieldValue != null && !keyFieldValue.toString().trim().equals("") && (!(keyFieldValue instanceof DynamicObjectCollection) || !((DynamicObjectCollection)keyFieldValue).isEmpty()) && (!"indextype".equals(key) || !"0".equals(keyFieldValue))) continue;
                iterator.remove();
            }
        }
    }

    private void setAttachment(Object supchange_id, String attpanelName) {
        AttachmentPanel attach = (AttachmentPanel)this.getView().getControl(attpanelName);
        List attachmentData = attach.getAttachmentData();
        HashSet<String> attNameSet = new HashSet<String>(16);
        HashMap<String, Long> attSizeMap = new HashMap<String, Long>(16);
        for (Map att : attachmentData) {
            String name = (String)att.get("name");
            Long size = (Long)att.get("size");
            attNameSet.add(name);
            if (size == null) continue;
            attSizeMap.put(name, Long.parseLong(size.toString()));
        }
        List attachments = AttachmentServiceHelper.getAttachments((String)"srm_supchange", (Object)supchange_id, (String)attpanelName);
        ArrayList newAttachments = new ArrayList(attachments.size());
        for (Map attachment : attachments) {
            String tempUrl;
            HashMap<String, String> newAttachment = new HashMap<String, String>(16);
            String url = (String)attachment.get("url");
            String name = (String)attachment.get("name");
            Long size = (Long)attachment.get("size");
            if (!url.contains("attachment/download.do") || attNameSet.contains(name) && ((Long)attSizeMap.get(name)).longValue() == size.longValue() || !StringUtils.isNotBlank((CharSequence)(tempUrl = this.saveAsTempFile(url, name)))) continue;
            newAttachment.put("url", tempUrl);
            newAttachment.put("uid", "rc-upload-" + System.currentTimeMillis() + "-" + new SecureRandom().nextInt(100));
            newAttachment.put("name", name);
            newAttachment.put("size", (String)attachment.get("size"));
            newAttachment.put("status", (String)attachment.get("status"));
            newAttachment.put("entityNum", "srm_supplierchg");
            newAttachment.put("billPkId", "0");
            newAttachments.add(newAttachment);
        }
        attach.upload(newAttachments);
    }

    private String saveAsTempFile(String url, String name) {
        String path = url.split("download.do\\?path=")[1];
        try {
            path = URLDecoder.decode(path, "UTF-8");
            path = FilePathUtil.dealPath((String)path, (String)"attach");
        }
        catch (UnsupportedEncodingException e) {
            this.log.info("\u518d\u6b21\u53d8\u66f4\u9644\u4ef6path\u8f6c\u7801\u5931\u8d25" + e.getMessage());
        }
        InputStream inputStream = fileService.getInputStream(path);
        String tempUrl = tempFileCache.saveAsUrl(name, inputStream, 7200);
        String address = RequestContext.get().getClientFullContextPath();
        if (!address.endsWith("/")) {
            address = address + "/";
        }
        tempUrl = address + tempUrl;
        return tempUrl;
    }

    private void setEnterMuBaseDateModel(String entryname, String fieldname) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection(entryname);
        int i = 0;
        for (DynamicObject dy : entrys) {
            DynamicObjectCollection dynamicObjectCollection = dy.getDynamicObjectCollection(fieldname);
            if (CTIY.equals(fieldname) || PROVINCE.equals(fieldname)) {
                this.setMuBaseDateLongnumber(i, dy, fieldname);
            }
            if (!CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
                if (CTIY.equals(fieldname)) {
                    DynamicObjectCollection province = dy.getDynamicObjectCollection(PROVINCE);
                    if (!CollectionUtils.isEmpty((Collection)province) && province.size() == 1) {
                        DynamicObjectCollection db_citys = this.queryCityByProvince(province);
                        if (!CollectionUtils.isEmpty((Collection)db_citys)) {
                            List db_citys_ids = db_citys.stream().map(x -> x.get("id")).collect(Collectors.toList());
                            Iterator dynamicObjectCollection_iterator = dynamicObjectCollection.iterator();
                            while (dynamicObjectCollection_iterator.hasNext()) {
                                DynamicObject next = (DynamicObject)dynamicObjectCollection_iterator.next();
                                if (!Objects.nonNull(next) || db_citys_ids.contains(next.get("fbasedataid.id"))) continue;
                                dynamicObjectCollection_iterator.remove();
                            }
                        }
                        this.getModel().setValue(fieldname, (Object)dynamicObjectCollection, i);
                    } else {
                        this.getModel().setValue(fieldname, null, i);
                    }
                } else {
                    this.getModel().setValue(fieldname, (Object)dynamicObjectCollection, i);
                }
            }
            ++i;
        }
    }

    private DynamicObjectCollection queryCityByProvince(DynamicObjectCollection province) {
        ArrayList<Long> proLongNumberList = new ArrayList<Long>();
        for (DynamicObject pro : province) {
            String proID = ((DynamicObject)pro.get(1)).getString("id");
            if (!org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)proID)) continue;
            proLongNumberList.add(Long.parseLong(proID));
        }
        QFilter filter = new QFilter("parent", "in", proLongNumberList);
        DynamicObjectCollection db_citys = QueryServiceHelper.query((String)"bd_admindivision", (String)"id,name", (QFilter[])new QFilter[]{filter});
        return db_citys;
    }

    private void setMuBaseDateLongnumber(int index, DynamicObject dy, String fieldname) {
        this.getModel().setValue("longnumber", null, index);
        DynamicObjectCollection provinceDynamicObjectCollection = dy.getDynamicObjectCollection(fieldname);
        ArrayList<String> proLongNumberList = new ArrayList<String>();
        for (DynamicObject pro : provinceDynamicObjectCollection) {
            String longnumber = ((DynamicObject)pro.get(1)).getString("longnumber");
            proLongNumberList.add(longnumber);
        }
        this.getModel().setValue("longnumber", (Object)String.join((CharSequence)",", proLongNumberList), index);
    }

    private void setChgValue(Map<String, HashMap<String, DynamicObject>> newEntryRowMap, String entryname, String fieldname, Object newvalue, String key, String entityName, String other) {
        boolean ismulilang = StringUtils.isNotBlank((CharSequence)other);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if (StringUtils.isEmpty((CharSequence)entryname)) {
            if (!ismulilang) {
                this.getModel().setValue(fieldname, newvalue);
            } else {
                String[] langrows = other.split(";;;");
                LocaleString mulilang = new LocaleString();
                for (String lang : langrows) {
                    if (StringUtils.isEmpty((CharSequence)lang)) continue;
                    String[] locallangs = lang.split(":::");
                    mulilang.setItem(locallangs[0], (Object)locallangs[1]);
                }
                this.getModel().setValue(fieldname, (Object)mulilang);
            }
        } else {
            Map curNewEntryRowMap = newEntryRowMap.get(entryname);
            if (curNewEntryRowMap == null) {
                newEntryRowMap.put(entryname, new HashMap(16));
                curNewEntryRowMap = newEntryRowMap.get(entryname);
            }
            EntryType entryType = (EntryType)((EntryProp)dataEntity.getDataEntityType().getProperties().get((Object)entryname)).getItemType();
            DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection(entryname);
            entry.sort((row1, row2) -> row1.getInt("seq") - row2.getInt("seq"));
            int i = 1;
            for (DynamicObject row12 : entry) {
                row12.set("seq", (Object)i++);
            }
            this.setEntryValue(curNewEntryRowMap, entityName, entry, key, entryType, fieldname, other, newvalue, ismulilang);
        }
    }

    private void setEntryValue(Map<String, DynamicObject> curNewEntryRowMap, String srmBdSupplier, DynamicObjectCollection rows, String key, EntryType entryType, String fieldname, String other, Object newvalue, boolean ismulilang) {
        Iterator itr;
        String[] split = key.split("-");
        String seq = split[0];
        String entryId = "0";
        if (split.length > 1) {
            entryId = split[1];
        }
        boolean haveRecord = false;
        if (ismulilang) {
            itr = rows.iterator();
            String[] langrows = other.split(";;;");
            LocaleString mulilang = new LocaleString();
            for (String lang : langrows) {
                if (StringUtils.isEmpty((CharSequence)lang)) continue;
                String[] locallangs = lang.split(":::");
                mulilang.setItem(locallangs[0], (Object)locallangs[1]);
            }
            while (itr.hasNext()) {
                DynamicObject row = (DynamicObject)itr.next();
                if (entryId.equals("0") || !row.getString("id").equals(entryId)) continue;
                haveRecord = true;
                row.set(fieldname, (Object)mulilang);
            }
            if (entryId.equals("0") && curNewEntryRowMap.get(seq) != null) {
                haveRecord = true;
                DynamicObject entryRow = curNewEntryRowMap.get(seq);
                entryRow.set(fieldname, (Object)mulilang);
            }
        } else {
            itr = rows.iterator();
            DynamicObjectType dynamicObjectType = rows.getDynamicObjectType();
            while (itr.hasNext()) {
                DynamicObject row = (DynamicObject)itr.next();
                if (entryId.equals("0") || !row.getString("id").equals(entryId)) continue;
                haveRecord = true;
                if ("seq".equals(fieldname) && StringUtils.isBlank((Object)newvalue)) {
                    itr.remove();
                    continue;
                }
                this.handleMatchEntry(row, dynamicObjectType, fieldname, newvalue);
            }
            if (entryId.equals("0") && curNewEntryRowMap.get(seq) != null) {
                haveRecord = true;
                DynamicObject entryRow = curNewEntryRowMap.get(seq);
                this.handleMatchEntry(entryRow, dynamicObjectType, fieldname, newvalue);
            }
        }
        if (!haveRecord) {
            DynamicObject tempRow = ORMUtil.newDynamicObject((String)(srmBdSupplier + "." + entryType));
            tempRow.set("seq", (Object)(rows.size() + 1));
            tempRow.set(fieldname, newvalue);
            rows.add((Object)tempRow);
            curNewEntryRowMap.put(seq, tempRow);
        }
    }

    private void handleMatchEntry(DynamicObject row, DynamicObjectType dynamicObjectType, String fieldname, Object newvalue) {
        HashSet<String> entryAttKeySet = new HashSet<String>();
        entryAttKeySet.add("goodsattachmentfield");
        entryAttKeySet.add("contractattachment");
        entryAttKeySet.add("attachmentfield");
        if (entryAttKeySet.contains(fieldname)) {
            DynamicObjectCollection cols = (DynamicObjectCollection)newvalue;
            DynamicObjectCollection newAttCol = new DynamicObjectCollection(cols.getDynamicObjectType(), (Object)cols);
            for (DynamicObject obj : cols) {
                newAttCol.add((Object)obj);
            }
            row.set(fieldname, (Object)newAttCol);
            return;
        }
        DynamicProperty property = dynamicObjectType.getProperty(fieldname);
        if (property instanceof BasedataProp) {
            String newValueStr = newvalue.toString();
            if (StringUtils.isBlank((CharSequence)newValueStr)) {
                row.set(fieldname, null);
            } else {
                Long baseId = Long.parseLong(newValueStr);
                Map baseData = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)((BasedataProp)property).getDynamicComplexPropertyType(), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)baseId)});
                row.set(fieldname, baseData.get(baseId));
            }
        } else {
            row.set(fieldname, newvalue);
        }
    }

    private Object bulidNewValue(Object value, String infoType, DynamicObject row) {
        Object newvalue = null;
        if (value != null && "D".equals(infoType)) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                newvalue = simpleDateFormat.parse(value.toString());
            }
            catch (ParseException e1) {
                this.log.error("SupplierFastChgEdit bulidNewValue parse date error");
            }
        } else if ("B".equals(infoType)) {
            String fieldName = row.getString("fieldname");
            if ("isdefault".equals(fieldName) || "isdefault_link".equals(fieldName)) {
                value = row.getString("srcbillid");
            }
            newvalue = value != null && value.equals("1");
        } else if ("A".equals(infoType)) {
            DynamicObjectCollection changeAttachmentCol = row.getDynamicObjectCollection("changeattachment");
            DynamicObjectCollection entryAttNewValue = new DynamicObjectCollection(changeAttachmentCol.getDynamicObjectType(), null);
            for (DynamicObject changeAttachment : changeAttachmentCol) {
                DynamicObject targetAttachment = ORMUtil.newDynamicObject((DynamicObjectType)changeAttachment.getDynamicObjectType());
                targetAttachment.set("fbasedataid", changeAttachment.get(1));
                entryAttNewValue.add((Object)targetAttachment);
            }
            newvalue = entryAttNewValue;
        } else {
            newvalue = value;
        }
        return newvalue;
    }

    private Object bulidValue(DynamicObject dataEntity, String infoType, DynamicObject row, String entryname, String fieldname) {
        Object value = null;
        value = "M".equals(infoType) ? SrmCommonUtil.getMulBasedataValue((DynamicObject)dataEntity, (DynamicObject)row, (String)entryname, (String)fieldname) : ("Z".equals(infoType) || "Q".equals(infoType) ? row.getString("srcbillid").trim() : row.getString("newvalue"));
        return value;
    }

    private DynamicObjectCollection getEntryentity(Object supchange_id, String entityName, String entryName) {
        String supchangeName = null;
        switch (entityName) {
            case "adm_supplierchg": {
                supchangeName = "adm_supchange";
                break;
            }
            case "srm_supplierchg": {
                supchangeName = "srm_supchange";
                break;
            }
            default: {
                supchangeName = null;
            }
        }
        if (Objects.isNull(supchangeName)) {
            return new DynamicObjectCollection();
        }
        DynamicObject dynamicObject = QueryRecordUtil.queryRecordSet((String)supchangeName, (String)"id", (String)"id", (Object)supchange_id, null, null, null, null, null, null, null, (String)"loadBill", null);
        DynamicObjectCollection rows = dynamicObject.getDynamicObjectCollection(entryName);
        return rows;
    }
}

