/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.sdk;

import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.field.ComboItem;
import kd.bos.lang.HZPinyin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.sec.user.utils.UserOperationUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.sdk.scm.srm.extpoint.ISrmSupChgPurUserAdminModifyService;

public class SrmSupChgPurUserAdminModifyDefService
implements ISrmSupChgPurUserAdminModifyService {
    private Log log = LogFactory.getLog((String)this.getClass().getName());

    public void setCombItem(List<ComboItem> data, boolean phonechg) {
        if (phonechg) {
            data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u65b0\u589e\u4e00\u4e2a\u4f9b\u5e94\u5546\u7ba1\u7406\u5458\u7528\u6237", (String)"PbdSupplierChgLinkmanInfoPlugin_3", (String)"scm-pbd-formplugin", (Object[])new Object[0])), "2"));
        } else {
            data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4fee\u6539\u539f\u6709\u7684\u4f9b\u5e94\u5546\u7ba1\u7406\u5458\u7528\u6237", (String)"PbdSupplierChgLinkmanInfoPlugin_4", (String)"scm-pbd-formplugin", (Object[])new Object[0])), "1"));
        }
        data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u540c\u6b65\u53d8\u66f4\u4f9b\u5e94\u5546\u7528\u6237", (String)"PbdSupplierChgLinkmanInfoPlugin_5", (String)"scm-pbd-formplugin", (Object[])new Object[0])), "3"));
        this.log.info("SrmSupChgPurUserAdminModifyDefService#setCombItem:" + data);
    }

    public void changePurUser(DynamicObject changeBillObj, Object bizpartnerPkValue, String paramchguser, String srcLinkman, String srcPhone, String newLinkMan, String newPhone) {
        this.log.info("SrmSupChgPurUserAdminModifyDefService#changePurUser:" + paramchguser);
        this.disablePurSupUser(bizpartnerPkValue);
        if ("1".equals(paramchguser)) {
            this.processPurUser(changeBillObj, bizpartnerPkValue, newLinkMan, srcPhone);
        } else if ("2".equals(paramchguser)) {
            this.processPurUser(changeBillObj, bizpartnerPkValue, newLinkMan, newPhone);
        }
    }

    private void disablePurSupUser(Object bizpartnerPkValue) {
        DynamicObject purUser = BusinessDataServiceHelper.loadSingle((String)"pur_supuser", (String)"id,bizpartner,org,user,userfullname,phone,email,username,enable,isadmin,status,disabler,disabledate,type", (QFilter[])new QFilter[]{new QFilter("bizpartner", "=", bizpartnerPkValue).and("isadmin", "=", (Object)"1")});
        if (purUser != null) {
            purUser.set("isadmin", (Object)"0");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{purUser});
        }
    }

    private void processPurUser(DynamicObject changeBillObj, Object bizpartnerPkValue, String newLinkMan, String newPhone) {
        DynamicObject query = QueryServiceHelper.queryOne((String)"pur_supuser", (String)"id", (QFilter[])new QFilter[]{new QFilter("bizpartner", "=", bizpartnerPkValue).and(new QFilter("user.phone", "=", (Object)newPhone).or("user.email", "=", (Object)newPhone))});
        if (query != null) {
            long pk = query.getLong("id");
            DynamicObject tmpPurUser = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"pur_supuser");
            DynamicObject user = tmpPurUser.getDynamicObject("user");
            Object pkValue = user.getPkValue();
            DynamicObject bosUser = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"bos_user");
            bosUser.set("enable", (Object)"1");
            bosUser.set("name", (Object)newLinkMan);
            tmpPurUser.set("isadmin", (Object)"1");
            tmpPurUser.set("enable", (Object)"1");
            tmpPurUser.set("name", (Object)newLinkMan);
            tmpPurUser.set("userfullname", (Object)newLinkMan);
            tmpPurUser.set("user.name", (Object)newLinkMan);
            tmpPurUser.set("username", (Object)newLinkMan);
            tmpPurUser.set("type", (Object)"3");
            try {
                String fullPinyin = HZPinyin.getFullSpell((String)newLinkMan, (String)"");
                String userFullName = UserOperationUtils.getUserNameByFullPinyin((long)0L, (String)fullPinyin, (Set)null);
                bosUser.set("username", (Object)userFullName);
            }
            catch (UnsupportedEncodingException e) {
                this.log.info("\u540d\u79f0\u8f6c\u62fc\u97f3\u5931\u8d25" + e.getMessage());
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tmpPurUser});
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
            operateOption.setVariableValue("isStrict", String.valueOf(false));
            operateOption.setVariableValue("WF", String.valueOf(false));
            OperationResult userSaveResult = SaveServiceHelper.saveOperate((String)"bos_user", (DynamicObject[])new DynamicObject[]{bosUser}, (OperateOption)operateOption);
            if (!userSaveResult.isSuccess()) {
                this.log.info("\u4fee\u6539\u4eba\u5458\u5931\u8d25\uff1a" + userSaveResult.getAllErrorOrValidateInfo() + "@@getMessage\uff1a" + userSaveResult.getMessage());
            }
        } else {
            this.createPurSupUser(changeBillObj, newLinkMan, newPhone);
        }
    }

    private void createPurSupUser(DynamicObject changeBillObj, String newLinkMan, String newPhone) {
        DynamicObject bizpartner = changeBillObj.getDynamicObject("bizpartner");
        DynamicObject org = changeBillObj.getDynamicObject("org");
        DynamicObject newPurSupUser = BusinessDataServiceHelper.newDynamicObject((String)"pur_supuser");
        newPurSupUser.set("username", (Object)newLinkMan);
        if (StringUtils.isEmail((String)newPhone)) {
            newPurSupUser.set("email", (Object)newPhone);
        } else {
            newPurSupUser.set("phone", (Object)newPhone);
        }
        newPurSupUser.set("bizpartner", (Object)bizpartner);
        newPurSupUser.set("isadmin", (Object)"1");
        newPurSupUser.set("type", (Object)"3");
        newPurSupUser.set("org", (Object)org);
        newPurSupUser.set("enable", (Object)"1");
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
        operateOption.setVariableValue("isStrict", String.valueOf(false));
        operateOption.setVariableValue("WF", String.valueOf(false));
        OperationResult saveResult = SaveServiceHelper.saveOperate((String)"pur_supuser", (DynamicObject[])new DynamicObject[]{newPurSupUser}, (OperateOption)operateOption.copy());
        if (!saveResult.isSuccess()) {
            this.log.info("\u65b0\u589e\u4f9b\u5e94\u5546\u7528\u6237\u5e76\u8bbe\u7f6e\u5176\u4e3a\u7ba1\u7406\u5458\u5931\u8d25\uff1a" + saveResult.getAllErrorOrValidateInfo() + "@@getMessage\uff1a" + saveResult.getMessage());
        }
    }
}

