/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class RfiVisibleUtil {
    public static Map<String, Boolean> queryRfiDefaultContent(String entityName, String selects, String rfinumber, String ispublic, String pagenumber) {
        QFilter[] qFilter = new QFilter[]{new QFilter("status", "=", (Object)"C").and(new QFilter("enable", "=", (Object)"1"))};
        DynamicObjectCollection pbd_rficontentconfigs = QueryServiceHelper.query((String)entityName, (String)selects, (QFilter[])qFilter);
        HashMap<String, Boolean> rfimap = new HashMap<String, Boolean>();
        Map numberMap = pbd_rficontentconfigs.stream().collect(Collectors.groupingBy(x -> x.getString(pagenumber), Collectors.toList()));
        numberMap.forEach((k, v) -> {
            List booleans = v.stream().map(x -> x.getBoolean(ispublic)).collect(Collectors.toList());
            if (!booleans.contains(Boolean.TRUE)) {
                rfimap.put((String)k, Boolean.FALSE);
            }
        });
        for (DynamicObject pbd_rfi : pbd_rficontentconfigs) {
            rfimap.put(pbd_rfi.getString(rfinumber), pbd_rfi.getBoolean(ispublic));
        }
        return rfimap;
    }

    public static Map<String, Boolean> queryRfiContentByRfiId(String entityName, String selects, String issuerfiid, String rfiContentNumber, String required, String rfiContentPageNumber) {
        HashMap<String, Boolean> rfimap = new HashMap<String, Boolean>();
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(issuerfiid))};
        DynamicObjectCollection srmIssuerfi = QueryServiceHelper.query((String)entityName, (String)selects, (QFilter[])qFilters);
        Map numberMap = srmIssuerfi.stream().collect(Collectors.groupingBy(x -> x.getString(rfiContentPageNumber), Collectors.toList()));
        numberMap.forEach((k, v) -> {
            List booleans = v.stream().map(x -> x.getBoolean(required)).collect(Collectors.toList());
            if (!booleans.contains(Boolean.TRUE)) {
                rfimap.put((String)k, Boolean.FALSE);
            }
        });
        for (DynamicObject dy : srmIssuerfi) {
            boolean aBoolean = dy.getBoolean(required);
            if (aBoolean) continue;
            String rfiname = dy.getString(rfiContentNumber);
            rfimap.put(rfiname, Boolean.FALSE);
        }
        return rfimap;
    }

    public static Map<String, Boolean> queryRfiContentUnenable() {
        HashMap<String, Boolean> rfimap = new HashMap<String, Boolean>();
        DynamicObjectCollection pbd_rficontentconfigs = RfiVisibleUtil.queryEnableRfiContent();
        Map pagenumberMap = pbd_rficontentconfigs.stream().collect(Collectors.groupingBy(x -> x.getString("pagenumber"), Collectors.toList()));
        pagenumberMap.forEach((k, v) -> {
            boolean flag = false;
            for (DynamicObject dy : v) {
                if (!"1".equals(dy.getString("enable")) || !"C".equals(dy.getString("status"))) continue;
                flag = true;
            }
            if (!flag) {
                rfimap.put((String)k, Boolean.FALSE);
            }
        });
        for (DynamicObject pbd_rficontentconfig : pbd_rficontentconfigs) {
            String enable = pbd_rficontentconfig.getString("enable");
            String number = pbd_rficontentconfig.getString("number");
            String status = pbd_rficontentconfig.getString("status");
            if (!"0".equals(enable) && "C".equals(status)) continue;
            rfimap.put(number, Boolean.FALSE);
        }
        return rfimap;
    }

    public static DynamicObjectCollection queryEnableRfiContent() {
        QFilter[] qFilter = new QFilter[]{new QFilter("status", "in", (Object)new String[]{"A", "B", "C"})};
        DynamicObjectCollection pbd_rficontentconfigs = QueryServiceHelper.query((String)"pbd_rficontent", (String)"id,enable,number,pagenumber,status", (QFilter[])qFilter);
        return pbd_rficontentconfigs;
    }

    public static DynamicObjectCollection queryRfiContentByBiztype(Long bizTypeId, Long orgId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("biztype", "=", (Object)bizTypeId).and(new QFilter("enable", "=", (Object)"1").and(new QFilter("status", "=", (Object)"C")).and(new QFilter("createorg", "=", (Object)orgId)))};
        String selects = "id,name,entryentity.id,entryentity.rficontent,entryentity.rficontent.number,entryentity.rficontent.pagenumber,entryentity.required,entryentity.rfidesc,entryentity.rficontent.name,entryentity.rficontent.pagename";
        DynamicObjectCollection rficontent = QueryServiceHelper.query((String)"pbd_rficontentconfig", (String)selects, (QFilter[])qFilters);
        return rficontent;
    }
}

