/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.scm.common.constant.SupplierLifeCycleConstant;

public class SupplierLifeCycleManagerUtil {
    public static boolean isEnableSupplierLifeCycleManager() {
        QFilter qFilter = new QFilter("paramkey", "=", (Object)"enablesupplierlifecycle");
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"pur_updateparamconfig", (String)"id,paramvalue,paramkey", (QFilter[])qFilter.toArray());
        return dyn != null && "Y".equals(dyn.getString("paramvalue"));
    }

    public static boolean hasUncompletedSrmAptitudeBill(String name, String societycreditcode) {
        QFilter qf = new QFilter("auditstatus", "!=", (Object)"E").and("supplier.societycreditcode", "=", (Object)societycreditcode);
        return QueryServiceHelper.exists((String)"srm_aptitudeexam", (QFilter[])new QFilter[]{qf});
    }

    public static Set<Long> getQuitOrInvalidOrgVaildRegistrationSet(String name, String creditno) {
        QFilter qf = new QFilter("societycreditcode", "=", (Object)creditno);
        DynamicObjectCollection existsQuitSupplier = QueryServiceHelper.query((String)"adm_supplier", (String)"id,org,supplier_status", (QFilter[])new QFilter[]{qf});
        return SupplierLifeCycleManagerUtil.existsNameOnOthersSupplier(name, creditno) ? new HashSet(16) : SupplierLifeCycleManagerUtil.getQuitOrInvalidOrgVaildRegistrationSet(existsQuitSupplier);
    }

    private static Set<Long> getQuitOrInvalidOrgVaildRegistrationSet(DynamicObjectCollection existsQuitSupplier) {
        Set<Long> quitOrgSet = SupplierLifeCycleManagerUtil.getQuitOrInvalidOrgSet(existsQuitSupplier);
        for (DynamicObject supplier : existsQuitSupplier) {
            long supplier_status = supplier.getLong("supplier_status");
            if (supplier_status != SupplierLifeCycleConstant.SUPSTATUS_REGISTER) continue;
            quitOrgSet.clear();
            break;
        }
        return quitOrgSet;
    }

    public static Set<Long> getQuitOrInvalidOrgSet(String name, String creditno) {
        QFilter qf = new QFilter("societycreditcode", "=", (Object)creditno);
        DynamicObjectCollection existsQuitSupplier = QueryServiceHelper.query((String)"adm_supplier", (String)"id,org,supplier_status", (QFilter[])new QFilter[]{qf});
        return SupplierLifeCycleManagerUtil.existsNameOnOthersSupplier(name, creditno) ? new HashSet(16) : SupplierLifeCycleManagerUtil.getQuitOrInvalidOrgSet(existsQuitSupplier);
    }

    private static Set<Long> getQuitOrInvalidOrgSet(DynamicObjectCollection existsQuitSupplier) {
        Set<Long> quitOrgSet = SupplierLifeCycleManagerUtil.getAllQuitOrInvalidOrgSet(existsQuitSupplier);
        for (DynamicObject supplier : existsQuitSupplier) {
            long supplier_status = supplier.getLong("supplier_status");
            long org = supplier.getLong("org");
            if (supplier_status == SupplierLifeCycleConstant.SUPSTATUS_QUIT || supplier_status == SupplierLifeCycleConstant.SUPSTATUS_INVALID) continue;
            quitOrgSet.remove(org);
        }
        return quitOrgSet;
    }

    public static Set<Long> getQuitOrInvalidOrgExcludeCurBillSet(String name, String creditno, Object curBillId) {
        QFilter qf = new QFilter("societycreditcode", "=", (Object)creditno);
        DynamicObjectCollection existsQuitSupplier = QueryServiceHelper.query((String)"adm_supplier", (String)"id,org,supplier_status", (QFilter[])new QFilter[]{qf});
        return SupplierLifeCycleManagerUtil.existsNameOnOthersSupplier(name, creditno) ? new HashSet(16) : SupplierLifeCycleManagerUtil.getQuitOrInvalidOrgExcludeCurBillSet(existsQuitSupplier, name, creditno, curBillId);
    }

    private static Set<Long> getQuitOrInvalidOrgExcludeCurBillSet(DynamicObjectCollection existsQuitSupplier, String name, String creditno, Object curBillId) {
        QFilter qf = new QFilter("societycreditcode", "=", (Object)creditno).and("id", "!=", curBillId);
        DynamicObjectCollection existsQuitSupplierUnCurBill = QueryServiceHelper.query((String)"adm_supplier", (String)"id,org,supplier_status", (QFilter[])new QFilter[]{qf});
        Set<Long> quitOrgSet = SupplierLifeCycleManagerUtil.getAllQuitOrInvalidOrgSet(existsQuitSupplier);
        for (DynamicObject supplier : existsQuitSupplierUnCurBill) {
            long supplier_status = supplier.getLong("supplier_status");
            long org = supplier.getLong("org");
            if (supplier_status == SupplierLifeCycleConstant.SUPSTATUS_QUIT || supplier_status == SupplierLifeCycleConstant.SUPSTATUS_INVALID) continue;
            quitOrgSet.remove(org);
        }
        return quitOrgSet;
    }

    private static Set<Long> getAllQuitOrInvalidOrgSet(DynamicObjectCollection existsQuitSupplier) {
        HashSet<Long> quitOrgSet = new HashSet<Long>(16);
        for (DynamicObject supplier : existsQuitSupplier) {
            long supplier_status = supplier.getLong("supplier_status");
            if (supplier_status != SupplierLifeCycleConstant.SUPSTATUS_QUIT && supplier_status != SupplierLifeCycleConstant.SUPSTATUS_INVALID) continue;
            quitOrgSet.add(supplier.getLong("org"));
        }
        return quitOrgSet;
    }

    private static boolean existsNameOnOthersSupplier(String name, String creditno) {
        boolean exists = QueryServiceHelper.exists((String)"srm_supplier", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)name).and("societycreditcode", "!=", (Object)creditno)});
        return exists;
    }

    public static Map<String, Object> checkSupplierStatus(Object supPk, String tarPushEntityName) {
        DynamicObject srm_supplier;
        String societycreditcode;
        boolean exists;
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        resultMap.put("success", true);
        if ("srm_supapprovetemp".equals(tarPushEntityName)) {
            DynamicObject srm_supplier2 = QueryServiceHelper.queryOne((String)"srm_supplier", (String)"supplier_status", (QFilter[])new QFilter[]{new QFilter("id", "=", supPk)});
            long supplier_status = srm_supplier2.getLong("supplier_status");
            if (SupplierLifeCycleConstant.SUPSTATUS_POTENTIAL != supplier_status) {
                resultMap.put("success", false);
                resultMap.put("msg", ResManager.loadKDString((String)"\u53ea\u6709\u6f5c\u5728\u4f9b\u5e94\u5546\u624d\u80fd\u8fdb\u884c\u4e34\u65f6\u4f9b\u5e94\u5546\u7533\u8bf7\u3002", (String)"SupplierLifeCycleManagerUtil_0", (String)"scm-srmcore-common", (Object[])new Object[0]));
            }
        } else if ("srm_supquit".equals(tarPushEntityName)) {
            DynamicObject srm_supplier3 = QueryServiceHelper.queryOne((String)"srm_supplier", (String)"supplier_status", (QFilter[])new QFilter[]{new QFilter("id", "=", supPk)});
            long supplier_status = srm_supplier3.getLong("supplier_status");
            if (SupplierLifeCycleConstant.SUPSTATUS_NORMAL != supplier_status && SupplierLifeCycleConstant.SUPSTATUS_POTENTIAL != supplier_status) {
                resultMap.put("success", false);
                resultMap.put("msg", ResManager.loadKDString((String)"\u53ea\u6709\u6f5c\u5728\u3001\u5408\u683c\u4f9b\u5e94\u5546\u624d\u80fd\u8fdb\u884c\u9000\u51fa\u7533\u8bf7\u3002", (String)"SupplierLifeCycleManagerUtil_2", (String)"scm-srmcore-common", (Object[])new Object[0]));
            }
        } else if ("srm_aptitudeexam".equals(tarPushEntityName)) {
            DynamicObject srm_supplier4 = QueryServiceHelper.queryOne((String)"srm_supplier", (String)"societycreditcode", (QFilter[])new QFilter[]{new QFilter("id", "=", supPk)});
            String societycreditcode2 = srm_supplier4.getString("societycreditcode");
            boolean exists2 = QueryServiceHelper.exists((String)"srm_blackenterprise", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)societycreditcode2).and("auditstatus", "=", (Object)"C")});
            if (exists2) {
                resultMap.put("success", false);
                resultMap.put("msg", ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u5df2\u52a0\u5165\u9ed1\u540d\u5355\uff0c\u8bf7\u5230\u4f01\u4e1a\u9ed1\u540d\u5355\u5217\u8868\u67e5\u770b\u5177\u4f53\u6570\u636e\u3002", (String)"SupplierLifeCycleManagerUtil_4", (String)"scm-srmcore-common", (Object[])new Object[0]));
            }
        } else if ("srm_blackenterprise".equals(tarPushEntityName) && (exists = QueryServiceHelper.exists((String)"srm_blackenterprise", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)(societycreditcode = (srm_supplier = QueryServiceHelper.queryOne((String)"srm_supplier", (String)"societycreditcode", (QFilter[])new QFilter[]{new QFilter("id", "=", supPk)})).getString("societycreditcode"))).and("auditstatus", "=", (Object)"C")}))) {
            resultMap.put("success", false);
            resultMap.put("msg", ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u5df2\u52a0\u5165\u9ed1\u540d\u5355\uff0c\u8bf7\u5230\u4f01\u4e1a\u9ed1\u540d\u5355\u5217\u8868\u67e5\u770b\u8be6\u60c5\u3002", (String)"SupplierLifeCycleManagerUtil_4", (String)"scm-srmcore-common", (Object[])new Object[0]));
        }
        return resultMap;
    }

    public static Map<String, Object> pushBizBill(Object supPk, String tarPushEntityName) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        resultMap.put("success", true);
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber("srm_supplier");
        pushArgs.setTargetEntityNumber(tarPushEntityName);
        pushArgs.setBuildConvReport(true);
        pushArgs.setHasRight(false);
        ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>();
        ListSelectedRow row = new ListSelectedRow();
        row.setPrimaryKeyValue(supPk);
        selectedRowList.add(row);
        pushArgs.setSelectedRows(selectedRowList);
        ConvertOperationResult result = ConvertServiceHelper.pushAndSave((PushArgs)pushArgs);
        if (!result.isSuccess()) {
            resultMap.put("success", Boolean.FALSE);
            StringBuilder message = new StringBuilder();
            result.getBillReports().forEach(rowx -> message.append(rowx.getFailMessage()));
            if (message.length() == 0) {
                message.append(ResManager.loadKDString((String)"botp\u51fa\u73b0\u5f02\u5e38\u3002", (String)"SupplierLifeCycleManagerUtil_3", (String)"scm-srmcore-common", (Object[])new Object[0]));
            }
            resultMap.put("msg", message.toString());
            return resultMap;
        }
        return resultMap;
    }
}

