/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.ApiUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.JacksonJsonUtil;

public final class SupplierUtil {
    private static Log log = LogFactory.getLog(SupplierUtil.class);

    public static Map<String, Object> synCreateEasSupplier(List<DynamicObject> datas) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        HashMap<String, Object> param = new HashMap<String, Object>(1);
        param.put("data", datas);
        param.put("database_type", "eas");
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"SupplierUtil", (String)"pur_apiconfig", (String)"username", (QFilter[])new QFilter[]{new QFilter("system", "=", (Object)"1").and(new QFilter("enable", "=", (Object)"1"))}, (String)"username");){
            dataSet.forEach(row -> param.put("username", row.getString("username")));
        }
        String msg = null;
        try (TXHandle h = TX.notSupported();){
            msg = ApiUtil.srmSupplierToEasSupplier(param);
        }
        StringBuilder messages = new StringBuilder();
        if (null == msg) {
            log.info("\u4f9b\u5e94\u5546\u540c\u6b65\u5931\u8d25 \uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            messages.append(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u540c\u6b65\u5931\u8d25 \uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (String)"SupplierUtil_0", (String)"scm-common", (Object[])new Object[0]));
            returnMap.put("succed", "false");
        } else if (!msg.isEmpty() && msg.contains("error")) {
            messages.append(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u540c\u6b65\u5931\u8d25 \uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (String)"SupplierUtil_0", (String)"scm-common", (Object[])new Object[0]));
            returnMap.put("succed", "false");
            returnMap.put("message", messages.toString());
            returnMap.put("number", "");
        } else if (StringUtils.isBlank((CharSequence)msg)) {
            returnMap.put("succed", "false");
            returnMap.put("message", ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u540c\u6b65\u5931\u8d25 \uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (String)"SupplierUtil_0", (String)"scm-common", (Object[])new Object[0]));
        } else if ("success".equals(msg)) {
            returnMap.put("succed", "true");
            returnMap.put("message", messages.toString());
            log.info(returnMap.toString());
        } else {
            boolean flag = false;
            Map dataMap = (Map)JacksonJsonUtil.fromJson((String)msg, Map.class);
            for (DynamicObject supplier : datas) {
                Object obj = dataMap.get(supplier.getString("id"));
                if (null == obj || !(obj instanceof Map)) continue;
                Map detailMap = (Map)obj;
                if ("500".equals(detailMap.get("status"))) {
                    flag = true;
                    messages.append(MessageFormat.format(ResManager.loadKDString((String)"\u6ce8\u518c\u4f9b\u5e94\u5546\u7f16\u7801\u4e3a{0}", (String)"SupplierUtil_1", (String)"scm-common", (Object[])new Object[0]), supplier.getString("number")));
                    messages.append(MessageFormat.format(ResManager.loadKDString((String)"\u521b\u5efaEAS\u4f9b\u5e94\u5546\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{0}\u3002", (String)"SupplierUtil_5", (String)"scm-common", (Object[])new Object[0]), detailMap.get("message")));
                    continue;
                }
                flag = false;
                messages.append(MessageFormat.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546EAS\u521b\u5efa\u6210\u529f\uff01EAS\u4f9b\u5e94\u5546\u7f16\u7801\u662f\uff1a{0}", (String)"SupplierUtil_3", (String)"scm-common", (Object[])new Object[0]), detailMap.get("number")));
                returnMap.put("number", detailMap.get("number"));
            }
            if (flag) {
                returnMap.put("succed", "false");
                returnMap.put("message", messages.toString());
                log.info(returnMap.toString());
            } else {
                returnMap.put("succed", "true");
                returnMap.put("message", messages.toString());
                log.info(returnMap.toString());
            }
        }
        return returnMap;
    }

    public static Map<String, Object> synDisableEasSupplier(List<DynamicObject> datas) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        HashMap<String, Object> param = new HashMap<String, Object>(1);
        HashSet numbers = new HashSet();
        param.put("database_type", "eas");
        datas.forEach(row -> numbers.add(row.getString("number")));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"SupplierUtil", (String)"pur_apiconfig", (String)"username", (QFilter[])new QFilter[]{new QFilter("system", "=", (Object)"1").and(new QFilter("enable", "=", (Object)"1"))}, (String)"username");){
            dataSet.forEach(row -> param.put("username", row.getString("username")));
        }
        param.put("numbers", numbers);
        param.put("operate", "disable");
        String msg = null;
        try (TXHandle h = TX.notSupported();){
            msg = ApiUtil.srmSupplierOperateEasSupplier(param);
        }
        StringBuilder messages = new StringBuilder();
        if (null == msg) {
            messages.append(ResManager.loadKDString((String)"\u5904\u7406EAS\u4f9b\u5e94\u5546\u5931\u8d25\u3002", (String)"SupplierUtil_4", (String)"scm-common", (Object[])new Object[0]));
            log.info(messages.append("@@@").toString());
        } else if ("true".equals(msg) || "success".equals(msg)) {
            returnMap.put("succed", "true");
            returnMap.put("message", messages.toString());
        } else {
            returnMap.put("succed", "false");
            messages.append("EAS");
            returnMap.put("message", messages.append(msg).toString());
        }
        log.info(messages.append("@@@@").toString());
        return returnMap;
    }

    public static Map<String, Object> synQuitEasSupplier(List<DynamicObject> datas) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        HashMap<String, Object> param = new HashMap<String, Object>(1);
        HashSet numbers = new HashSet();
        param.put("database_type", "eas");
        datas.forEach(row -> numbers.add(row.getString("number")));
        param.put("numbers", numbers);
        param.put("operate", "quit");
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"SupplierUtil", (String)"pur_apiconfig", (String)"username", (QFilter[])new QFilter[]{new QFilter("system", "=", (Object)"1").and(new QFilter("enable", "=", (Object)"1"))}, (String)"username");){
            dataSet.forEach(row -> param.put("username", row.getString("username")));
        }
        TXHandle h = TX.notSupported();
        var5_5 = null;
        if (h != null) {
            if (var5_5 != null) {
                try {
                    h.close();
                }
                catch (Throwable throwable) {
                    var5_5.addSuppressed(throwable);
                }
            } else {
                h.close();
            }
        }
        return returnMap;
    }

    public static void srmSupplierSendEmail(DynamicObject data) {
        if (ApiConfigUtil.hasOldMsgConfig()) {
            MessageInfo messageInfo = new MessageInfo();
            if (Objects.isNull(data.get("certifiapply")) || StringUtils.isEmpty((CharSequence)data.getString("issuerfiid"))) {
                return;
            }
            String linkman = data.getString("linkman");
            String phone = data.getString("phone");
            String org = data.getString("org.name");
            StringBuilder message = new StringBuilder();
            message.append(ResManager.loadKDString((String)"<p>\u5c0a\u656c\u7684 ", (String)"SupplierUtil_6", (String)"scm-common", (Object[])new Object[0])).append(linkman).append(" \uff0c</p>");
            message.append(ResManager.loadKDString((String)"<p>\u60a8\u7684\u6ce8\u518c\u8d44\u6599\uff0c", (String)"SupplierUtil_7", (String)"scm-common", (Object[])new Object[0])).append("<font size=\"3\" color=\"red\">").append(org).append(ResManager.loadKDString((String)"</font>\u7684\u5ba1\u6279\u7ed3\u679c\u4e3a \u201c\u6ce8\u518c\u901a\u8fc7\u201d\u3002</p>", (String)"SupplierUtil_8", (String)"scm-common", (Object[])new Object[0]));
            StringBuilder url = new StringBuilder();
            String domainContextUrl = UrlService.getDomainContextUrl();
            url.append(domainContextUrl).append("/login.html");
            message.append(ResManager.loadKDString((String)"<p>\u8bf7\u70b9\u51fb ", (String)"SupplierUtil_9", (String)"scm-common", (Object[])new Object[0])).append("<a href=\"").append((CharSequence)url).append("\"><font size=\"4\" color=\"blue\">").append((CharSequence)url).append(ResManager.loadKDString((String)"</font></a> \u8fdb\u5165\u7cfb\u7edf\u3002\u60a8\u7684\u8d26\u53f7\uff1a", (String)"SupplierUtil_10", (String)"scm-common", (Object[])new Object[0])).append(phone).append(ResManager.loadKDString((String)"\uff0c\u521d\u59cb\u5bc6\u7801\u4e3a123456\u3002\u9996\u6b21\u767b\u5f55\u540e\u8bf7\u6309\u63d0\u793a\u4fee\u6539\u5bc6\u7801\u3002</p>", (String)"SupplierUtil_11", (String)"scm-common", (Object[])new Object[0]));
            message.append(ResManager.loadKDString((String)"<p>\u5982\u60a8\u9047\u5230\u767b\u5f55\u95ee\u9898\uff0c\u8bf7\u8054\u7cfb\u6211\u53f8\u91c7\u8d2d\u7ba1\u7406\u5458\u3002</p>", (String)"SupplierUtil_12", (String)"scm-common", (Object[])new Object[0]));
            message.append(ResManager.loadKDString((String)"<p>\u6b64\u90ae\u4ef6\u65e0\u9700\u56de\u590d\uff0c\u611f\u8c22\u60a8\u7684\u652f\u6301\u3002</p>", (String)"SupplierUtil_13", (String)"scm-common", (Object[])new Object[0]));
            message.append("<p><font size=\"4\" color=\"red\">").append(org).append("</font></p>");
            ArrayList<String> emails = new ArrayList<String>();
            emails.add(phone);
            messageInfo.setTitle(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u8d44\u8d28\u8ba4\u8bc1", (String)"SupplierUtil_14", (String)"scm-common", (Object[])new Object[0]));
            HashMap<String, ArrayList<String>> param = new HashMap<String, ArrayList<String>>(1);
            param.put("email", emails);
            messageInfo.setParams(param);
            messageInfo.setContent(message.toString());
            messageInfo.setNotifyType(MessageChannels.EMAIL.getNumber());
            messageInfo.setMessageType("message");
            messageInfo.setEntityNumber("srm_supplierreg");
            messageInfo.setContentUrl(url.toString());
            MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
        }
    }

    public static void setIssuerfiHaveconfirm(DynamicObject[] objects, String haveconfirm) {
        DynamicObject[] dynamicObjects;
        if (objects.length == 0) {
            return;
        }
        List list = CollectionUtils.arrayToList((Object)objects);
        List ids = list.stream().filter(x -> StringUtils.isNotEmpty((CharSequence)x.getString("issuerfiid"))).map(x -> x.getString("issuerfiid")).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(ids) && (dynamicObjects = BusinessDataServiceHelper.load((String)"srm_issuerfi", (String)"id,haveconfirm", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)CommonUtil.getLongList(ids))})).length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                dynamicObject.set("haveconfirm", (Object)haveconfirm);
            }
            SaveServiceHelper.update((DynamicObject[])dynamicObjects);
        }
    }
}

