/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.validator;

import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.scm.common.util.SupplierLifeCycleManagerUtil;

public class SupplierCheckAuditOrgIsQuitOrgValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (SupplierLifeCycleManagerUtil.isEnableSupplierLifeCycleManager()) {
            for (ExtendedDataEntity dataEntity : dataEntities) {
                DynamicObject data = dataEntity.getDataEntity();
                String billName = data.getDynamicObjectType().getName();
                String name = data.getString("name");
                String societycreditcode = data.getString("societycreditcode");
                long curOrg = data.getLong("org.id");
                Object pkValue = data.getPkValue();
                Set<Long> quitOrgSet = SupplierLifeCycleManagerUtil.getQuitOrInvalidOrgExcludeCurBillSet(name, societycreditcode, pkValue);
                if (quitOrgSet == null || quitOrgSet.isEmpty() || quitOrgSet.contains(curOrg)) continue;
                if ("srm_supplierreg".equals(billName)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u5ba1\u6279\u7ec4\u7ec7\u4e0b\u4e0d\u6ee1\u8db3\u6ce8\u518c\u6761\u4ef6\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SupplierCheckAuditOrgIsQuitOrgValidator_0", (String)"scm-common", (Object[])new Object[0]));
                    continue;
                }
                if (!"adm_companyinfo_register".equals(billName)) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u6ce8\u518c\u5ba1\u6279\u5355\u4f4d\u4e0b\u4e0d\u6ee1\u8db3\u6ce8\u518c\u6761\u4ef6\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SupplierCheckAuditOrgIsQuitOrgValidator_1", (String)"scm-common", (Object[])new Object[0]));
            }
        }
    }
}

