/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.formplugin;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.algo.util.io.IOUtils;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.attachment.AttachmentFieldServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.FileNameUtils;
import kd.scm.common.fulltext.utils.PbdMalElasticSearchUtils;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.malcore.constant.MalConstant;
import kd.scm.malcore.enums.MallStatusEnum;

public class EntImportPicturePlugin
extends AbstractFormPlugin
implements UploadListener {
    private static Log log = LogFactory.getLog(EntImportPicturePlugin.class);
    private static final String[] SPECIAL_SYMBOLS = new String[]{"%", "=", "+", "&"};
    private static String UPLOAD_FLAG = "uploadFlag";
    private static String DIGIT_RANGE = "12345";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar advToolBar = (Toolbar)this.getControl("advcontoolbarap");
        if (null != advToolBar) {
            advToolBar.addItemClickListener((ItemClickListener)this);
            advToolBar.addUploadListener((UploadListener)this);
        }
    }

    private static String replaceSpeSymbol(String str) {
        for (int i = 0; i < SPECIAL_SYMBOLS.length; ++i) {
            if (!str.contains(SPECIAL_SYMBOLS[i])) continue;
            str = str.replace(SPECIAL_SYMBOLS[i], "_");
        }
        return str;
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object goodsIds = customParams.get("goodsIds");
        if (Objects.nonNull(goodsIds)) {
            this.allotEntity((List)goodsIds);
        }
    }

    public void upload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls.length > 0) {
            String zipUrl = (String)urls[0];
            this.getPageCache().put("uploadZipUrl", zipUrl);
            DynamicObjectCollection dynList = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            boolean thumbnailFlag = false;
            boolean pictureFlag = false;
            for (DynamicObject dyn : dynList) {
                DynamicObject goods = dyn.getDynamicObject("goods");
                if (goods == null) continue;
                thumbnailFlag = thumbnailFlag || "true".equals(this.getPageCache().get(goods.getString("number") + "_thumbnail"));
                boolean bl = pictureFlag = pictureFlag || "true".equals(this.getPageCache().get(goods.getString("number") + "_picture"));
                if (!thumbnailFlag && !pictureFlag) continue;
                break;
            }
            if (thumbnailFlag || pictureFlag) {
                this.getPageCache().put("uploadZipUrl", zipUrl);
                this.showConfirmPage("coverageConfirm");
            } else {
                this.uploadZipFile(zipUrl, true);
            }
        }
    }

    private void showConfirmPage(String closeCallBackId) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("pbd_picuploadcmf");
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCustomParam("param", (Object)closeCallBackId);
        param.setCustomParam("hiddenLabel", (Object)this.getPageCache().get("hiddenLabel"));
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closeCallBackId));
        this.getView().showForm(param);
    }

    public void closedCallBack(ClosedCallBackEvent callBackEvent) {
        super.closedCallBack(callBackEvent);
        String actionId = callBackEvent.getActionId();
        Object returnData = callBackEvent.getReturnData();
        if (returnData != null && "coverageConfirm".equals(actionId)) {
            String zipUrl = this.getPageCache().get("uploadZipUrl");
            this.uploadZipFile(zipUrl, "cover".equals(returnData.toString()));
        }
    }

    private void uploadZipFile(String zipFileUrl, boolean coverFlag) {
        String message = this.checkValidImgZip(zipFileUrl);
        if (StringUtils.isNotEmpty((CharSequence)message)) {
            this.getView().showErrorNotification(message);
        } else {
            HashMap<String, Map<Integer, Map<String, String>>> picListMap = new HashMap<String, Map<Integer, Map<String, String>>>(5);
            int result = this.getImageInfoUrl(zipFileUrl, picListMap);
            int successNum = this.setImageInfo(picListMap, coverFlag);
            this.getPageCache().put("coverFlag", coverFlag ? "true" : "false");
            this.getPageCache().put(UPLOAD_FLAG, "true");
            if (result == 1) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4e0a\u4f20\u6210\u529f\uff0c\u6709\u6548\u5bfc\u5165{0}\u5f20\u56fe\u7247\uff0c\u90e8\u5206\u5546\u54c1\u56fe\u7247\u547d\u540d\u683c\u5f0f\u9519\u8bef\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"EntImportPicturePlugin_8", (String)"scm-ent-formplugin", (Object[])new Object[]{successNum}), MessageBoxOptions.OK);
            } else if (result == 2) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4e0a\u4f20\u6210\u529f\uff0c\u6709\u6548\u5bfc\u5165{0}\u5f20\u56fe\u7247\uff0c\u90e8\u5206\u5546\u54c1\u7684\u56fe\u7247\u8d85\u51fa\u7cfb\u7edf\u9650\u5236\uff0c\u4ec5\u652f\u6301\u4e0a\u4f205\u5f20\u56fe\u7247\u3002", (String)"EntImportPicturePlugin_0", (String)"scm-ent-formplugin", (Object[])new Object[]{successNum}), MessageBoxOptions.OK);
            } else {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4e0a\u4f20\u6210\u529f\uff0c\u6709\u6548\u5bfc\u5165{0}\u5f20\u56fe\u7247\u3002", (String)"EntImportPicturePlugin_1", (String)"scm-ent-formplugin", (Object[])new Object[]{successNum}), MessageBoxOptions.OK);
            }
        }
    }

    private int setImageInfo(Map<String, Map<Integer, Map<String, String>>> picListMap, boolean coverFlag) {
        DynamicObjectCollection dynList = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        String domianUrl = UrlService.getDomainContextUrl() + "/";
        ArrayList<Map<String, String>> pictureUrlList = new ArrayList<Map<String, String>>(dynList.size() * 5);
        int successNum = 0;
        for (int i = 0; i < dynList.size(); ++i) {
            DynamicObject entry = (DynamicObject)dynList.get(i);
            DynamicObject goods = entry.getDynamicObject("goods");
            String number = goods.getString("number");
            Map<Integer, Map<String, String>> picMap = picListMap.get(number);
            if (picMap == null) continue;
            successNum += this.setImageUrl(entry, "thumbnail", domianUrl, picMap.remove(1), coverFlag, pictureUrlList);
            for (Map.Entry<Integer, Map<String, String>> entry1 : picMap.entrySet()) {
                successNum += this.setImageUrl(entry, "picture" + (entry1.getKey() - 1), domianUrl, entry1.getValue(), coverFlag, pictureUrlList);
            }
        }
        this.saveTempAttachments(pictureUrlList);
        this.getView().updateView();
        return successNum;
    }

    private int setImageUrl(DynamicObject uploadEntry, String imageKey, String domianUrl, Map<String, String> urlMap, boolean coverFlag, List<Map<String, String>> pictureUrlList) {
        int success = 0;
        if (urlMap != null && !urlMap.isEmpty()) {
            String picture = uploadEntry.getString(imageKey);
            if (coverFlag) {
                uploadEntry.set(imageKey, (Object)(domianUrl + urlMap.get("url") + "&accountId=" + RequestContext.get().getAccountId()));
                pictureUrlList.add(urlMap);
                success = 1;
            } else if (StringUtils.isEmpty((CharSequence)picture)) {
                uploadEntry.set(imageKey, (Object)(domianUrl + urlMap.get("url") + "&accountId=" + RequestContext.get().getAccountId()));
                pictureUrlList.add(urlMap);
                success = 1;
            }
        }
        return success;
    }

    private List<DynamicObject> saveTempAttachments(List<Map<String, String>> pictureUrlList) {
        ArrayList<Map<String, Object>> attachmentList = new ArrayList<Map<String, Object>>(pictureUrlList.size());
        for (Map<String, String> pictureUrl : pictureUrlList) {
            Map<String, Object> attachment = this.saveUrlFile2TempAttachment(pictureUrl.get("name"), pictureUrl.get("url"));
            attachmentList.add(attachment);
        }
        return AttachmentFieldServiceHelper.saveAttachments((String)"ent_importpicture", (String)this.getView().getPageId(), attachmentList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkValidImgZip(String url) {
        ZipEntry zipEntry;
        BufferedInputStream buffInputStream;
        InputStream inputStream;
        ZipInputStream zipInputStream;
        block9: {
            String string;
            TempFileCache fileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            zipInputStream = null;
            inputStream = null;
            buffInputStream = null;
            try {
                inputStream = fileCache.getInputStream(url);
                buffInputStream = new BufferedInputStream(inputStream, inputStream.available() + 1);
                zipInputStream = new ZipInputStream((InputStream)buffInputStream, Charset.forName("GBK"));
                zipEntry = zipInputStream.getNextEntry();
                if (zipEntry != null) break block9;
                string = ResManager.loadKDString((String)"\u56fe\u7247\u538b\u7f29\u5305\u5185\u6ca1\u6709\u56fe\u7247\u6587\u4ef6\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u56fe\u7247\u8d44\u6e90\u5305\u3002", (String)"EntImportPicturePlugin_3", (String)"scm-ent-formplugin", (Object[])new Object[0]);
            }
            catch (Exception e) {
                String string2;
                try {
                    log.error("excelSecurityVerification create BufferedInputStream error is ", (Throwable)e);
                    string2 = ResManager.loadKDString((String)"\u538b\u7f29\u5305\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u5206\u6790\u3002", (String)"EntImportPicturePlugin_7", (String)"scm-ent-formplugin", (Object[])new Object[0]);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(buffInputStream);
                    IOUtils.closeQuietly((AutoCloseable)inputStream);
                    IOUtils.closeQuietly(zipInputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((AutoCloseable)buffInputStream);
                IOUtils.closeQuietly((AutoCloseable)inputStream);
                IOUtils.closeQuietly((AutoCloseable)zipInputStream);
                return string2;
            }
            IOUtils.closeQuietly((AutoCloseable)buffInputStream);
            IOUtils.closeQuietly((AutoCloseable)inputStream);
            IOUtils.closeQuietly((AutoCloseable)zipInputStream);
            return string;
        }
        while (true) {
            block12: {
                block11: {
                    block10: {
                        if (null == zipEntry) break;
                        if (!zipEntry.isDirectory()) break block10;
                        String string = ResManager.loadKDString((String)"\u56fe\u7247\u538b\u7f29\u5305\u5185\u542b\u6709\u6587\u4ef6\u5939\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u56fe\u7247\u8d44\u6e90\u5305\u3002", (String)"EntImportPicturePlugin_4", (String)"scm-ent-formplugin", (Object[])new Object[0]);
                        IOUtils.closeQuietly((AutoCloseable)buffInputStream);
                        IOUtils.closeQuietly((AutoCloseable)inputStream);
                        IOUtils.closeQuietly((AutoCloseable)zipInputStream);
                        return string;
                    }
                    if (this.isImgName(zipEntry.getName())) break block11;
                    String string = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230{0}\u6587\u4ef6\u4e0d\u5c5e\u4e8e\u56fe\u7247\u6587\u4ef6\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u56fe\u7247\u8d44\u6e90\u5305\u3002", (String)"EntImportPicturePlugin_5", (String)"scm-ent-formplugin", (Object[])new Object[]{zipEntry.getName()});
                    IOUtils.closeQuietly((AutoCloseable)buffInputStream);
                    IOUtils.closeQuietly((AutoCloseable)inputStream);
                    IOUtils.closeQuietly((AutoCloseable)zipInputStream);
                    return string;
                }
                long size = zipEntry.getSize();
                if (size <= 0x100000L) break block12;
                String string = ResManager.loadKDString((String)"\u56fe\u7247({0})\u5927\u5c0f\u4e0d\u80fd\u8d85\u8fc71M\u3002", (String)"EntImportPicturePlugin_6", (String)"scm-ent-formplugin", (Object[])new Object[]{zipEntry.getName()});
                IOUtils.closeQuietly((AutoCloseable)buffInputStream);
                IOUtils.closeQuietly((AutoCloseable)inputStream);
                IOUtils.closeQuietly((AutoCloseable)zipInputStream);
                return string;
            }
            zipEntry = zipInputStream.getNextEntry();
            continue;
            break;
        }
        IOUtils.closeQuietly((AutoCloseable)buffInputStream);
        IOUtils.closeQuietly((AutoCloseable)inputStream);
        IOUtils.closeQuietly((AutoCloseable)zipInputStream);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int getImageInfoUrl(String fileUrl, Map<String, Map<Integer, Map<String, String>>> picListMap) {
        int result;
        block13: {
            result = 0;
            ZipInputStream zipInputStream = null;
            InputStream inputStream = null;
            TempFileCache fileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            try {
                int timeout = 7200;
                inputStream = fileCache.getInputStream(fileUrl);
                zipInputStream = new ZipInputStream(inputStream, Charset.forName("GBK"));
                ZipEntry zipEntry = null;
                int spliteSize = Integer.parseInt(System.getProperty("redis.tempfile.splite.size", "10")) * 1024 * 1024;
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    String filename = zipEntry.getName();
                    if (zipEntry.isDirectory() || !StringUtils.isNotEmpty((CharSequence)filename) || filename.indexOf(95) <= 0) continue;
                    String name = filename.substring(0, filename.lastIndexOf(46));
                    int index = name.indexOf(95);
                    if (name.length() >= index + 2) {
                        String number = name.substring(0, index);
                        String digit = name.substring(index + 1, index + 2);
                        if (DIGIT_RANGE.contains(digit)) {
                            Map<Integer, Map<String, String>> picList = picListMap.get(number);
                            if (picList == null) {
                                picList = new HashMap<Integer, Map<String, String>>(5);
                                picListMap.put(number, picList);
                            }
                            if (picList.get(Integer.parseInt(digit)) != null) {
                                result = 1;
                                continue;
                            }
                            if (picList.size() >= 5) {
                                result = 2;
                                continue;
                            }
                            byte[] data = this.readDataFromStream(zipInputStream, spliteSize);
                            String tempUrl = fileCache.saveAsUrl(name, data, timeout);
                            HashMap<String, String> imageMap = new HashMap<String, String>(2);
                            imageMap.put("name", filename);
                            imageMap.put("url", tempUrl);
                            picList.put(Integer.parseInt(digit), imageMap);
                            continue;
                        }
                        result = 1;
                        continue;
                    }
                    result = 1;
                }
                zipInputStream.closeEntry();
                IOUtils.closeQuietly((AutoCloseable)zipInputStream);
            }
            catch (KDBizException e) {
                log.error("file batch upload error", (Throwable)e);
                break block13;
            }
            catch (Exception e2) {
                log.error("file batch upload error", (Throwable)e2);
                break block13;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeQuietly(zipInputStream);
                IOUtils.closeQuietly((AutoCloseable)inputStream);
            }
            IOUtils.closeQuietly((AutoCloseable)inputStream);
        }
        return result;
    }

    private boolean isImgName(String name) {
        for (String imgName : MalConstant.IMG_NAME_LIST) {
            if (!name.toLowerCase(Locale.ROOT).endsWith(imgName)) continue;
            return true;
        }
        return false;
    }

    private byte[] readDataFromStream(InputStream in, int spliteSize) {
        try {
            int doneRead = 0;
            byte[] dataAll = new byte[spliteSize];
            do {
                int toRead = in.available();
                int curRead = in.read(dataAll, doneRead, toRead);
                doneRead += curRead;
            } while (in.available() > 0);
            return dataAll;
        }
        catch (IOException e) {
            throw new IllegalStateException("fail read data from file steam : ", e);
        }
    }

    private void allotEntity(List<Long> goodsIdsList) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObjectCollection goodsList = QueryServiceHelper.query((String)"ent_prodmanage", (String)"id,number,thumbnail,picture1,picture2,picture3,picture4", (QFilter[])new QFilter[]{new QFilter("id", "in", goodsIdsList)});
        String hiddenLabel = "";
        TableValueSetter ts = new TableValueSetter(new String[0]);
        for (int i = 0; i < goodsList.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)goodsList.get(i);
            String number = dynamicObject.getString("number");
            ts.set("goods", (Object)dynamicObject.getLong("id"), i);
            if (StringUtils.isNotBlank((Object)dynamicObject.get("thumbnail"))) {
                ts.set("thumbnail", dynamicObject.get("thumbnail"), i);
                this.getPageCache().put(number + "_thumbnail", "true");
            } else {
                hiddenLabel = "increase";
            }
            for (int j = 1; j < 5; ++j) {
                String pictureKey = "picture" + j;
                String picture = dynamicObject.getString(pictureKey);
                if (StringUtils.isNotEmpty((CharSequence)picture)) {
                    ts.set(pictureKey, (Object)picture, i);
                    this.getPageCache().put(number + "_picture", "true");
                    continue;
                }
                hiddenLabel = "increase";
            }
        }
        this.getPageCache().put("hiddenLabel", hiddenLabel);
        model.batchCreateNewEntryRow("entryentity", ts);
    }

    private Map<String, Object> saveUrlFile2TempAttachment(String imageName, String imageUrl) {
        HashMap<String, Object> attachItem = new HashMap<String, Object>();
        if (StringUtils.isEmpty((CharSequence)imageName) && (imageName = imageUrl).lastIndexOf(47) > 0) {
            imageName = imageName.substring(imageName.lastIndexOf(47) + 1);
        }
        attachItem.put("name", imageName);
        String tempUrl = imageUrl;
        attachItem.put("uid", UUID.randomUUID().toString());
        attachItem.put("url", tempUrl);
        attachItem.put("status", "success");
        attachItem.put("entityNum", "ent_importpicture");
        attachItem.put("attKey", "picture");
        attachItem.put("client", "web");
        return attachItem;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        ArrayList<Integer> seqList = new ArrayList<Integer>(16);
        for (Object row : entryentity) {
            if (!StringUtils.isEmpty((CharSequence)row.getString("thumbnail"))) continue;
            seqList.add(row.getInt("seq"));
        }
        if ("save".equals(operateKey)) {
            if (seqList.size() > 0) {
                args.setCancel(true);
                StringBuilder strBuilder = new StringBuilder();
                for (Integer seq : seqList) {
                    strBuilder.append(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u4e3b\u56fe\u4e3a\u7a7a\u3002", (String)"EntImportPicturePlugin_9", (String)"scm-ent-formplugin", (Object[])new Object[]{seq})).append('\n');
                }
                String str = strBuilder.substring(0, strBuilder.length() - 1);
                this.getView().showMessage(ResManager.loadKDString((String)"\u4fdd\u5b58\u56fe\u7247\u5931\u8d25", (String)"EntImportPicturePlugin_2", (String)"scm-ent-formplugin", (Object[])new Object[]{str}), strBuilder.toString(), MessageTypes.Default);
            } else {
                try {
                    this.updateGoodsPicture();
                }
                catch (KDException e) {
                    log.error("\u56fe\u7247\u4e0a\u4f20\u5931\u8d25", (Object)ExceptionUtil.getStackTrace((Throwable)e));
                    throw new KDBizException(e.getMessage());
                }
            }
        }
    }

    private void updateGoodsPicture() {
        String domianUrl = UrlService.getDomainContextUrl() + "/";
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List goodsIds = (List)customParams.get("goodsIds");
        DynamicObject[] goodsDynArray = BusinessDataServiceHelper.load((String)"ent_prodmanage", (String)"id,number,thumbnail,picture1,picture2,picture3,picture4", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)goodsIds)});
        int len = goodsDynArray.length;
        boolean coverFlag = StringUtils.equals((CharSequence)"true", (CharSequence)this.getPageCache().get("coverFlag"));
        HashMap<String, DynamicObject> oldGoodsMap = new HashMap<String, DynamicObject>(len);
        for (DynamicObject goodsDyn : goodsDynArray) {
            String number = goodsDyn.getString("number");
            oldGoodsMap.put(number, goodsDyn);
        }
        DynamicObjectCollection uploadGoodsList = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        HashMap<String, DynamicObject> uploadGoodsMap = new HashMap<String, DynamicObject>(len);
        HashMap<String, String> urlMap = new HashMap<String, String>(len * 5);
        for (DynamicObject entryDyn : uploadGoodsList) {
            DynamicObject goods = entryDyn.getDynamicObject("goods");
            if (goods == null) continue;
            String number = goods.getString("number");
            uploadGoodsMap.put(number, entryDyn);
            DynamicObject goodsDyn = (DynamicObject)oldGoodsMap.get(number);
            this.putUrlMapInfo(entryDyn, goodsDyn, "thumbnail", urlMap, coverFlag, domianUrl);
            for (int j = 1; j < 5; ++j) {
                this.putUrlMapInfo(entryDyn, goodsDyn, "picture" + j, urlMap, coverFlag, domianUrl);
            }
        }
        String selectFields = "id,name,tempfile,url,pageid,size";
        QFilter[] filters = new QFilter[]{new QFilter("tempfile", "=", (Object)"0"), new QFilter("url", "in", urlMap.keySet()), new QFilter("status", "=", (Object)"B")};
        DynamicObject[] att = BusinessDataServiceHelper.load((String)"bd_attachment", (String)selectFields, (QFilter[])filters);
        FileService imageFileService = FileServiceFactory.getImageFileService();
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        for (int i = 0; i < att.length; ++i) {
            String tempUrl = att[i].getString("url");
            String name = att[i].getString("name");
            Object attPk = att[i].getPkValue();
            if (!tempUrl.contains("configKey") || !urlMap.containsKey(tempUrl)) continue;
            String path = FileNameUtils.getAttachmentFileName((String)tenantId, (String)accountId, (Object)attPk, (String)(uuid + "/" + EntImportPicturePlugin.replaceSpeSymbol(name)));
            TempFileCache downLoad = CacheFactory.getCommonCacheFactory().getTempFileCache();
            FileItem fileItem = new FileItem(name, path, downLoad.getInputStream(tempUrl));
            String uploadPatch = imageFileService.upload(fileItem);
            urlMap.put(tempUrl, uploadPatch);
            att[i].set("url", (Object)uploadPatch);
            att[i].set("tempfile", (Object)1);
            att[i].set("pageid", (Object)"");
        }
        SaveServiceHelper.save((DynamicObject[])att);
        ArrayList<String> oldPathList = new ArrayList<String>(goodsDynArray.length * 5);
        for (DynamicObject goodsDyn : goodsDynArray) {
            DynamicObject uploadGoods = (DynamicObject)uploadGoodsMap.get(goodsDyn.getString("number"));
            this.updateGoodsPicture(goodsDyn, uploadGoods, "thumbnail", urlMap, coverFlag, domianUrl, oldPathList);
            for (int i = 1; i < 5; ++i) {
                this.updateGoodsPicture(goodsDyn, uploadGoods, "picture" + i, urlMap, coverFlag, domianUrl, oldPathList);
            }
        }
        SaveServiceHelper.save((DynamicObject[])goodsDynArray);
        this.deleteOldPitcutreFile(oldPathList);
        this.soldPublish(goodsIds);
    }

    private void deleteOldPitcutreFile(List<String> oldPathList) {
        if (oldPathList != null && !oldPathList.isEmpty()) {
            try {
                FileService fileService = FileServiceFactory.getImageFileService();
                for (String path : oldPathList) {
                    fileService.delete(path);
                }
            }
            catch (KDException e) {
                log.error("\u5546\u54c1\u56fe\u7247\u5220\u9664\u6267\u884c\u62a5\u9519", (Throwable)e);
            }
            catch (Exception e) {
                log.error("\u5546\u54c1\u56fe\u7247\u5220\u9664\u6267\u884c\u62a5\u9519", (Throwable)e);
            }
        }
    }

    private void soldPublish(List<Long> goodsIds) {
        DynamicObjectCollection dynList = QueryServiceHelper.query((String)"ent_prodpool", (String)"id,mallstatus", (QFilter[])new QFilter("goods", "in", goodsIds).toArray());
        ArrayList prodpoolId = new ArrayList(dynList.size());
        dynList.forEach(t -> {
            String mallStatus = t.getString("mallstatus");
            if (MallStatusEnum.SOLD.getVal().equals(mallStatus)) {
                prodpoolId.add(t.getLong("id"));
            }
        });
        if (!prodpoolId.isEmpty()) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", String.valueOf(true));
            option.setVariableValue("isStrict", String.valueOf(false));
            CommonUtil.check((OperationResult)OperationServiceHelper.executeOperate((String)"soldpublish", (String)"pmm_prodpool", (Object[])prodpoolId.toArray(), (OperateOption)option));
        }
        PbdMalElasticSearchUtils.MalGoodsBatchSync((String)"pmm_prodmanage", goodsIds);
    }

    private void putUrlMapInfo(DynamicObject entryDyn, DynamicObject goodsDyn, String pictueKey, Map<String, String> urlMap, boolean coverFlag, String domianUrl) {
        String pictureUrl = entryDyn.getString(pictueKey);
        if (StringUtils.isNotEmpty((CharSequence)pictureUrl) && pictureUrl.contains("configKey")) {
            if (pictureUrl.startsWith(domianUrl)) {
                pictureUrl = pictureUrl.substring(domianUrl.length());
            }
            if (coverFlag) {
                urlMap.put(pictureUrl, null);
            } else if (StringUtils.isEmpty((CharSequence)goodsDyn.getString(pictueKey))) {
                urlMap.put(pictureUrl, null);
            }
        } else {
            urlMap.put(pictureUrl, pictureUrl);
        }
    }

    private void updateGoodsPicture(DynamicObject goodsDyn, DynamicObject uploadGoods, String pictueKey, Map<String, String> urlMap, boolean coverFlag, String domianUrl, List<String> oldPathList) {
        String url = uploadGoods.getString(pictueKey);
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            String newUrl;
            if (url.startsWith(domianUrl)) {
                url = url.substring(domianUrl.length());
            }
            if (StringUtils.isNotEmpty((CharSequence)(newUrl = urlMap.get(url)))) {
                if (coverFlag) {
                    String path = goodsDyn.getString(pictueKey);
                    goodsDyn.set(pictueKey, (Object)newUrl);
                    if (StringUtils.isNotEmpty((CharSequence)path) && !path.equals(newUrl)) {
                        oldPathList.add(path);
                    }
                } else if (StringUtils.isEmpty((CharSequence)goodsDyn.getString(pictueKey))) {
                    goodsDyn.set(pictueKey, (Object)newUrl);
                }
            }
        }
    }
}

