/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.formplugin;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.common.ORMUtil;
import kd.scm.common.helper.apiconnector.api.util.EcApiUtil;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.GetCategorysUtil;
import kd.scm.common.util.MalFeeHandleHelper;

public class EntSurchargeAllotPlugin
extends AbstractTreeListPlugin
implements TreeNodeClickListener {
    public static final String rootNodeId = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private static final String KEY_TREEVIEW = "treeviewap";
    private static final String ENTRY_ENTITY = "entryentity";
    public static final String FOCUS_NODE_ID = "focusNodeId";
    protected static final String SOURCE_SHARING = "1";

    public void afterCreateNewData(EventObject e) {
        this.initTree();
        this.refreshEntry();
    }

    private void initTree() {
        TreeNode treenode = this.getCloudData();
        TreeView tree = (TreeView)this.getControl(KEY_TREEVIEW);
        tree.deleteAllNodes();
        tree.addNode(treenode);
        tree.setRootVisible(true);
        tree.expand(treenode.getId());
    }

    public TreeNode getCloudData() {
        ArrayList<TreeNode> cloudNode = new ArrayList<TreeNode>();
        TreeNode RootNode = new TreeNode("", "0", ResManager.loadKDString((String)"\u5168\u90e8", (String)"EntSurchargeAllotPlugin_0", (String)"scm-ent-formplugin", (Object[])new Object[0]));
        RootNode.setText(ResManager.loadKDString((String)"\u5546\u54c1\u5206\u7c7b", (String)"EntSurchargeAllotPlugin_1", (String)"scm-ent-formplugin", (Object[])new Object[0]));
        String rootid = RootNode.getId();
        QFilter filter = new QFilter("standard", "=", (Object)Long.valueOf(EcApiUtil.getStandard((String)SOURCE_SHARING)));
        QFilter[] filters = new QFilter[]{filter};
        ORM orm = ORM.create();
        cloudNode.add(RootNode);
        try (DataSet ds = orm.queryDataSet("mdr_goodsclass", "mdr_goodsclass", this.assembleSelectFilds(), filters, null);){
            for (Row row : ds) {
                TreeNode node = new TreeNode();
                String nodeID = row.getString("id");
                String parentid = row.getString("parent.id");
                node.setText(row.getString("name"));
                if (RootNode.getId().equals(rootid) && parentid.equals("0")) {
                    node.setParentid(rootid);
                } else {
                    node.setParentid(parentid);
                }
                node.setId(nodeID);
                cloudNode.add(node);
            }
        }
        Map<String, TreeNode> nodes = this.buildTree(cloudNode);
        if (null != nodes.get(RootNode.getId())) {
            RootNode = nodes.get(RootNode.getId());
            RootNode.setParentid("");
        }
        return nodes.get(RootNode.getId());
    }

    private Map<String, TreeNode> buildTree(List<TreeNode> nodes) {
        LinkedHashMap<String, TreeNode> allNodes = new LinkedHashMap<String, TreeNode>((int)((double)nodes.size() / 0.75));
        for (TreeNode node : nodes) {
            allNodes.put(node.getId(), node);
        }
        for (TreeNode node : allNodes.values()) {
            TreeNode parentNode = (TreeNode)allNodes.get(node.getParentid());
            if (parentNode == null) continue;
            parentNode.addChild(node);
        }
        return allNodes;
    }

    private String assembleSelectFilds() {
        String selectFields = "id,number,name,parent.id,parent.number,parent.name,level,enable";
        return selectFields;
    }

    public void refreshEntry() {
        List supIdList = BizPartnerUtil.getSupplierByUserOfBizPartner();
        QFilter filters = new QFilter("supplier", "in", (Object)supIdList);
        if (null != this.getPageCache().get(FOCUS_NODE_ID)) {
            ArrayList<String> nodeid = new ArrayList<String>();
            nodeid.add(this.getPageCache().get(FOCUS_NODE_ID));
            ArrayList nodelist = GetCategorysUtil.getAllLeafNodeByLevel(nodeid, (String)SOURCE_SHARING, (int)3);
            ArrayList<Long> idList = new ArrayList<Long>();
            for (String node : nodelist) {
                idList.add(Long.valueOf(node));
            }
            filters.and(new QFilter("category", "in", idList));
        }
        FormShowParameter param = this.getView().getFormShowParameter();
        String operate = (String)param.getCustomParam("operate");
        String surid = (String)param.getCustomParam("surid");
        if ("unallot".equals(operate)) {
            filters.and(new QFilter("surchargeid", "match", (Object)surid));
        }
        ORM orm = ORM.create();
        String orderby = "uploaddate";
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        try (DataSet ds = orm.queryDataSet("ent_prodmanage", "ent_prodmanage", this.assembleSelectProdFilds(), new QFilter[]{filters}, orderby);){
            Iterator rows = ds.iterator();
            int index = 0;
            while (rows.hasNext()) {
                Row row = (Row)rows.next();
                vs.set("number", (Object)row.getString("id"), index);
                ++index;
            }
        }
        model.deleteEntryData(ENTRY_ENTITY);
        model.batchCreateNewEntryRow(ENTRY_ENTITY, vs);
    }

    private String assembleSelectProdFilds() {
        String selectFields = "id,number,name,uploaddate";
        return selectFields;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getControl(KEY_TREEVIEW);
        treeView.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                super.treeNodeClick(evt);
                EntSurchargeAllotPlugin.this.getPageCache().put(EntSurchargeAllotPlugin.FOCUS_NODE_ID, evt.getNodeId().toString());
                EntSurchargeAllotPlugin.this.refreshEntry();
            }
        });
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String searchText = searchEnterEvent.getText();
        List searchField = searchEnterEvent.getFieldNames();
        Search search = (Search)this.getControl("searchap");
        if ("searchap".equals(search.getKey())) {
            List supIdList = BizPartnerUtil.getSupplierByUserOfBizPartner();
            QFilter filters = new QFilter("supplier", "in", (Object)supIdList);
            FormShowParameter param = this.getView().getFormShowParameter();
            String operate = (String)param.getCustomParam("operate");
            String surid = (String)param.getCustomParam("surid");
            if ("unallot".equals(operate)) {
                filters.and(new QFilter("surchargeid", "match", (Object)surid));
            }
            QFilter searchFieldFilter = null;
            for (String field : searchField) {
                if (searchFieldFilter == null) {
                    searchFieldFilter = new QFilter("upper(" + field + ")", "like", (Object)("%" + searchText.toUpperCase() + "%"));
                    continue;
                }
                searchFieldFilter.or(new QFilter("upper(" + field + ")", "like", (Object)("%" + searchText.toUpperCase() + "%")));
            }
            filters.and(searchFieldFilter);
            DynamicObjectCollection dynamicObjects = ORMUtil.queryDynamicObjectCollection((String)"ent_prodmanage", (String)this.assembleSelectProdFilds(), (QFilter[])new QFilter[]{filters}, (String)"uploaddate");
            TableValueSetter vs = new TableValueSetter(new String[0]);
            DynamicObject dyn = null;
            for (int i = 0; i < dynamicObjects.size(); ++i) {
                dyn = (DynamicObject)dynamicObjects.get(i);
                vs.set("number", (Object)dyn.getString("id"), i);
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.deleteEntryData(ENTRY_ENTITY);
            model.batchCreateNewEntryRow(ENTRY_ENTITY, vs);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String itemkey;
        super.afterDoOperation(args);
        OperationResult result = args.getOperationResult();
        if (null == result || !result.isSuccess()) {
            return;
        }
        switch (itemkey = args.getOperateKey()) {
            case "confirm": {
                this.confirmOperate();
                break;
            }
        }
    }

    private void confirmOperate() {
        FormShowParameter param = this.getView().getFormShowParameter();
        String operate = (String)param.getCustomParam("operate");
        if ("allot".equals(operate)) {
            this.allot();
        } else {
            this.unallot();
        }
    }

    public void unallot() {
        FormShowParameter param = this.getView().getFormShowParameter();
        String id = (String)param.getCustomParam("surid");
        HashMap<String, String> surMap = new HashMap<String, String>();
        HashMap<String, BigDecimal> surAmountMap = new HashMap<String, BigDecimal>();
        ArrayList<DynamicObject> prodList = new ArrayList<DynamicObject>();
        if (!this.operateCheck(surMap, surAmountMap, prodList)) {
            return;
        }
        Object[] prods = prodList.toArray(new DynamicObject[prodList.size()]);
        for (int i = 0; i < prods.length; ++i) {
            DynamicObject prod = prods[i];
            String surchargeid = prod.getString("surchargeid");
            String surchargename = prod.getString("surchargename");
            String surchargeamount = prod.getString("surchargeamount");
            String[] surchargeids = surchargeid.split(",");
            String[] surchargenames = surchargename.split(",");
            String[] surchargeamounts = surchargeamount.split(",");
            int index = this.getSurchargeIndex(surchargeids, id);
            if (index == surchargeids.length + 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5546\u54c1\u4e0d\u5b58\u5728\u9009\u4e2d\u7684\u9644\u52a0\u8d39\u3002", (String)"EntSurchargeAllotPlugin_2", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                return;
            }
            surchargeid = this.removeIndex(index, surchargeids);
            surchargename = this.removeIndex(index, surchargenames);
            surchargeamount = this.removeIndex(index, surchargeamounts);
            prod.set("surchargeid", (Object)surchargeid);
            prod.set("surchargename", (Object)surchargename);
            prod.set("surchargeamount", (Object)surchargeamount);
        }
        SaveServiceHelper.save((IDataEntityType)prods[0].getDataEntityType(), (Object[])prods);
        HashMap<String, String> isSuccess = new HashMap<String, String>();
        isSuccess.put("success", "true");
        this.getView().returnDataToParent(isSuccess);
        this.getView().close();
    }

    private String removeIndex(int index, String[] surchargeids) {
        StringBuilder strBuffer = new StringBuilder();
        for (int i = 0; i < surchargeids.length; ++i) {
            if (i == index) continue;
            strBuffer.append(surchargeids[i]).append(',');
        }
        if (strBuffer.length() > 0) {
            return strBuffer.toString().substring(0, strBuffer.toString().length() - 1);
        }
        return strBuffer.toString();
    }

    public int getSurchargeIndex(String[] surchargeids, String id) {
        int index = surchargeids.length + 1;
        for (int i = surchargeids.length - 1; i >= 0; --i) {
            if (!surchargeids[i].equals(id)) continue;
            return i;
        }
        return index;
    }

    public boolean operateCheck(HashMap<String, String> surMap, HashMap<String, BigDecimal> surAmountMap, List<DynamicObject> prods) {
        FormShowParameter param = this.getView().getFormShowParameter();
        String id = (String)param.getCustomParam("surid");
        QFilter idfilter = new QFilter("id", "in", (Object)Long.valueOf(id));
        DynamicObject surcharge = QueryServiceHelper.queryOne((String)"ent_surcharge", (String)"id,name,number,project,project.name,cost", (QFilter[])new QFilter[]{idfilter});
        surMap.put(surcharge.getString("id"), surcharge.getString("project.name"));
        surAmountMap.put(surcharge.getString("id"), surcharge.getBigDecimal("cost"));
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        int[] selectrows = grid.getEntryState().getSelectedRows();
        if (null == selectrows || selectrows.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u5546\u54c1\u3002", (String)"EntSurchargeAllotPlugin_3", (String)"scm-ent-formplugin", (Object[])new Object[0]));
            return false;
        }
        ArrayList<String> prodidList = new ArrayList<String>();
        for (int i = 0; i < selectrows.length; ++i) {
            DynamicObject prod = this.getModel().getEntryRowEntity(ENTRY_ENTITY, selectrows[i]);
            String prodId = prod.getDynamicObject("number").getPkValue().toString();
            MalFeeHandleHelper.clearRedisCacheByGoodsKey((String)prodId);
            prodidList.add(prodId);
        }
        ArrayList prodList = new ArrayList();
        prodidList.forEach(prodid -> prodList.add(Long.valueOf(prodid)));
        QFilter prodfilter = new QFilter("id", "in", prodList);
        DynamicObject[] prodArray = BusinessDataServiceHelper.load((String)"ent_prodmanage", (String)"id,number,surchargename,surchargeid,surchargeamount", (QFilter[])new QFilter[]{prodfilter});
        if (null == prodArray || prodArray.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u5546\u54c1\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"EntSurchargeAllotPlugin_4", (String)"scm-ent-formplugin", (Object[])new Object[0]));
            return false;
        }
        prods.addAll(Arrays.asList(prodArray));
        return true;
    }

    private void allot() {
        FormShowParameter param = this.getView().getFormShowParameter();
        String id = (String)param.getCustomParam("surid");
        HashMap<String, String> surMap = new HashMap<String, String>();
        HashMap<String, BigDecimal> surAmountMap = new HashMap<String, BigDecimal>();
        ArrayList<DynamicObject> prodList = new ArrayList<DynamicObject>();
        if (!this.operateCheck(surMap, surAmountMap, prodList)) {
            return;
        }
        Object[] prods = prodList.toArray(new DynamicObject[0]);
        for (int i = 0; i < prods.length; ++i) {
            DynamicObject prod = prods[i];
            String surchargeid = prod.getString("surchargeid");
            if (StringUtils.isEmpty((String)surchargeid)) {
                prod.set("surchargeid", (Object)id);
                prod.set("surchargename", (Object)surMap.get(id));
                BigDecimal amount = surAmountMap.get(id);
                String amo = String.valueOf(amount.setScale(2, 4));
                prod.set("surchargeamount", (Object)("\uffe5" + amo));
                continue;
            }
            if (!this.checkSameSurcharge(prod, id)) {
                return;
            }
            StringBuilder idsb = new StringBuilder();
            StringBuilder namesb = new StringBuilder();
            StringBuilder amountsb = new StringBuilder();
            idsb.append(prod.getString("surchargeid")).append(',');
            namesb.append(prod.getString("surchargename")).append(',');
            amountsb.append(prod.getString("surchargeamount")).append(',');
            idsb.append(id);
            namesb.append(surMap.get(id));
            BigDecimal amount = surAmountMap.get(id);
            String amo = String.valueOf(amount.setScale(2, 4));
            amountsb.append('\uffe5').append(amo);
            prod.set("surchargeid", (Object)idsb.toString());
            prod.set("surchargename", (Object)namesb.toString());
            prod.set("surchargeamount", (Object)amountsb.toString());
        }
        SaveServiceHelper.save((IDataEntityType)prods[0].getDataEntityType(), (Object[])prods);
        HashMap<String, String> isSuccess = new HashMap<String, String>();
        isSuccess.put("success", "true");
        this.getView().returnDataToParent(isSuccess);
        this.getView().close();
    }

    private boolean checkSameSurcharge(DynamicObject prod, String id) {
        if (prod.getString("surchargeid").contains(id)) {
            this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u5546\u54c1\u201c{0}\u201d\u5df2\u5206\u914d\u8be5\u9644\u52a0\u8d39\u4e0d\u80fd\u91cd\u590d\u5206\u914d\u3002", (String)"EntSurchargeAllotPlugin_5", (String)"scm-ent-formplugin", (Object[])new Object[0]), prod.getString("name")));
            return false;
        }
        return true;
    }
}

