/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.formplugin.edit;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.MalFeeHandleHelper;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.ent.common.plugin.AbstractEntBillPlugIn;

public class EntFreightSchemeEdit
extends AbstractEntBillPlugIn
implements BeforeF7SelectListener {
    private static final String SUPPLIER = "supplier";
    private static final String BIZPARTER = "bizpartner";
    private static final String PROVINCE = "province";
    private static final String CTIY = "city";

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        DynamicObjectCollection supcol = BizPartnerUtil.getSupplierCollByBizPartner();
        if (StringUtils.isNotBlank((CharSequence)MalOrderUtil.getDefaultCurrency())) {
            this.getModel().setValue("curr", (Object)MalOrderUtil.getDefaultCurrency());
        }
        for (DynamicObject sup : supcol) {
            String mallStatus = sup.getString("mallstatus");
            if (!"B".equals(mallStatus)) continue;
            model.setValue(SUPPLIER, sup.get(0));
            long bizpartner = sup.getLong(BIZPARTER);
            model.setValue(BIZPARTER, (Object)bizpartner);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        DynamicObjectCollection entries = model.getEntryEntity("entryentity");
        for (int i = 0; i < entries.size(); ++i) {
            DynamicObjectCollection province = (DynamicObjectCollection)model.getValue(PROVINCE, i);
            if (province.size() == 1) {
                this.getView().setEnable(Boolean.TRUE, i, new String[]{CTIY});
                continue;
            }
            this.getView().setEnable(Boolean.FALSE, i, new String[]{CTIY});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        super.afterDoOperation(args);
        IDataModel model = this.getModel();
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "newentry": {
                DynamicObjectCollection entries = model.getEntryEntity("entryentity");
                this.getView().setEnable(Boolean.FALSE, entries.size() - 1, new String[]{CTIY});
                break;
            }
            case "delete": {
                DynamicObject supplier = (DynamicObject)this.getModel().getValue(SUPPLIER);
                if (supplier == null) break;
                MalFeeHandleHelper.clearRedisCacheBySupKey((String)supplier.getString("id"));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        String name = e.getProperty().getName();
        ChangeData[] changedData = e.getChangeSet();
        int rowIndex = changedData[0].getRowIndex();
        switch (name) {
            case "province": {
                DynamicObjectCollection province = (DynamicObjectCollection)model.getValue(PROVINCE, rowIndex);
                model.setValue("longnumber", null, rowIndex);
                model.setValue(CTIY, null, rowIndex);
                if (province.size() == 1) {
                    this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{CTIY});
                } else {
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{CTIY});
                }
                ArrayList<String> proLongNumberList = new ArrayList<String>();
                for (DynamicObject pro : province) {
                    String longnumber = ((DynamicObject)pro.get(1)).getString("longnumber");
                    proLongNumberList.add(longnumber);
                }
                model.setValue("longnumber", (Object)String.join((CharSequence)",", proLongNumberList), rowIndex);
                break;
            }
            case "city": {
                DynamicObjectCollection procoll = (DynamicObjectCollection)model.getValue(PROVINCE, rowIndex);
                if (this.checkBeforeSave(model)) {
                    DynamicObjectCollection cities = (DynamicObjectCollection)model.getValue(CTIY, rowIndex);
                    if (null == cities || cities.size() == 0) {
                        model.setValue("longnumber", null, rowIndex);
                        if (procoll.size() == 0) {
                            model.setValue("longnumber", null, rowIndex);
                            break;
                        }
                        model.setValue("longnumber", (Object)((DynamicObject)((DynamicObject)procoll.get(0)).get(1)).getString("longnumber"), rowIndex);
                        break;
                    }
                    ArrayList<String> cityLongNumberList = new ArrayList<String>();
                    for (DynamicObject city : cities) {
                        String longnumber = ((DynamicObject)city.get(1)).getString("longnumber");
                        cityLongNumberList.add(longnumber);
                    }
                    model.setValue("longnumber", (Object)String.join((CharSequence)",", cityLongNumberList), rowIndex);
                    break;
                }
                model.setValue(CTIY, null, rowIndex);
                if (procoll.size() == 0) {
                    model.setValue("longnumber", null, rowIndex);
                    break;
                }
                model.setValue("longnumber", (Object)((DynamicObject)((DynamicObject)procoll.get(0)).get(1)).getString("longnumber"), rowIndex);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        IDataModel model = this.getModel();
        if (operateKey.equals("save")) {
            if (!this.checkBeforeSave(model)) {
                args.setCancel(true);
                return;
            }
            DynamicObject supplier = (DynamicObject)this.getModel().getValue(SUPPLIER);
            if (supplier != null) {
                MalFeeHandleHelper.clearRedisCacheBySupKey((String)supplier.getString("id"));
            }
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"save")) {
            DynamicObjectCollection entries = this.getModel().getEntryEntity("entryentity");
            for (int i = 0; i < entries.size(); ++i) {
                DynamicObject object = (DynamicObject)entries.get(i);
                String province = object.getString(PROVINCE);
                if (!province.contains("[]")) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199 \u201c\u7701\u201d\u3002", (String)"EntFreightSchemeEdit_0", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            DynamicObjectCollection supplierCol = BizPartnerUtil.getMalSupplierCollByBizPartner();
            ArrayList<Long> supIDList = new ArrayList<Long>();
            for (DynamicObject supplier : supplierCol) {
                supIDList.add(supplier.getLong("id"));
                QFilter supIDFilter = new QFilter(SUPPLIER, "in", supIDList);
                QFilter idFilter = new QFilter("id", "!=", this.getModel().getDataEntity().getPkValue());
                DynamicObjectCollection freight = QueryServiceHelper.query((String)"ent_freightscheme", (String)"id", (QFilter[])new QFilter[]{supIDFilter, idFilter});
                if (freight.size() <= 0) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e00\u4e2a\u4f9b\u5e94\u5546\u53ea\u80fd\u7ef4\u62a4\u4e00\u5957\u8fd0\u8d39\u65b9\u6848\u3002", (String)"EntFreightSchemeEdit_1", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    private boolean checkBeforeSave(IDataModel model) {
        HashMap<String, Integer> proMap = new HashMap<String, Integer>();
        DynamicObjectCollection entries = model.getEntryEntity("entryentity");
        if (null != entries && entries.size() >= 1) {
            for (int i = 0; i < entries.size(); ++i) {
                int j = i + 1;
                DynamicObject entry = (DynamicObject)entries.get(i);
                DynamicObjectCollection city = (DynamicObjectCollection)entry.get(CTIY);
                if (null == city || city.size() == 0) {
                    DynamicObjectCollection provinces = (DynamicObjectCollection)entry.get(PROVINCE);
                    for (DynamicObject obj : provinces) {
                        DynamicObject pro = obj.getDynamicObject(1);
                        if (null != proMap.get(pro.getPkValue().toString())) {
                            this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u8fd0\u8d39\u4fe1\u606f\u7b2c{0}\u884c\u5206\u5f55\u548c\u7b2c{1}\u884c\u5206\u5f55\u5b58\u5728\u76f8\u540c\u7701\u4efd\u4e14\u540c\u65f6\u672a\u5f55\u5165\u5e02\uff0c\u8bf7\u4fee\u6539\u3002", (String)"EntFreightSchemeEdit_2", (String)"scm-ent-formplugin", (Object[])new Object[0]), j, proMap.get(pro.getPkValue().toString())));
                            return false;
                        }
                        proMap.put(pro.getPkValue().toString(), j);
                    }
                    continue;
                }
                for (DynamicObject obj : city) {
                    DynamicObject cobj = obj.getDynamicObject(1);
                    if (null != proMap.get(cobj.getPkValue().toString())) {
                        this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u8fd0\u8d39\u4fe1\u606f\u7b2c{0}\u884c\u5206\u5f55\u548c\u7b2c{1}\u884c\u5206\u5f55\u5b58\u5728\u76f8\u540c\u5e02\uff0c\u8bf7\u4fee\u6539\u3002", (String)"EntFreightSchemeEdit_3", (String)"scm-ent-formplugin", (Object[])new Object[0]), j, proMap.get(cobj.getPkValue().toString())));
                        return false;
                    }
                    proMap.put(cobj.getPkValue().toString(), j);
                }
            }
        }
        return true;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        e.getSource();
        BasedataEdit city = (BasedataEdit)this.getView().getControl(CTIY);
        city.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"bar_save"});
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        IDataModel model = this.getModel();
        String fieldKey = arg0.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
        int index = arg0.getRow();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)CTIY)) {
            DynamicObjectCollection province = (DynamicObjectCollection)model.getValue(PROVINCE, index);
            ArrayList<Long> proLongNumberList = new ArrayList<Long>();
            for (DynamicObject pro : province) {
                Long proID = ((DynamicObject)pro.get(1)).getLong("id");
                proLongNumberList.add(proID);
            }
            QFilter filter = new QFilter("parent", "in", proLongNumberList);
            showParameter.getListFilterParameter().getQFilters().add(filter);
        }
    }
}

