/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.formplugin.edit;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BasedataFuzzySearchEvent;
import kd.bos.form.field.events.BasedataFuzzySearchListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.StringConversionUtil;
import kd.scm.common.util.ValidateDataUtil;
import kd.scm.ent.common.plugin.AbstractEntBillPlugIn;
import kd.scm.malcore.domain.GoodsInventory;
import kd.scm.malcore.domain.GoodsInventoryHandleSku;
import kd.scm.malcore.util.MalFuzzySearchUtil;

public class EntInstockEdit
extends AbstractEntBillPlugIn
implements BeforeF7SelectListener,
BasedataFuzzySearchListener,
HyperLinkClickListener {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String PROD_NUMBER = "goods";
    private static final String SUPPLIER = "supplier";
    private static final String PROD_SEQ = "seq";
    private static final String PROD_UNIT = "unit";
    private static final String PROD_CURQTY = "currentqty";
    private static final String PROD_QTY = "qty";
    private static final String PROD_NEWQTY = "newqty";
    private static final String PROD_AVAILABLEQTY = "availableqty";
    private static final String PROD_LOCKEDQTY = "lockedqty";

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if ((itemKey.equalsIgnoreCase("bar_save") || itemKey.equalsIgnoreCase("bar_submit")) && !ValidateDataUtil.EntryDuplicateValidate((IFormView)this.getView(), (DynamicObjectCollection)this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY), (String)PROD_NUMBER)) {
            evt.setCancel(true);
            return;
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObject supplier = (DynamicObject)this.getModel().getValue(SUPPLIER);
        String name = beforeF7SelectEvent.getProperty().getName();
        if (name.equals(PROD_NUMBER)) {
            if (Objects.nonNull(supplier)) {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.getListFilterParameter().getQFilters().add(new QFilter(SUPPLIER, "=", (Object)supplier.getLong("id")));
                showParameter.setCustomParam("ismergerows", (Object)true);
            } else {
                beforeF7SelectEvent.setCancel(true);
            }
        }
    }

    private ArrayList<DynamicObject> queryProd() {
        ArrayList<DynamicObject> allProd = new ArrayList<DynamicObject>();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String selectcol = (String)showParameter.getCustomParam("allProd");
        if (null != selectcol) {
            int i;
            ArrayList allProdid = StringConversionUtil.conversion((String)selectcol);
            ArrayList<Long> list = new ArrayList<Long>(allProdid.size());
            for (String str : allProdid) {
                list.add(Long.parseLong(str));
            }
            QFilter goodsfilter = new QFilter(PROD_NUMBER, "in", list);
            QFilter[] params = new QFilter[]{goodsfilter};
            String selectFields = "id,goods,unit,qty,supplier,bizpartner,goodsclass,lockedqty,availableqty";
            DynamicObject[] prods = BusinessDataServiceHelper.load((String)"ent_inventory", (String)selectFields, (QFilter[])params);
            for (i = 0; i < prods.length; ++i) {
                allProd.add(prods[i]);
            }
            if (null != list) {
                for (i = 0; i < prods.length; ++i) {
                    list.remove(Long.parseLong(((DynamicObject)prods[i].get(PROD_NUMBER)).getPkValue().toString()));
                }
                QFilter idfilter = new QFilter("id", "in", list);
                selectFields = "id,number,unit,supplier,category";
                DynamicObject[] goods = BusinessDataServiceHelper.load((String)"ent_prodmanage", (String)selectFields, (QFilter[])new QFilter[]{idfilter});
                for (int i2 = 0; i2 < goods.length; ++i2) {
                    allProd.add(goods[i2]);
                }
            }
        }
        return allProd;
    }

    public void afterCreateNewData(EventObject e) {
        ArrayList<DynamicObject> allProd;
        DynamicObjectCollection bizPartners = BizPartnerUtil.getBizPartners();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Long supplierPrt = (Long)showParameter.getCustomParam(SUPPLIER);
        if (Objects.nonNull(supplierPrt)) {
            DynamicObject[] suppliers;
            QFilter enterFilter = new QFilter("id", "=", (Object)supplierPrt);
            for (DynamicObject dyn : suppliers = BusinessDataServiceHelper.load((String)"bd_supplier", (String)"id,name,number,bizpartner", (QFilter[])new QFilter[]{enterFilter})) {
                model.setValue(SUPPLIER, (Object)supplierPrt);
                DynamicObject bizpartnerdy = (DynamicObject)dyn.get("bizpartner");
                if (null == bizpartnerdy) continue;
                model.setValue("bizpartner", (Object)bizpartnerdy.getLong("id"));
            }
        } else {
            model.setValue("bizpartner", bizPartners != null & bizPartners.size() > 0 ? ((DynamicObject)bizPartners.get(0)).get("bizpartner") : Long.valueOf(0L));
            DynamicObjectCollection supplierColl = BizPartnerUtil.getMalSupplierCollByBizPartner();
            model.setValue(SUPPLIER, supplierColl != null & supplierColl.size() > 0 ? ((DynamicObject)supplierColl.get(0)).get("id") : Long.valueOf(0L));
        }
        DynamicObject supplier = (DynamicObject)model.getValue(SUPPLIER);
        if (null != supplier) {
            model.setValue("org", supplier.get("createorg"));
        }
        if ((allProd = this.queryProd()).size() > 0) {
            model.deleteEntryData(ENTRY_ENTITY);
            TableValueSetter vs = new TableValueSetter(new String[0]);
            for (int i = 0; i < allProd.size(); ++i) {
                DynamicObject prod = allProd.get(i);
                vs.set(PROD_SEQ, (Object)(i + 1), i);
                if (prod.getDataEntityType().getName().equals("ent_prodmanage")) {
                    vs.set(PROD_NUMBER, (Object)prod.getLong("id"), i);
                } else {
                    vs.set(PROD_NUMBER, (Object)((DynamicObject)prod.get(PROD_NUMBER)).getLong("id"), i);
                    if (null != prod.get(PROD_QTY)) {
                        vs.set(PROD_CURQTY, (Object)prod.getBigDecimal(PROD_QTY), i);
                        vs.set(PROD_NEWQTY, (Object)(prod.getBigDecimal(PROD_QTY).compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : prod.getBigDecimal(PROD_QTY)), i);
                        vs.set(PROD_AVAILABLEQTY, (Object)prod.getBigDecimal(PROD_AVAILABLEQTY), i);
                        vs.set(PROD_LOCKEDQTY, (Object)prod.getBigDecimal(PROD_LOCKEDQTY), i);
                    }
                }
                if (null != prod.get(PROD_UNIT)) {
                    vs.set(PROD_UNIT, (Object)((DynamicObject)prod.get(PROD_UNIT)).getLong("id"), i);
                }
                vs.set(PROD_QTY, null, i);
            }
            model.batchCreateNewEntryRow(ENTRY_ENTITY, vs);
        }
        this.reCalculateGoodsInventoryQty();
    }

    public void propertyChanged(PropertyChangedArgs arg0) {
        String proName = arg0.getProperty().getName();
        int rowIndex = arg0.getChangeSet()[0].getRowIndex();
        Object value = arg0.getChangeSet()[0].getNewValue();
        BillModel dataModel = (BillModel)this.getModel();
        BigDecimal currentqty = (BigDecimal)dataModel.getValue(PROD_CURQTY, rowIndex);
        switch (proName) {
            case "goods": {
                DynamicObject newObject = (DynamicObject)arg0.getChangeSet()[0].getNewValue();
                if (newObject == null) {
                    return;
                }
                DynamicObjectCollection oldRows = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
                if (oldRows == null || oldRows.size() == 0) {
                    return;
                }
                int count = 0;
                int currentRow = arg0.getChangeSet()[0].getRowIndex();
                DynamicObject oldObject = null;
                for (DynamicObject obj : oldRows) {
                    oldObject = obj.getDynamicObject(PROD_NUMBER);
                    if (oldObject != null && oldObject.getPkValue().equals(newObject.getPkValue())) {
                        ++count;
                    }
                    if (oldObject == null || count != 2) continue;
                    this.getView().showConfirm(MessageFormat.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5f55\u5165\u91cd\u590d\u7684\u5546\u54c1\u201c{0}\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"EntInstockEdit_1", (String)"scm-ent-formplugin", (Object[])new Object[0]), oldObject.getString("number")), MessageBoxOptions.OK);
                    this.getModel().setValue(PROD_NUMBER, null, currentRow);
                    return;
                }
                if (!(value instanceof DynamicObject)) break;
                DynamicObject goods = (DynamicObject)value;
                DynamicObject supplier = (DynamicObject)this.getModel().getValue(SUPPLIER);
                dataModel.setValue(PROD_UNIT, goods.get("unit_id"), rowIndex);
                DynamicObject qtyDyn = QueryServiceHelper.queryOne((String)"ent_inventory", (String)"qty,availableqty,lockedqty", (QFilter[])new QFilter[]{new QFilter(SUPPLIER, "in", supplier.getPkValue()).and(new QFilter(PROD_NUMBER, "in", goods.getPkValue()))});
                if (qtyDyn != null) {
                    dataModel.setValue(PROD_CURQTY, (Object)qtyDyn.getBigDecimal(PROD_QTY), rowIndex);
                    dataModel.setValue(PROD_QTY, null, rowIndex);
                    dataModel.setValue(PROD_NEWQTY, (Object)(qtyDyn.getBigDecimal(PROD_QTY).compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : qtyDyn.getBigDecimal(PROD_QTY)), rowIndex);
                    dataModel.setValue(PROD_AVAILABLEQTY, (Object)qtyDyn.getBigDecimal(PROD_AVAILABLEQTY), rowIndex);
                    dataModel.setValue(PROD_LOCKEDQTY, (Object)qtyDyn.getBigDecimal(PROD_LOCKEDQTY), rowIndex);
                    break;
                }
                dataModel.setValue(PROD_CURQTY, null, rowIndex);
                dataModel.setValue(PROD_QTY, null, rowIndex);
                dataModel.setValue(PROD_NEWQTY, null, rowIndex);
                dataModel.setValue(PROD_AVAILABLEQTY, null, rowIndex);
                QFilter malOrderQFilter = new QFilter("entryentity.goods", "=", (Object)goods.getLong("id"));
                malOrderQFilter.and("billstatus", "=", (Object)BillStatusEnum.SUBMIT.getVal());
                BigDecimal lockedQty = BigDecimal.ZERO;
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mal_order", (String)"entryentity.goods goods,entryentity.qty qty", (QFilter[])malOrderQFilter.toArray(), null);){
                    for (Row row : dataSet) {
                        lockedQty = lockedQty.add(row.getBigDecimal(PROD_QTY));
                    }
                }
                dataModel.setValue(PROD_LOCKEDQTY, (Object)lockedQty, rowIndex);
                break;
            }
            case "qty": {
                dataModel.beginInit();
                if (BigDecimal.valueOf(0L, currentqty.scale()).compareTo(currentqty.add((BigDecimal)value)) <= 0) {
                    dataModel.setValue(PROD_NEWQTY, (Object)currentqty.add((BigDecimal)value), rowIndex);
                } else {
                    dataModel.setValue(PROD_QTY, (Object)0, rowIndex);
                    dataModel.setValue(PROD_NEWQTY, (Object)0, rowIndex);
                }
                dataModel.endInit();
                break;
            }
            case "newqty": {
                dataModel.beginInit();
                if (BigDecimal.ZERO.compareTo((BigDecimal)value) > 0) {
                    dataModel.setValue(PROD_NEWQTY, (Object)BigDecimal.ZERO, rowIndex);
                }
                dataModel.setValue(PROD_QTY, (Object)((BigDecimal)dataModel.getValue(PROD_NEWQTY, rowIndex)).subtract(currentqty), rowIndex);
                dataModel.endInit();
                break;
            }
        }
        this.getView().updateView(ENTRY_ENTITY);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit goodsEdit = (BasedataEdit)this.getControl(PROD_NUMBER);
        goodsEdit.addBeforeF7SelectListener(this::beforeF7Select);
        goodsEdit.addBasedataFuzzySearchListener((BasedataFuzzySearchListener)this);
        BasedataEdit supplier = (BasedataEdit)this.getControl(SUPPLIER);
        supplier.setQFilter(BizPartnerUtil.assembleQFilterBizPartner());
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        switch (operateKey) {
            case "submit": {
                if (operationResult.isSuccess()) {
                    this.getView().invokeOperation("refresh");
                    break;
                }
                this.reCalculateGoodsInventoryQty();
            }
        }
    }

    private void reCalculateGoodsInventoryQty() {
        this.getModel().beginInit();
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(ENTRY_ENTITY);
        HashMap<Long, DynamicObject> goodsIdAndDynMap = new HashMap<Long, DynamicObject>(dynamicObjectCollection.size());
        HashMap<Long, GoodsInventoryHandleSku> goodsIdAndQtyMap = new HashMap<Long, GoodsInventoryHandleSku>(dynamicObjectCollection.size());
        ArrayList<GoodsInventoryHandleSku> skuList = new ArrayList<GoodsInventoryHandleSku>(dynamicObjectCollection.size());
        for (DynamicObject entry : dynamicObjectCollection) {
            if (entry.getDynamicObject(PROD_NUMBER) == null) continue;
            long goodsId = entry.getLong("goods_id");
            GoodsInventoryHandleSku sku = new GoodsInventoryHandleSku();
            sku.setGoodsId(Long.valueOf(goodsId));
            sku.setGoodsNumber(entry.getDynamicObject(PROD_NUMBER).getString("number"));
            sku.setQty(entry.getBigDecimal(PROD_NEWQTY));
            skuList.add(sku);
            goodsIdAndDynMap.put(goodsId, entry);
            goodsIdAndQtyMap.put(goodsId, sku);
        }
        List goodsInventories = (List)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pmm", (String)"IPmmGoodsInventoryService", (String)"queryGoodsInventory", (Object[])new Object[]{skuList});
        List noInventoryGoodsIds = goodsInventories.stream().filter(GoodsInventory::isUnlimited).map(GoodsInventory::getGoodsId).collect(Collectors.toList());
        HashMap goodsIdAndMalOrderQtyMap = new HashMap(noInventoryGoodsIds.size());
        QFilter qFilter = new QFilter("entryentity.goods", "in", noInventoryGoodsIds);
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.SUBMIT.getVal());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mal_order", (String)"entryentity.goods goods,entryentity.qty qty", (QFilter[])qFilter.toArray(), null);){
            dataSet.forEach(row -> {
                BigDecimal qty = goodsIdAndMalOrderQtyMap.getOrDefault(row.getLong(PROD_NUMBER), BigDecimal.ZERO);
                qty = qty.add(row.getBigDecimal(PROD_QTY));
                goodsIdAndMalOrderQtyMap.put(row.getLong(PROD_NUMBER), qty);
            });
        }
        for (GoodsInventory goodsInventory : goodsInventories) {
            GoodsInventoryHandleSku sku = (GoodsInventoryHandleSku)goodsIdAndQtyMap.get(goodsInventory.getGoodsId());
            DynamicObject dynamicObject = (DynamicObject)goodsIdAndDynMap.get(goodsInventory.getGoodsId());
            BigDecimal currentqty = dynamicObject.getBigDecimal(PROD_CURQTY);
            BigDecimal lockedQty = goodsInventory.isUnlimited() ? goodsIdAndMalOrderQtyMap.getOrDefault(goodsInventory.getGoodsId(), BigDecimal.ZERO) : goodsInventory.getLockedQty();
            if (sku.getQty().compareTo(lockedQty) < 0) {
                dynamicObject.set(PROD_LOCKEDQTY, (Object)lockedQty);
            }
            if (goodsInventory.getCurrentQty().compareTo(currentqty) == 0) continue;
            dynamicObject.set(PROD_CURQTY, (Object)goodsInventory.getCurrentQty());
            dynamicObject.set(PROD_NEWQTY, (Object)BigDecimal.ZERO);
            dynamicObject.set(PROD_QTY, (Object)BigDecimal.ZERO);
            dynamicObject.set(PROD_LOCKEDQTY, (Object)goodsInventory.getLockedQty());
            dynamicObject.set(PROD_AVAILABLEQTY, (Object)goodsInventory.getAvailableQty());
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRY_ENTITY);
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        e.getSource();
    }

    public void handleData(BasedataFuzzySearchEvent arg0) {
        List queryData = arg0.getQueryData();
        MalFuzzySearchUtil.queryDataDuplicatesRemoveByNumber((List)queryData);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        DynamicObjectCollection rows = this.getModel().getEntryEntity(ENTRY_ENTITY);
        if ("goodsname".equals(hyperLinkClickEvent.getFieldName())) {
            DynamicObject dynamicObject = (DynamicObject)rows.get(hyperLinkClickEvent.getRowIndex());
            DynamicObject goods = (DynamicObject)dynamicObject.get(PROD_NUMBER);
            long goodsId = goods.getLong("id");
            this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)"ent_prodmanage", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.VIEW, (long)goodsId, null, null));
        }
    }
}

