/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.formplugin.edit;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scm.common.constant.CalConstant;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.common.util.cal.CalculateUtils;
import kd.scm.ent.business.service.impl.EntPriceRequestValidatorServiceImpl;
import kd.scm.ent.common.plugin.AbstractEntBillPlugIn;
import kd.scm.malcore.domain.LadderPriceInfo;
import kd.scm.malcore.enums.MallStatusEnum;

public class EntPriceRequestEdit
extends AbstractEntBillPlugIn
implements HyperLinkClickListener,
RowClickEventListener,
CellClickListener,
BeforeF7SelectListener,
AfterF7SelectListener {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String BTN_ADJUST = "bar_adjust";
    private static final String CFMSTATUS = "cfmstatus";
    private static final String MODE = "adjustmode";
    private static final String TYPE = "adjusttype";
    private static final String PERCENT = "percent";
    private static final String AMOUNT = "amount";
    private static final String ORG = "org";
    private static final String ADJUSTPRICE = "adjustPrice";
    private static final String SUPPLIER = "supplier";
    private static final String BIZPARTER = "bizpartner";
    private static final String PROD_SEQ = "seq";
    private static final String PROD_NUMBER = "goods";
    private static final String PROD_CLASS = "class";
    private static final String PROD_UNIT = "unit";
    private static final String PROD_PRICE = "price";
    private static final String PROD_PRICEOLD = "price_old";
    private static final String PROD_TAXPRICE = "taxprice";
    private static final String PROD_TAXPRICEOLD = "taxprice_old";
    private static final String PROD_SHOPPRICE = "shopprice";
    private static final String PROD_SHOPPRICEOLD = "shopprice_old";
    private static final String PROD_TAXRATE = "taxrate";
    private static final String PROD_CATEGORY = "category";
    private static final String PROD_TAXRATEID_ID = "taxrateid_id";
    public static final String PRODPOOL = "prodpool";

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        DynamicObjectCollection prodPoolDynColl = null;
        this.getModel().beginInit();
        if (showParameter.getCustomParams().get("prodPoolIdSet") != null) {
            Set prodPoolIdSet = (Set)SerializationUtils.fromJsonString((String)((String)showParameter.getCustomParams().get("prodPoolIdSet")), Set.class);
            prodPoolDynColl = QueryServiceHelper.query((String)"ent_prodpool", (String)this.getSelectProperties(), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)prodPoolIdSet)});
            this.deleteNewEmptyData();
            this.allotEntryData(prodPoolDynColl);
            showParameter.setCustomParam("prodPoolIdSet", null);
        }
        if (StringUtils.isNotBlank((CharSequence)MalOrderUtil.getDefaultCurrency())) {
            this.getModel().setValue("curr", (Object)MalOrderUtil.getDefaultCurrency());
        }
        this.allotHeadData(prodPoolDynColl);
        this.getModel().endInit();
        this.getView().updateView(ORG);
        this.getView().updateView(SUPPLIER);
        this.getView().updateView(BIZPARTER);
        this.getView().updateView("person");
        this.getView().updateView(ENTRY_ENTITY);
        this.getPageCache().remove("isCreateNewData");
    }

    public void afterBindData(EventObject e) {
        String param;
        super.afterBindData(e);
        if (!MalOrderUtil.getDefaultMalVersion()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"protocolnumber"});
            this.getView().setEnable(Boolean.FALSE, new String[]{ORG});
        }
        if (Boolean.parseBoolean(param = ParamUtil.getSysCtrlParam((String)"UUPIH+47DAK", (String)"latestladderprice"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"pricetype", "ladderprice"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"pricetype", "ladderprice"});
        }
        this.setPricelimit();
        Object cfmstatus = this.getModel().getValue(CFMSTATUS);
        if ("D".equals(cfmstatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"resubmit"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"resubmit"});
        }
    }

    private void allotHeadData(DynamicObjectCollection prodPoolDynColl) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        model.setValue("person", (Object)RequestContext.get().getUserId());
        Long supplierPrt = (Long)showParameter.getCustomParam(SUPPLIER);
        if (Objects.nonNull(supplierPrt)) {
            DynamicObject[] suppliers;
            QFilter enterFilter = new QFilter("id", "=", (Object)supplierPrt);
            for (DynamicObject dyn : suppliers = BusinessDataServiceHelper.load((String)"bd_supplier", (String)"id,name,number,bizpartner", (QFilter[])new QFilter[]{enterFilter})) {
                model.setValue(SUPPLIER, (Object)supplierPrt);
                DynamicObject bizpartnerdy = (DynamicObject)dyn.get(BIZPARTER);
                if (null == bizpartnerdy) continue;
                model.setValue(BIZPARTER, (Object)bizpartnerdy.getLong("id"));
            }
        } else {
            DynamicObjectCollection supcol = BizPartnerUtil.getSupplierCollByBizPartner();
            for (DynamicObject sup : supcol) {
                String mallStatus = sup.getString("mallstatus");
                if (!"B".equals(mallStatus)) continue;
                model.setValue(SUPPLIER, sup.get(0));
                long bizpartner = sup.getLong(BIZPARTER);
                model.setValue(BIZPARTER, (Object)bizpartner);
            }
        }
        if (prodPoolDynColl != null && !prodPoolDynColl.isEmpty()) {
            model.setValue(ORG, (Object)((DynamicObject)prodPoolDynColl.get(0)).getLong("auditorg"));
        } else {
            this.setOrgData(model);
        }
    }

    private void setOrgData(AbstractFormDataModel model) {
        if (this.getModel().getValue(ORG) != null) {
            return;
        }
        DynamicObject supplier = (DynamicObject)model.getValue(SUPPLIER);
        String supfilterpk = "0";
        DynamicObject org = null;
        if (null != supplier && null != supplier.getPkValue()) {
            supfilterpk = supplier.getPkValue().toString();
        }
        if (StringUtils.isNotEmpty((CharSequence)supfilterpk)) {
            QFilter supfilter = new QFilter(SUPPLIER, "=", (Object)Long.parseLong(supfilterpk));
            supfilter.and(CFMSTATUS, "=", (Object)"B");
            DynamicObject auditorg = BusinessDataServiceHelper.loadSingle((String)"ent_suprequest", (String)ORG, (QFilter[])new QFilter[]{supfilter});
            if (null != auditorg) {
                org = auditorg.getDynamicObject(ORG);
            }
        }
        if (null != org) {
            QFilter idFilter = new QFilter("id", "=", (Object)Long.parseLong(org.getPkValue().toString()));
            idFilter.and("fispurchase", "=", (Object)"1");
            QFilter[] filters = new QFilter[]{idFilter};
            String select = "id";
            DynamicObject org1 = QueryServiceHelper.queryOne((String)"bos_org", (String)select, (QFilter[])filters);
            if (null != org1) {
                model.setValue(ORG, (Object)org);
            }
        }
        if (model.getValue(ORG) == null) {
            model.setValue(ORG, (Object)OrgUnitServiceHelper.getRootOrgId());
        }
    }

    private void allotEntryData(DynamicObjectCollection prodPoolDynColl) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        Set prodPoolIds = model.getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY).stream().map(k -> k.getDynamicObject(PRODPOOL).getLong("id")).collect(Collectors.toSet());
        if (null != prodPoolDynColl && prodPoolDynColl.size() > 0) {
            TableValueSetter vs = new TableValueSetter(new String[0]);
            for (int i = 0; i < prodPoolDynColl.size(); ++i) {
                DynamicObject prodPoolDyn = (DynamicObject)prodPoolDynColl.get(i);
                if (prodPoolIds.contains(prodPoolDyn.getLong(PRODPOOL))) continue;
                vs.set(PROD_NUMBER, (Object)prodPoolDyn.getLong(PROD_NUMBER), i);
                vs.set(PROD_UNIT, (Object)prodPoolDyn.getLong(PROD_UNIT), i);
                vs.set(PROD_CLASS, (Object)prodPoolDyn.getLong(PROD_CATEGORY), i);
                vs.set(PROD_PRICEOLD, (Object)prodPoolDyn.getBigDecimal(PROD_PRICE), i);
                vs.set(PROD_TAXPRICEOLD, (Object)prodPoolDyn.getBigDecimal(PROD_TAXPRICE), i);
                vs.set(PROD_TAXPRICE, (Object)prodPoolDyn.getBigDecimal(PROD_TAXPRICE), i);
                vs.set(PROD_PRICE, (Object)prodPoolDyn.getBigDecimal(PROD_PRICE), i);
                vs.set(PROD_TAXRATE, (Object)prodPoolDyn.getBigDecimal(PROD_TAXRATE), i);
                vs.set(PROD_TAXRATEID_ID, (Object)prodPoolDyn.getLong("taxrateid"), i);
                vs.set(PRODPOOL, (Object)prodPoolDyn.getLong(PRODPOOL), i);
            }
            model.batchCreateNewEntryRow(ENTRY_ENTITY, vs);
            DynamicObjectCollection entrys = model.getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
            for (DynamicObject row : entrys) {
                DynamicObjectCollection pmm_prodpool;
                DynamicObject newObject = row.getDynamicObject(PROD_NUMBER);
                int rowIndex = row.getInt(PROD_SEQ) - 1;
                if (null == newObject) {
                    IDataModel entryOperate = this.getModel();
                    entryOperate.setEntryCurrentRowIndex(ENTRY_ENTITY, rowIndex);
                    entryOperate.deleteEntryData("subentryentity");
                    continue;
                }
                Long goodsId = newObject.getLong("id");
                Object pool = this.getModel().getValue(PRODPOOL, rowIndex);
                QFilter qFilter = new QFilter("goods.id", "=", (Object)goodsId);
                if (null != pool) {
                    DynamicObject poolInfo = (DynamicObject)pool;
                    qFilter.and(new QFilter("id", "=", (Object)poolInfo.getLong("id")));
                }
                if ((pmm_prodpool = QueryServiceHelper.query((String)"pmm_prodpool", (String)"priceentry.qtyto,priceentry.qtyfrom,priceentry.ladprice", (QFilter[])qFilter.toArray())).size() > 1) {
                    IDataModel entryOperate = this.getModel();
                    entryOperate.setEntryCurrentRowIndex(ENTRY_ENTITY, rowIndex);
                    entryOperate.deleteEntryData("subentryentity");
                    boolean ispricetype = false;
                    for (DynamicObject info : pmm_prodpool) {
                        int subRow = entryOperate.createNewEntryRow("subentryentity");
                        BigDecimal qtyto = info.getBigDecimal("priceentry.qtyto");
                        BigDecimal qtyfrom = info.getBigDecimal("priceentry.qtyfrom");
                        BigDecimal ladprice = info.getBigDecimal("priceentry.ladprice");
                        model.setValue("qtyto", (Object)qtyto, subRow, rowIndex);
                        model.setValue("qtyfrom", (Object)qtyfrom, subRow, rowIndex);
                        model.setValue("ladprice", (Object)ladprice, subRow, rowIndex);
                        ispricetype = true;
                    }
                    if (ispricetype) {
                        this.getModel().setValue("pricetype", (Object)"B", rowIndex);
                        continue;
                    }
                    this.getModel().setValue("pricetype", (Object)"A", rowIndex);
                    entryOperate.deleteEntryData("subentryentity");
                    continue;
                }
                model.setValue("pricetype", (Object)"A", rowIndex);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs arg0) {
        String propertyName;
        super.propertyChanged(arg0);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        switch (propertyName = arg0.getProperty().getName()) {
            case "supplier": {
                DynamicObject supplier = this.getModel().getDataEntity(true).getDynamicObject(propertyName);
                if (supplier == null) {
                    return;
                }
                DynamicObject bizpartner = supplier.getDynamicObject(BIZPARTER);
                this.getModel().setValue(BIZPARTER, (Object)bizpartner);
                break;
            }
            case "taxprice": {
                int rowIndex = arg0.getChangeSet()[0].getRowIndex();
                if (null == model.getValue(propertyName)) {
                    return;
                }
                DynamicObject curr = (DynamicObject)this.getModel().getValue("curr");
                int scale = curr.getInt("priceprecision");
                BigDecimal taxPrice = (BigDecimal)model.getValue(propertyName, rowIndex);
                BigDecimal price = CalConstant.BIGDECIMAL_ZERO;
                int rowIndex1 = arg0.getChangeSet()[0].getRowIndex();
                IDataModel entryOperate = this.getModel();
                DynamicObject entry = entryOperate.getEntryRowEntity(ENTRY_ENTITY, rowIndex1);
                DynamicObject entryprod = entry.getDynamicObject(PROD_NUMBER);
                if (null == entryprod) {
                    return;
                }
                BigDecimal taxRate = entry.getBigDecimal(PROD_TAXRATE);
                String taxtype = entryprod.getString("taxtype");
                price = "0".equals(taxtype) ? CalculateUtils.calPriceIsPriceInTax((BigDecimal)taxRate, (BigDecimal)taxPrice, (int)scale) : CalculateUtils.calPrice((BigDecimal)taxPrice, (BigDecimal)taxRate, (int)scale);
                this.getModel().beginInit();
                model.setValue(PROD_PRICE, (Object)price, rowIndex1);
                model.setValue(PROD_TAXPRICE, (Object)taxPrice, rowIndex1);
                this.getModel().endInit();
                view.updateView(ENTRY_ENTITY);
                IDataModel subEntryOperate = this.getModel();
                subEntryOperate.setEntryCurrentRowIndex(ENTRY_ENTITY, rowIndex1);
                DynamicObjectCollection subentryentity = subEntryOperate.getEntryEntity("subentryentity");
                if (subentryentity.size() > 0 && ((DynamicObject)subentryentity.get(0)).getBigDecimal("ladprice").compareTo(BigDecimal.ZERO) > 0) {
                    this.getModel().setValue("ladprice", (Object)taxPrice, 0, rowIndex1);
                }
                this.doPriceLimitChange(arg0);
                break;
            }
            case "taxrate": {
                int rowIndex2 = arg0.getChangeSet()[0].getRowIndex();
                IDataModel entryOperate1 = this.getModel();
                DynamicObject entry1 = entryOperate1.getEntryRowEntity(ENTRY_ENTITY, rowIndex2);
                DynamicObject entryprod = entry1.getDynamicObject(PROD_NUMBER);
                if (null == entryprod) {
                    return;
                }
                BigDecimal price = entry1.getBigDecimal(PROD_TAXPRICE);
                BigDecimal taxPrice1 = entry1.getBigDecimal(PROD_TAXPRICE);
                BigDecimal taxRate1 = entry1.getBigDecimal(PROD_TAXRATE);
                String taxtype = entryprod.getString("taxtype");
                price = "0".equals(taxtype) ? CalculateUtils.calPriceIsPriceInTax((BigDecimal)taxRate1, (BigDecimal)taxPrice1, (int)2) : CalculateUtils.calPrice((BigDecimal)taxPrice1, (BigDecimal)taxRate1, (int)2);
                this.getModel().beginInit();
                model.setValue(PROD_PRICE, (Object)price, rowIndex2);
                model.setValue(PROD_TAXRATE, (Object)taxRate1, rowIndex2);
                this.getModel().endInit();
                view.updateView(ENTRY_ENTITY);
                break;
            }
            case "org": {
                this.doOrgChange(arg0);
                break;
            }
            case "goods": {
                this.prodValueChange(arg0);
                break;
            }
        }
    }

    private void doPriceLimitChange(PropertyChangedArgs arg0) {
        DynamicObject prodpool;
        QFilter qFilter;
        DynamicObject ent_prodpools;
        int rowIndex = arg0.getChangeSet()[0].getRowIndex();
        if (null != this.getModel().getValue(PROD_NUMBER, rowIndex) && null != this.getModel().getValue(PRODPOOL, rowIndex) && null != (ent_prodpools = QueryServiceHelper.queryOne((String)"ent_prodpool", (String)"protocolentry.taxprice", (QFilter[])(qFilter = new QFilter("id", "=", (Object)(prodpool = (DynamicObject)this.getModel().getValue(PRODPOOL, rowIndex)).getLong("id"))).toArray()))) {
            BigDecimal taxPrice = BigDecimal.ZERO;
            if (null != this.getModel().getValue(PROD_TAXPRICE, rowIndex)) {
                taxPrice = (BigDecimal)this.getModel().getValue(PROD_TAXPRICE, rowIndex);
            }
            BigDecimal taxprice_old = BigDecimal.ZERO;
            if (null != this.getModel().getValue(PROD_TAXPRICEOLD, rowIndex)) {
                taxprice_old = (BigDecimal)this.getModel().getValue(PROD_TAXPRICEOLD, rowIndex);
            }
            BigDecimal protocolTaxprice = ent_prodpools.getBigDecimal("protocolentry.taxprice");
            EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
            ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>();
            this.setPricelimitValue(rowIndex, taxPrice, taxprice_old, protocolTaxprice, cellStyles);
            if (cellStyles.size() > 0) {
                grid.setCellStyle(cellStyles);
            }
        }
    }

    private void prodValueChange(PropertyChangedArgs arg0) {
        int rowIndex = arg0.getChangeSet()[0].getRowIndex();
        String name = arg0.getProperty().getName();
        if (null == this.getModel().getValue(name, rowIndex)) {
            IDataModel entryOperate = this.getModel();
            entryOperate.setEntryCurrentRowIndex(ENTRY_ENTITY, rowIndex);
            entryOperate.deleteEntryData("subentryentity");
        }
        this.getModel().beginInit();
        this.getModel().setValue(PRODPOOL, null, rowIndex);
        this.getModel().setValue(PROD_TAXPRICEOLD, null, rowIndex);
        this.getModel().setValue(PROD_TAXPRICE, null, rowIndex);
        this.getModel().setValue(PROD_PRICEOLD, null, rowIndex);
        this.getModel().setValue(PROD_PRICE, null, rowIndex);
        this.getModel().setValue(PROD_CLASS, null, rowIndex);
        this.getModel().setValue("taxrateid", null, rowIndex);
        this.getModel().setValue(PROD_TAXRATE, null, rowIndex);
        this.getModel().setValue("protaxprice", null, rowIndex);
        this.getModel().setValue("protocolpricelimit", null, rowIndex);
        this.getModel().setValue("pricelimit", null, rowIndex);
        this.getModel().endInit();
        this.getView().updateView(ENTRY_ENTITY);
    }

    private void doOrgChange(PropertyChangedArgs arg0) {
        Object oldValue = arg0.getChangeSet()[0].getOldValue();
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        boolean isTip = true;
        for (DynamicObject row : entrys) {
            if (row.getDynamicObject(PROD_NUMBER) == null) continue;
            isTip = false;
            break;
        }
        if (!isTip) {
            if (oldValue != null) {
                String orgId = ((DynamicObject)oldValue).getString("id");
                this.getPageCache().put("doOrgChangeOldValue", orgId);
            }
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("orgChangeConfirm", (IFormPlugin)this);
            String confirmTip = ResManager.loadKDString((String)"\u5ba1\u6279\u5355\u4f4d\u5207\u6362\u5c06\u6e05\u7a7a\u5206\u5f55\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"EntPriceRequestEdit_4", (String)"scm-ent-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
        } else {
            this.doOrgChangeConfirm();
        }
    }

    private void doOrgChangeConfirm() {
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        this.getView().updateView(ENTRY_ENTITY);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        IDataModel model = this.getModel();
        BasedataEdit supplier1 = (BasedataEdit)this.getView().getControl(SUPPLIER);
        supplier1.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent arg0) {
                ListShowParameter formShowParameter = (ListShowParameter)arg0.getFormShowParameter();
                formShowParameter.getListFilterParameter().getQFilters().add(new QFilter(EntPriceRequestEdit.BIZPARTER, "in", (Object)BizPartnerUtil.getBizPartnerId()));
            }
        });
        BasedataEdit product = (BasedataEdit)this.getView().getControl(PROD_NUMBER);
        product.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        product.addAfterF7SelectListener((AfterF7SelectListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        entryGrid.addCellClickListener((CellClickListener)this);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        BasedataEdit org = (BasedataEdit)this.getView().getControl(ORG);
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void entryRowClick(RowClickEvent evt) {
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)ENTRY_ENTITY, (CharSequence)source.getKey())) {
            int row = evt.getRow();
            this.getPageCache().put("row", String.valueOf(row));
        }
    }

    public static final DynamicObject getSupplier(String supplierId) {
        QFilter idFilter = new QFilter("id", "=", (Object)Long.valueOf(supplierId));
        String select = "id,createorg,group,entry_bank,bank.name,bankaccount,accountname,isdefault_bank,bizpartnerid";
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObject suppliers = BusinessDataServiceHelper.loadSingle((String)"bd_supplier", (String)select, (QFilter[])filters);
        return null != suppliers ? suppliers : null;
    }

    private List<Long> getExistProd() {
        ArrayList<Long> prodPoolIdList = new ArrayList<Long>();
        QFilter statusFilter = new QFilter(CFMSTATUS, "=", (Object)"A");
        String selectProperties = "id,entryentity.prodpool prodpool";
        DynamicObjectCollection priceReqBill = QueryServiceHelper.query((String)"ent_pricerequest", (String)selectProperties, (QFilter[])new QFilter[]{statusFilter});
        priceReqBill.forEach(bill -> prodPoolIdList.add(bill.getLong(PRODPOOL)));
        DynamicObject dynamicObject = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection(ENTRY_ENTITY);
        entryEntity.forEach(entry -> prodPoolIdList.add(entry.getLong("prodpool_id")));
        return prodPoolIdList;
    }

    public void cellClick(CellClickEvent arg0) {
        DynamicObject supplier;
        if (StringUtils.equals((CharSequence)PROD_NUMBER, (CharSequence)arg0.getFieldKey()) && (supplier = this.getModel().getDataEntity().getDynamicObject(SUPPLIER)) == null) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u5546\u5bb6\u201d\uff0c\u518d\u5f55\u5165\u5546\u54c1\u660e\u7ec6\u3002", (String)"EntPriceRequestEdit_2", (String)"scm-ent-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"orgChangeConfirm", (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.doOrgChangeConfirm();
            } else {
                this.getModel().beginInit();
                String oldValue = this.getPageCache().get("doOrgChangeOldValue");
                if (oldValue == null) {
                    this.getModel().setValue(ORG, null);
                } else {
                    this.getModel().setValue(ORG, (Object)Long.valueOf(oldValue));
                }
                this.getModel().endInit();
                this.getView().updateView(ORG);
                this.getPageCache().remove("doOrgChangeOldValue");
            }
        }
    }

    public void cellDoubleClick(CellClickEvent arg0) {
        DynamicObject supplier;
        if (StringUtils.equals((CharSequence)PROD_NUMBER, (CharSequence)arg0.getFieldKey()) && (supplier = this.getModel().getDataEntity().getDynamicObject(SUPPLIER)) == null) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u5546\u5bb6\u201d\uff0c\u518d\u5f55\u5165\u5546\u54c1\u660e\u7ec6\u3002", (String)"EntPriceRequestEdit_2", (String)"scm-ent-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        String fieldName = arg0.getFieldName();
        if ("goodsname".equals(fieldName)) {
            DynamicObjectCollection rows = this.getModel().getEntryEntity(ENTRY_ENTITY);
            DynamicObject dynamicObject = (DynamicObject)rows.get(arg0.getRowIndex());
            DynamicObject prod = (DynamicObject)dynamicObject.get(PROD_NUMBER);
            long prodId = prod.getLong("id");
            this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)"ent_prodmanage", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.VIEW, (long)prodId, null, null));
        } else if ("protocolnumber".equals(fieldName)) {
            DynamicObjectCollection rows = this.getModel().getEntryEntity(ENTRY_ENTITY);
            DynamicObject dynamicObject = (DynamicObject)rows.get(arg0.getRowIndex());
            DynamicObject prodPool = (DynamicObject)dynamicObject.get(PRODPOOL);
            long protocolId = prodPool.getDynamicObject("protocol").getLong("id");
            this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)"ent_protocol", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.VIEW, (long)protocolId, null, null));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "bar_adjust": {
                this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)"ent_adjustprice", null, (CloseCallBack)new CloseCallBack((IFormPlugin)this, ADJUSTPRICE), (ShowType)ShowType.Modal));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        IDataModel model = this.getModel();
        if (ADJUSTPRICE.equals(closedCallBackEvent.getActionId())) {
            Object condition = closedCallBackEvent.getReturnData();
            IPageCache cache = this.getPageCache();
            if (condition != null) {
                DynamicObject curr = (DynamicObject)this.getModel().getValue("curr");
                int scale = curr.getInt("priceprecision");
                Map map = condition instanceof Map ? (Map)condition : new HashMap();
                cache.put(MODE, (String)map.get(MODE));
                int mode = Integer.parseInt((String)map.get(MODE));
                cache.put(TYPE, (String)map.get(TYPE));
                int type = Integer.parseInt((String)map.get(TYPE));
                DynamicObjectCollection entryCol = this.getModel().getEntryEntity(ENTRY_ENTITY);
                DynamicObject prod = new DynamicObject();
                int flag = 0;
                for (int i = 0; i < entryCol.size(); ++i) {
                    DynamicObject entry = (DynamicObject)entryCol.get(i);
                    prod = (DynamicObject)entry.get(PROD_NUMBER);
                    if (prod == null) {
                        ++flag;
                        continue;
                    }
                    BigDecimal oldprice = entry.getBigDecimal(PROD_TAXPRICEOLD);
                    BigDecimal price = CalConstant.BIGDECIMAL_ZERO;
                    if (mode == 1) {
                        BigDecimal percent = (BigDecimal)map.get(PERCENT);
                        price = type == 1 ? oldprice.subtract(oldprice.multiply(percent.divide(CalConstant.BIGDECIMAL_ONEHUNDRED, scale, RoundingMode.HALF_UP))) : oldprice.add(oldprice.multiply(percent.divide(CalConstant.BIGDECIMAL_ONEHUNDRED, scale, RoundingMode.HALF_UP)));
                    } else if (mode == 2) {
                        price = type == 1 ? oldprice.subtract((BigDecimal)map.get(AMOUNT)) : oldprice.add((BigDecimal)map.get(AMOUNT));
                    }
                    model.setValue(PROD_TAXPRICE, (Object)price, i);
                }
                if (prod == null && entryCol.size() == flag) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76f8\u5e94\u5546\u54c1\u8fdb\u884c\u8c03\u4ef7\u7533\u8bf7\u3002", (String)"EntPriceRequestEdit_3", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                }
            }
        }
        if ("setladderprice".equals(closedCallBackEvent.getActionId())) {
            this.doSetladderprice(closedCallBackEvent);
        }
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"orgclose") && null != closedCallBackEvent.getReturnData()) {
            HashMap returnData = (HashMap)closedCallBackEvent.getReturnData();
            List orgIdList = (List)returnData.get("orgIdList");
            for (String orgId : orgIdList) {
                this.getModel().setValue(ORG, (Object)Long.valueOf(orgId));
            }
            this.getView().updateView(ORG);
        }
    }

    private void doSetladderprice(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if (null != returnData) {
            Map returnDataMap = (Map)returnData;
            List entryList = (List)returnDataMap.get("entry");
            TableValueSetter vs = new TableValueSetter(new String[0]);
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.deleteEntryData("subentryentity");
            int index = 0;
            BigDecimal price = BigDecimal.ZERO;
            for (LadderPriceInfo info : entryList) {
                vs.set("qtyfrom", (Object)info.getQtyfrom(), index);
                vs.set("qtyto", (Object)info.getQtyto(), index);
                vs.set("ladprice", (Object)info.getLadprice(), index);
                if (index == 0) {
                    price = info.getLadprice();
                }
                ++index;
            }
            model.beginInit();
            model.batchCreateNewEntryRow("subentryentity", vs);
            model.endInit();
            this.getView().updateView("subentryentity");
            EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
            int[] selectRows = grid.getSelectRows();
            int rowIndex = selectRows[0];
            if (null != this.getPageCache().get("row")) {
                rowIndex = Integer.parseInt(this.getPageCache().get("row"));
                this.getPageCache().remove("row");
            }
            this.getModel().setValue(PROD_TAXPRICE, (Object)price, rowIndex);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        IDataModel model = this.getModel();
        switch (key) {
            case "save": {
                DynamicObjectCollection entities = model.getEntryEntity(ENTRY_ENTITY);
                for (DynamicObject entitiy : entities) {
                    entitiy.set(PROD_SHOPPRICE, entitiy.get(PROD_TAXPRICE));
                }
                break;
            }
            case "submit": {
                EntPriceRequestValidatorServiceImpl entPriceRequestValidatorService = new EntPriceRequestValidatorServiceImpl();
                StringBuilder msg = entPriceRequestValidatorService.checkGoodsProtocol(new DynamicObject[]{this.getModel().getDataEntity(true)});
                if (msg.length() > 0) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u90e8\u5206\u5546\u54c1\u5df2\u5173\u8054\u534f\u8bae\uff0c\u6570\u636e\u5df2\u6539\u53d8\uff0c\u8bf7\u91cd\u65b0\u53d1\u8d77\u8c03\u4ef7\u7533\u8bf7\u3002", (String)"EntPriceRequestEdit_9", (String)"scm-ent-formplugin", (Object[])new Object[0]), msg.toString(), MessageBoxOptions.OK, ConfirmTypes.Default, new ConfirmCallBackListener("confirm"));
                    this.getView().updateView();
                    args.setCancel(true);
                }
                DynamicObjectCollection entities = model.getEntryEntity(ENTRY_ENTITY);
                for (DynamicObject entitiy : entities) {
                    entitiy.set(PROD_SHOPPRICE, entitiy.get(PROD_TAXPRICE));
                }
                break;
            }
            case "setladderprice": {
                this.setLadderPrice(args);
                break;
            }
            case "resubmit": {
                if (this.copyValid()) break;
                args.setCancel(true);
            }
        }
    }

    private boolean copyValid() {
        DynamicObject info = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryCol = info.getDynamicObjectCollection(ENTRY_ENTITY);
        if (!"D".equals(info.getString(CFMSTATUS))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u9009\u62e9\u4e00\u6761\u4e0d\u540c\u610f\u7684\u7533\u8bf7\u5355\u91cd\u65b0\u63d0\u4ea4\u7533\u8bf7\u3002", (String)"EntPriceRequestEdit_8", (String)"scm-ent-formplugin", (Object[])new Object[0]));
            return false;
        }
        ArrayList<Long> prodPoolIdList = new ArrayList<Long>(16);
        HashMap<Long, String> prodPoolIdMap = new HashMap<Long, String>(16);
        ArrayList<Long> goodsIdList = new ArrayList<Long>(16);
        for (DynamicObject row : entryCol) {
            long prodPoolId = 0L;
            if (null != row.get(PRODPOOL)) {
                prodPoolId = row.getLong("prodpool.id");
            }
            long goodsId = 0L;
            if (null != row.get(PROD_NUMBER)) {
                goodsId = row.getLong("goods.id");
            }
            prodPoolIdList.add(prodPoolId);
            prodPoolIdMap.put(prodPoolId, row.getString("goods.number"));
            goodsIdList.add(goodsId);
        }
        DynamicObjectCollection prods = QueryServiceHelper.query((String)"ent_prodmanage", (String)"id,number,protocolentry.prodpool prodpool,protocolentry.prodpool.mallstatus mallstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", goodsIdList)});
        StringBuilder prodNumber = new StringBuilder();
        HashMap<Long, String> prodOfProdPool = new HashMap<Long, String>(prods.size());
        HashMap<Long, String> numberOfProdPool = new HashMap<Long, String>(prods.size());
        prods.forEach(prod -> prodOfProdPool.put(prod.getLong(PRODPOOL), prod.getString("mallstatus")));
        for (DynamicObject prod2 : prods) {
            prodOfProdPool.put(prod2.getLong(PRODPOOL), prod2.getString("mallstatus"));
            numberOfProdPool.put(prod2.getLong(PRODPOOL), prod2.getString("number"));
        }
        for (Long prodPoolId : prodPoolIdList) {
            if (!prodOfProdPool.containsKey(prodPoolId)) {
                prodNumber.append((String)prodPoolIdMap.get(prodPoolId)).append("\n");
                continue;
            }
            String mallStatus = (String)prodOfProdPool.get(prodPoolId);
            if (MallStatusEnum.SOLD.getVal().equals(mallStatus) || MallStatusEnum.UNSOLD.getVal().equals(mallStatus)) continue;
            prodNumber.append((String)numberOfProdPool.get(prodPoolId)).append("\n");
        }
        if (prodNumber.length() > 0) {
            String title = ResManager.loadKDString((String)"\u5546\u54c1\u660e\u7ec6\u4e2d\u90e8\u5206\u5546\u54c1\u4e0a\u67b6\u72b6\u6001\u5df2\u53d8\u66f4/\u5df2\u5173\u8054\u534f\u8bae\uff0c\u4e0d\u652f\u6301\u91cd\u65b0\u7533\u8bf7\uff0c\u8bf7\u624b\u5de5\u65b0\u589e\u8c03\u4ef7\u7533\u8bf7\u5355\u3002", (String)"EntPriceRequestEdit_7", (String)"scm-ent-formplugin", (Object[])new Object[0]);
            this.getView().showMessage(title, prodNumber.toString(), MessageTypes.Default);
            return false;
        }
        return true;
    }

    private void setLadderPrice(BeforeDoOperationEventArgs args) {
        DynamicObject row;
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        int[] selectRows = grid.getSelectRows();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryCol = dataEntity.getDynamicObjectCollection(ENTRY_ENTITY);
        int rowIndex = selectRows[0];
        if (null != this.getPageCache().get("row")) {
            rowIndex = Integer.parseInt(this.getPageCache().get("row"));
        }
        if ("A".equals((row = (DynamicObject)entryCol.get(rowIndex)).getString("pricetype"))) {
            String msg = ResManager.loadKDString((String)"\u53ea\u6709\u4ef7\u683c\u7c7b\u578b\u4e3a\u9636\u68af\u4ef7\u624d\u80fd\u8bbe\u7f6e\u9636\u68af\u4ef7\u3002", (String)"EntPriceRequestEdit_6", (String)"scm-ent-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            args.setCancel(true);
            return;
        }
        BigDecimal minorderqty = BigDecimal.ZERO;
        DynamicObject prodpool = row.getDynamicObject(PRODPOOL);
        if (null != prodpool && prodpool.getBigDecimal("minorderqty").compareTo(BigDecimal.ZERO) != 0) {
            minorderqty = prodpool.getBigDecimal("minorderqty");
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("pbd_ladderprice");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, String> detailParamMap = new HashMap<String, String>();
        DynamicObjectCollection subEntryRows = row.getDynamicObjectCollection("subentryentity");
        List<Object> ladderPriceInfos = new ArrayList<LadderPriceInfo>(1024);
        for (DynamicObject subrow : subEntryRows) {
            if (subrow.getBigDecimal("ladprice").compareTo(BigDecimal.ZERO) <= 0) continue;
            LadderPriceInfo info = new LadderPriceInfo(subrow.getBigDecimal("qtyfrom"), subrow.getBigDecimal("qtyto"), subrow.getBigDecimal("ladprice"), Long.valueOf(dataEntity.getDynamicObject("curr").getLong("id")));
            ladderPriceInfos.add(info);
        }
        BigDecimal price = row.getBigDecimal(PROD_TAXPRICEOLD);
        if (ladderPriceInfos.size() < 2) {
            ladderPriceInfos.clear();
            ladderPriceInfos.add(new LadderPriceInfo(minorderqty, minorderqty.add(BigDecimal.ONE), price, Long.valueOf(dataEntity.getDynamicObject("curr").getLong("id"))));
            ladderPriceInfos.add(new LadderPriceInfo(minorderqty.add(BigDecimal.ONE), BigDecimal.ZERO, price, Long.valueOf(dataEntity.getDynamicObject("curr").getLong("id"))));
        }
        ladderPriceInfos = ladderPriceInfos.stream().sorted(Comparator.comparing(LadderPriceInfo::getQtyfrom)).collect(Collectors.toList());
        detailParamMap.put("ladderPrices", SerializationUtils.toJsonString(ladderPriceInfos));
        showParameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "setladderprice"));
        Object cfmstatus = this.getModel().getValue(CFMSTATUS);
        if (null == cfmstatus) {
            detailParamMap.put("status", "0");
        } else {
            detailParamMap.put("status", "1");
        }
        showParameter.setCustomParams(detailParamMap);
        this.getView().showForm(showParameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("submit".equals(key) && args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            this.getModel().setValue(CFMSTATUS, (Object)"A");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = evt.getProperty().getName()) {
            case "goods": {
                if (this.getModel().getValue(ORG) == null) {
                    evt.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5ba1\u6279\u5355\u4f4d\u3002", (String)"EntPriceRequestEdit_1", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                    return;
                }
                ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().setFilter(this.getGoodsQFilter());
                break;
            }
            case "org": {
                if (!"click".equals(evt.getSourceMethod())) break;
                evt.setCancel(true);
                HashMap<String, String> paramMap = new HashMap<String, String>(8);
                paramMap.put("orgType", "purorg");
                OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)"ent_orgselect", (ShowType)ShowType.Modal, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "orgclose"));
                break;
            }
        }
    }

    private QFilter getGoodsQFilter() {
        QFilter prodQFilter = new QFilter("protocolentry.protocol", "=", (Object)0L).or(new QFilter("protocolentry.protocol.protocolstatus", "=", (Object)"A")).or(new QFilter("protocolentry.protocol.protocolstatus", "=", (Object)"B"));
        DynamicObject auditOrg = (DynamicObject)this.getModel().getValue(ORG);
        prodQFilter.and(new QFilter("protocolentry.prodpool.auditorg", "=", (Object)auditOrg.getLong("id")));
        prodQFilter.and(new QFilter("protocolentry.prodpool", "not in", this.getExistProd()));
        prodQFilter.and(new QFilter("protocolentry.prodpool.mallstatus", "=", (Object)MallStatusEnum.SOLD.getVal()).or("protocolentry.prodpool.mallstatus", "=", (Object)MallStatusEnum.UNSOLD.getVal()));
        DynamicObject supplier = (DynamicObject)this.getModel().getValue(SUPPLIER);
        prodQFilter.and(new QFilter(SUPPLIER, "=", (Object)supplier.getLong("id")));
        return prodQFilter;
    }

    public void afterF7Select(AfterF7SelectEvent evt) {
        BasedataEdit source = (BasedataEdit)evt.getSource();
        String key = source.getProperty().getName();
        if (key.equals(PROD_NUMBER)) {
            DynamicObjectCollection prodDynColl;
            ListSelectedRowCollection listSelectedRowCollection = evt.getListSelectedRowCollection();
            if (listSelectedRowCollection.isEmpty() && evt.getInputValues().isEmpty()) {
                return;
            }
            Object[] entryPrimaryKeyValues = evt.getListSelectedRowCollection().getEntryPrimaryKeyValues();
            QFilter filter = new QFilter("protocolentry.id", "in", (Object)entryPrimaryKeyValues);
            if (entryPrimaryKeyValues.length == 0 || entryPrimaryKeyValues[0] == null) {
                entryPrimaryKeyValues = evt.getListSelectedRowCollection().getPrimaryKeyValues();
                if (entryPrimaryKeyValues.length == 0 || entryPrimaryKeyValues[0] == null) {
                    entryPrimaryKeyValues = evt.getInputValues().stream().map(value -> Long.valueOf((String)value)).toArray();
                }
                filter = new QFilter("id", "in", (Object)entryPrimaryKeyValues);
                filter.and(new QFilter("protocolentry.prodpool.mallstatus", "=", (Object)MallStatusEnum.SOLD.getVal()).or("protocolentry.prodpool.mallstatus", "=", (Object)MallStatusEnum.UNSOLD.getVal()));
            }
            if (!(prodDynColl = QueryServiceHelper.query((String)"ent_prodmanage", (String)"id goods,category,protocolentry.prodpool.id prodpool,protocolentry.prodpool.auditorg,protocolentry.prodpool.taxprice taxprice,protocolentry.prodpool.taxrateid taxrateid,protocolentry.prodpool.taxrate taxrate,protocolentry.prodpool.price price,protocolentry.prodpool.unit unit", (QFilter[])new QFilter[]{filter})).isEmpty()) {
                this.getModel().beginInit();
                this.deleteNewEmptyData();
                this.allotEntryData(prodDynColl);
                this.getModel().endInit();
                this.getView().updateView(ENTRY_ENTITY);
            }
            this.setPricelimit();
        }
    }

    private void deleteNewEmptyData() {
        DynamicObject dynamicObject = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection(ENTRY_ENTITY);
        Iterator iterator = entryEntity.iterator();
        while (iterator.hasNext()) {
            DynamicObject next = (DynamicObject)iterator.next();
            DynamicObject prodPoolDyn = next.getDynamicObject(PRODPOOL);
            if (prodPoolDyn != null) continue;
            iterator.remove();
        }
    }

    private String getSelectProperties() {
        return "id prodpool,auditorg,goods.id goods,goods.category category,taxprice,taxrateid,taxrate,price,unit";
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.setPricelimit();
        this.getModel().setDataChanged(false);
    }

    private void setPricelimit() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryCols = dataEntity.getDynamicObjectCollection(ENTRY_ENTITY);
        HashSet<Long> goodsIds = new HashSet<Long>(16);
        for (DynamicObject row : entryCols) {
            DynamicObject prodpool = row.getDynamicObject(PRODPOOL);
            if (null == prodpool) continue;
            goodsIds.add(prodpool.getLong("id"));
        }
        HashMap<Long, DynamicObject> prodPoolMap = new HashMap<Long, DynamicObject>(16);
        if (goodsIds.size() > 0) {
            QFilter qFilter = new QFilter("id", "in", goodsIds);
            DynamicObjectCollection ent_prodpools = QueryServiceHelper.query((String)"ent_prodpool", (String)"id,protocolentry.taxprice", (QFilter[])qFilter.toArray());
            for (DynamicObject row : ent_prodpools) {
                long key = row.getLong("id");
                prodPoolMap.put(key, row);
            }
        }
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>();
        for (DynamicObject row : entryCols) {
            DynamicObject goods = row.getDynamicObject(PROD_NUMBER);
            if (null == goods) continue;
            BigDecimal protocolTaxprice = BigDecimal.ZERO;
            if (null != row.get(PRODPOOL)) {
                DynamicObject prodpool = row.getDynamicObject(PRODPOOL);
                long prodpoolId = prodpool.getLong("id");
                protocolTaxprice = ((DynamicObject)prodPoolMap.get(prodpoolId)).getBigDecimal("protocolentry.taxprice");
            }
            BigDecimal taxPrice = row.getBigDecimal(PROD_TAXPRICE);
            BigDecimal taxprice_old = row.getBigDecimal(PROD_TAXPRICEOLD);
            this.setPricelimitValue(row.getInt(PROD_SEQ) - 1, taxPrice, taxprice_old, protocolTaxprice, cellStyles);
        }
        if (cellStyles.size() > 0) {
            grid.setCellStyle(cellStyles);
        }
    }

    private void setPricelimitValue(int seq, BigDecimal taxPrice, BigDecimal taxprice_old, BigDecimal protocolTaxprice, ArrayList<CellStyle> cellStyles) {
        BigDecimal newTaxPrice;
        BigDecimal hundred = new BigDecimal("100");
        if (taxPrice.compareTo(BigDecimal.ZERO) > 0 && taxprice_old.compareTo(BigDecimal.ZERO) > 0) {
            newTaxPrice = taxPrice.subtract(taxprice_old);
            if (newTaxPrice.compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal multiply = newTaxPrice.divide(taxprice_old, 4, RoundingMode.HALF_UP).multiply(hundred).setScale(2);
                if (newTaxPrice.compareTo(BigDecimal.ZERO) > 0) {
                    this.getModel().setValue("pricelimit", (Object)(multiply + "%"), seq);
                    cellStyles.add(this.getCellStyle("#D9001B", "pricelimit", seq));
                } else {
                    this.getModel().setValue("pricelimit", (Object)(multiply + "%"), seq);
                    cellStyles.add(this.getCellStyle("#404040", "pricelimit", seq));
                }
            } else {
                this.getModel().setValue("pricelimit", (Object)"-", seq);
                cellStyles.add(this.getCellStyle("#404040", "pricelimit", seq));
            }
        } else {
            this.getModel().setValue("pricelimit", (Object)"-", seq);
            cellStyles.add(this.getCellStyle("#404040", "pricelimit", seq));
        }
        if (null != protocolTaxprice) {
            if (protocolTaxprice.compareTo(BigDecimal.ZERO) > 0) {
                this.getModel().setValue("protaxprice", (Object)protocolTaxprice, seq);
                newTaxPrice = taxPrice.subtract(protocolTaxprice);
                if (newTaxPrice.compareTo(BigDecimal.ZERO) != 0) {
                    this.getModel().setValue("protocolpricelimit", (Object)(newTaxPrice.divide(protocolTaxprice, 2, RoundingMode.HALF_UP).multiply(hundred) + "%"), seq);
                    cellStyles.add(this.getCellStyle("#D9001B", "protocolpricelimit", seq));
                } else {
                    this.getModel().setValue("protocolpricelimit", (Object)"-", seq);
                    cellStyles.add(this.getCellStyle("#404040", "protocolpricelimit", seq));
                }
            } else {
                this.getModel().setValue("protocolpricelimit", (Object)"-", seq);
                cellStyles.add(this.getCellStyle("#404040", "protocolpricelimit", seq));
            }
        } else {
            this.getModel().setValue("protocolpricelimit", (Object)"-", seq);
            cellStyles.add(this.getCellStyle("#404040", "protocolpricelimit", seq));
        }
    }

    private CellStyle getCellStyle(String foreColor, String fieldName, int seq) {
        CellStyle cs = new CellStyle();
        cs.setForeColor(foreColor);
        cs.setRow(seq);
        cs.setFieldKey(fieldName);
        return cs;
    }
}

