/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.formplugin.edit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scm.common.constant.CalConstant;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.MalFeeHandleHelper;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.common.util.OrgUtil;
import kd.scm.common.util.cal.CalculateUtils;
import kd.scm.ent.business.model.prod.Sku;
import kd.scm.ent.business.service.impl.EntProdManageAuditServiceImpl;
import kd.scm.ent.common.plugin.AbstractEntBillPlugIn;
import kd.scm.ent.common.util.EntProdManageUtil;

public class EntProdManageEdit
extends AbstractEntBillPlugIn
implements BeforeF7SelectListener {
    private static final String RICHTEXTEDITORAP = "richtexteditorap";
    private static final String RICHTEXTEDITORAP1 = "richtexteditorap1";
    private BigDecimal ZERO = BigDecimal.ZERO;
    private boolean flag = false;
    private String PRICE = "price";
    private String TAXPRICE = "taxprice";
    private String TAXRATE = "taxrate";
    private static final String MAL_PRODUCTDETAIL = "mal_productdetail";
    private String TAXTYPE = "taxtype";
    private String SUPPLIER = "supplier";
    private static final String ALLOTCALLBACK = "allotcallback";
    private static final String UNALLOTCALLBACK = "unallotcallback";
    private static final String ZJ = "944841720602823680";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        IBillModel m = (IBillModel)model;
        List<Long> supIdList = this.getSupplierByUserOfBizPartner();
        if (supIdList != null && supIdList.size() >= 1) {
            model.setValue(this.SUPPLIER, (Object)supIdList.get(0));
            Long bizPartnerId = BizPartnerUtil.getBizPartnerBySupplier((Object)supIdList.get(0));
            model.setValue("bizpartner", (Object)bizPartnerId);
        }
        if (!m.isFromImport()) {
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            String node = (String)showParameter.getCustomParam("node");
            if (null != node) {
                model.setValue("category", (Object)Long.valueOf(node));
            } else {
                this.getModel().setValue("category", null);
            }
        }
        model.setValue("content", (Object)"");
        model.setValue("specification", (Object)"");
        model.setValue("standard", (Object)ZJ);
        this.setCreateOrgValue(MalOrderUtil.getDefaultMalVersion());
        if (StringUtils.isNotBlank((CharSequence)MalOrderUtil.getDefaultCurrency())) {
            this.getModel().setValue("curr", (Object)MalOrderUtil.getDefaultCurrency());
        }
        if (null != this.getView().getFormShowParameter().getCustomParam("atrMap")) {
            String category = (String)this.getView().getFormShowParameter().getCustomParam("categoryId");
            String createorg = (String)this.getView().getFormShowParameter().getCustomParam("orgId");
            String supplier = (String)this.getView().getFormShowParameter().getCustomParam("supplierId");
            String atrMap = (String)this.getView().getFormShowParameter().getCustomParam("atrMap");
            String number = (String)this.getView().getFormShowParameter().getCustomParam("number");
            model.setValue("category", (Object)category);
            model.setValue("supplier", (Object)supplier);
            model.setValue("createorg", (Object)createorg);
            model.setValue("spunumber", (Object)number);
            DynamicObjectCollection attrCol = (DynamicObjectCollection)model.getValue("prodattributeentry");
            Map attributeMap = (Map)SerializationUtils.fromJsonString((String)atrMap, Map.class);
            HashMap<Long, Long> newAtrMap = new HashMap<Long, Long>(attributeMap.size());
            for (Map.Entry entry : attributeMap.entrySet()) {
                newAtrMap.put(Long.valueOf((String)entry.getKey()), Long.valueOf((String)entry.getValue()));
            }
            QFilter atrFilter = new QFilter("id", "in", newAtrMap.keySet());
            DynamicObject[] atrDyoCol = BusinessDataServiceHelper.load((String)"ent_prodattribute", (String)"id,prodattributename,prodattributegroup,attributetype", (QFilter[])new QFilter[]{atrFilter});
            QFilter filter = new QFilter("id", "in", newAtrMap.values());
            DynamicObject[] atrValDyoCol = BusinessDataServiceHelper.load((String)"ent_prodattributevalue", (String)"id", (QFilter[])new QFilter[]{filter});
            for (Map.Entry entry : attributeMap.entrySet()) {
                DynamicObject entryDyo = attrCol.addNew();
                for (DynamicObject atrDyn : atrDyoCol) {
                    if (!atrDyn.getString("id").equals(entry.getKey())) continue;
                    entryDyo.set("prodattribute", (Object)atrDyn);
                }
                for (DynamicObject atrDyn : atrValDyoCol) {
                    if (!atrDyn.getString("id").equals(entry.getValue())) continue;
                    entryDyo.set("prodattributevalue", (Object)atrDyn);
                }
            }
        }
        this.getModel().setValue("prodtype", (Object)1576866653114004480L);
    }

    public void afterCopyData(EventObject e) {
        this.setCreateOrgValue(MalOrderUtil.getDefaultMalVersion());
    }

    private void setCreateOrgValue(boolean isNewMalVersion) {
        IDataModel model = this.getModel();
        DynamicObject supplier = (DynamicObject)model.getValue("supplier");
        if (isNewMalVersion) {
            DynamicObject orgDyn;
            long createorg;
            List purOrgIds = OrgUtil.getUserHasAllPurPermissionOrgs();
            if (purOrgIds.contains(createorg = supplier.getLong("createorg_id")) && (orgDyn = QueryServiceHelper.queryOne((String)"bos_org", (String)"id,fispurchase", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)createorg)})).getBoolean("fispurchase")) {
                model.setValue("createorg", (Object)createorg);
            }
        } else {
            QFilter qFilter = new QFilter("supplier", "=", (Object)supplier.getLong("id"));
            qFilter.and(new QFilter("cfmstatus", "=", (Object)"B"));
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"ent_suprequest", (String)"org", (QFilter[])qFilter.toArray());
            if (dynamicObject != null) {
                model.setValue("createorg", (Object)dynamicObject.getLong("org"));
            } else {
                model.setValue("createorg", (Object)OrgUnitServiceHelper.getRootOrgId());
            }
        }
    }

    private List<Long> getSupplierByUserOfBizPartner() {
        return BizPartnerUtil.getSupplierByUserOfBizPartner();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        IDataModel model = this.getModel();
        switch (key) {
            case "save": 
            case "submit": {
                this.withSave(model);
                break;
            }
        }
    }

    private void withSave(IDataModel model) {
        RichTextEditor richTextEditor = (RichTextEditor)this.getControl(RICHTEXTEDITORAP);
        String text = richTextEditor.getText();
        model.setValue("content_tag", (Object)text);
        model.setValue("content", (Object)"");
        RichTextEditor richTextEditor1 = (RichTextEditor)this.getControl(RICHTEXTEDITORAP1);
        String text1 = richTextEditor1.getText();
        model.setValue("specification_tag", (Object)text1);
        model.setValue("specification", (Object)"");
        BigDecimal shopprice = (BigDecimal)model.getValue("taxprice");
        model.setValue("shopprice", (Object)shopprice);
        DynamicObject category = (DynamicObject)model.getValue("category");
        if (null != category) {
            model.setValue("catlongnumber", category.get("longnumber"));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        IDataModel model = this.getModel();
        this.setRichText();
        super.afterDoOperation(e);
        String itemKey = e.getOperateKey();
        if (itemKey.equalsIgnoreCase("allot") || itemKey.equalsIgnoreCase("unallot")) {
            this.allotAndUnallot(itemKey, e);
        }
        if ("queryprotocol".equalsIgnoreCase(itemKey)) {
            this.showQueryProtocol();
        }
        if (("submit".equals(itemKey) || "save".equals(itemKey)) && e.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
        if ("submit".equals(itemKey) && e.getOperationResult().isSuccess()) {
            this.syncSpu();
        }
    }

    private void syncSpu() {
        if (StringUtils.isEmpty((CharSequence)this.getModel().getDataEntity().getString("spunumber"))) {
            return;
        }
        EntProdManageAuditServiceImpl entProdManageAuditService = new EntProdManageAuditServiceImpl();
        ArrayList<Sku> skus = new ArrayList<Sku>(8);
        skus.add(this.initSKu());
        Map res = entProdManageAuditService.writeBackSpu(skus);
        if (res.get("msg") != null) {
            StringBuilder msg = (StringBuilder)res.get("msg");
            this.getView().showMessage(ResManager.loadKDString((String)"\u5546\u54c1\u672a\u81ea\u52a8\u5173\u8054SPU\uff0c\u5982\u9700\u5173\u8054\u8bf7\u624b\u52a8\u5904\u7406\u3002", (String)"EntProdRequestEdit_28", (String)"scm-ent-formplugin", (Object[])new Object[0]), msg.toString(), MessageTypes.Default);
        }
        this.getView().invokeOperation("refresh");
        if (null != this.getView().getFormShowParameter().getCustomParam("atrMap")) {
            this.getView().getParentView().invokeOperation("refresh");
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    private Sku initSKu() {
        DynamicObject dynamicObject = this.getModel().getDataEntity(true);
        Sku sku = new Sku();
        sku.setId(Long.valueOf(dynamicObject.getLong("id")));
        sku.setCreateOrg(Long.valueOf(dynamicObject.getLong("createorg_id")));
        sku.setNumber(dynamicObject.getString("number"));
        sku.setSpu(dynamicObject.getString("spunumber"));
        sku.setSupplier(Long.valueOf(dynamicObject.getLong("supplier_id")));
        DynamicObjectCollection prodattributeentry = dynamicObject.getDynamicObjectCollection("prodattributeentry");
        HashSet<Long> baseAttributeValues = new HashSet<Long>(prodattributeentry.size());
        HashSet<Long> saleAttributeValues = new HashSet<Long>(prodattributeentry.size());
        for (DynamicObject entry : prodattributeentry) {
            DynamicObject prodattribute = entry.getDynamicObject("prodattribute");
            if ("1".equals(prodattribute.getString("attributetype"))) {
                baseAttributeValues.add(entry.getLong("prodattributevalue_id"));
                continue;
            }
            if (!"2".equals(prodattribute.getString("attributetype"))) continue;
            saleAttributeValues.add(entry.getLong("prodattributevalue_id"));
        }
        sku.setBaseAttributeValues(baseAttributeValues);
        sku.setSaleAttributeValues(saleAttributeValues);
        return sku;
    }

    public void allotAndUnallot(String operate, AfterDoOperationEventArgs e) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("goodid", String.valueOf(this.getModel().getValue("id")));
        paramMap.put("operate", operate);
        DynamicObject sup = (DynamicObject)this.getModel().getValue("supplier");
        paramMap.put("supplier", sup.getLong("id"));
        MalFeeHandleHelper.clearRedisCacheByGoodsKey((String)String.valueOf(this.getModel().getValue("id")));
        DynamicObject[] surcharges = EntProdManageUtil.getSurCharge(paramMap, (String)operate);
        if ("allot".equals(operate)) {
            if (surcharges.length <= 0) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u9644\u52a0\u8d39\u65b9\u6848\u3002", (String)"EntProdManageEdit_1", (String)"scm-ent-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
                return;
            }
            this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)"ent_prodmanageallot", paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, ALLOTCALLBACK), (ShowType)ShowType.Modal));
        } else {
            if (surcharges.length <= 0) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u5546\u54c1\u65e0\u9644\u52a0\u8d39\uff0c\u65e0\u9700\u53d6\u6d88\u3002", (String)"EntProdManageEdit_2", (String)"scm-ent-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
                return;
            }
            this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)"ent_prodmanageallot", paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, UNALLOTCALLBACK), (ShowType)ShowType.Modal));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "allotcallback": {
                if (null == closedCallBackEvent.getReturnData()) break;
                Map returnData = (Map)closedCallBackEvent.getReturnData();
                if (null != returnData.get("success") && returnData.get("success").equals("true")) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f\u3002", (String)"EntProdManageEdit_3", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                }
                this.getView().invokeOperation("refresh");
                break;
            }
            case "unallotcallback": {
                if (null == closedCallBackEvent.getReturnData()) break;
                Map returnData = (Map)closedCallBackEvent.getReturnData();
                if (null != returnData.get("success") && returnData.get("success").equals("true")) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u914d\u6210\u529f\u3002", (String)"EntProdManageEdit_4", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                }
                this.getView().invokeOperation("refresh");
                break;
            }
            case "orgclose": {
                if (null == closedCallBackEvent.getReturnData()) break;
                HashMap returnData = (HashMap)closedCallBackEvent.getReturnData();
                List orgIdList = (List)returnData.get("orgIdList");
                for (String orgId : orgIdList) {
                    this.getModel().setValue("createorg", (Object)Long.valueOf(orgId));
                }
                this.getView().updateView("createorg");
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (!MalOrderUtil.getDefaultMalVersion()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_queryprotocol", "isprotocolprod", "isgoodsvisible", "advconap", "barcode", "spunumber"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"createorg"});
        }
        if (StringUtils.isNotBlank((Object)this.getModel().getValue("spunumber"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"createorg", "category"});
        }
        if (this.getModel().getDataEntity().getLong("id") != 0L && this.getModel().getDataEntity().get("unit") != null) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"unit"});
        }
        this.setRichText();
    }

    public void setRichText() {
        String specification;
        RichTextEditor richTextEditor = (RichTextEditor)this.getControl(RICHTEXTEDITORAP);
        RichTextEditor richTextEditor1 = (RichTextEditor)this.getControl(RICHTEXTEDITORAP1);
        IDataModel dataModel = this.getModel();
        String contentTag = dataModel.getValue("content_tag") == null ? "" : dataModel.getValue("content_tag").toString();
        String content = dataModel.getValue("content") == null ? "" : dataModel.getValue("content").toString();
        String specificationTag = dataModel.getValue("specification_tag") == null ? "" : dataModel.getValue("specification_tag").toString();
        String string = specification = dataModel.getValue("specification") == null ? "" : dataModel.getValue("specification").toString();
        if (StringUtils.isNotEmpty((CharSequence)contentTag)) {
            richTextEditor.setText(contentTag);
        }
        if (StringUtils.isEmpty((CharSequence)contentTag) && StringUtils.isNotEmpty((CharSequence)content)) {
            richTextEditor.setText(content);
        }
        if (StringUtils.isNotEmpty((CharSequence)specificationTag)) {
            richTextEditor1.setText(specificationTag);
        }
        if (StringUtils.isEmpty((CharSequence)specification) && StringUtils.isNotEmpty((CharSequence)specification)) {
            richTextEditor1.setText(specification);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit supplier1 = (BasedataEdit)this.getView().getControl(this.SUPPLIER);
        supplier1.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("bizpartner", "in", (Object)BizPartnerUtil.getBizPartnerId()));
            }
        });
        BasedataEdit orgEdit = (BasedataEdit)this.getControl("createorg");
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"tb_auxptytoolbar"});
        BasedataEdit prodAttribute = (BasedataEdit)this.getView().getControl("prodattribute");
        prodAttribute.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit prodattributevalue = (BasedataEdit)this.getView().getControl("prodattributevalue");
        prodattributevalue.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        QFilter filter;
        List idList;
        DynamicObjectCollection prodAttributeDyoCol;
        QFilter prodAttributeFilter;
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"prodattribute")) {
            DynamicObject category = (DynamicObject)this.getModel().getValue("category");
            Long categoryId = category != null ? category.getLong("id") : 0L;
            prodAttributeFilter = new QFilter("group", "=", (Object)categoryId).and(new QFilter("enable", "=", (Object)"1"));
            prodAttributeDyoCol = QueryServiceHelper.query((String)"ent_prodattribute", (String)"id", (QFilter[])new QFilter[]{prodAttributeFilter});
            idList = prodAttributeDyoCol.stream().map(item -> item.getLong("id")).collect(Collectors.toList());
            filter = new QFilter("id", "in", idList);
            showParameter.getListFilterParameter().getQFilters().add(filter);
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"prodattributevalue")) {
            DynamicObject prodAttribute = (DynamicObject)this.getModel().getValue("prodattribute");
            if (null == prodAttribute) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u5c5e\u6027\u540d\u79f0\u201d\uff0c\u518d\u5f55\u5165\u5c5e\u6027\u5185\u5bb9\u3002", (String)"EntProdManageEdit_12", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            Long prodAttributeClassId = prodAttribute.getLong("prodattributename.id");
            prodAttributeFilter = new QFilter("group", "=", (Object)prodAttributeClassId).and(new QFilter("enable", "=", (Object)"1"));
            prodAttributeDyoCol = QueryServiceHelper.query((String)"ent_prodattributevalue", (String)"id", (QFilter[])new QFilter[]{prodAttributeFilter});
            idList = prodAttributeDyoCol.stream().map(item -> item.getLong("id")).collect(Collectors.toList());
            filter = new QFilter("id", "in", idList);
            showParameter.getListFilterParameter().getQFilters().add(filter);
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"createorg") && "click".equals(beforeF7SelectEvent.getSourceMethod())) {
            beforeF7SelectEvent.setCancel(true);
            HashMap<String, String> paramMap = new HashMap<String, String>(8);
            paramMap.put("orgType", "purorg");
            OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)"ent_orgselect", (ShowType)ShowType.Modal, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "orgclose"));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if (this.flag) {
            this.flag = true;
            return;
        }
        String propertyName = e.getProperty().getName();
        IDataModel model = this.getModel();
        switch (propertyName) {
            case "price": {
                this.calTaxPriceByPrice(model);
                break;
            }
            case "prodattribute": {
                model.setValue("prodattributevalue", null);
                this.doCheckAttribute(model, rowIndex);
                break;
            }
            case "taxprice": {
                this.calPriceByTaxPrice(model);
                break;
            }
            case "taxrate": {
                BigDecimal oldtaxrate = (BigDecimal)e.getChangeSet()[0].getOldValue();
                BigDecimal taxrate = (BigDecimal)model.getValue(this.TAXRATE);
                if (taxrate.compareTo(CalConstant.BIGDECIMAL_ONEHUNDRED) >= 0 || taxrate.compareTo(this.ZERO) < 0) {
                    model.setValue(this.TAXRATE, (Object)oldtaxrate);
                }
                this.calPriceByTaxPrice(model);
                break;
            }
            case "category": {
                this.getModel().deleteEntryData("prodattributeentry");
                break;
            }
        }
    }

    private void doCheckAttribute(IDataModel model, int rowIndex) {
        if (null == model.getValue("prodattribute", rowIndex)) {
            return;
        }
        DynamicObject prodAttribute = (DynamicObject)model.getValue("prodattribute", rowIndex);
        Long prodAttributeId = (Long)prodAttribute.get("id");
        DynamicObjectCollection entrys = model.getDataEntity(true).getDynamicObjectCollection("prodattributeentry");
        for (DynamicObject row : entrys) {
            Long prodAttributeName;
            if (null == prodAttribute || null == row.getDynamicObject("prodattribute") || !(prodAttributeName = (Long)row.getDynamicObject("prodattribute").getPkValue()).equals(prodAttributeId) || rowIndex + 1 == row.getInt("seq")) continue;
            String msg = ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u7684\u5c5e\u6027\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"EntProdManageEdit_13", (String)"scm-ent-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            model.setValue("prodattribute", null);
            break;
        }
    }

    public void calTaxPriceByPrice(IDataModel model) {
        BigDecimal price = null == model.getValue(this.PRICE) ? this.ZERO : (BigDecimal)model.getValue(this.PRICE);
        BigDecimal taxRate = null == model.getValue(this.TAXRATE) ? this.ZERO : (BigDecimal)model.getValue(this.TAXRATE);
        int scale = this.getPricePrecision(model);
        BigDecimal taxPrice = CalculateUtils.calTaxPrice((BigDecimal)price, (BigDecimal)taxRate, (int)scale);
        this.flag = true;
        model.setValue(this.TAXPRICE, (Object)taxPrice);
    }

    public void calPriceByTaxPrice(IDataModel model) {
        String taxType = (String)model.getValue(this.TAXTYPE);
        BigDecimal taxPrice = null == model.getValue(this.TAXPRICE) ? this.ZERO : (BigDecimal)model.getValue(this.TAXPRICE);
        BigDecimal taxRate = null == model.getValue(this.TAXRATE) ? this.ZERO : (BigDecimal)model.getValue(this.TAXRATE);
        int scale = this.getPricePrecision(model);
        BigDecimal price = null;
        price = "1".equals(taxType) ? CalculateUtils.calPrice((BigDecimal)taxPrice, (BigDecimal)taxRate, (int)scale) : CalculateUtils.calPriceIsPriceInTax((BigDecimal)taxRate, (BigDecimal)taxPrice, (int)scale);
        this.flag = true;
        model.setValue(this.PRICE, (Object)price);
    }

    protected int getPricePrecision(IDataModel datamodel) {
        int pricePrecision = 6;
        Object currency = datamodel.getValue("curr");
        if (null != currency && currency instanceof DynamicObject) {
            DynamicObject curr = (DynamicObject)currency;
            pricePrecision = curr.getInt("priceprecision");
        }
        return pricePrecision;
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "bar_preview": {
                Long id = (Long)this.getModel().getValue("id");
                boolean b = this.previewCheck(id);
                if (!b) {
                    return;
                }
                this.showDetailPage(id);
            }
        }
    }

    private void showDetailPage(Long productId) {
        FormShowParameter showParameter = new FormShowParameter();
        HashMap<String, String> detailParamMap = new HashMap<String, String>();
        if (MalOrderUtil.getDefaultMalVersion()) {
            showParameter.setFormId("mal_newproductdetail");
            detailParamMap.put("productSelfId", String.valueOf(productId));
        } else {
            showParameter.setFormId(MAL_PRODUCTDETAIL);
            DynamicObject productDyn = BusinessDataServiceHelper.loadSingle((Object)productId, (String)"pmm_prodmanage");
            detailParamMap.put("productDyn", (String)productDyn);
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        detailParamMap.put("origin", "sup");
        showParameter.setCustomParams(detailParamMap);
        showParameter.setCaption(ResManager.loadKDString((String)"\u5546\u54c1\u9884\u89c8", (String)"EntProdManageEdit_5", (String)"scm-ent-formplugin", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
    }

    private boolean previewCheck(Long productId) {
        QFilter filter = new QFilter("id", "=", (Object)productId);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject[] sups = BusinessDataServiceHelper.load((String)"ent_prodmanage", (String)"number,mallstatus,status,name,unit,category,source,taxprice,thumbnail", (QFilter[])filters);
        StringBuilder sb = new StringBuilder();
        if (sups[0].getString("name") == null) {
            sb.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5546\u54c1\u540d\u79f0\u201d\u3002", (String)"EntProdManageEdit_6", (String)"scm-ent-formplugin", (Object[])new Object[0])).append('\n');
        }
        if (sups[0].getString("unit") == null) {
            sb.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8ba1\u91cf\u5355\u4f4d\u201d\u3002", (String)"EntProdManageEdit_7", (String)"scm-ent-formplugin", (Object[])new Object[0])).append('\n');
        }
        if (sups[0].getString("taxprice").equals("0E-10")) {
            sb.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u542b\u7a0e\u5355\u4ef7\u201d\u3002", (String)"EntProdManageEdit_8", (String)"scm-ent-formplugin", (Object[])new Object[0])).append('\n');
        }
        if (sups[0].getString("thumbnail") == "") {
            sb.append(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u201c\u5546\u54c1\u4e3b\u56fe\u201d\u3002", (String)"EntProdManageEdit_9", (String)"scm-ent-formplugin", (Object[])new Object[0])).append('\n');
        }
        if (sb.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u65e0\u6cd5\u9884\u89c8\u5546\u54c1\uff0c\u8bf7\u5f55\u5165\u4ee5\u4e0b\u4fe1\u606f\u3002", (String)"EntProdManageEdit_10", (String)"scm-ent-formplugin", (Object[])new Object[0]), String.valueOf(sb), MessageTypes.Default);
            return false;
        }
        return true;
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        Map objectMap = e.getSourceData();
        for (Map.Entry obj : objectMap.entrySet()) {
            String property = (String)obj.getKey();
            Object valus = obj.getValue();
            if (property.equalsIgnoreCase("taxprice")) {
                Object tax = objectMap.get("taxrate");
                if (null == tax) {
                    tax = "0.00";
                }
                BigDecimal price = CalculateUtils.calPrice((BigDecimal)new BigDecimal(String.valueOf(valus)), (BigDecimal)new BigDecimal(String.valueOf(tax)), (int)2);
                this.getModel().setValue("price", (Object)price);
                continue;
            }
            if (!property.equalsIgnoreCase("content_import")) continue;
            this.getModel().setValue("content", valus);
            this.getModel().setValue("content_tag", valus);
        }
    }

    private void showQueryProtocol() {
        if (!this.checkHasProtocolViewPermission()) {
            return;
        }
        this.getView().updateView("protocolentry");
        DynamicObject dynamicObject = this.getModel().getDataEntity(true);
        DynamicObjectCollection protocolEntry = dynamicObject.getDynamicObjectCollection("protocolentry");
        ArrayList<Long> protocolIdList = new ArrayList<Long>(protocolEntry.size());
        for (DynamicObject entry : protocolEntry) {
            DynamicObject protocol = entry.getDynamicObject("protocol");
            if (protocol == null) continue;
            protocolIdList.add(protocol.getLong("id"));
        }
        QFilter protocolQFilter = new QFilter("id", "in", protocolIdList);
        List userOfBizPartner = BizPartnerUtil.getSupplierByUserOfBizPartner();
        protocolQFilter.and(new QFilter("partyb", "in", (Object)userOfBizPartner));
        protocolQFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal()));
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getListFilterParameter().setFilter(protocolQFilter);
        listShowParameter.setBillFormId("ent_priceprotocol_bd");
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u5546\u57ce\u534f\u8bae", (String)"EntProdManageEdit_11", (String)"scm-ent-formplugin", (Object[])new Object[0]));
        listShowParameter.setCustomParam("isOpenNewTab", (Object)Boolean.TRUE);
        listShowParameter.setCustomParam("prodManageQuery", (Object)"true");
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.getOpenStyle().setTargetKey("_submaintab_");
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private boolean checkHasProtocolViewPermission() {
        String appId = AppMetadataCache.getAppInfo((String)"ent").getId();
        boolean hasPermResult = PermissionServiceHelper.checkPermission((Long)UserServiceHelper.getCurrentUserId(), (String)appId, (String)"ent_protocol", (String)"47150e89000000ac");
        if (!hasPermResult) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u534f\u8bae\u67e5\u8be2\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"EntProdManageEdit_14", (String)"scm-ent-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

