/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.formplugin.edit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.OrgUtil;
import kd.scm.ent.business.service.impl.EntSpuValidatorServiceImpl;
import kd.scm.ent.common.plugin.AbstractEntBillPlugIn;

public class EntProdSpuEdit
extends AbstractEntBillPlugIn
implements BeforeF7SelectListener,
RowClickEventListener {
    private static final String SAVE = "save";
    private static final String NEWSKU = "newsku";
    private static final String SKUMAPINIT = "skumapinit";
    private static final String NEWENTRY_SALEATR = "newentry_saleatr";
    private static final String DELETEENTRY_SALEATR = "deleteentry_saleatr";
    private static final String DELETEENTRY_SALEVAL = "deleteentry_saleval";
    private static final String DELETEENTRY_MAP = "deleteentry_map";
    private static final String NEWENTRY = "newentry";
    private static final String SALE_PROD_ATTRIBUTE_VALUE_CHANGE_OLD_VALUE = "saleProdAttributeValueChangeOldValue";
    private static final String SALE_PROD_ATTRIBUTE_VALUE_CHANGE_INDEX = "saleProdAttributeValueChangeIndex";
    private static final String SALE_PROD_ATTRIBUTE_VALUE_CHANGE_CALLBACK = "saleProdAttributeValueChangeCallback";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List supIdList = BizPartnerUtil.getSupplierByUserOfBizPartner();
        if (supIdList.size() > 0) {
            this.getModel().setValue("supplier", supIdList.get(0));
        }
        this.setOrgValue();
    }

    private void setOrgValue() {
        DynamicObject orgDyn;
        long createorg;
        IDataModel model = this.getModel();
        DynamicObject supplier = (DynamicObject)model.getValue("supplier");
        List purOrgIds = OrgUtil.getUserHasAllPurPermissionOrgs();
        if (purOrgIds.contains(createorg = supplier.getLong("createorg_id")) && (orgDyn = QueryServiceHelper.queryOne((String)"bos_org", (String)"id,fispurchase", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)createorg)})).getBoolean("fispurchase")) {
            model.setValue("orgfield", (Object)createorg);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String status = String.valueOf(this.getModel().getValue("status"));
        if ("E".equals(status)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"fs_baseinfo", "newentry_atrval", SKUMAPINIT, DELETEENTRY_SALEVAL, DELETEENTRY_MAP, NEWENTRY, "deleteentry", NEWENTRY_SALEATR, DELETEENTRY_SALEATR});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
        }
        if ("A".equals(status)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"fs_baseinfo", NEWENTRY, "deleteentry", NEWENTRY_SALEATR, DELETEENTRY_SALEATR, "bar_submit", "specadv1", "specadv"});
        }
        if ("A".equals(status) || "C".equals(status) || "D".equals(status)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"newentry_atrval", SKUMAPINIT, DELETEENTRY_SALEVAL, DELETEENTRY_MAP, "bar_submit", "bar_save"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save"});
        }
        if ("B".equals(status)) {
            this.setBtnEnableByStatus();
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"void"});
        }
        this.setOrgEnable();
    }

    private void setBtnEnableByStatus() {
        this.getView().setEnable(Boolean.FALSE, new String[]{NEWENTRY, "deleteentry", NEWENTRY_SALEATR, DELETEENTRY_SALEATR});
        this.getView().setEnable(Boolean.FALSE, new String[]{"fs_baseinfo", "specadv1", NEWENTRY_SALEATR, DELETEENTRY_SALEATR, "saleattributeentry"});
        EntryGrid spuSkuMapEntry = (EntryGrid)this.getControl("spuskumapentry");
        DynamicObject[] datas = spuSkuMapEntry.getEntryData().getDataEntitys();
        ArrayList<Integer> tagRow = new ArrayList<Integer>();
        for (DynamicObject dynamicObject : datas) {
            String confirmstatus = dynamicObject.getString("confirmstatus");
            if (!"B".equals(confirmstatus)) continue;
            tagRow.add(dynamicObject.getInt("seq"));
        }
        int[] rows = new int[tagRow.size()];
        int i = 0;
        for (Integer Row2 : tagRow) {
            rows[i] = Row2 - 1;
            ++i;
        }
        spuSkuMapEntry.setRowLock(Boolean.TRUE.booleanValue(), rows);
        this.getView().setVisible(Boolean.TRUE, new String[]{"void"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"baritemap1"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit supplierEdit = (BasedataEdit)this.getView().getControl("supplier");
        supplierEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit prodAttribute = (BasedataEdit)this.getView().getControl("prodattribute");
        prodAttribute.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit prodattributevalue = (BasedataEdit)this.getView().getControl("prodattributevalue");
        prodattributevalue.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit saleProdAttribute = (BasedataEdit)this.getView().getControl("saleprodattribute");
        saleProdAttribute.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit saleprodattributevalue = (BasedataEdit)this.getView().getControl("saleprodattributevalue");
        saleprodattributevalue.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit goods = (BasedataEdit)this.getView().getControl("goods");
        goods.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("spuskumapentry");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        this.addItemClickListeners(new String[]{"saletoolbar"});
        this.addItemClickListeners(new String[]{"salevartoolbar"});
        BasedataEdit orgEdit = (BasedataEdit)this.getControl("orgfield");
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String fieldKey = arg0.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
        switch (fieldKey) {
            case "supplier": {
                List supIdList = BizPartnerUtil.getSupplierByUserOfBizPartner();
                QFilter filter = new QFilter("id", "in", (Object)supIdList);
                showParameter.getListFilterParameter().getQFilters().add(filter);
                break;
            }
            case "prodattribute": {
                this.getAtrFilters(showParameter, "prodattribute");
                break;
            }
            case "prodattributevalue": {
                DynamicObject prodAttribute = (DynamicObject)this.getModel().getValue("prodattribute");
                this.getAtrValFilters(showParameter, arg0, prodAttribute);
                break;
            }
            case "saleprodattribute": {
                this.getAtrFilters(showParameter, "saleprodattribute");
                break;
            }
            case "saleprodattributevalue": {
                DynamicObject prodAtribute = (DynamicObject)this.getModel().getValue("saleprodattribute");
                this.getAtrValFilters(showParameter, arg0, prodAtribute);
                break;
            }
            case "goods": {
                this.getGoodsFilters(showParameter, arg0);
                break;
            }
            case "orgfield": {
                this.showOrgFrom(arg0);
                break;
            }
        }
    }

    private void showOrgFrom(BeforeF7SelectEvent arg0) {
        if ("click".equals(arg0.getSourceMethod())) {
            arg0.setCancel(true);
            HashMap<String, String> paramMap = new HashMap<String, String>(8);
            paramMap.put("orgType", "purorg");
            HasPermOrgResult hasPermDimObjResult = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"02", (String)"/DNE/KK2RNOZ", (String)"ent_spu", (String)"47150e89000000ac", (boolean)false);
            if (!hasPermDimObjResult.hasAllOrgPerm()) {
                String orgIds = SerializationUtils.toJsonString((Object)hasPermDimObjResult.getHasPermOrgs());
                paramMap.put("orgIds", orgIds);
            }
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("ent_orgselect");
            fsp.setCustomParams(paramMap);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "orgclose"));
            fsp.setCaption(ResManager.loadKDString((String)"\u5ba1\u6279\u5355\u4f4d", (String)"EntProdSpuEdit_13", (String)"scm-ent-formplugin", (Object[])new Object[0]));
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(fsp);
        } else {
            HasPermOrgResult hasPermDimObjResult = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"02", (String)"/DNE/KK2RNOZ", (String)"ent_spu", (String)"47150e89000000ac", (boolean)false);
            if (!hasPermDimObjResult.hasAllOrgPerm()) {
                arg0.addCustomQFilter(new QFilter("id", "in", (Object)hasPermDimObjResult.getHasPermOrgs()));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "orgclose": {
                if (null == closedCallBackEvent.getReturnData()) break;
                HashMap returnData = (HashMap)closedCallBackEvent.getReturnData();
                List orgIdList = (List)returnData.get("orgIdList");
                for (String orgId : orgIdList) {
                    this.getModel().setValue("orgfield", (Object)Long.valueOf(orgId));
                }
                this.getView().updateView("orgfield");
                break;
            }
            case "newSku": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    private void getAtrFilters(ListShowParameter showParameter, String attrTag) {
        DynamicObjectCollection baseAtrEntry;
        DynamicObject category = (DynamicObject)this.getModel().getValue("group");
        Long categoryId = category != null ? category.getLong("id") : 0L;
        QFilter prodAttributeFilter = new QFilter("group", "=", (Object)categoryId);
        DynamicObjectCollection prodAttributeDyoCol = QueryServiceHelper.query((String)"ent_prodattribute", (String)"id", (QFilter[])new QFilter[]{prodAttributeFilter});
        List idList = prodAttributeDyoCol.stream().map(item -> item.getLong("id")).collect(Collectors.toList());
        List<Object> attrIdList = new ArrayList(1024);
        if ("prodattribute".equals(attrTag)) {
            baseAtrEntry = this.getModel().getEntryEntity("baseattributeentry");
            attrIdList = baseAtrEntry.stream().filter(m -> m.getDynamicObject("prodattribute") != null).map(m -> m.getDynamicObject("prodattribute").getPkValue()).collect(Collectors.toList());
        } else {
            baseAtrEntry = this.getModel().getEntryEntity("saleattributeentry");
            attrIdList = baseAtrEntry.stream().filter(m -> m.getDynamicObject("saleprodattribute") != null).map(m -> m.getDynamicObject("saleprodattribute").getPkValue()).collect(Collectors.toList());
        }
        QFilter filter = new QFilter("id", "in", idList).and(new QFilter("id", "not in", attrIdList));
        showParameter.getListFilterParameter().getQFilters().add(filter);
    }

    private void getAtrValFilters(ListShowParameter showParameter, BeforeF7SelectEvent arg0, DynamicObject prodAttribute) {
        if ("true".equals(this.getPageCache().get("hasChecked"))) {
            this.getPageCache().remove("hasChecked");
            arg0.setCancel(true);
            return;
        }
        if (null == prodAttribute) {
            if ("getLookUpList".equals(arg0.getSourceMethod()) || "setItemByNumber".equals(arg0.getSourceMethod())) {
                this.getPageCache().put("hasChecked", "true");
            }
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u5c5e\u6027\u540d\u79f0\u201d\uff0c\u518d\u5f55\u5165\u5c5e\u6027\u5185\u5bb9\u3002", (String)"EntProdSpuEdit_0", (String)"scm-ent-formplugin", (Object[])new Object[0]));
            arg0.setCancel(true);
        } else {
            Long prodAttributeClassId = prodAttribute.getLong("prodattributename.id");
            QFilter prodAttributeFilter = new QFilter("group", "=", (Object)prodAttributeClassId).and(new QFilter("enable", "=", (Object)"1"));
            DynamicObjectCollection prodAttributeDyoCol = QueryServiceHelper.query((String)"ent_prodattributevalue", (String)"id", (QFilter[])new QFilter[]{prodAttributeFilter});
            List idList = prodAttributeDyoCol.stream().map(item -> item.getLong("id")).collect(Collectors.toList());
            DynamicObjectCollection saleAtrValEntry = this.getModel().getEntryEntity("saleatrvalueentry");
            QFilter filter = new QFilter("id", "in", idList);
            if (saleAtrValEntry != null) {
                List attrValIdList = saleAtrValEntry.stream().filter(m -> m.getDynamicObject("saleprodattributevalue") != null).map(m -> m.getDynamicObject("saleprodattributevalue").getPkValue()).collect(Collectors.toList());
                filter.and(new QFilter("id", "not in", attrValIdList));
            }
            showParameter.getListFilterParameter().getQFilters().add(filter);
        }
    }

    private void getGoodsFilters(ListShowParameter showParameter, BeforeF7SelectEvent arg0) {
        DynamicObjectCollection spuskumapentry = this.getModel().getEntryEntity("spuskumapentry");
        List choiceSkuList = spuskumapentry.stream().filter(k -> k.getDynamicObject("goods") != null).map(k -> k.getLong("goods_id")).collect(Collectors.toList());
        Long supplierId = (Long)this.getModel().getValue("supplier_id");
        Long orgId = (Long)this.getModel().getValue("orgfield_id");
        Long categoryId = (Long)this.getModel().getValue("group_id");
        DynamicObjectCollection baseAtrEntry = this.getModel().getEntryEntity("baseattributeentry");
        List baseAtrValIdList = baseAtrEntry.stream().filter(m -> m.getDynamicObject("prodattributevalue") != null).map(m -> m.getDynamicObject("prodattributevalue").getLong("id")).collect(Collectors.toList());
        int selectRows = arg0.getRow();
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("spuskumapentry", selectRows);
        DynamicObjectCollection spuAtrDetailEntry = entryRowEntity.getDynamicObjectCollection("spuatrdetailentry");
        List atrValIds = spuAtrDetailEntry.stream().map(m -> m.getDynamicObject("saleprodattributevalueid").getLong("id")).collect(Collectors.toList());
        ArrayList spuAtrList = new ArrayList(baseAtrValIdList.size() + atrValIds.size());
        spuAtrList.addAll(baseAtrValIdList);
        spuAtrList.addAll(atrValIds);
        QFilter prodFilter = new QFilter("supplier", "=", (Object)supplierId).and(new QFilter("category", "=", (Object)categoryId)).and(new QFilter("id", "not in", choiceSkuList)).and(new QFilter("spunumber", "is null", (Object)" ").or("spunumber", "=", (Object)" ").or("spunumber", "=", this.getModel().getValue("number")));
        HashMap prodIdAndAttrIdsMap = new HashMap();
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getPluginName(), (String)"ent_prodmanage", (String)"id,prodattributeentry.prodattributevalue prodattributevalue", (QFilter[])new QFilter[]{prodFilter}, (String)"id");
        Object object = null;
        try {
            dataSet.forEach(row -> {
                List attrIds = prodIdAndAttrIdsMap.computeIfAbsent(row.getLong("id"), k -> new ArrayList());
                attrIds.add(row.getLong("prodattributevalue"));
            });
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        ArrayList<Number> idList = new ArrayList<Number>(prodIdAndAttrIdsMap.size());
        for (Map.Entry entry : prodIdAndAttrIdsMap.entrySet()) {
            Long prodId = (Long)entry.getKey();
            List attrIds = (List)entry.getValue();
            if (!attrIds.containsAll(spuAtrList)) continue;
            idList.add(prodId);
        }
        if (prodIdAndAttrIdsMap.isEmpty()) {
            idList.add(0);
        }
        QFilter filter = new QFilter("id", "in", idList);
        showParameter.setCustomParam("ismergerows", (Object)Boolean.TRUE);
        showParameter.getListFilterParameter().getQFilters().add(filter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "skumapinit": {
                boolean isCheck = this.dataCheck();
                if (isCheck) {
                    this.skuMapInit(args);
                    break;
                }
                args.setCancel(true);
                break;
            }
            case "deleteentry_map": {
                if (!this.checkSkuAtr()) break;
                args.setCancel(true);
                break;
            }
            case "newsku": {
                this.newSku();
                break;
            }
            case "submit": {
                this.submitOp();
                args.setCancel(true);
                break;
            }
            case "unsubmit": {
                this.unSubmitOp();
                args.setCancel(true);
                break;
            }
        }
    }

    private void submitOp() {
        DynamicObject[] spus = new DynamicObject[]{this.getModel().getDataEntity(true)};
        EntSpuValidatorServiceImpl entSpuValidatorService = new EntSpuValidatorServiceImpl();
        Map<Long, Integer> selectEntryIdAndRowIndexs = this.getSelectEntryIdAndRowIndexs();
        Map res = entSpuValidatorService.submitHandleAndValid(spus, selectEntryIdAndRowIndexs);
        entSpuValidatorService.submitMessageShow(res, this.getView(), selectEntryIdAndRowIndexs);
        int successNum = (Integer)res.get("successNum");
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("isshowmessage", "false");
        if (successNum > 0) {
            this.getView().invokeOperation(SAVE, operateOption);
        }
        this.getView().updateView();
    }

    private void unSubmitOp() {
        this.getView().invokeOperation("refresh");
        DynamicObject[] spus = new DynamicObject[]{this.getModel().getDataEntity(true)};
        EntSpuValidatorServiceImpl entSpuValidatorService = new EntSpuValidatorServiceImpl();
        Map<Long, Integer> selectEntryIdAndRowIndexs = this.getSelectEntryIdAndRowIndexs();
        Map res = entSpuValidatorService.unSubmitHandleAndValid(spus, selectEntryIdAndRowIndexs);
        entSpuValidatorService.unSubmitMessageShow(res, this.getView(), selectEntryIdAndRowIndexs);
        int successNum = (Integer)res.get("successNum");
        int failNum = (Integer)res.get("failNum");
        OperateOption option = OperateOption.create();
        option.setVariableValue("isshowmessage", String.valueOf(Boolean.FALSE));
        if (successNum > 0 && (failNum == 0 || selectEntryIdAndRowIndexs.isEmpty())) {
            this.getView().invokeOperation(SAVE, option);
        } else if (successNum > 0 && failNum > 0) {
            this.getView().invokeOperation(SAVE, option);
        }
        this.getView().invokeOperation("refresh");
    }

    private Map<Long, Integer> getSelectEntryIdAndRowIndexs() {
        EntryGrid spuSkuMapEntry = (EntryGrid)this.getControl("spuskumapentry");
        int[] select = spuSkuMapEntry.getSelectRows();
        HashMap<Long, Integer> selectEntryIdAndRowIndexs = new HashMap<Long, Integer>(select.length);
        for (int selectRow : select) {
            selectEntryIdAndRowIndexs.put(this.getModel().getEntryRowEntity("spuskumapentry", selectRow).getLong("id"), selectRow);
        }
        return selectEntryIdAndRowIndexs;
    }

    public void beforeAddRow(BeforeAddRowEventArgs e) {
        super.beforeAddRow(e);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        super.beforeItemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "newentry_saleatr": 
            case "deleteentry_saleatr": 
            case "newentry": {
                this.confirmDelete(itemKey, evt);
                break;
            }
            case "deleteentry_saleval": {
                if (this.checkAtrVal()) {
                    evt.setCancel(true);
                    break;
                }
                this.confirmDelete(itemKey, evt);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        Set changeFields;
        EntryGrid grid;
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)DELETEENTRY_SALEVAL, (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.deleteAtrVal();
            grid = (EntryGrid)this.getView().getControl("saleatrvalueentry");
            this.getModel().deleteEntryRows("saleatrvalueentry", grid.getSelectRows());
        }
        if (StringUtils.equals((CharSequence)NEWENTRY_SALEATR, (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getModel().deleteEntryData("spuskumapentry");
            this.getView().invokeOperation(NEWENTRY_SALEATR);
        }
        if (StringUtils.equals((CharSequence)NEWENTRY, (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getModel().deleteEntryData("baseattributeentry");
            this.getView().invokeOperation(NEWENTRY);
        }
        if (StringUtils.equals((CharSequence)DELETEENTRY_SALEATR, (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            grid = (EntryGrid)this.getView().getControl("saleattributeentry");
            this.getModel().deleteEntryRows("saleattributeentry", grid.getSelectRows());
            this.getModel().deleteEntryData("spuskumapentry");
        }
        if ((changeFields = Stream.of("prodattribute", "prodattributevalue", "saleprodattribute").collect(Collectors.toSet())).contains(messageBoxClosedEvent.getCallBackId())) {
            this.fieldChangeConfirmCallback(messageBoxClosedEvent);
        }
        if (StringUtils.equals((CharSequence)SALE_PROD_ATTRIBUTE_VALUE_CHANGE_CALLBACK, (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            this.saleProdAttributeValueRollBack();
        }
        if (StringUtils.equals((CharSequence)"saleprodattributevalue", (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.No) {
                this.saleProdAttributeValueRollBack();
            } else {
                String oldValueId = this.getPageCache().get(SALE_PROD_ATTRIBUTE_VALUE_CHANGE_OLD_VALUE);
                if (StringUtils.isNotBlank((CharSequence)oldValueId)) {
                    long atrValueId = Long.parseLong(oldValueId);
                    int delRow = 0;
                    if (atrValueId != 0L) {
                        DynamicObjectCollection mapEntry = this.getModel().getEntryEntity("spuskumapentry");
                        for (DynamicObject dynamicObject : mapEntry) {
                            String mapJson = dynamicObject.getString("spumapids");
                            if (!mapJson.contains(String.valueOf(atrValueId))) continue;
                            delRow = dynamicObject.getInt("seq");
                        }
                        this.getModel().deleteEntryRow("spuskumapentry", delRow - 1);
                    }
                }
                this.getPageCache().remove(SALE_PROD_ATTRIBUTE_VALUE_CHANGE_OLD_VALUE);
                this.getPageCache().remove(SALE_PROD_ATTRIBUTE_VALUE_CHANGE_INDEX);
            }
        }
    }

    private void saleProdAttributeValueRollBack() {
        String oldValueId = this.getPageCache().get(SALE_PROD_ATTRIBUTE_VALUE_CHANGE_OLD_VALUE);
        if (StringUtils.isNotBlank((CharSequence)oldValueId)) {
            String index = this.getPageCache().get(SALE_PROD_ATTRIBUTE_VALUE_CHANGE_INDEX);
            this.getModel().beginInit();
            this.getModel().setValue("saleprodattributevalue_id", (Object)Long.valueOf(oldValueId), Integer.parseInt(index));
            this.getModel().endInit();
            this.getPageCache().remove(SALE_PROD_ATTRIBUTE_VALUE_CHANGE_OLD_VALUE);
            this.getPageCache().remove(SALE_PROD_ATTRIBUTE_VALUE_CHANGE_INDEX);
            this.getView().updateView();
        }
    }

    private void fieldChangeConfirmCallback(MessageBoxClosedEvent messageBoxClosedEvent) {
        String fieldName = this.getPageCache().get("fieldName");
        List changeSet = (List)SerializationUtils.fromJsonString((String)this.getPageCache().getBigObject("changeData"), List.class);
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.fieldChangeConfirmCallbackYes(fieldName, changeSet);
        } else {
            this.fieldChangeConfirmCallbackNo(fieldName, changeSet);
        }
        this.getView().updateView();
    }

    private void fieldChangeConfirmCallbackYes(String fieldName, List<Map<String, Object>> changeSet) {
        if ("saleprodattributevalue".equals(fieldName)) {
            this.deleteAtrVal();
            this.getModel().beginInit();
            for (Map<String, Object> changeData : changeSet) {
                if (changeData.get("newValue") != null) {
                    this.getModel().setValue(fieldName, ((Map)changeData.get("newValue")).get("id"), ((Integer)changeData.get("rowIndex")).intValue());
                    continue;
                }
                this.getModel().setValue(fieldName, null, ((Integer)changeData.get("rowIndex")).intValue());
            }
            this.getModel().endInit();
        } else {
            this.getModel().deleteEntryData("spuskumapentry");
            if ("saleprodattribute".equals(fieldName)) {
                this.getModel().deleteEntryData("saleatrvalueentry");
            } else if ("prodattribute".equals(fieldName)) {
                for (Map<String, Object> changeData : changeSet) {
                    this.getModel().setValue("prodattributevalue", null, ((Integer)changeData.get("rowIndex")).intValue());
                }
            }
        }
    }

    private void fieldChangeConfirmCallbackNo(String fieldName, List<Map<String, Object>> changeSet) {
        this.getModel().beginInit();
        for (Map<String, Object> changeData : changeSet) {
            if (changeData.get("oldValue") != null) {
                this.getModel().setValue(fieldName, ((Map)changeData.get("oldValue")).get("id"), ((Integer)changeData.get("rowIndex")).intValue());
                continue;
            }
            this.getModel().setValue(fieldName, null, ((Integer)changeData.get("rowIndex")).intValue());
        }
        this.getModel().endInit();
    }

    private void confirmDelete(String operateKey, BeforeItemClickEvent evt) {
        EntryGrid grid;
        EntryGrid grid2;
        String msg = "";
        if (DELETEENTRY_SALEATR.equals(operateKey) && (grid2 = (EntryGrid)this.getView().getControl("saleattributeentry")).getSelectRows().length == 0) {
            msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"EntProdSpuEdit_12", (String)"scm-ent-formplugin", (Object[])new Object[0]);
        }
        if (DELETEENTRY_SALEVAL.equals(operateKey) && (grid2 = (EntryGrid)this.getView().getControl("saleatrvalueentry")).getSelectRows().length == 0) {
            msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"EntProdSpuEdit_12", (String)"scm-ent-formplugin", (Object[])new Object[0]);
        }
        if (NEWENTRY.equals(operateKey) && (grid2 = (EntryGrid)this.getView().getControl("baseattributeentry")).getSelectRows().length == 0) {
            msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"EntProdSpuEdit_12", (String)"scm-ent-formplugin", (Object[])new Object[0]);
        }
        if (msg.length() > 0) {
            this.getView().showTipNotification(msg);
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection spuskumapentry = dataEntity.getDynamicObjectCollection("spuskumapentry");
        DynamicObjectCollection saleattributeentry = dataEntity.getDynamicObjectCollection("saleattributeentry");
        if (NEWENTRY_SALEATR.equals(operateKey) && saleattributeentry.size() > 0 && spuskumapentry.size() > 0) {
            msg = ResManager.loadKDString((String)"\u65b0\u589e\u9500\u552e\u5c5e\u6027\u5c06\u6e05\u7a7a\u5173\u8054SKU\u5206\u5f55\uff0c\u9700\u91cd\u65b0\u5173\u8054SKU\u5e76\u786e\u8ba4\uff0c\u786e\u5b9a\u65b0\u589e\u5417\uff1f", (String)"EntProdSpuEdit_9", (String)"scm-ent-formplugin", (Object[])new Object[0]);
        }
        if (DELETEENTRY_SALEATR.equals(operateKey) && saleattributeentry.size() > 0 && spuskumapentry.size() > 0) {
            msg = ResManager.loadKDString((String)"\u5220\u9664\u9500\u552e\u5c5e\u6027\u5c06\u6e05\u7a7a\u5173\u8054SKU\u5206\u5f55\uff0c\u9700\u91cd\u65b0\u5173\u8054SKU\u5e76\u786e\u8ba4\uff0c\u786e\u5b9a\u5220\u9664\u5417\uff1f", (String)"EntProdSpuEdit_10", (String)"scm-ent-formplugin", (Object[])new Object[0]);
        }
        if (NEWENTRY.equals(operateKey) && saleattributeentry.size() > 0 && spuskumapentry.size() > 0) {
            msg = ResManager.loadKDString((String)"\u65b0\u589e\u57fa\u672c\u5c5e\u6027\u5c06\u6e05\u7a7a\u5173\u8054SKU\u5206\u5f55\uff0c\u9700\u91cd\u65b0\u5173\u8054SKU\u5e76\u786e\u8ba4\uff0c\u786e\u5b9a\u65b0\u589e\u5417\uff1f", (String)"EntProdSpuEdit_16", (String)"scm-ent-formplugin", (Object[])new Object[0]);
            evt.setCancel(true);
        }
        if (DELETEENTRY_SALEVAL.equals(operateKey) && spuskumapentry.size() > 0 && this.isExistAtrVal()) {
            msg = ResManager.loadKDString((String)"\u5220\u9664\u9500\u552e\u5c5e\u6027\u5185\u5bb9\u5c06\u6e05\u7a7a\u5173\u8054SKU\u5206\u5f55\uff0c\u9700\u91cd\u65b0\u5173\u8054SKU\u5e76\u786e\u8ba4\uff0c\u786e\u5b9a\u5220\u9664\u5417\uff1f", (String)"EntProdSpuEdit_11", (String)"scm-ent-formplugin", (Object[])new Object[0]);
        }
        if (msg.length() > 0) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(operateKey, (IFormPlugin)this);
            this.getView().showConfirm(msg, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            return;
        }
        if (spuskumapentry.size() == 0) {
            if (NEWENTRY_SALEATR.equals(operateKey)) {
                this.getModel().deleteEntryData("spuskumapentry");
                this.getView().invokeOperation(NEWENTRY_SALEATR);
            }
            if (DELETEENTRY_SALEATR.equals(operateKey)) {
                grid = (EntryGrid)this.getView().getControl("saleattributeentry");
                this.getModel().deleteEntryRows("saleattributeentry", grid.getSelectRows());
            }
        }
        if ((spuskumapentry.size() == 0 || !this.isExistAtrVal()) && DELETEENTRY_SALEVAL.equals(operateKey)) {
            this.deleteAtrVal();
            grid = (EntryGrid)this.getView().getControl("saleatrvalueentry");
            this.getModel().deleteEntryRows("saleatrvalueentry", grid.getSelectRows());
        }
    }

    private boolean checkSkuAtr() {
        EntryGrid spuSkuMapEntry = (EntryGrid)this.getControl("spuskumapentry");
        int[] selectRows = spuSkuMapEntry.getSelectRows();
        ArrayList<String> atrVal = new ArrayList<String>(selectRows.length);
        for (int i : selectRows) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("spuskumapentry", i);
            String confirmstatus = entryRowEntity.getString("confirmstatus");
            if (!"B".equals(confirmstatus) && !"A".equals(confirmstatus)) continue;
            atrVal.add(String.valueOf(entryRowEntity.getPkValue()));
            break;
        }
        if (!CollectionUtils.isEmpty(atrVal)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u90e8\u5206\u884c\u5f85\u786e\u8ba4/\u5df2\u786e\u8ba4\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"EntProdSpuEdit_3", (String)"scm-ent-formplugin", (Object[])new Object[0]));
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private boolean checkAtrVal() {
        EntryGrid saleAtrValueEntry = (EntryGrid)this.getControl("saleatrvalueentry");
        int[] selectRows = saleAtrValueEntry.getSelectRows();
        ArrayList<String> atrVal = new ArrayList<String>(selectRows.length);
        block0: for (int i : selectRows) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("saleatrvalueentry", i);
            long atrValueId = DynamicObjectUtil.getDynamicObjectPk((DynamicObject)entryRowEntity, (String)"saleprodattributevalue");
            if (atrValueId == 0L) continue;
            DynamicObjectCollection mapEntry = this.getModel().getEntryEntity("spuskumapentry");
            for (DynamicObject dynamicObject : mapEntry) {
                String mapJson = dynamicObject.getString("spumapids");
                String confirmstatus = dynamicObject.getString("confirmstatus");
                if (!mapJson.contains(String.valueOf(atrValueId)) || !Arrays.asList("A", "B").contains(confirmstatus)) continue;
                atrVal.add(String.valueOf(entryRowEntity.getDynamicObject("saleprodattributevalue").get("name")));
                continue block0;
            }
        }
        if (!CollectionUtils.isEmpty(atrVal)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"{0}\u5c5e\u6027\u5185\u5bb9\u5df2\u4f7f\u7528\u4e14\u5f85\u786e\u8ba4/\u5df2\u786e\u8ba4\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"EntProdSpuEdit_4", (String)"scm-ent-formplugin", (Object[])new Object[]{atrVal}), MessageBoxOptions.OK, new ConfirmCallBackListener(SALE_PROD_ATTRIBUTE_VALUE_CHANGE_CALLBACK, (IFormPlugin)this));
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void deleteAtrVal() {
        EntryGrid saleAtrValueEntry = (EntryGrid)this.getControl("saleatrvalueentry");
        int[] selectRows = saleAtrValueEntry.getSelectRows();
        ArrayList<Integer> delRow = new ArrayList<Integer>();
        for (int i : selectRows) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("saleatrvalueentry", i);
            long atrValueId = DynamicObjectUtil.getDynamicObjectPk((DynamicObject)entryRowEntity, (String)"saleprodattributevalue");
            if (atrValueId == 0L) continue;
            delRow.clear();
            DynamicObjectCollection mapEntry = this.getModel().getEntryEntity("spuskumapentry");
            for (DynamicObject dynamicObject : mapEntry) {
                String mapJson = dynamicObject.getString("spumapids");
                if (!mapJson.contains(String.valueOf(atrValueId))) continue;
                delRow.add(dynamicObject.getInt("seq"));
            }
            int[] delRow2 = new int[delRow.size()];
            int j = 0;
            for (Integer Row2 : delRow) {
                delRow2[j] = Row2 - 1;
                ++j;
            }
            this.getModel().deleteEntryRows("spuskumapentry", delRow2);
        }
    }

    private boolean isExistAtrVal() {
        EntryGrid saleAtrValueEntry = (EntryGrid)this.getControl("saleatrvalueentry");
        int[] selectRows = saleAtrValueEntry.getSelectRows();
        boolean isExist = false;
        block0: for (int i : selectRows) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("saleatrvalueentry", i);
            long atrValueId = DynamicObjectUtil.getDynamicObjectPk((DynamicObject)entryRowEntity, (String)"saleprodattributevalue");
            if (atrValueId == 0L) continue;
            DynamicObjectCollection mapEntry = this.getModel().getEntryEntity("spuskumapentry");
            for (DynamicObject dynamicObject : mapEntry) {
                String mapJson = dynamicObject.getString("spumapids");
                if (!mapJson.contains(String.valueOf(atrValueId))) continue;
                isExist = true;
                continue block0;
            }
        }
        return isExist;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (operateKey.equals("invalid")) {
            this.getView().updateView();
            this.getView().updateView("spuskumapentry");
        }
        if (operateKey.equals("refresh") && "B".equals(String.valueOf(this.getModel().getValue("status")))) {
            this.setBtnEnableByStatus();
        }
        if (operateKey.equals(SAVE) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.setOrgEnable();
        }
    }

    private void setOrgEnable() {
        Long id = (Long)this.getModel().getValue("id");
        if (id != 0L) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"orgfield"});
        }
    }

    private void newSku() {
        DynamicObject entryRowEntity;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String supplierId = String.valueOf(this.getModel().getValue("supplier_id"));
        String orgId = String.valueOf(this.getModel().getValue("orgfield_id"));
        String categoryId = String.valueOf((Long)this.getModel().getValue("group_id"));
        String number = String.valueOf(this.getModel().getValue("number"));
        paramMap.put("categoryId", categoryId);
        paramMap.put("orgId", orgId);
        paramMap.put("supplierId", supplierId);
        paramMap.put("number", number);
        DynamicObjectCollection baseAtrEntry = this.getModel().getEntryEntity("baseattributeentry");
        if (baseAtrEntry.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u57fa\u672c\u5c5e\u6027\u5206\u5f55\u3002", (String)"EntProdSpuEdit_20", (String)"scm-ent-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, String> atrMap = new HashMap<String, String>(baseAtrEntry.size());
        for (int row = 0; row < baseAtrEntry.size(); ++row) {
            DynamicObject baseDyn = (DynamicObject)baseAtrEntry.get(row);
            if (baseDyn.getDynamicObject("prodattribute") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u57fa\u672c\u5c5e\u6027\u7b2c{0}\u884c\u7684\u5c5e\u6027\u7f16\u7801\u4e3a\u7a7a\uff0c\u8bf7\u5148\u586b\u5199\u3002", (String)"EntProdSpuEdit_14", (String)"scm-ent-formplugin", (Object[])new Object[]{row + 1}));
                return;
            }
            if (baseDyn.getDynamicObject("prodattributevalue") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u57fa\u672c\u5c5e\u6027\u7b2c{0}\u884c\u7684\u5c5e\u6027\u5185\u5bb9\u7f16\u7801\u4e3a\u7a7a\uff0c\u8bf7\u5148\u586b\u5199\u3002", (String)"EntProdSpuEdit_15", (String)"scm-ent-formplugin", (Object[])new Object[]{row + 1}));
                return;
            }
            String attributeId = baseDyn.getDynamicObject("prodattribute").getPkValue().toString();
            String attributeValId = baseDyn.getDynamicObject("prodattributevalue").getPkValue().toString();
            atrMap.put(attributeId, attributeValId);
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("isshowmessage", "false");
        this.getView().invokeOperation(SAVE, operateOption);
        EntryGrid saleAtrValueEntry = (EntryGrid)this.getControl("spuskumapentry");
        int[] selectRows = saleAtrValueEntry.getSelectRows();
        int rowIndex = selectRows[0];
        if (null != this.getPageCache().get("row")) {
            rowIndex = Integer.parseInt(this.getPageCache().get("row"));
            this.getPageCache().remove("row");
        }
        if ((entryRowEntity = this.getModel().getEntryRowEntity("spuskumapentry", rowIndex)).getDynamicObject("goods") != null && Arrays.asList("A", "B").contains(entryRowEntity.getString("confirmstatus"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5173\u8054SKU\uff0c\u4e0d\u652f\u6301\u65b0\u589eSKU\u3002", (String)"EntProdSpuEdit_23", (String)"scm-ent-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection spuAtrDetailCol = entryRowEntity.getDynamicObjectCollection("spuatrdetailentry");
        for (DynamicObject saleDyn : spuAtrDetailCol) {
            String attributeId = saleDyn.getDynamicObject("saleprodattributeid").getPkValue().toString();
            String attributeValId = saleDyn.getDynamicObject("saleprodattributevalueid").getPkValue().toString();
            atrMap.put(attributeId, attributeValId);
        }
        paramMap.put("atrMap", SerializationUtils.toJsonString(atrMap));
        this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)"ent_prodmanage", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.ADDNEW, (long)0L, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "newSku")));
    }

    private void skuMapInit(BeforeDoOperationEventArgs args) {
        Object specList;
        Object allSaleAtrValList = new ArrayList(1024);
        ArrayList<Object> saleAtrValList = new ArrayList<Object>(1024);
        DynamicObjectCollection saleAtrEntry = this.getModel().getEntryEntity("saleattributeentry");
        HashMap atrMap = new HashMap(saleAtrEntry.size());
        for (DynamicObject dynamicObject : saleAtrEntry) {
            DynamicObjectCollection saleAtrValueEntry = dynamicObject.getDynamicObjectCollection("saleatrvalueentry");
            ArrayList list = new ArrayList(saleAtrValueEntry.size());
            list.addAll(saleAtrValueEntry);
            saleAtrValList.add(list);
            String atrId = dynamicObject.getString("saleprodattribute.id");
            List atrValIdList = list.stream().map(m -> m.getDynamicObject("saleprodattributevalue").getPkValue()).collect(Collectors.toList());
            atrMap.put(atrId, atrValIdList);
        }
        for (List list : saleAtrValList) {
            int size = allSaleAtrValList.size();
            if (size == 0) {
                for (DynamicObject specDy : list) {
                    ArrayList specDyList = new ArrayList(list.size());
                    specDyList.add(specDy);
                    allSaleAtrValList.add(specDyList);
                }
                continue;
            }
            ArrayList newAllSaleAtrValList = new ArrayList(1024);
            for (int i = 0; i < size; ++i) {
                for (DynamicObject specDy : list) {
                    specList = new ArrayList<DynamicObject>((Collection)allSaleAtrValList.get(i));
                    specList.add(specDy);
                    newAllSaleAtrValList.add(specList);
                }
            }
            allSaleAtrValList = newAllSaleAtrValList;
        }
        int size = allSaleAtrValList.size();
        if (size == 0) {
            this.getModel().deleteEntryData("spuskumapentry");
            return;
        }
        ArrayList<List> arrayList = new ArrayList<List>();
        DynamicObjectCollection spuSkuMapCol = this.getModel().getEntryEntity("spuskumapentry");
        for (DynamicObject entry : spuSkuMapCol) {
            DynamicObjectCollection spuAtrDetailEntry = entry.getDynamicObjectCollection("spuatrdetailentry");
            List collect = spuAtrDetailEntry.stream().map(m -> m.getDynamicObject("saleprodattributevalueid").getPkValue()).collect(Collectors.toList());
            specList = allSaleAtrValList.iterator();
            while (specList.hasNext()) {
                List collect2;
                List list = (List)specList.next();
                if (CollectionUtils.isEmpty((Collection)list) || !(collect2 = list.stream().map(m -> m.getDynamicObject("saleprodattributevalue").getPkValue()).collect(Collectors.toList())).toString().equals(collect.toString())) continue;
                arrayList.add(list);
            }
        }
        allSaleAtrValList.removeAll(arrayList);
        size = allSaleAtrValList.size();
        if (size > 0) {
            int[] spuSkuMapRowIds = this.getModel().batchCreateNewEntryRow("spuskumapentry", size);
            StringBuilder mapName = new StringBuilder();
            StringBuilder mapids = new StringBuilder();
            for (int i = 0; i < spuSkuMapRowIds.length; ++i) {
                List skuMapList = (List)allSaleAtrValList.get(i);
                mapName.setLength(0);
                mapids.setLength(0);
                mapids.append("[");
                this.getModel().setEntryCurrentRowIndex("spuskumapentry", spuSkuMapRowIds[i]);
                this.getModel().deleteEntryData("spuatrdetailentry");
                int[] spuAtrdtlRowIds = this.getModel().batchCreateNewEntryRow("spuatrdetailentry", skuMapList.size());
                for (int j = 0; j < spuAtrdtlRowIds.length; ++j) {
                    Object saleAtrValueId = null;
                    String attributId = null;
                    DynamicObject detailValueRow = (DynamicObject)skuMapList.get(j);
                    if (detailValueRow != null && detailValueRow.getDynamicObject("saleprodattributevalue") != null) {
                        saleAtrValueId = detailValueRow.getDynamicObject("saleprodattributevalue").getPkValue();
                        mapName.append(detailValueRow.getDynamicObject("saleprodattributevalue").getString("name")).append('+');
                        for (Map.Entry entry : atrMap.entrySet()) {
                            String atrId = (String)entry.getKey();
                            List atrValList = (List)entry.getValue();
                            if (!atrValList.contains(detailValueRow.getDynamicObject("saleprodattributevalue").getPkValue())) continue;
                            attributId = atrId;
                        }
                        this.getModel().setValue("saleprodattributeid", attributId, spuAtrdtlRowIds[j]);
                        mapids.append("{\"key\":").append((Object)attributId).append(",").append("\"value\":").append(saleAtrValueId).append("}").append(",");
                    }
                    this.getModel().setValue("saleprodattributevalueid", saleAtrValueId, spuAtrdtlRowIds[j]);
                }
                mapName.setLength(mapName.lastIndexOf("+"));
                mapids.setLength(mapids.lastIndexOf(","));
                mapids.append("]");
                this.getModel().setValue("atrvaluename", (Object)mapName.toString(), spuSkuMapRowIds[i]);
                this.getModel().setValue("spumapids", (Object)mapids.toString(), spuSkuMapRowIds[i]);
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4ee5\u751f\u6210\u7684\u5c5e\u6027\u5185\u5bb9\u7ec4\u5408\u3002", (String)"EntProdSpuEdit_26", (String)"scm-ent-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private boolean dataCheck() {
        OperationResult save;
        DynamicObjectCollection attributeCol = this.getModel().getEntryEntity("saleattributeentry");
        if (attributeCol == null || attributeCol.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u52a0\u5c5e\u6027", (String)"EntProdSpuEdit_5", (String)"scm-ent-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject attributeDy = null;
        DynamicObject attributeValueDy = null;
        for (int i = 0; i < attributeCol.size(); ++i) {
            attributeDy = ((DynamicObject)attributeCol.get(i)).getDynamicObject("saleprodattribute");
            if (attributeDy == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u5c5e\u6027\u4e3a\u7a7a\u3002", (String)"EntProdSpuEdit_6", (String)"scm-ent-formplugin", (Object[])new Object[]{i + 1}));
                return false;
            }
            DynamicObjectCollection subRowObjs = ((DynamicObject)attributeCol.get(i)).getDynamicObjectCollection("saleatrvalueentry");
            if (subRowObjs == null || subRowObjs.size() == 0) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u8bf7\u5148\u6dfb\u5c5e\u6027\u5185\u5bb9\u3002", (String)"EntProdSpuEdit_7", (String)"scm-ent-formplugin", (Object[])new Object[0]), attributeDy.getLocaleString("prodattributename.name")));
                return false;
            }
            for (int j = 0; j < subRowObjs.size(); ++j) {
                attributeValueDy = ((DynamicObject)subRowObjs.get(j)).getDynamicObject("saleprodattributevalue");
                if (attributeValueDy != null) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u5c5e\u6027\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"EntProdSpuEdit_8", (String)"scm-ent-formplugin", (Object[])new Object[]{j + 1}));
                return false;
            }
        }
        return 0L != this.getModel().getDataEntity().getLong("id") || (save = this.getView().invokeOperation(SAVE)).isSuccess();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldName = e.getProperty().getName();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection spuskumapentry = dataEntity.getDynamicObjectCollection("spuskumapentry");
        Set changeFields = Stream.of("prodattribute", "prodattributevalue", "saleprodattribute", "saleprodattributevalue").collect(Collectors.toSet());
        if (!spuskumapentry.isEmpty() && changeFields.contains(fieldName)) {
            ChangeData[] changeSet = e.getChangeSet();
            this.getPageCache().put("fieldName", fieldName);
            this.getPageCache().putBigObject("changeData", SerializationUtils.toJsonString((Object)changeSet));
            String msg = "";
            if ("prodattribute".equals(fieldName)) {
                msg = ResManager.loadKDString((String)"\u4fee\u6539\u57fa\u672c\u9500\u552e\u7684\u5c5e\u6027\u7f16\u7801\u5c06\u6e05\u7a7a\u5173\u8054SKU\u5206\u5f55\uff0c\u9700\u91cd\u65b0\u5173\u8054SKU\u5e76\u786e\u8ba4\uff0c\u786e\u5b9a\u5220\u9664\u5417\uff1f", (String)"EntProdSpuEdit_17", (String)"scm-ent-formplugin", (Object[])new Object[0]);
            } else if ("prodattributevalue".equals(fieldName)) {
                msg = ResManager.loadKDString((String)"\u4fee\u6539\u57fa\u672c\u5c5e\u6027\u7684\u5c5e\u6027\u5185\u5bb9\u7f16\u7801\u5c06\u6e05\u7a7a\u5173\u8054SKU\u5206\u5f55\uff0c\u9700\u91cd\u65b0\u5173\u8054SKU\u5e76\u786e\u8ba4\uff0c\u786e\u5b9a\u5220\u9664\u5417\uff1f", (String)"EntProdSpuEdit_18", (String)"scm-ent-formplugin", (Object[])new Object[0]);
            } else if ("saleprodattribute".equals(fieldName)) {
                msg = ResManager.loadKDString((String)"\u4fee\u6539\u9500\u552e\u5c5e\u6027\u5185\u5bb9\u7684\u5c5e\u6027\u5185\u5bb9\u7f16\u7801\u5c06\u6e05\u7a7a\u5173\u8054SKU\u5206\u5f55\uff0c\u9700\u91cd\u65b0\u5173\u8054SKU\u5e76\u786e\u8ba4\uff0c\u786e\u5b9a\u5220\u9664\u5417\uff1f", (String)"EntProdSpuEdit_19", (String)"scm-ent-formplugin", (Object[])new Object[0]);
            } else if ("saleprodattributevalue".equals(fieldName)) {
                msg = this.saleProdAttributeValueChange(changeSet);
            }
            if (StringUtils.isNotBlank((CharSequence)msg)) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(fieldName, (IFormPlugin)this);
                this.getView().showConfirm(msg, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            }
        } else if (spuskumapentry.isEmpty() && "saleprodattribute".equals(fieldName)) {
            this.getModel().deleteEntryData("saleatrvalueentry");
        } else if (spuskumapentry.isEmpty() && "prodattribute".equals(fieldName)) {
            for (ChangeData changeData : e.getChangeSet()) {
                this.getModel().setValue("prodattributevalue", null, changeData.getRowIndex());
            }
        }
    }

    private String saleProdAttributeValueChange(ChangeData[] changeSet) {
        String id;
        DynamicObject oldValue = (DynamicObject)changeSet[0].getOldValue();
        String string = id = oldValue == null ? "0" : oldValue.getString("id");
        if (this.checkIsExistSubmitVal(oldValue)) {
            this.getPageCache().put(SALE_PROD_ATTRIBUTE_VALUE_CHANGE_OLD_VALUE, id);
            this.getPageCache().put(SALE_PROD_ATTRIBUTE_VALUE_CHANGE_INDEX, String.valueOf(changeSet[0].getRowIndex()));
            return "";
        }
        if (this.checkIsExistAtrVal(oldValue)) {
            this.getPageCache().put(SALE_PROD_ATTRIBUTE_VALUE_CHANGE_OLD_VALUE, id);
            this.getPageCache().put(SALE_PROD_ATTRIBUTE_VALUE_CHANGE_INDEX, String.valueOf(changeSet[0].getRowIndex()));
            return ResManager.loadKDString((String)"\u4fee\u6539\u9500\u552e\u5c5e\u6027\u5185\u5bb9\u7684\u5c5e\u6027\u5185\u5bb9\u7f16\u7801\u5c06\u6e05\u7a7a\u5173\u8054SKU\u5206\u5f55\uff0c\u9700\u91cd\u65b0\u5173\u8054SKU\u5e76\u786e\u8ba4\uff0c\u786e\u5b9a\u5220\u9664\u5417\uff1f", (String)"EntProdSpuEdit_19", (String)"scm-ent-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private boolean checkIsExistSubmitVal(DynamicObject oldValue) {
        ArrayList<String> atrVal = new ArrayList<String>(8);
        if (oldValue != null) {
            Long atrValueId = oldValue.getLong("id");
            DynamicObjectCollection mapEntry = this.getModel().getEntryEntity("spuskumapentry");
            for (DynamicObject dynamicObject : mapEntry) {
                String mapJson = dynamicObject.getString("spumapids");
                String confirmstatus = dynamicObject.getString("confirmstatus");
                if (!mapJson.contains(String.valueOf(atrValueId)) || !Arrays.asList("A", "B").contains(confirmstatus)) continue;
                atrVal.add(String.valueOf(oldValue.get("name")));
                break;
            }
        }
        if (!CollectionUtils.isEmpty(atrVal)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"{0}\u5c5e\u6027\u5185\u5bb9\u5df2\u4f7f\u7528\u4e14\u5f85\u786e\u8ba4/\u5df2\u786e\u8ba4\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"EntProdSpuEdit_21", (String)"scm-ent-formplugin", (Object[])new Object[]{atrVal}), MessageBoxOptions.OK, new ConfirmCallBackListener(SALE_PROD_ATTRIBUTE_VALUE_CHANGE_CALLBACK, (IFormPlugin)this));
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private boolean checkIsExistAtrVal(DynamicObject oldValue) {
        boolean isExist = false;
        if (oldValue != null) {
            DynamicObjectCollection mapEntry = this.getModel().getEntryEntity("spuskumapentry");
            for (DynamicObject dynamicObject : mapEntry) {
                String mapJson = dynamicObject.getString("spumapids");
                if (!mapJson.contains(oldValue.getString("id"))) continue;
                isExist = true;
                break;
            }
        }
        return isExist;
    }

    public void entryRowClick(RowClickEvent evt) {
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)"spuskumapentry", (CharSequence)source.getKey())) {
            int row = evt.getRow();
            this.getPageCache().put("row", String.valueOf(row));
        }
    }
}

