/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.formplugin.edit;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.malcore.constant.ProdTypeConstant;

public class EntProductCombineEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String FIELD_COMBINE = "combines";
    private static final String FIELD_ORG = "org";
    private static final String FIELD_PRICE_TYPE = "pricetype";
    private static final String FIELD_SUPPLIER = "supplier";
    private static final String FIELD_DISCOUNT_TYPE = "discounttype";
    private static final String FIELD_DISCOUNT = "discount";
    private static final String FIELD_ENTRY = "entryentity";
    private static final String FIELD_ENTRY_PRODUCT = "product";
    private static final String FIELD_ENTRY_FIX_PRICE = "fixprice";
    private static final String FIELD_ENTRY_DISCOUNT = "entrydiscount";
    private static final String FIELD_ENTRY_UNIT = "unit";
    private static final String FIELD_ENTRY_CURRENCY = "currency";
    private static final String FIELD_PRODUCT_SUPPLIER = "supplier";
    private static final String FIELD_PRODUCT_TYPE = "prodtype";
    private static final String FIELD_PRODUCTENTRY_AUDIT_ORG = "protocolentry.prodpool.auditorg";
    private static final String FIELD_PRODUCT_UNIT = "unit";
    private static final String FIELD_PRODUCT_CURR = "curr";
    private static final String FIELD_MAL_SUPPLIER_ID = "ID";
    private static final String ENUM_PRICE_TYPE_FIX_PRICE = "A";
    private static final String ENUM_DISCOUNT_TYPE_ALL_DISCOUNT = "A";
    private static final String ENUM_DISCOUNT_TYPE_PART_DISCOUNT = "B";
    private static final String ENUM_DISCOUNT_TYPE_NONE_DISCOUNT = "C";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit combineComponent = (BasedataEdit)this.getControl(FIELD_COMBINE);
        combineComponent.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit supplierComponent = (BasedataEdit)this.getControl("supplier");
        supplierComponent.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit productComponent = (BasedataEdit)this.getControl(FIELD_ENTRY_PRODUCT);
        productComponent.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        List<Long> supIdList = this.getSupplierByUserOfBizPartner();
        if (supIdList != null && supIdList.size() >= 1) {
            model.setValue("supplier", (Object)supIdList.get(0));
            DynamicObject supplier = (DynamicObject)model.getValue("supplier");
            this.setOrgBySupplier(supplier);
        }
    }

    private void setOrgBySupplier(DynamicObject supplier) {
        IDataModel model = this.getModel();
        DynamicObject orgDyn = QueryServiceHelper.queryOne((String)"bos_org", (String)"id,fispurchase", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)supplier.getLong("createorg_id"))});
        if (orgDyn.getBoolean("fispurchase")) {
            model.setValue(FIELD_ORG, (Object)supplier.getLong("createorg_id"));
        }
    }

    private List<Long> getSupplierByUserOfBizPartner() {
        return BizPartnerUtil.getSupplierByUserOfBizPartner();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.doDiscountTypeChanged(this.getModel().getValue(FIELD_DISCOUNT_TYPE));
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        switch (key) {
            case "combines": {
                if (!this.orgInputCheck()) {
                    evt.setCancel(true);
                    return;
                }
                this.setProductFilter(showParameter);
                showParameter.setCustomParam("ismergerows", (Object)true);
                break;
            }
            case "supplier": {
                this.setSupplierFilter(showParameter);
                break;
            }
            case "product": {
                if (!this.orgInputCheck()) {
                    evt.setCancel(true);
                    return;
                }
                this.setEntryProductFilter(showParameter);
                showParameter.setCustomParam("ismergerows", (Object)true);
            }
        }
    }

    private void setEntryProductFilter(ListShowParameter showParameter) {
        List filterList = showParameter.getListFilterParameter().getQFilters();
        DynamicObject orgDO = (DynamicObject)this.getModel().getValue(FIELD_ORG);
        QFilter orgQFilter = new QFilter(FIELD_PRODUCTENTRY_AUDIT_ORG, "=", orgDO.getPkValue());
        filterList.add(orgQFilter);
        QFilter typeQFilter = new QFilter(FIELD_PRODUCT_TYPE, "in", (Object)new Object[]{ProdTypeConstant.PRODUCT_TYPE_NORMAL_ID, ProdTypeConstant.PRODUCT_TYPE_PRESENT_ID});
        filterList.add(typeQFilter);
    }

    private void setSupplierFilter(ListShowParameter showParameter) {
        List filterList = showParameter.getListFilterParameter().getQFilters();
        List supIdList = BizPartnerUtil.getSupplierByUserOfBizPartner();
        QFilter supQFilter = new QFilter(FIELD_MAL_SUPPLIER_ID, "in", (Object)supIdList);
        filterList.add(supQFilter);
    }

    private void setProductFilter(ListShowParameter showParameter) {
        List filterList = showParameter.getListFilterParameter().getQFilters();
        List supIdList = BizPartnerUtil.getSupplierByUserOfBizPartner();
        DynamicObject orgDO = (DynamicObject)this.getModel().getValue(FIELD_ORG);
        QFilter orgQFilter = new QFilter(FIELD_PRODUCTENTRY_AUDIT_ORG, "=", orgDO.getPkValue());
        filterList.add(orgQFilter);
        QFilter supQFilter = new QFilter("supplier", "in", (Object)supIdList);
        filterList.add(supQFilter);
        QFilter typeQFilter = new QFilter(FIELD_PRODUCT_TYPE, "=", (Object)ProdTypeConstant.PRODUCT_TYPE_COMBINE_ID);
        filterList.add(typeQFilter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldName = e.getProperty().getName();
        Object newVal = e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (fieldName) {
            case "discounttype": {
                this.doDiscountTypeChanged(newVal);
                break;
            }
            case "product": {
                this.doEntryProductChanged(newVal, rowIndex);
                break;
            }
            case "supplier": {
                this.doSupplierChange(newVal);
            }
        }
    }

    private void doEntryProductChanged(Object newVal, int rowIndex) {
        IDataModel dataModel = this.getModel();
        if (null == newVal) {
            dataModel.setValue("unit", null, rowIndex);
            dataModel.setValue(FIELD_ENTRY_CURRENCY, null, rowIndex);
        } else {
            DynamicObject product = (DynamicObject)newVal;
            DynamicObject unit = product.getDynamicObject("unit");
            Object pkObj = null == unit ? null : unit.getPkValue();
            dataModel.setValue("unit", pkObj, rowIndex);
            DynamicObject curr = product.getDynamicObject(FIELD_PRODUCT_CURR);
            Object currPkObj = null == unit ? null : curr.getPkValue();
            dataModel.setValue(FIELD_ENTRY_CURRENCY, currPkObj, rowIndex);
        }
    }

    private void doSupplierChange(Object newVal) {
        if (newVal == null) {
            return;
        }
        DynamicObject supplier = (DynamicObject)newVal;
        this.setOrgBySupplier(supplier);
    }

    private void doDiscountTypeChanged(Object newVal) {
        this.discountViewControl(newVal);
        this.discountValueControl(newVal);
    }

    private void discountViewControl(Object newVal) {
        if ("A".equals(newVal)) {
            DecimalEdit discountComponent = (DecimalEdit)this.getControl(FIELD_DISCOUNT);
            discountComponent.setMustInput(true);
            this.getView().setVisible(Boolean.TRUE, new String[]{FIELD_DISCOUNT, FIELD_ENTRY_DISCOUNT});
            this.getView().setEnable(Boolean.TRUE, new String[]{FIELD_DISCOUNT});
            this.getView().setEnable(Boolean.FALSE, -1, new String[]{FIELD_ENTRY_DISCOUNT});
        } else if (ENUM_DISCOUNT_TYPE_PART_DISCOUNT.equals(newVal)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FIELD_DISCOUNT});
            this.getView().setVisible(Boolean.TRUE, new String[]{FIELD_ENTRY_DISCOUNT});
            this.getView().setEnable(Boolean.TRUE, -1, new String[]{FIELD_ENTRY_DISCOUNT});
        } else if (ENUM_DISCOUNT_TYPE_NONE_DISCOUNT.equals(newVal)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FIELD_DISCOUNT, FIELD_ENTRY_DISCOUNT});
        }
        this.getView().updateView(FIELD_DISCOUNT);
        this.getView().updateView(FIELD_ENTRY);
    }

    private void discountValueControl(Object newVal) {
        boolean isNoneDiscount = ENUM_DISCOUNT_TYPE_NONE_DISCOUNT.equals(newVal);
        if (isNoneDiscount) {
            DynamicObjectCollection entryColl = this.getModel().getEntryEntity(FIELD_ENTRY);
            for (DynamicObject entryDO : entryColl) {
                entryDO.set(FIELD_ENTRY_DISCOUNT, (Object)BigDecimal.ONE);
            }
        }
    }

    private boolean orgInputCheck() {
        IDataModel dataModel = this.getModel();
        if (null == dataModel.getValue(FIELD_ORG)) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u5ba1\u6279\u5355\u4f4d\u3002", (String)"EntProductCombineEdit_0", (String)"scm-ent-formplugin", (Object[])new Object[0]);
            this.getView().showMessage(msg);
            return false;
        }
        return true;
    }
}

