/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.formplugin.list;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.list.IListView;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.malcore.domain.LadderPriceInfo;

public class EntNewPriceManageList
extends AbstractListPlugin {
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List supIdList = BizPartnerUtil.getSupplierByUserOfBizPartner();
        QFilter supqfilter = new QFilter("goods.supplier", "in", (Object)supIdList);
        e.getQFilters().add(supqfilter);
    }

    public void packageData(PackageDataEvent e) {
        Object srcentitybilltype;
        if (e.getSource() instanceof ListOperationColumnDesc) {
            List operationColItems = (List)e.getFormatValue();
            Object pricetype = e.getRowData().get("pricetype");
            for (OperationColItem operationColItem : operationColItems) {
                if ("viewladdderprice".equalsIgnoreCase(operationColItem.getOperationKey()) && "B".equals(pricetype)) {
                    operationColItem.setVisible(true);
                    continue;
                }
                operationColItem.setVisible(false);
            }
        }
        if ("pmm_prodaudit".equals(srcentitybilltype = e.getRowData().get("srcentitybilltype"))) {
            e.getNoLinkKey().add("srcbillno");
        }
        super.packageData(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if (key.equals("viewladdderprice")) {
            this.showLadDerPriceForm(args);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String param = ParamUtil.getSysCtrlParam((String)"UUPIH+47DAK", (String)"latestladderprice");
        if (Boolean.parseBoolean(param)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"ladderprice"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"ladderprice"});
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        QFilter qFilter;
        DynamicObject newPrice;
        ListSelectedRowCollection selectCol = ((IListView)this.getView()).getSelectedRows();
        Object primaryKeyValue = selectCol.get(0).getPrimaryKeyValue();
        if (null != this.getPageCache().get("selectid")) {
            primaryKeyValue = this.getPageCache().get("selectid");
            this.getPageCache().remove("selectid");
        }
        if (null != (newPrice = QueryServiceHelper.queryOne((String)"ent_newpricelog", (String)"goodspool.protocol.id,goodspool.protocol.billno,srcentitybilltype,srcbillid,srcbillno", (QFilter[])(qFilter = new QFilter("id", "=", (Object)Long.parseLong(String.valueOf(primaryKeyValue)))).toArray()))) {
            if (StringUtils.equals((CharSequence)"goodspool_protocol_billno", (CharSequence)args.getHyperLinkClickEvent().getFieldName())) {
                this.showDetail("ent_protocol", newPrice.getString("goodspool.protocol.id"));
                args.setCancel(true);
            }
            if (StringUtils.equals((CharSequence)"srcbillno", (CharSequence)args.getHyperLinkClickEvent().getFieldName())) {
                String billtype = "";
                billtype = "pmm_prodaudit".equals(newPrice.getString("srcentitybilltype")) ? "ent_prodrequest" : ("pmm_priceaudit".equals(newPrice.getString("srcentitybilltype")) ? "ent_pricerequest" : newPrice.getString("srcentitybilltype"));
                this.showDetail(billtype, newPrice.getString("srcbillid"));
                args.setCancel(true);
            }
        } else {
            args.setCancel(true);
        }
    }

    private void showDetail(String billFormId, Object primaryKeyValue) {
        BillShowParameter param = new BillShowParameter();
        param.setFormId(billFormId);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setStatus(OperationStatus.VIEW);
        param.setPkId(primaryKeyValue);
        this.getView().showForm((FormShowParameter)param);
    }

    public void listRowClick(ListRowClickEvent evt) {
        if (null != evt.getCurrentListSelectedRow()) {
            Object primaryKeyValue = evt.getCurrentListSelectedRow().getPrimaryKeyValue();
            this.getPageCache().put("selectid", String.valueOf(primaryKeyValue));
        }
    }

    private void showLadDerPriceForm(BeforeDoOperationEventArgs args) {
        QFilter qFilter;
        DynamicObject newPrice;
        ListSelectedRowCollection selectCol = ((IListView)this.getView()).getSelectedRows();
        Object primaryKeyValue = selectCol.get(0).getPrimaryKeyValue();
        if (null != this.getPageCache().get("selectid")) {
            primaryKeyValue = this.getPageCache().get("selectid");
            this.getPageCache().remove("selectid");
        }
        if (null != (newPrice = QueryServiceHelper.queryOne((String)"ent_newpricelog", (String)"srcentitybilltype,srcbillid", (QFilter[])(qFilter = new QFilter("id", "=", (Object)Long.parseLong(String.valueOf(primaryKeyValue)))).toArray()))) {
            qFilter = new QFilter("id", "=", (Object)Long.parseLong(newPrice.getString("srcbillid")));
            DynamicObjectCollection pools = QueryServiceHelper.query((String)newPrice.getString("srcentitybilltype"), (String)"entryentity.subentryentity.qtyfrom qtyfrom,entryentity.subentryentity.qtyto qtyto,entryentity.subentryentity.ladprice ladprice,curr", (QFilter[])qFilter.toArray());
            if (pools.size() == 1) {
                String msg = ResManager.loadKDString((String)"\u5546\u54c1\u672a\u5f55\u9636\u68af\u4ef7\u3002", (String)"EntNewPriceManageList_0", (String)"scm-ent-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                args.setCancel(true);
                return;
            }
            List<Object> ladderPriceInfos = new ArrayList(16);
            for (DynamicObject info : pools) {
                BigDecimal qtyto = info.getBigDecimal("qtyto");
                BigDecimal qtyfrom = info.getBigDecimal("qtyfrom");
                BigDecimal ladprice = info.getBigDecimal("ladprice");
                ladderPriceInfos.add(new LadderPriceInfo(qtyfrom, qtyto, ladprice, Long.valueOf(info.getLong("curr"))));
            }
            ladderPriceInfos = ladderPriceInfos.stream().sorted(Comparator.comparing(LadderPriceInfo::getQtyfrom)).collect(Collectors.toList());
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("pbd_ladderprice");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            HashMap<String, String> detailParamMap = new HashMap<String, String>();
            showParameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "setladderprice"));
            detailParamMap.put("status", "1");
            detailParamMap.put("ladderPrices", SerializationUtils.toJsonString(ladderPriceInfos));
            showParameter.setCustomParams(detailParamMap);
            this.getView().showForm(showParameter);
        } else {
            args.setCancel(true);
        }
    }
}

