/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.formplugin.list;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.MalFeeHandleHelper;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.common.util.StringConversionUtil;
import kd.scm.ent.business.model.prod.Sku;
import kd.scm.ent.business.service.impl.EntProdManageAuditServiceImpl;
import kd.scm.ent.common.plugin.AbstractEntBuildTreeListPlugIn;
import kd.scm.ent.common.util.EntProdManageUtil;
import kd.scm.malcore.domain.LadderPriceInfo;

public class EntProdManageList
extends AbstractEntBuildTreeListPlugIn
implements ListRowClickListener {
    private static Log log = LogFactory.getLog(EntProdManageList.class);
    private static final String CONFIRMDOWN = "confirmdowm";
    private static final String CONFIRMUP = "confirmup";
    private static final String CONFIRM = "confirm";
    private static final String DOWNLOADCHECK = "downloadCheck";
    private static final String CONFIRMINSTOCK = "confirmInstock";
    private static final String KEY_TREEBUTTONPANEL = "flexpanel_treebtn";
    private static final String MAL_PRODUCTDETAIL = "mal_productdetail";
    private static final String FINALROOTID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private static final String ALLOTCALLBACK = "allotcallback";
    private static final String UNALLOTCALLBACK = "unallotcallback";
    private static final String INFO_CHANGE_CONFIRM = "infoChangeConfirm";

    public void packageData(PackageDataEvent e) {
        if (e.getSource() instanceof ListOperationColumnDesc) {
            DataEntityPropertyCollection dataModelProperties = e.getRowData().getDataEntityType().getProperties();
            boolean isContain = false;
            for (IDataEntityProperty iDataEntityProperty : dataModelProperties) {
                if (!iDataEntityProperty.getName().contains("protocolentry")) continue;
                isContain = true;
            }
            if (!isContain) {
                return;
            }
            List operationColItems = (List)e.getFormatValue();
            String pricetype = "A";
            if (null != e.getRowData().get("protocolentry.prodpool")) {
                pricetype = ((DynamicObject)e.getRowData().get("protocolentry.prodpool")).getString("pricetype");
            }
            for (OperationColItem operationColItem : operationColItems) {
                if ("viewladdderprice".equalsIgnoreCase(operationColItem.getOperationKey()) && "B".equals(pricetype)) {
                    operationColItem.setVisible(true);
                    continue;
                }
                operationColItem.setVisible(false);
            }
        }
        super.packageData(e);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        LicenseCheckResult checkResult = LicenseServiceHelper.checkPerformGroup((String)"PRO_PMAL");
        if (!checkResult.getHasLicense().booleanValue()) {
            e.setCancel(true);
            e.setCancelMessage(checkResult.getMsg());
            e.setCancelFormShowParameter(checkResult.getCancelFormShowParameter());
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        if (null != evt.getCurrentListSelectedRow()) {
            Object entryPrimaryKeyValue = evt.getCurrentListSelectedRow().getEntryPrimaryKeyValue();
            this.getPageCache().put("entryid", String.valueOf(entryPrimaryKeyValue));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String param = ParamUtil.getSysCtrlParam((String)"UUPIH+47DAK", (String)"latestladderprice");
        if (Boolean.parseBoolean(param)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"ladderprice"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"ladderprice"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        LicenseCheckResult checkResult = LicenseServiceHelper.checkPerformGroup((String)"PRO_PMAL");
        if (!checkResult.getHasLicense().booleanValue()) {
            this.getView().showMessage(checkResult.getMsg());
            return;
        }
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map param = parameter.getCustomParams();
        Object pmm = param.get("new");
        if (null != pmm) {
            this.getPageCache().put("new", String.valueOf(pmm));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String clickKey;
        super.beforeItemClick(evt);
        switch (clickKey = evt.getItemKey()) {
            case "tblinfochange": {
                this.infoChangeClick(evt);
            }
        }
    }

    private void infoChangeClick(BeforeItemClickEvent evt) {
        IListView listview = (IListView)this.getView();
        Object[] primaryKeyValues = listview.getSelectedRows().getPrimaryKeyValues();
        if (primaryKeyValues.length == 0) {
            return;
        }
        if (primaryKeyValues.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u540c\u65f6\u5bf9\u4e00\u4e2a\u5546\u54c1\u8fdb\u884c\u4fe1\u606f\u53d8\u66f4\u3002", (String)"EntProdManageList_29", (String)"scm-ent-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        LicenseCheckResult checkResult = LicenseServiceHelper.checkPerformGroup((String)"PRO_PMAL");
        if (!checkResult.getHasLicense().booleanValue()) {
            args.setCancel(true);
            args.setCancelMessage(checkResult.getMsg());
            return;
        }
        if (operateKey.equalsIgnoreCase("new")) {
            TreeView treeView = (TreeView)this.getView().getControl("treeview");
            String nodeId = treeView.getTreeState().getFocusNodeId();
            if (null == nodeId) {
                this.getPageCache().remove("nodeId");
                return;
            }
            if (nodeId.equals(FINALROOTID)) {
                this.getPageCache().remove("nodeId");
                return;
            }
            QFilter filters = new QFilter("level", "=", (Object)Integer.parseInt("3")).and(new QFilter("id", "=", (Object)Long.parseLong(nodeId)));
            DynamicObject[] goodses = BusinessDataServiceHelper.load((String)"mdr_goodsclass", (String)"id", (QFilter[])new QFilter[]{filters});
            if (goodses.length == 0) {
                this.getPageCache().remove("nodeId");
                return;
            }
            this.getPageCache().put("nodeId", nodeId);
            return;
        }
        if (!operateKey.equalsIgnoreCase("infochange")) {
            if (!operateKey.equalsIgnoreCase("viewladdderprice")) return;
            this.showLadderPrice(args);
            return;
        }
        IListView listview = (IListView)this.getView();
        Object[] primaryKeyValues = listview.getSelectedRows().getPrimaryKeyValues();
        if (primaryKeyValues.length == 0) {
            args.setCancel(true);
            return;
        }
        if (primaryKeyValues.length <= 1) return;
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u540c\u65f6\u5bf9\u4e00\u4e2a\u5546\u54c1\u8fdb\u884c\u4fe1\u606f\u53d8\u66f4\u3002", (String)"EntProdManageList_29", (String)"scm-ent-formplugin", (Object[])new Object[0]));
        args.setCancel(true);
    }

    private void checkAddtopackege(AfterDoOperationEventArgs e) {
        IListView listview = (IListView)this.getView();
        Object[] selectCol = listview.getSelectedRows().getPrimaryKeyValues();
        if (selectCol.length == 0) {
            return;
        }
        if (null != selectCol) {
            ArrayList<Long> proIds = new ArrayList<Long>(selectCol.length);
            for (Object s : selectCol) {
                proIds.add(Long.parseLong(s.toString()));
            }
            QFilter idFilter = new QFilter("id", "in", proIds);
            QFilter[] filters = new QFilter[]{idFilter};
            String selectFields = "id,number,name,createorg,status,supplier,supplier.name";
            DynamicObjectCollection col = QueryServiceHelper.query((String)"ent_prodmanage", (String)selectFields, (QFilter[])filters);
            StringBuilder msg = new StringBuilder(64);
            HashSet<Long> suppliers = new HashSet<Long>(selectCol.length);
            HashSet<String> prodList = new HashSet<String>(col.size());
            ArrayList<Long> errorids = new ArrayList<Long>(selectCol.length);
            String suppliername = null;
            for (DynamicObject prod : col) {
                Long supplier = prod.getLong("supplier");
                if (supplier != null) {
                    suppliers.add(supplier);
                }
                suppliername = prod.getString("supplier.name");
                Long proid = prod.getLong("id");
                if (!"C".equals(prod.getString("status"))) {
                    if (errorids.contains(proid)) continue;
                    errorids.add(proid);
                    msg.append(ResManager.loadKDString((String)"\u5546\u54c1{0}\uff1a\u53ea\u6709\u5df2\u5ba1\u6838\u7684\u5546\u54c1\u624d\u5141\u8bb8\u52a0\u5165\u91c7\u8d2d\u5957\u9910\u3002\r\n", (String)"EntProdManageList_36", (String)"scm-ent-formplugin", (Object[])new Object[]{prod.getString("number") + prod.getString("name")}));
                    continue;
                }
                prodList.add(String.valueOf(prod.getLong("id")));
            }
            String appId = AppMetadataCache.getAppInfo((String)"ent").getId();
            HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((long)UserServiceHelper.getCurrentUserId(), (String)"02", (boolean)true, (String)appId, (String)"ent_packageselection", (String)"47156aff000000ac");
            List orgids = hasPermOrgResult.getHasPermOrgs();
            if (orgids.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u201c\u91c7\u8d2d\u5957\u9910\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"EntProdManageList_39", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                return;
            }
            if (suppliers.size() > 1 || suppliers.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u540c\u4e00\u6240\u5c5e\u5546\u5bb6\u7684\u5546\u54c1\u52a0\u5165\u91c7\u8d2d\u5957\u9910\u3002", (String)"EntProdManageList_38", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                return;
            }
            if (prodList.size() == 0 && msg.length() > 0) {
                this.getView().showTipNotification(msg.toString());
                return;
            }
            this.getPageCache().put("pakage_suplier", ((Long)suppliers.iterator().next()).toString());
            this.getPageCache().put("pakage_suppliername", suppliername);
            this.getPageCache().put("pakage_prodlist", String.join((CharSequence)",", prodList));
            if (msg.length() > 0) {
                String error = String.format(ResManager.loadKDString((String)"\u5df2\u9009 %1$s\u6761\u6570\u636e\u52a0\u5165\u91c7\u8d2d\u5957\u9910\uff0c\u7b26\u5408\u6761\u4ef6\u7684%2$s\u6761\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"EntProdManageList_40", (String)"scm-ent-formplugin", (Object[])new Object[0]), selectCol.length, prodList.size());
                this.getView().showConfirm(error, msg.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("addtopackege"));
            } else {
                this.addPackege();
            }
        }
    }

    private void showLadderPrice(BeforeDoOperationEventArgs args) {
        QFilter qFilter;
        DynamicObjectCollection pools;
        ListSelectedRowCollection selectCol = ((IListView)this.getView()).getSelectedRows();
        Object entryPrimaryKeyValue = selectCol.get(0).getEntryPrimaryKeyValue();
        if (null != this.getPageCache().get("entryid")) {
            entryPrimaryKeyValue = this.getPageCache().get("entryid");
            this.getPageCache().remove("entryid");
        }
        if ((pools = QueryServiceHelper.query((String)"pmm_prodmanage", (String)"protocolentry.prodpool,protocolentry.prodpool.priceentry", (QFilter[])(qFilter = new QFilter("protocolentry.id", "=", (Object)Long.parseLong(String.valueOf(entryPrimaryKeyValue)))).toArray())).size() == 1) {
            String msg = ResManager.loadKDString((String)"\u5546\u54c1\u672a\u5f55\u9636\u68af\u4ef7\u3002", (String)"EntProdManageList_34", (String)"scm-ent-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            args.setCancel(true);
            return;
        }
        qFilter = new QFilter("id", "=", (Object)((DynamicObject)pools.get(0)).getLong("protocolentry.prodpool"));
        DynamicObjectCollection pmm_prodpools = QueryServiceHelper.query((String)"pmm_prodpool", (String)"goods.curr,priceentry.qtyto,priceentry.qtyfrom,priceentry.ladprice", (QFilter[])qFilter.toArray());
        List<Object> ladderPriceInfos = new ArrayList(1024);
        for (DynamicObject info : pmm_prodpools) {
            BigDecimal qtyto = info.getBigDecimal("priceentry.qtyto");
            BigDecimal qtyfrom = info.getBigDecimal("priceentry.qtyfrom");
            BigDecimal ladprice = info.getBigDecimal("priceentry.ladprice");
            ladderPriceInfos.add(new LadderPriceInfo(qtyfrom, qtyto, ladprice, Long.valueOf(info.getLong("goods.curr"))));
        }
        ladderPriceInfos = ladderPriceInfos.stream().sorted(Comparator.comparing(LadderPriceInfo::getQtyfrom)).collect(Collectors.toList());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("pbd_ladderprice");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, String> detailParamMap = new HashMap<String, String>();
        showParameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "setladderprice"));
        detailParamMap.put("status", "1");
        detailParamMap.put("ladderPrices", SerializationUtils.toJsonString(ladderPriceInfos));
        showParameter.setCustomParams(detailParamMap);
        this.getView().showForm(showParameter);
    }

    private void prodInfoChangeOp() {
        IListView listview = (IListView)this.getView();
        Object[] primaryKeyValues = listview.getSelectedRows().getPrimaryKeyValues();
        this.getPageCache().put("infoChangId", primaryKeyValues[0].toString());
        if (!this.prodInfoChangeValid(primaryKeyValues)) {
            return;
        }
        OpenFormUtil.openBasePage((IFormView)this.getView(), (String)"ent_prodinfochange", (Object)primaryKeyValues[0], (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.MainNewTabPage, null, null);
    }

    private boolean prodInfoChangeValid(Object[] primaryKeyValues) {
        QFilter qFilter = new QFilter("entryentity.goods", "=", primaryKeyValues[0]);
        boolean exists = QueryServiceHelper.exists((String)"mal_order", (QFilter[])qFilter.toArray());
        if (exists) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5546\u54c1\u5df2\u5173\u8054\u8ba2\u5355\uff0c\u5546\u54c1\u540d\u79f0\u3001\u89c4\u683c\u578b\u53f7\u3001\u7a0e\u7387\u7f16\u7801\u3001\u5546\u54c1\u8be6\u60c5\u3001\u5546\u54c1\u53c2\u6570\u3001\u5305\u88c5\u6e05\u5355\u3001\u552e\u540e\u4fdd\u969c\u5b57\u6bb5\u65e0\u6cd5\u4fee\u6539\u3002", (String)"EntProdManageList_33", (String)"scm-ent-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK, new ConfirmCallBackListener(INFO_CHANGE_CONFIRM, (IFormPlugin)this));
            return false;
        }
        return true;
    }

    public void initializeTree(EventObject e) {
        TreeNode Node2 = this.getCloudData("944841720602823680");
        ITreeModel treeModel = this.getTreeModel();
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        if (null == treeModel.getRoot() || treeModel.getRoot().getText().equals(ResManager.loadKDString((String)"\u5168\u90e8", (String)"EntProdManageList_1", (String)"scm-ent-formplugin", (Object[])new Object[0]))) {
            treeModel.setRoot(Node2);
            treeView.addNode(Node2);
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_TREEBUTTONPANEL});
    }

    public void refreshNode(RefreshNodeEvent e) {
        super.refreshNode(e);
        List filter = this.getTreeModel().getTreeFilter();
        filter.clear();
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter sourceFilter = new QFilter("standard", "=", (Object)Long.parseLong("944841720602823680"));
        filter.add(sourceFilter);
        filter.add(enableFilter);
    }

    public void initTreeToolbar(EventObject e) {
        super.initTreeToolbar(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_TREEBUTTONPANEL});
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        QFilter qfilter = new QFilter("standard", "=", (Object)Long.parseLong("944841720602823680"));
        QFilter qFilter = new QFilter("origin", "=", (Object)"1").and(new QFilter("status", "!=", (Object)"C"));
        QFilter cfmStatus = new QFilter("status", "=", (Object)"C").or(qFilter);
        qfilter.and(cfmStatus);
        qFilters.add(qfilter);
        if (null == this.getPageCache().get("new")) {
            List supIdList = BizPartnerUtil.getSupplierByUserOfBizPartner();
            QFilter supqfilter = new QFilter("supplier", "in", (Object)supIdList);
            qFilters.add(supqfilter);
        }
    }

    private Map<String, Object> operateCheck() {
        IListView listview = (IListView)this.getView();
        Object[] selectCol = listview.getSelectedRows().getPrimaryKeyValues();
        HashMap<String, Object> paramMap = new HashMap<String, Object>(1024);
        if (null != selectCol) {
            ArrayList<Long> proIds = new ArrayList<Long>();
            List<Object> suppliers = new ArrayList();
            for (Object s : selectCol) {
                proIds.add(Long.parseLong(s.toString()));
            }
            QFilter idFilter = new QFilter("id", "in", proIds);
            QFilter[] filters = new QFilter[]{idFilter};
            String selectFields = "id,number,name,category,unit,model,price,taxrate,taxprice,mallstatus,supplier,description,status";
            DynamicObject[] prodcol = BusinessDataServiceHelper.load((String)"ent_prodmanage", (String)selectFields, (QFilter[])filters);
            ArrayList<DynamicObject> supplierList = new ArrayList<DynamicObject>();
            for (DynamicObject prod : prodcol) {
                DynamicObject supplier = (DynamicObject)prod.get("supplier");
                supplierList.add(supplier);
            }
            suppliers = supplierList.stream().distinct().collect(Collectors.toList());
            if (suppliers.size() > 1) {
                listview.showTipNotification(ResManager.loadKDString((String)"\u6b64\u5904\u4e00\u6b21\u53ea\u80fd\u5bf9\u4e00\u5bb6\u4f9b\u5e94\u5546\u7684\u5185\u5bb9\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"EntProdManageList_28", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                return paramMap;
            }
            paramMap.put("supplier", ((DynamicObject)suppliers.get(0)).getLong("id"));
            return paramMap;
        }
        return paramMap;
    }

    private ArrayList<String> selectCheck(boolean ismulti) {
        IListView listview = (IListView)this.getView();
        Object[] selectCol = listview.getSelectedRows().getPrimaryKeyValues();
        if (null != selectCol) {
            if (ismulti && selectCol.length < 1) {
                listview.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4ef6\u5546\u54c1\u3002", (String)"EntProdManageList_3", (String)"scm-ent-formplugin", (Object[])new Object[0]));
            }
            if (!ismulti && selectCol.length != 1) {
                listview.showTipNotification(ResManager.loadKDString((String)"\u6709\u4e14\u53ea\u80fd\u9009\u62e9\u4e00\u4ef6\u5546\u54c1\u9884\u89c8\u3002", (String)"EntProdManageList_4", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                selectCol = null;
            }
            ArrayList<String> list = new ArrayList<String>();
            if (null != selectCol) {
                for (Object s : selectCol) {
                    list.add(s.toString());
                }
            }
            IPageCache cache = this.getPageCache();
            cache.put("select", String.join((CharSequence)",", list));
            return list;
        }
        return null;
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        String s = e.getParameter().getBillStatus().toString();
        Map customParams = e.getParameter().getCustomParams();
        Object iscopy = customParams.get("iscopy");
        if ("ADDNEW".equalsIgnoreCase(s) && iscopy == null) {
            String nodeId = this.getPageCache().get("nodeId");
            if (null != nodeId) {
                e.getParameter().setCustomParam("node", (Object)nodeId);
            } else {
                e.getParameter().setCustomParam("node", null);
            }
        }
    }

    private void showDetailPage(Long productId) {
        FormShowParameter showParameter = new FormShowParameter();
        HashMap<String, String> detailParamMap = new HashMap<String, String>();
        if (MalOrderUtil.getDefaultMalVersion()) {
            showParameter.setFormId("mal_newproductdetail");
            detailParamMap.put("productSelfId", String.valueOf(productId));
        } else {
            showParameter.setFormId(MAL_PRODUCTDETAIL);
            DynamicObject productDyn = BusinessDataServiceHelper.loadSingle((Object)productId, (String)"pmm_prodmanage");
            detailParamMap.put("productDyn", (String)productDyn);
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        detailParamMap.put("origin", "sup");
        showParameter.setCaption(ResManager.loadKDString((String)"\u5546\u54c1\u9884\u89c8", (String)"EntProdManageList_6", (String)"scm-ent-formplugin", (Object[])new Object[0]));
        showParameter.setCustomParams(detailParamMap);
        this.getView().showForm(showParameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String selectcols;
        ArrayList selectCol;
        HashMap<String, String> param;
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (CONFIRMUP.equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            param = new HashMap<String, String>();
            selectCol = StringConversionUtil.conversion((String)this.getPageCache().get("select"));
            selectcols = String.join((CharSequence)",", selectCol);
            param.put("allProd", selectcols);
            this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)"ent_prodrequest", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.ADDNEW, (long)0L, param, null));
        }
        if (CONFIRM.equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            param = new HashMap();
            selectCol = StringConversionUtil.conversion((String)this.getPageCache().get("select"));
            selectcols = String.join((CharSequence)",", selectCol);
            param.put("allProd", selectcols);
            this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)"ent_pricerequest", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.ADDNEW, (long)0L, param, null));
        }
        if (CONFIRMINSTOCK.equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            param = new HashMap();
            selectCol = StringConversionUtil.conversion((String)this.getPageCache().get("select"));
            selectcols = String.join((CharSequence)",", selectCol);
            log.info("$$$$217" + selectcols);
            param.put("allProd", selectcols);
            this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)"ent_instock", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.ADDNEW, (long)0L, param, null));
        }
        if (INFO_CHANGE_CONFIRM.equals(callBackId)) {
            HashMap<String, String> customParams = new HashMap<String, String>(8);
            String infoChangId = this.getPageCache().get("infoChangId");
            customParams.put("hasOrder", "true");
            OpenFormUtil.openBasePage((IFormView)this.getView(), (String)"ent_prodinfochange", (Object)Long.valueOf(infoChangId), (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.MainNewTabPage, customParams, null);
        }
        if ("addtopackege".equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.addPackege();
        }
    }

    private boolean previewCheck(Long productId) {
        QFilter filter = new QFilter("id", "=", (Object)productId);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject[] sups = BusinessDataServiceHelper.load((String)"ent_prodmanage", (String)"number,mallstatus,status,name,unit,category,source,taxprice,thumbnail", (QFilter[])filters);
        StringBuilder sb = new StringBuilder();
        if (sups[0].getString("name") == null) {
            sb.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5546\u54c1\u540d\u79f0\u201d\u3002", (String)"EntProdManageList_7", (String)"scm-ent-formplugin", (Object[])new Object[0])).append('\n');
        }
        if (sups[0].getString("unit") == null) {
            sb.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8ba1\u91cf\u5355\u4f4d\u201d\u3002", (String)"EntProdManageList_8", (String)"scm-ent-formplugin", (Object[])new Object[0])).append('\n');
        }
        if (StringUtils.isBlank((CharSequence)sups[0].getString("source"))) {
            sb.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5546\u54c1\u6765\u6e90\u201d\u3002", (String)"EntProdManageList_9", (String)"scm-ent-formplugin", (Object[])new Object[0])).append('\n');
        }
        if (sups[0].getString("taxprice").equals("0E-10")) {
            sb.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u542b\u7a0e\u5355\u4ef7\u201d\u3002", (String)"EntProdManageList_10", (String)"scm-ent-formplugin", (Object[])new Object[0])).append('\n');
        }
        if (sups[0].getString("thumbnail") == "") {
            sb.append(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u201c\u5546\u54c1\u4e3b\u56fe\u201d\u3002", (String)"EntProdManageList_11", (String)"scm-ent-formplugin", (Object[])new Object[0])).append('\n');
        }
        if (sb.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u65e0\u6cd5\u9884\u89c8\u5546\u54c1\uff0c\u8bf7\u5f55\u5165\u4ee5\u4e0b\u4fe1\u606f\u3002", (String)"EntProdManageList_12", (String)"scm-ent-formplugin", (Object[])new Object[0]), String.valueOf(sb), MessageTypes.Default);
            return false;
        }
        return true;
    }

    private boolean promptMessage(String key) {
        DynamicObject[] sups;
        ArrayList selectCols = StringConversionUtil.conversion((String)this.getPageCache().get("select"));
        ArrayList<Long> list = new ArrayList<Long>(selectCols.size());
        for (String str : selectCols) {
            list.add(Long.parseLong(str));
        }
        QFilter filter = new QFilter("id", "in", list);
        QFilter[] filters = new QFilter[]{filter};
        StringBuilder sb = new StringBuilder();
        String confirm = "";
        for (DynamicObject sup : sups = BusinessDataServiceHelper.load((String)"ent_prodmanage", (String)"number,mallstatus,status", (QFilter[])filters)) {
            if (!"tblinstock".equals(key) || "C".equalsIgnoreCase(sup.getString("status"))) continue;
            confirm = CONFIRMINSTOCK;
            sb.append(MessageFormat.format(ResManager.loadKDString((String)"\u5546\u54c1\u7f16\u7801\uff1a{0}\u7684\u5546\u54c1\u8fd8\u672a\u5ba1\u6838\u3002", (String)"EntProdManageList_17", (String)"scm-ent-formplugin", (Object[])new Object[0]), sup.getString("number"))).append('\n');
            this.removeProd(sup.getPkValue().toString());
        }
        filter = new QFilter("id", "in", list);
        filters = new QFilter[]{filter};
        ArrayList selectList = StringConversionUtil.conversion((String)this.getPageCache().get("select"));
        if (sb.length() > 0 && selectList.size() == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6240\u9009\u5546\u54c1\u5747\u4e0d\u7b26\u5408\u89c4\u5219\u3002", (String)"EntProdManageList_21", (String)"scm-ent-formplugin", (Object[])new Object[0]), String.valueOf(sb), MessageTypes.Default);
            return true;
        }
        if (sb.length() > 0) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4ee5\u4e0b\u5546\u54c1\u4e0d\u7b26\u5408\u89c4\u5219\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"EntProdManageList_22", (String)"scm-ent-formplugin", (Object[])new Object[0]), String.valueOf(sb), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(confirm));
            return true;
        }
        return false;
    }

    private void removeProd(String prodpk) {
        ArrayList selectCols = StringConversionUtil.conversion((String)this.getPageCache().get("select"));
        for (int i = selectCols.size() - 1; i >= 0; --i) {
            if (!prodpk.equalsIgnoreCase((String)selectCols.get(i))) continue;
            selectCols.remove(i);
        }
        IPageCache cache = this.getPageCache();
        cache.put("select", String.join((CharSequence)",", selectCols));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        OperationResult result;
        super.afterDoOperation(args);
        String itemKey = args.getOperateKey();
        if ("submit".equals(itemKey) && !args.getOperationResult().getSuccessPkIds().isEmpty()) {
            this.syncSpu(args.getOperationResult().getSuccessPkIds());
        }
        if (null == (result = args.getOperationResult()) || !result.isSuccess()) {
            return;
        }
        if (itemKey.equalsIgnoreCase("refresh") || itemKey.equalsIgnoreCase("close")) {
            return;
        }
        ArrayList<Object> selectCol = new ArrayList();
        if (!(Arrays.asList("importdata", "exportlist", "exportlistbyselectfields", "exportlist_expt").contains(itemKey) || null != (selectCol = "preview".equals(itemKey) ? this.selectCheck(false) : this.selectCheck(true)) && selectCol.size() >= 1)) {
            return;
        }
        switch (itemKey) {
            case "preview": {
                IListView listview = (IListView)this.getView();
                Object[] productIds = listview.getSelectedRows().getPrimaryKeyValues();
                boolean b = this.previewCheck((Long)productIds[0]);
                if (!b) {
                    return;
                }
                this.showDetailPage((Long)productIds[0]);
                break;
            }
            case "instock": {
                Map<String, Object> instockCheckMap = this.operateCheck();
                if (instockCheckMap.isEmpty()) {
                    return;
                }
                Object supObj = instockCheckMap.get("supplier");
                boolean flag = this.promptMessage("tblinstock");
                if (flag) break;
                HashMap<String, Object> param = new HashMap<String, Object>();
                String selectcols = String.join((CharSequence)",", selectCol);
                param.put("allProd", selectcols);
                param.put("supplier", supObj);
                this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)"ent_instock", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.ADDNEW, (long)0L, param, null));
                break;
            }
            case "batchimportimage": {
                ArrayList<Long> idList = new ArrayList<Long>(selectCol.size());
                for (String string : selectCol) {
                    idList.add(Long.parseLong(string));
                }
                DynamicObjectCollection dynList = QueryServiceHelper.query((String)"ent_prodmanage", (String)"id,supplier", (QFilter[])new QFilter("id", "in", idList).toArray());
                HashSet hashSet = new HashSet(dynList.size());
                dynList.forEach(t -> goodIds.add(t.getLong("supplier")));
                if (hashSet.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u540c\u4e00\u4e2a\u4f9b\u5e94\u5546\u7684\u5546\u54c1\u3002", (String)"EntProdManageList_31", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (idList.size() > 100) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5546\u54c1\u6570\u91cf\u8d85\u8fc7100\u4e2a\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"EntProdManageList_32", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                    return;
                }
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("ent_importpicture");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                HashMap<String, Object> detailParamMap = new HashMap<String, Object>();
                detailParamMap.put("goodsIds", idList);
                detailParamMap.put("origin", "ent");
                showParameter.setCustomParams(detailParamMap);
                this.getView().showForm(showParameter);
                break;
            }
            case "allot": 
            case "unallot": {
                this.allotAndUnallot(itemKey);
                break;
            }
            case "infochange": {
                this.prodInfoChangeOp();
                break;
            }
            case "addtopackege": {
                this.checkAddtopackege(args);
                break;
            }
        }
    }

    private void addPackege() {
        String prodliststr = this.getPageCache().get("pakage_prodlist");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("allprodids", prodliststr);
        param.put("cur_supplier", this.getPageCache().get("pakage_suplier"));
        param.put("cur_suppliername", this.getPageCache().get("pakage_suppliername"));
        this.getPageCache().remove("pakage_suppliername");
        this.getPageCache().remove("pakage_suplier");
        this.getPageCache().remove("pakage_prodlist");
        this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)"ent_packageselection", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.ADDNEW, (long)0L, param, null));
    }

    public void allotAndUnallot(String operate) {
        BillList list = (BillList)this.getView().getControl("billlistap");
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        Object[] objects = list.getSelectedRows().getPrimaryKeyValues();
        StringBuilder idStr = new StringBuilder();
        for (int i = 0; i < objects.length; ++i) {
            idStr.append(objects[i]).append(',');
            MalFeeHandleHelper.clearRedisCacheByGoodsKey((String)objects[i].toString());
        }
        paramMap.put("goodid", idStr.substring(0, idStr.length() - 1));
        paramMap.put("operate", operate);
        DynamicObject[] surcharges = EntProdManageUtil.getSurCharge(paramMap, (String)operate);
        if ("allot".equals(operate)) {
            Map<String, Object> checkResult = this.operateCheck();
            if (checkResult.isEmpty()) {
                return;
            }
            Object supplierObj = checkResult.get("supplier");
            if (surcharges.length <= 0) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u9644\u52a0\u8d39\u65b9\u6848\u3002", (String)"EntProdManageList_24", (String)"scm-ent-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
                return;
            }
            paramMap.put("supplier", supplierObj);
            this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)"ent_prodmanageallot", paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, ALLOTCALLBACK), (ShowType)ShowType.Modal));
        } else {
            if (surcharges.length <= 0) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u5546\u54c1\u65e0\u9644\u52a0\u8d39\uff0c\u65e0\u9700\u53d6\u6d88\u3002", (String)"EntProdManageList_25", (String)"scm-ent-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
                return;
            }
            this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)"ent_prodmanageallot", paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, UNALLOTCALLBACK), (ShowType)ShowType.Modal));
        }
    }

    private void syncSpu(List<Object> prodIds) {
        EntProdManageAuditServiceImpl entProdManageAuditService = new EntProdManageAuditServiceImpl();
        List<Sku> skus = this.initSKu(prodIds);
        Map res = entProdManageAuditService.writeBackSpu(skus);
        if (res.get("msg") != null) {
            StringBuilder msg = (StringBuilder)res.get("msg");
            this.getView().showMessage(ResManager.loadKDString((String)"\u5546\u54c1\u5173\u8054SPU\u5931\u8d25\u3002", (String)"EntProdRequestEdit_20", (String)"scm-ent-formplugin", (Object[])new Object[0]), msg.toString(), MessageTypes.Default);
        }
    }

    private List<Sku> initSKu(List<Object> prodIds) {
        QFilter qFilter = new QFilter("id", "in", prodIds);
        qFilter.and("spunumber", "is not null", (Object)" ").and("spunumber", "!=", (Object)" ");
        DynamicObject[] prods = BusinessDataServiceHelper.load((String)"ent_prodmanage", (String)"id,number,spunumber,createorg,supplier,prodattributeentry.prodattribute,prodattributeentry.prodattributevalue", (QFilter[])qFilter.toArray());
        ArrayList<Sku> skus = new ArrayList<Sku>(prods.length);
        for (DynamicObject dynamicObject : prods) {
            Sku sku = new Sku();
            sku.setId(Long.valueOf(dynamicObject.getLong("id")));
            sku.setCreateOrg(Long.valueOf(dynamicObject.getLong("createorg_id")));
            sku.setNumber(dynamicObject.getString("number"));
            sku.setSpu(dynamicObject.getString("spunumber"));
            sku.setSupplier(Long.valueOf(dynamicObject.getLong("supplier_id")));
            DynamicObjectCollection prodattributeentry = dynamicObject.getDynamicObjectCollection("prodattributeentry");
            HashSet<Long> baseAttributeValues = new HashSet<Long>(prodattributeentry.size());
            HashSet<Long> saleAttributeValues = new HashSet<Long>(prodattributeentry.size());
            for (DynamicObject entry : prodattributeentry) {
                DynamicObject prodattribute = entry.getDynamicObject("prodattribute");
                if ("1".equals(prodattribute.getString("attributetype"))) {
                    baseAttributeValues.add(entry.getLong("prodattributevalue_id"));
                    continue;
                }
                if (!"2".equals(prodattribute.getString("attributetype"))) continue;
                saleAttributeValues.add(entry.getLong("prodattributevalue_id"));
            }
            sku.setBaseAttributeValues(baseAttributeValues);
            sku.setSaleAttributeValues(saleAttributeValues);
            skus.add(sku);
        }
        return skus;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "allotcallback": {
                if (null != closedCallBackEvent.getReturnData()) {
                    Map returnData = (Map)closedCallBackEvent.getReturnData();
                    if (null != returnData.get("success") && returnData.get("success").equals("true")) {
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f\u3002", (String)"EntProdManageList_26", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                    }
                    IListView listview = (IListView)this.getView();
                    listview.refresh();
                    break;
                }
            }
            case "unallotcallback": {
                if (null == closedCallBackEvent.getReturnData()) break;
                Map returnData = (Map)closedCallBackEvent.getReturnData();
                if (null != returnData.get("success") && returnData.get("success").equals("true")) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u914d\u6210\u529f\u3002", (String)"EntProdManageList_27", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                }
                IListView listview = (IListView)this.getView();
                listview.refresh();
                break;
            }
        }
    }

    private int checkHasPermission(String billtype, String permitem, Long orgid) {
        String appId = AppMetadataCache.getAppInfo((String)"ent").getId();
        int hasPermResult = PermissionServiceHelper.checkPermission((Long)UserServiceHelper.getCurrentUserId(), (Long)orgid, (String)appId, (String)billtype, (String)permitem);
        return hasPermResult;
    }
}

