/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.formplugin.list;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.parent.TreeListBuildTreePlugin;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.malcore.enums.MallStatusEnum;

public class EntProdManageProdPoolList
extends TreeListBuildTreePlugin {
    private static final String RELATE_PROTOCOL_CONFIRM = "relateProtocolConfirm";
    private static final String OPEN_PROTOCOL_F7_CALL_BACK = "openProtocolF7CallBack";
    private static final String RELATE_PROTOCOL_OP_PROD_ID_SET = "relateProtocolOpProdIDSet";
    private static final String DOWNLOAD_CONFIRM = "downloadConfirm";
    public static final String CACHE_ALL_PROD = "allProd";
    public static final String CACHE_PROD_POOL_IDS = "prodPoolIds";
    public static final String CACHE_SUPPLIER = "supplier";

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        boolean defaultMalVersion = MalOrderUtil.getDefaultMalVersion();
        this.hideFilterColumn(args.getCommonFilterColumns(), this.getHideCommonColumn(defaultMalVersion));
        this.hideFilterColumn(args.getSchemeFilterColumns(), this.getHideSchemeColumn(defaultMalVersion));
    }

    private Set<String> getHideCommonColumn(boolean isMalNewVersion) {
        HashSet<String> hideColumnsKey = new HashSet<String>(8);
        if (!isMalNewVersion) {
            hideColumnsKey.add("isprotocolprod");
        } else {
            hideColumnsKey.add("mallstatus");
        }
        return hideColumnsKey;
    }

    private Set<String> getHideSchemeColumn(boolean isMalNewVersion) {
        HashSet<String> hideColumnsKey = new HashSet<String>(8);
        if (!isMalNewVersion) {
            hideColumnsKey.add("prodpool.mallstatus");
            hideColumnsKey.add("isprotocolprod");
            hideColumnsKey.add("barcode");
        } else {
            hideColumnsKey.add("mallstatus");
        }
        return hideColumnsKey;
    }

    private void hideFilterColumn(List<FilterColumn> filterColumns, Set<String> hideCommonColumn) {
        Iterator<FilterColumn> iterator = filterColumns.iterator();
        while (iterator.hasNext()) {
            FilterColumn filterColumn = iterator.next();
            String fieldName = filterColumn.getFieldName();
            if (!hideCommonColumn.contains(fieldName)) continue;
            iterator.remove();
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        this.malVersionView(args);
    }

    private void malVersionView(BeforeCreateListColumnsArgs args) {
        boolean defaultMalVersion = MalOrderUtil.getDefaultMalVersion();
        Set<String> hideColumns = this.malVersionHideColumns(defaultMalVersion);
        Set<String> showColumns = this.malVersionShowColumns(defaultMalVersion);
        Set<String> fixedColumns = this.malVersionFixedColumns(defaultMalVersion);
        List listColumns = args.getListColumns();
        for (IListColumn listColumn : listColumns) {
            if (!(listColumn instanceof ListColumn)) continue;
            String listFieldKey = listColumn.getListFieldKey();
            if (fixedColumns.contains(listFieldKey)) {
                ListColumn listOperationColumn = (ListColumn)listColumn;
                listOperationColumn.setFixed(true);
            }
            if (hideColumns.contains(listFieldKey)) {
                listColumn.setVisible(0);
            }
            if (!showColumns.contains(listFieldKey)) continue;
            listColumn.setVisible(1);
        }
    }

    private Set<String> malVersionFixedColumns(boolean isNewMalVersion) {
        HashSet<String> fixedColumns = new HashSet<String>(16);
        if (isNewMalVersion) {
            fixedColumns.add("number");
            fixedColumns.add("name");
            fixedColumns.add("thumbnail");
        }
        return fixedColumns;
    }

    private Set<String> malVersionHideColumns(boolean isNewMalVersion) {
        Set<String> hideColumns = new HashSet<String>(16);
        if (!isNewMalVersion) {
            hideColumns.add("isprotocolprod");
            hideColumns.add("supplier.name");
            hideColumns.add("prodpool.mallstatus");
            hideColumns.add("prodpool.salestatus");
            hideColumns.add("prodpool.taxprice");
            hideColumns.add("prodpool.priceeffectdate");
            hideColumns.add("prodpool.priceinvaliddate");
            hideColumns.add("prodpool.effectstatus");
            hideColumns.add("protocol.protocolname");
            hideColumns.add("protocol.protocolstatus");
            hideColumns.add("prodpool.minorderqty");
            hideColumns.add("prodpool.leadtime");
            hideColumns.add("barcode");
            hideColumns.add("prodpool.purplan.name");
        } else {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Object hideFieldJson = customParams.get("hideFields");
            if (hideFieldJson != null) {
                hideColumns = (Set)SerializationUtils.fromJsonString((String)((String)hideFieldJson), Set.class);
            }
        }
        return hideColumns;
    }

    private Set<String> malVersionShowColumns(boolean isNewMalVersion) {
        HashSet<String> showColumns = new HashSet<String>(16);
        if (!isNewMalVersion) {
            showColumns.add("taxprice");
            showColumns.add("mallstatus");
            showColumns.add("surchargename");
            showColumns.add("surchargeamount");
        }
        return showColumns;
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if ("bos_org".equals(args.getRefEntityId())) {
            HashMap<String, String> paramMap = new HashMap<String, String>(8);
            paramMap.put("orgType", "purorg");
            OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)"ent_orgselect", (ShowType)ShowType.Modal, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "orgclose"));
            args.setCancel(true);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (!MalOrderUtil.getDefaultMalVersion()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblrelateprotocol", "tblimportimage", "bar_infochange"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "upload": {
                this.uploadOp(args);
                break;
            }
            case "download": {
                DynamicObjectCollection prodDynColl = this.querySelectedProdDynColl();
                this.downloadOpValid(args, prodDynColl);
                break;
            }
            case "adjprice": {
                this.adjustOp(args);
                break;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void uploadOp(BeforeDoOperationEventArgs args) {
        void var16_23;
        Object[] entry;
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listview.getSelectedRows();
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        if (primaryKeyValues.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4ef6\u5546\u54c1\u3002", (String)"EntProdManageList_3", (String)"scm-ent-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        DynamicObject[] prodDynArray = BusinessDataServiceHelper.load((String)"ent_prodmanage", (String)"id,status,supplier,protocolentry.prodpool,protocolentry.protocol", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)});
        Object[] entryPrimaryKeyValues = selectedRows.getEntryPrimaryKeyValues();
        HashSet<Long> entryIdSet = new HashSet<Long>(entryPrimaryKeyValues.length);
        if (entryPrimaryKeyValues[0] != null) {
            for (Object entryPrimaryKeyValue : entryPrimaryKeyValues) {
                entryIdSet.add((Long)entryPrimaryKeyValue);
            }
        } else {
            for (DynamicObject dynamicObject : prodDynArray) {
                entryIdSet.add(((DynamicObject)dynamicObject.getDynamicObjectCollection("protocolentry").get(0)).getLong("id"));
            }
        }
        if (!this.uploadConsistencyValid(prodDynArray, entryIdSet)) {
            args.setCancel(true);
            return;
        }
        Long supplierId = prodDynArray[0].getLong("supplier_id");
        String protocolId = "-1";
        block2: for (DynamicObject prod : prodDynArray) {
            entry = prod.getDynamicObjectCollection("protocolentry");
            for (DynamicObject dynamicObject : entry) {
                if (!entryIdSet.contains(dynamicObject.getLong("id"))) continue;
                DynamicObject protocol = dynamicObject.getDynamicObject("protocol");
                if (protocol == null) continue block2;
                protocolId = protocol.getString("id");
                continue block2;
            }
        }
        if (!this.supplierEffectValid(supplierId)) {
            args.setCancel(true);
            return;
        }
        ArrayList<String> prodPoolIdList = new ArrayList<String>(primaryKeyValues.length);
        boolean uploadStatusValid = this.uploadStatusValid(prodDynArray, entryIdSet, protocolId, prodPoolIdList);
        if (!uploadStatusValid) {
            args.setCancel(true);
            return;
        }
        if (!this.uploadProdAuditValid(primaryKeyValues, protocolId)) {
            args.setCancel(true);
            return;
        }
        String prodPoolCols = String.join((CharSequence)",", prodPoolIdList);
        ArrayList<String> prodIdList = new ArrayList<String>(primaryKeyValues.length);
        entry = primaryKeyValues;
        int n = entry.length;
        boolean bl = false;
        while (var16_23 < n) {
            Object primaryKeyValue = entry[var16_23];
            prodIdList.add(primaryKeyValue.toString());
            ++var16_23;
        }
        String selectCols = String.join((CharSequence)",", prodIdList);
        this.getView().getPageCache().put(CACHE_ALL_PROD, selectCols);
        this.getView().getPageCache().put(CACHE_PROD_POOL_IDS, prodPoolCols);
        this.getView().getPageCache().put(CACHE_SUPPLIER, String.valueOf(supplierId));
    }

    private void downloadOpValid(BeforeDoOperationEventArgs args, DynamicObjectCollection prodDynColl) {
        if (prodDynColl.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4ef6\u5546\u54c1\u3002", (String)"EntProdManageList_3", (String)"scm-ent-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (!this.downloadValid(prodDynColl)) {
            args.setCancel(true);
        }
    }

    private boolean downloadValid(DynamicObjectCollection prodDynColl) {
        boolean haveEffectProtocol = false;
        Long protocolId = null;
        Long auditOrg = null;
        Long supplierId = null;
        HashSet<Long> prodIds = new HashSet<Long>(prodDynColl.size());
        for (DynamicObject prodDyn : prodDynColl) {
            if (!MallStatusEnum.SOLD.getVal().equals(prodDyn.getString("mallstatus")) && !MallStatusEnum.UNSOLD.getVal().equals(prodDyn.getString("mallstatus"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u5f85\u4e0a\u67b6/\u5df2\u4e0a\u67b6\u7684\u5546\u54c1\u4e0b\u67b6\u3002", (String)"EntProdManageProdPoolList_4", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                return false;
            }
            if ("B".equals(prodDyn.getString("protocolstatus"))) {
                haveEffectProtocol = true;
            }
            if (protocolId != null && protocolId.longValue() != prodDyn.getLong("protocol")) {
                if (protocolId == 0L || prodDyn.getLong("protocol") == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u6570\u636e\u4e2d\u5b58\u5728\u65e0\u534f\u8bae\u7684\u5546\u54c1\u53ca\u6709\u534f\u8bae\u7684\u5546\u54c1\uff0c\u8bf7\u5206\u5f00\u8d70\u4e0b\u67b6\u6d41\u7a0b\u3002", (String)"GoodsManageProdPoolList_28", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6279\u91cf\u9009\u62e9\u7684\u5546\u54c1\u4e2d\u534f\u8bae\u4e0d\u540c\uff0c\u4ec5\u652f\u6301\u5bf9\u540c\u4e00\u4e2a\u534f\u8bae\u4e0b\u7684\u5546\u54c1\u6279\u91cf\u4e0b\u67b6\u3002", (String)"GoodsManageProdPoolList_27", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                }
                return false;
            }
            protocolId = prodDyn.getLong("protocol");
            if (auditOrg != null && auditOrg.longValue() != prodDyn.getLong("auditorg")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5546\u54c1\u5206\u5f55\u4e2d\u5ba1\u6279\u7ec4\u7ec7\u76f8\u540c\u7684\u5546\u54c1\u5206\u5f55\u4e00\u8d77\u4e0b\u67b6\u3002", (String)"GoodsManageProdPoolList_30", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                return false;
            }
            auditOrg = prodDyn.getLong("auditorg");
            if (supplierId != null && supplierId.longValue() != prodDyn.getLong(CACHE_SUPPLIER)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u6279\u91cf\u9009\u62e9\u540c\u4e00\u4e2a\u4f9b\u5e94\u5546\u7684\u5546\u54c1\u5206\u5f55\u4e00\u8d77\u4e0b\u67b6\u3002", (String)"GoodsManageProdPoolList_31", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                return false;
            }
            supplierId = prodDyn.getLong(CACHE_SUPPLIER);
            prodIds.add(prodDyn.getLong("id"));
        }
        if (!this.checkProdOtherBill(protocolId, prodIds)) {
            return false;
        }
        if (haveEffectProtocol) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u90e8\u5206\u5546\u54c1\u5173\u8054\u7684\u534f\u8bae\u751f\u6548\u4e2d\uff0c\u4e0b\u67b6\u540e\u65e0\u6cd5\u641c\u5230\u5546\u54c1\uff0c\u786e\u5b9a\u8981\u4e0b\u67b6\u5546\u54c1\u5417\uff1f", (String)"EntProdManageProdPoolList_8", (String)"scm-ent-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DOWNLOAD_CONFIRM));
            return false;
        }
        return true;
    }

    private boolean checkProdOtherBill(Long protocolId, Set<Long> prodIds) {
        QFilter qFilter = new QFilter("prod", "in", prodIds);
        qFilter.and("cfmstatus", "=", (Object)"A");
        DynamicObjectCollection prodChangeManages = QueryServiceHelper.query((String)"pmm_prodchange_manage", (String)"billno,prod.number", (QFilter[])qFilter.toArray());
        StringBuilder sb = new StringBuilder();
        for (DynamicObject prodChangeManage : prodChangeManages) {
            String msg = ResManager.loadKDString((String)"\u5546\u54c1%1$s\u5b58\u5728\u5f85\u786e\u8ba4\u7684\u53d8\u66f4\u5355\uff1a%2$s\uff0c\u4e0d\u5141\u8bb8\u4e0b\u67b6\u3002", (String)"GoodsManageProdPoolList_25", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            sb.append(String.format(msg, prodChangeManage.getString("prod.number"), prodChangeManage.getString("billno"))).append("\n");
        }
        QFilter qFilterRequest = new QFilter("entryentity.goods", "in", prodIds);
        qFilterRequest.and("cfmstatus", "=", (Object)"A");
        qFilterRequest.and("biztype", "=", (Object)"2");
        qFilterRequest.and("protocolid", "=", (Object)protocolId);
        DynamicObjectCollection prodRequests = QueryServiceHelper.query((String)"pmm_prodaudit", (String)"billno,entryentity.goods.id goods,entryentity.goods.number goodsnumber", (QFilter[])qFilterRequest.toArray());
        for (DynamicObject prodRequest : prodRequests) {
            String msg = ResManager.loadKDString((String)"\u5546\u54c1%1$s\u5b58\u5728\u5f85\u5ba1\u6279\u7684\u4e0b\u67b6\u7533\u8bf7\u5355\uff1a%2$s\uff0c\u4e0d\u5141\u8bb8\u4e0b\u67b6\u3002", (String)"GoodsManageProdPoolList_29", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            sb.append(String.format(msg, prodRequest.getString("goodsnumber"), prodRequest.getString("billno"))).append("\n");
        }
        if (sb.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u4e0b\u67b6\u5931\u8d25", (String)"GoodsManageProdPoolList_26", (String)"scm-pmm-formplugin", (Object[])new Object[0]), sb.toString(), MessageTypes.Default);
            return false;
        }
        return true;
    }

    private void downloadToProdRequest(DynamicObjectCollection prodDynColl) {
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("biztype", "download");
        ArrayList<String> prodPoolIds = new ArrayList<String>(prodDynColl.size());
        ArrayList<String> prodIds = new ArrayList<String>(prodDynColl.size());
        for (DynamicObject prodDyn : prodDynColl) {
            prodPoolIds.add(prodDyn.getString("prodpool"));
            prodIds.add(prodDyn.getString("id"));
        }
        params.put(CACHE_ALL_PROD, String.join((CharSequence)",", prodIds));
        params.put(CACHE_PROD_POOL_IDS, String.join((CharSequence)",", prodPoolIds));
        params.put(CACHE_SUPPLIER, ((DynamicObject)prodDynColl.get(0)).getLong(CACHE_SUPPLIER));
        this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)"ent_prodrequest", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.ADDNEW, (long)0L, params, null));
    }

    private boolean uploadConsistencyValid(DynamicObject[] prodDynArray, Set<Long> entryIdSet) {
        String protocolId = "";
        String supplier = "";
        for (DynamicObject prodDyn : prodDynArray) {
            String supplierId = prodDyn.getString("supplier_id");
            if (StringUtils.isBlank((CharSequence)supplier)) {
                supplier = supplierId;
            } else if (!supplier.equals(supplierId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u5904\u4e00\u6b21\u53ea\u80fd\u5bf9\u4e00\u5bb6\u4f9b\u5e94\u5546\u7684\u5185\u5bb9\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"EntProdManageList_28", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                return false;
            }
            DynamicObjectCollection protocolEntry = prodDyn.getDynamicObjectCollection("protocolentry");
            for (DynamicObject entry : protocolEntry) {
                if (!entryIdSet.contains(entry.getLong("id"))) continue;
                DynamicObject protocolDyn = entry.getDynamicObject("protocol");
                if (StringUtils.isBlank((CharSequence)protocolId)) {
                    protocolId = protocolDyn == null ? "-1" : protocolDyn.getString("id");
                    continue;
                }
                if (protocolDyn == null && !protocolId.equals("-1") || protocolDyn != null && protocolId.equals("-1")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u6570\u636e\u4e2d\u5b58\u5728\u65e0\u534f\u8bae\u7684\u5546\u54c1\u53ca\u6709\u534f\u8bae\u7684\u5546\u54c1\uff0c\u8bf7\u5206\u5f00\u8d70\u4e0a\u67b6\u6d41\u7a0b\u3002", (String)"EntProdManageProdPoolList_10", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                    return false;
                }
                if (protocolDyn == null || protocolId.equals(protocolDyn.getString("id"))) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6279\u91cf\u9009\u62e9\u7684\u5546\u54c1\u4e2d\u534f\u8bae\u4e0d\u540c\uff0c\u4ec5\u652f\u6301\u5bf9\u540c\u4e00\u4e2a\u534f\u8bae\u4e0b\u7684\u5546\u54c1\u6279\u91cf\u4e0a\u67b6\u3002", (String)"EntProdManageProdPoolList_11", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private boolean supplierEffectValid(Long supplierId) {
        DynamicObject supplier = QueryServiceHelper.queryOne((String)"bd_supplier", (String)"id,enable,mallstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)supplierId)});
        String enable = supplier.getString("enable");
        String mallStatus = supplier.getString("mallstatus");
        if ("0".equals(enable)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5546\u54c1\u4f9b\u5e94\u5546\u5df2\u7981\u7528\uff0c\u5546\u54c1\u65e0\u6cd5\u4e0a\u67b6\u3002", (String)"EntProdManageProdPoolList_25", (String)"scm-ent-formplugin", (Object[])new Object[0]));
            return false;
        }
        if ("C".equals(mallStatus)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5546\u54c1\u4f9b\u5e94\u5546\u5df2\u51bb\u7ed3\uff0c\u5546\u54c1\u65e0\u6cd5\u4e0a\u67b6\u3002", (String)"EntProdManageProdPoolList_26", (String)"scm-ent-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean uploadProdAuditValid(Object[] primaryKeyValues, String protocolId) {
        QFilter qFilter = new QFilter("entryentity.goods", "in", (Object)primaryKeyValues);
        if (!"-1".equals(protocolId)) {
            qFilter.and(new QFilter("protocolid", "=", (Object)Long.valueOf(protocolId)));
        }
        qFilter.and(new QFilter("cfmstatus", "!=", (Object)"B")).and(new QFilter("cfmstatus", "!=", (Object)"D")).and(new QFilter("cfmstatus", "!=", (Object)"C"));
        qFilter.and("biztype", "=", (Object)"1");
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"ent_prodrequest", (String)"id,billno,entryentity.goods.id goods,entryentity.goods.number goodsnumber", (QFilter[])new QFilter[]{qFilter});
        if (dynamicObjects.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (DynamicObject dynamicObject : dynamicObjects) {
                String msg = ResManager.loadKDString((String)"\u5546\u54c1\u7f16\u7801\uff1a%1$s\uff0c\u4e0a\u67b6\u7533\u8bf7\u5355\uff1a%2$s", (String)"EntProdManageProdPoolList_20", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                sb.append(String.format(msg, dynamicObject.getString("goodsnumber"), dynamicObject.getString("billno"))).append("\n");
            }
            this.getView().showMessage(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u90e8\u5206\u5546\u54c1\u5b58\u5728\u672a\u5ba1\u6279\u7684\u4e0a\u67b6\u7533\u8bf7\u5355\uff0c\u8bf7\u5148\u5ba1\u6279\u901a\u8fc7\u3002", (String)"EntProdManageProdPoolList_12", (String)"scm-ent-formplugin", (Object[])new Object[0]), sb.toString(), MessageTypes.Default);
            return false;
        }
        QFilter qFilter1 = new QFilter("prod", "in", (Object)primaryKeyValues);
        qFilter1.and("cfmstatus", "=", (Object)"A");
        DynamicObjectCollection prodChangeManages = QueryServiceHelper.query((String)"ent_prodchange_manage", (String)"billno,prod.number", (QFilter[])qFilter1.toArray());
        StringBuilder sb = new StringBuilder();
        for (DynamicObject prodChangeManage : prodChangeManages) {
            String msg = ResManager.loadKDString((String)"\u5546\u54c1%1$s\u5b58\u5728\u5f85\u786e\u8ba4\u7684\u53d8\u66f4\u5355\uff1a%2$s\uff0c\u4e0d\u5141\u8bb8\u4e0a\u67b6\u3002", (String)"GoodsManageProdPoolList_24", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            sb.append(String.format(msg, prodChangeManage.getString("prod.number"), prodChangeManage.getString("billno"))).append("\n");
        }
        if (sb.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u4e0a\u67b6\u5931\u8d25", (String)"GoodsManageProdPoolList_32", (String)"scm-pmm-formplugin", (Object[])new Object[0]), sb.toString(), MessageTypes.Default);
            return false;
        }
        return true;
    }

    private boolean uploadStatusValid(DynamicObject[] prodDynArray, Set<Long> entryIdSet, String protocolId, List<String> prodPoolIdList) {
        for (DynamicObject prodDyn : prodDynArray) {
            if (!BillStatusEnum.AUDIT.getVal().equals(prodDyn.getString("status"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5546\u54c1\u8fd8\u672a\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u4e0a\u67b6\u3002", (String)"EntProdManageProdPoolList_7", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                return false;
            }
            DynamicObjectCollection protocolEntry = prodDyn.getDynamicObjectCollection("protocolentry");
            for (DynamicObject entry : protocolEntry) {
                if (!entryIdSet.contains(entry.getLong("id"))) continue;
                DynamicObject prodPoolDyn = entry.getDynamicObject("prodpool");
                String mallStatus = prodPoolDyn.getString("mallstatus");
                if (MallStatusEnum.SOLDOUT.getVal().equals(mallStatus) || MallStatusEnum.BACKMODIFY.getVal().equals(mallStatus) || MallStatusEnum.TEMPSTATUS.getVal().equals(mallStatus)) {
                    DynamicObject protocolDyn = entry.getDynamicObject("protocol");
                    if (!"-1".equals(protocolId) && !"B".equals(protocolDyn.getString("protocolstatus"))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u751f\u6548\u4e2d\u7684\u534f\u8bae\u6216\u65e0\u534f\u8bae\u7684\u5546\u54c1\u4e0a\u67b6\u3002", (String)"EntProdManageProdPoolList_0", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                        return false;
                    }
                } else {
                    if (MallStatusEnum.UNSOLD.getVal().equals(mallStatus)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5546\u54c1\u672a\u751f\u6548\uff0c\u5f85\u751f\u6548\u540e\u81ea\u52a8\u4e0a\u67b6\uff0c\u65e0\u9700\u4eba\u5de5\u5904\u7406\u3002", (String)"EntProdManageProdPoolList_13", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                        return false;
                    }
                    if (MallStatusEnum.SOLD.getVal().equals(mallStatus)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u90e8\u5206\u5546\u54c1\u5df2\u4e0a\u67b6\uff0c\u65e0\u9700\u91cd\u590d\u4e0a\u67b6\uff0c\u8bf7\u91cd\u65b0\u52fe\u9009\u3002", (String)"EntProdManageProdPoolList_21", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                        return false;
                    }
                }
                prodPoolIdList.add(prodPoolDyn.getString("id"));
            }
        }
        return true;
    }

    private void adjustOp(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection prodDynColl = this.querySelectedProdDynColl();
        if (prodDynColl.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4ef6\u5546\u54c1\u3002", (String)"EntProdManageList_3", (String)"scm-ent-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (!this.adjustValid(prodDynColl)) {
            args.setCancel(true);
            return;
        }
        HashSet prodPoolIdSet = new HashSet(prodDynColl.size());
        prodDynColl.forEach(prodDyn -> prodPoolIdSet.add(prodDyn.getLong("prodpool")));
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("prodPoolIdSet", SerializationUtils.toJsonString(prodPoolIdSet));
        param.put(CACHE_SUPPLIER, ((DynamicObject)prodDynColl.get(0)).getLong(CACHE_SUPPLIER));
        this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)"ent_pricerequest", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.ADDNEW, (long)0L, param, null));
    }

    private boolean adjustValid(DynamicObjectCollection prodDynColl) {
        String auditOrgId = "";
        String supplier = "";
        HashSet<Long> prodPoolIdSet = new HashSet<Long>(prodDynColl.size());
        for (DynamicObject prodDyn : prodDynColl) {
            String supplierId = prodDyn.getString(CACHE_SUPPLIER);
            if (StringUtils.isBlank((CharSequence)supplier)) {
                supplier = supplierId;
            } else if (!supplier.equals(supplierId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u5904\u4e00\u6b21\u53ea\u80fd\u5bf9\u4e00\u5bb6\u4f9b\u5e94\u5546\u7684\u5185\u5bb9\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"EntProdManageList_28", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                return false;
            }
            String protocolStatus = prodDyn.getString("protocolstatus");
            if (StringUtils.isNotBlank((CharSequence)protocolStatus) && !"A".equals(protocolStatus) && !"B".equals(protocolStatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u672a\u751f\u6548\u6216\u751f\u6548\u4e2d\u7684\u534f\u8bae\u5546\u54c1\u8fdb\u884c\u8c03\u4ef7\u3002", (String)"EntProdManageProdPoolList_15", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                return false;
            }
            String auditOrg = prodDyn.getString("auditorg");
            if (StringUtils.isBlank((CharSequence)auditOrgId)) {
                auditOrgId = auditOrg;
            } else if (!auditOrgId.equals(auditOrg)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u8c03\u4ef7\u7533\u8bf7\u7684\u5546\u54c1\u5bf9\u5e94\u7684\u5ba1\u6279\u5355\u4f4d\u9700\u76f8\u540c\u3002", (String)"EntProdManageProdPoolList_16", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                return false;
            }
            String mallStatus = prodDyn.getString("mallstatus");
            if (!MallStatusEnum.SOLD.getVal().equals(mallStatus) && !MallStatusEnum.UNSOLD.getVal().equals(mallStatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u5df2\u4e0a\u67b6\u6216\u5f85\u4e0a\u67b6\u7684\u5546\u54c1\u8fdb\u884c\u8c03\u4ef7\u3002", (String)"EntProdManageProdPoolList_17", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                return false;
            }
            prodPoolIdSet.add(prodDyn.getLong("prodpool"));
        }
        QFilter qFilter = new QFilter("entryentity.prodpool", "in", prodPoolIdSet);
        qFilter.and(new QFilter("cfmstatus", "=", (Object)"A"));
        DynamicObjectCollection priceRequestDynColl = QueryServiceHelper.query((String)"ent_pricerequest", (String)"id,cfmstatus,entryentity.goods.number goods,entryentity.prodpool.protocol.billno protocol", (QFilter[])qFilter.toArray());
        StringBuilder sb = new StringBuilder();
        for (DynamicObject priceRequestDyn : priceRequestDynColl) {
            String prodNumber = priceRequestDyn.getString("goods");
            if (priceRequestDyn.getString("protocol") == null) {
                sb.append(String.format(ResManager.loadKDString((String)"\u5546\u54c1\u201c%1$s\u201d\u6709\u5f85\u5ba1\u6279\u7684\u8c03\u4ef7\u7533\u8bf7\uff0c\u4e0d\u80fd\u518d\u6b21\u63d0\u8d77\u8c03\u4ef7\u7533\u8bf7\u3002", (String)"EntProdManageProdPoolList_28", (String)"scm-ent-formplugin", (Object[])new Object[0]), prodNumber)).append("\n");
                continue;
            }
            sb.append(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5f85\u5ba1\u6279\u7684\u8c03\u4ef7\u7533\u8bf7\uff0c\u4e0d\u80fd\u518d\u6b21\u63d0\u8d77\u8c03\u4ef7\u7533\u8bf7\u3002\u5546\u54c1\u7f16\u7801\uff1a%1$s\uff0c\u534f\u8bae\u7f16\u7801\uff1a%2$s\u3002", (String)"EntProdManageProdPoolList_18", (String)"scm-ent-formplugin", (Object[])new Object[0]), prodNumber, priceRequestDyn.getString("protocol"))).append("\n");
        }
        if (sb.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6240\u9009\u5546\u54c1\u4e0d\u7b26\u5408\u89c4\u5219\u3002", (String)"EntProdManageProdPoolList_19", (String)"scm-ent-formplugin", (Object[])new Object[0]), String.valueOf(sb), MessageTypes.Default);
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult result = args.getOperationResult();
        if (null == result || !result.isSuccess()) {
            return;
        }
        String itemKey = args.getOperateKey();
        if (itemKey.equalsIgnoreCase("refresh") || itemKey.equalsIgnoreCase("close")) {
            return;
        }
        switch (itemKey) {
            case "upload": {
                HashMap<String, Object> param = new HashMap<String, Object>(8);
                String allProd = this.getPageCache().get(CACHE_ALL_PROD);
                if (!StringUtils.isNotEmpty((CharSequence)allProd)) break;
                param.put(CACHE_ALL_PROD, allProd);
                String prodPoolIds = this.getPageCache().get(CACHE_PROD_POOL_IDS);
                param.put(CACHE_PROD_POOL_IDS, prodPoolIds);
                String supplierId = this.getPageCache().get(CACHE_SUPPLIER);
                if (StringUtils.isNotEmpty((CharSequence)supplierId)) {
                    param.put(CACHE_SUPPLIER, Long.valueOf(supplierId));
                }
                this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)"ent_prodrequest", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.ADDNEW, (long)0L, param, null));
                break;
            }
            case "relateprotocol": {
                this.relateProtocolOp();
                break;
            }
            case "download": {
                if (!MalOrderUtil.getDefaultMalVersion()) {
                    this.downloadOp(this.querySelectedProdDynColl());
                    break;
                }
                this.downloadToProdRequest(this.querySelectedProdDynColl());
            }
        }
    }

    private void relateProtocolOp() {
        DynamicObjectCollection prodDynColl = this.queryProdDynCollByPKId();
        if (prodDynColl.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u6b21\u9009\u62e9\u3002", (String)"EntProdManageList_30", (String)"scm-ent-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!this.checkHasProtocolViewPermission()) {
            return;
        }
        HashSet<Long> prodIDSet = new HashSet<Long>(prodDynColl.size());
        ArrayList<Long> protocolIdList = new ArrayList<Long>(prodDynColl.size());
        boolean containNoProtocol = false;
        String supplier = "";
        for (DynamicObject prodDyn : prodDynColl) {
            if (!BillStatusEnum.AUDIT.getVal().equals(prodDyn.getString("status"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5546\u54c1\u8fd8\u672a\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u5173\u8054\u5546\u57ce\u534f\u8bae\u3002", (String)"EntProdManageProdPoolList_14", (String)"scm-ent-formplugin", (Object[])new Object[0]));
                return;
            }
            prodIDSet.add(prodDyn.getLong("id"));
            long protocol = prodDyn.getLong("protocol");
            if (protocol == 0L) {
                containNoProtocol = true;
            } else {
                protocolIdList.add(protocol);
            }
            if (StringUtils.isBlank((CharSequence)supplier)) {
                supplier = prodDyn.getString(CACHE_SUPPLIER);
                continue;
            }
            if (supplier.equals(prodDyn.getString(CACHE_SUPPLIER))) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u540c\u4e00\u4e2a\u4f9b\u5e94\u5546\u7684\u5546\u54c1\u5173\u8054\u65e0\u6e05\u5355\u534f\u8bae\u3002", (String)"EntProdManageProdPoolList_29", (String)"scm-ent-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getProtocolQFilter(prodIDSet, protocolIdList);
        this.getPageCache().put(RELATE_PROTOCOL_OP_PROD_ID_SET, SerializationUtils.toJsonString(prodIDSet));
        this.getPageCache().put("protocolIdList", SerializationUtils.toJsonString(protocolIdList));
        this.getPageCache().put("relateSupplier", supplier);
        if (containNoProtocol) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u5546\u54c1\u5df2\u8bbe\u7f6e\u4e3a\u975e\u534f\u8bae\u5546\u54c1\uff0c\u5173\u8054\u534f\u8bae\u5219\u66f4\u65b0\u4ef7\u683c\u53ca\u9002\u7528\u7ec4\u7ec7\u8303\u56f4\uff0c\u786e\u8ba4\u8981\u5173\u8054\u5417\uff1f", (String)"EntProdManageProdPoolList_1", (String)"scm-ent-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(RELATE_PROTOCOL_CONFIRM));
            return;
        }
        this.openProtocolF7();
    }

    private void getProtocolQFilter(Set<Long> prodIDSet, List<Long> protocolIdList) {
        QFilter qFilter = new QFilter("entryentity.goods", "in", prodIDSet);
        qFilter.and(new QFilter("cfmstatus", "=", (Object)"E").or(new QFilter("cfmstatus", "=", (Object)"A")));
        DynamicObjectCollection prodAudits = QueryServiceHelper.query((String)"pmm_prodaudit", (String)"protocolid", (QFilter[])qFilter.toArray());
        prodAudits.forEach(prodAudit -> protocolIdList.add(prodAudit.getLong("protocolid")));
    }

    private void openProtocolF7() {
        IFormView view = this.getView();
        String relateSupplier = this.getPageCache().get("relateSupplier");
        QFilter protocolQFilter = new QFilter("partyb", "=", (Object)Long.valueOf(relateSupplier));
        protocolQFilter.and(new QFilter("protocolstatus", "=", (Object)"A").or("protocolstatus", "=", (Object)"B"));
        protocolQFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal()));
        protocolQFilter.and(new QFilter("confirmstatus", "=", (Object)"C"));
        protocolQFilter.and(new QFilter("entryentity", "=", null));
        String protocolIdListJson = this.getPageCache().get("protocolIdList");
        if (StringUtils.isNotBlank((CharSequence)protocolIdListJson)) {
            List protocolIdList = (List)SerializationUtils.fromJsonString((String)protocolIdListJson, List.class);
            protocolQFilter.and(new QFilter("id", "not in", (Object)protocolIdList));
        }
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setLookUp(true);
        listShowParameter.getListFilterParameter().setFilter(protocolQFilter);
        listShowParameter.setFormId("bos_listf7");
        listShowParameter.setBillFormId("ent_priceprotocol_bd");
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("960px");
        styleCss.setHeight("580px");
        listShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
        listShowParameter.setMultiSelect(false);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, OPEN_PROTOCOL_F7_CALL_BACK));
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm((FormShowParameter)listShowParameter);
    }

    private boolean downloadOp(DynamicObjectCollection prodDynColl) {
        ArrayList<Long> prodPoolIdList = new ArrayList<Long>(prodDynColl.size());
        for (DynamicObject dynamicObject : prodDynColl) {
            prodPoolIdList.add(dynamicObject.getLong("prodpool"));
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("isStrict", String.valueOf(false));
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"download", (String)"ent_prodpool", (Object[])prodPoolIdList.toArray(new Object[0]), (OperateOption)option);
        if (!operationResult.isSuccess()) {
            StringBuilder messageError = new StringBuilder();
            operationResult.getAllErrorOrValidateInfo().forEach(row -> messageError.append(row.getMessage()).append("\n\t"));
            if (operationResult.getSuccessPkIds().size() > 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u90e8\u5206\u5546\u54c1\u4e0b\u67b6\u5931\u8d25\u3002", (String)"EntProdManageProdPoolList_5", (String)"scm-ent-formplugin", (Object[])new Object[0]), messageError.toString(), MessageTypes.Default);
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u4e0b\u67b6\u5931\u8d25", (String)"EntProdManageProdPoolList_6", (String)"scm-ent-formplugin", (Object[])new Object[0]), messageError.toString(), MessageTypes.Default);
            }
            return false;
        }
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refresh();
        return true;
    }

    private DynamicObjectCollection querySelectedProdDynColl() {
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectCol = listview.getSelectedRows();
        if (selectCol.isEmpty()) {
            return new DynamicObjectCollection();
        }
        Object[] entryPrimaryKeyValues = selectCol.getPrimaryKeyValues();
        QFilter qFilter = new QFilter("id", "in", (Object)entryPrimaryKeyValues);
        if (selectCol.getEntryPrimaryKeyValues().length > 0 && selectCol.getEntryPrimaryKeyValues()[0] != null) {
            entryPrimaryKeyValues = selectCol.getEntryPrimaryKeyValues();
            qFilter = new QFilter("protocolentry.id", "in", (Object)entryPrimaryKeyValues);
        }
        return QueryServiceHelper.query((String)"ent_prodmanage", (String)"id,supplier,protocolentry.prodpool.id prodpool,protocolentry.prodpool.mallstatus mallstatus,protocolentry.prodpool.auditorg auditorg,protocolentry.protocol.id protocol,protocolentry.protocol.protocolstatus protocolstatus", (QFilter[])qFilter.toArray());
    }

    private DynamicObjectCollection queryProdDynCollByPKId() {
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectCol = listview.getSelectedRows();
        Object[] primaryKeyValues = selectCol.getPrimaryKeyValues();
        return QueryServiceHelper.query((String)"ent_prodmanage", (String)"id,supplier,status,protocolentry.prodpool.id prodpool,protocolentry.prodpool.mallstatus mallstatus,protocolentry.prodpool.auditorg auditorg,protocolentry.protocol.id protocol,protocolentry.protocol.protocolstatus protocolstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)});
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (RELATE_PROTOCOL_CONFIRM.equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            this.openProtocolF7();
        }
        if (DOWNLOAD_CONFIRM.equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            DynamicObjectCollection prodDynColl = this.querySelectedProdDynColl();
            if (MalOrderUtil.getDefaultMalVersion()) {
                this.downloadToProdRequest(this.querySelectedProdDynColl());
            }
            if (!MalOrderUtil.getDefaultMalVersion() && this.downloadOp(prodDynColl)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4e0b\u67b6\u6210\u529f", (String)"EntProdManageProdPoolList_22", (String)"scm-ent-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "openProtocolF7CallBack": {
                this.protocolF7CallBack(closedCallBackEvent);
            }
        }
    }

    private void protocolF7CallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData != null) {
            Set relateProtocolOpProdIdSet = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get(RELATE_PROTOCOL_OP_PROD_ID_SET), Set.class);
            Object primaryKeyValue = ((ListSelectedRowCollection)returnData).get(0).getPrimaryKeyValue();
            DynamicObjectCollection pmmProtocolDynColl = QueryServiceHelper.query((String)"pmm_protocol", (String)"id,purmode,isgoodvisible,effectdate,invaliddate,entryentity.orgname.id orgname,entryentity1.materialname materialname", (QFilter[])new QFilter[]{new QFilter("id", "=", primaryKeyValue)});
            HashSet<Long> protocolOrgSet = new HashSet<Long>(pmmProtocolDynColl.size());
            for (DynamicObject dynamicObject : pmmProtocolDynColl) {
                protocolOrgSet.add(dynamicObject.getLong("orgname"));
            }
            QFilter priceRequestQFilter = new QFilter("entryentity.goods", "in", (Object)relateProtocolOpProdIdSet);
            priceRequestQFilter.and(new QFilter("protocolid", "=", primaryKeyValue));
            priceRequestQFilter.and(new QFilter("cfmstatus", "=", (Object)"E").or(new QFilter("cfmstatus", "=", (Object)"A")));
            DynamicObjectCollection priceRequestDynColl = QueryServiceHelper.query((String)"ent_prodrequest", (String)"id,protocolid.id protocolid,protocolid.billno protocolbillno,entryentity.goods.id goods,entryentity.goods.number goodsnumber", (QFilter[])priceRequestQFilter.toArray());
            StringBuilder sb1 = new StringBuilder();
            for (DynamicObject dynamicObject : priceRequestDynColl) {
                sb1.append(String.format(ResManager.loadKDString((String)"\u5546\u54c1\u7f16\u7801\uff1a%1$s\uff0c\u534f\u8bae\u7f16\u7801\uff1a%2$s", (String)"EntProdManageProdPoolList_23", (String)"scm-ent-formplugin", (Object[])new Object[0]), dynamicObject.getString("goodsnumber"), dynamicObject.getString("protocolbillno")));
            }
            if (sb1.length() > 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u90e8\u5206\u5546\u54c1\u7684\u534f\u8bae\u5df2\u5b58\u5728\u672a\u5ba1\u6838\u7684\u4e0a\u67b6\u7533\u8bf7\u5355\uff0c\u8bf7\u67e5\u770b\u8be6\u60c5\u3002", (String)"EntProdManageProdPoolList_24", (String)"scm-ent-formplugin", (Object[])new Object[0]), sb1.toString(), MessageTypes.Default);
                return;
            }
            DynamicObject[] prodPoolDynArray = BusinessDataServiceHelper.load((String)"ent_prodpool", (String)"id,protocol,goods,isgoodvisible,entryentity.orgname", (QFilter[])new QFilter[]{new QFilter("goods", "in", (Object)relateProtocolOpProdIdSet)});
            StringBuilder sb = this.checkOrgIntersection(prodPoolDynArray, (DynamicObject)pmmProtocolDynColl.get(0), protocolOrgSet);
            if (sb.length() > 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u90e8\u5206\u5546\u54c1\u7684\u534f\u8bae\u6709\u6548\u671f\u5b58\u5728\u4ea4\u53c9\uff0c\u65e0\u6cd5\u63d0\u4ea4\uff0c\u8bf7\u67e5\u770b\u8be6\u60c5\u3002", (String)"EntProdManageProdPoolList_3", (String)"scm-ent-formplugin", (Object[])new Object[0]), sb.toString(), MessageTypes.Default);
                return;
            }
            Long supplierId = prodPoolDynArray[0].getDynamicObject("goods").getDynamicObject(CACHE_SUPPLIER).getLong("id");
            ArrayList prodIdList = new ArrayList(relateProtocolOpProdIdSet.size());
            relateProtocolOpProdIdSet.forEach(prodId -> prodIdList.add(String.valueOf(prodId)));
            HashMap<String, Object> param = new HashMap<String, Object>(8);
            String selectCols = String.join((CharSequence)",", prodIdList);
            param.put(CACHE_ALL_PROD, selectCols);
            param.put(CACHE_SUPPLIER, supplierId);
            param.put("protocolId", primaryKeyValue);
            this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)"ent_prodrequest", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.ADDNEW, (long)0L, param, null));
        }
    }

    private StringBuilder checkOrgIntersection(DynamicObject[] prodPoolDynArray, DynamicObject pmmProtocolDyn, Set<Long> protocolOrgSet) {
        StringBuilder sb = new StringBuilder();
        for (DynamicObject prodPoolDyn : prodPoolDynArray) {
            DynamicObject protocol = prodPoolDyn.getDynamicObject("protocol");
            DynamicObject goods = prodPoolDyn.getDynamicObject("goods");
            if (protocol == null || "C".equals(protocol.getString("protocolstatus")) || "D".equals(protocol.getString("protocolstatus")) || !this.checkProtocolDateIntersection(protocol, pmmProtocolDyn)) continue;
            if (prodPoolDyn.getBoolean("isgoodvisible") || pmmProtocolDyn.getBoolean("isgoodvisible")) {
                sb.append(String.format(ResManager.loadKDString((String)"\u534f\u8bae\u7f16\u53f7\uff1a%1$s\uff0c\u5c65\u7ea6\u5355\u4f4d\uff1a%2$s\uff0c\u751f\u6548\u671f\u95f4\uff1a%3$s~%4$s\uff0c\u5546\u54c1\u7f16\u53f7\uff1a%5$s", (String)"EntProdManageProdPoolList_2", (String)"scm-ent-formplugin", (Object[])new Object[0]), protocol.getString("billno"), protocol.getDynamicObject("org").getString("name"), DateUtil.date2str((Date)protocol.getDate("effectdate"), (String)"yyyy-MM-dd"), DateUtil.date2str((Date)protocol.getDate("invaliddate"), (String)"yyyy-MM-dd"), goods.getString("number")));
                continue;
            }
            DynamicObjectCollection entryEntity = prodPoolDyn.getDynamicObjectCollection("entryentity");
            HashSet<Long> poolOrgSet = new HashSet<Long>(entryEntity.size());
            for (DynamicObject dynamicObject : entryEntity) {
                poolOrgSet.add(dynamicObject.getDynamicObject("orgname").getLong("id"));
            }
            for (Long protocolOrgId : protocolOrgSet) {
                if (!poolOrgSet.contains(protocolOrgId)) continue;
                sb.append(String.format(ResManager.loadKDString((String)"\u534f\u8bae\u7f16\u53f7\uff1a%1$s\uff0c\u5c65\u7ea6\u5355\u4f4d\uff1a%2$s\uff0c\u751f\u6548\u671f\u95f4\uff1a%3$s~%4$s\uff0c\u5546\u54c1\u7f16\u53f7\uff1a%5$s", (String)"EntProdManageProdPoolList_2", (String)"scm-ent-formplugin", (Object[])new Object[0]), protocol.getString("billno"), protocol.getDynamicObject("org").getString("name"), DateUtil.date2str((Date)protocol.getDate("effectdate"), (String)"yyyy-MM-dd"), DateUtil.date2str((Date)protocol.getDate("invaliddate"), (String)"yyyy-MM-dd"), goods.getString("number")));
            }
        }
        return sb;
    }

    private boolean checkProtocolDateIntersection(DynamicObject protocol, DynamicObject pmmProtocolDyn) {
        Date oldEffectDate = protocol.getDate("effectdate");
        Date oldInvalidDate = protocol.getDate("invaliddate");
        Date newEffectDate = pmmProtocolDyn.getDate("effectdate");
        Date newInvalidDate = pmmProtocolDyn.getDate("invaliddate");
        if (oldInvalidDate == null && newInvalidDate == null) {
            return true;
        }
        if (oldInvalidDate == null && newInvalidDate.after(oldEffectDate)) {
            return true;
        }
        if (newInvalidDate == null && oldInvalidDate.after(newEffectDate)) {
            return true;
        }
        if (oldInvalidDate != null && newInvalidDate != null) {
            return newEffectDate.compareTo(oldEffectDate) >= 0 && newEffectDate.compareTo(oldInvalidDate) <= 0 || newInvalidDate.compareTo(oldEffectDate) >= 0 && newInvalidDate.compareTo(oldInvalidDate) <= 0;
        }
        return false;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        BillList list = (BillList)this.getView().getControl("billlistap");
        Object entryPrimaryKeyValue = list.getCurrentSelectedRowInfo().getEntryPrimaryKeyValue();
        if ("protocol_protocolname".equals(fieldName)) {
            args.setCancel(true);
            DynamicObject prodDynColl = QueryServiceHelper.queryOne((String)"ent_prodmanage", (String)"protocolentry.id,protocolentry.protocol protocol", (QFilter[])new QFilter[]{new QFilter("protocolentry.id", "=", entryPrimaryKeyValue)});
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId("ent_protocol");
            showParameter.setPkId((Object)prodDynColl.getLong("protocol"));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private boolean checkHasProtocolViewPermission() {
        String appId = AppMetadataCache.getAppInfo((String)"ent").getId();
        boolean hasPermResult = PermissionServiceHelper.checkPermission((Long)UserServiceHelper.getCurrentUserId(), (String)appId, (String)"ent_protocol", (String)"47150e89000000ac");
        if (!hasPermResult) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u534f\u8bae\u67e5\u8be2\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"EntProdManageProdPoolList_27", (String)"scm-ent-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

