/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.business.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.ent.business.model.prod.Sku;
import kd.scm.ent.business.service.EntProdManageAuditService;

public class EntProdManageAuditServiceImpl
implements EntProdManageAuditService {
    @Override
    public Map<String, Object> writeBackSpu(List<Sku> skuLists) {
        DynamicObject[] prods;
        HashMap<String, Object> res = new HashMap<String, Object>(8);
        if (skuLists == null || skuLists.isEmpty()) {
            return res;
        }
        ArrayList<Sku> skuList = new ArrayList<Sku>(skuLists);
        StringBuilder error = new StringBuilder();
        ArrayList<String> spuList = new ArrayList<String>(skuList.size());
        HashMap<String, List> spuAndSkusMap = new HashMap<String, List>(skuList.size());
        for (Sku sku : skuList) {
            spuList.add(sku.getSpu());
            List skus = spuAndSkusMap.computeIfAbsent(sku.getSpu(), k -> new ArrayList());
            skus.add(sku);
        }
        QFilter qFilter = new QFilter("number", "in", spuList);
        DynamicObject[] spus = BusinessDataServiceHelper.load((String)"ent_spu", (String)"id,number,orgfield,supplier,baseattributeentry.prodattributevalue,spuatrdetailentry.saleprodattributevalueid,spuskumapentry.goods", (QFilter[])qFilter.toArray());
        for (DynamicObject spu : spus) {
            List skus = (List)spuAndSkusMap.remove(spu.getString("number"));
            this.RemoveSkuDifferentFromSpu(skus, spu, error);
            if (skus.isEmpty()) continue;
            this.setSkuToSkuEntryOrRemove(skus, spu, error);
            for (Sku sku : skus) {
                error.append(ResManager.loadKDString((String)"{0}\uff1aSKU\u5546\u54c1\u53c2\u6570\u672a\u5305\u542bSPU\u5546\u54c1\u5c5e\u6027\u3002", (String)"EntProdManageAuditServiceImpl_4", (String)"scm-ent-business", (Object[])new Object[]{sku.getNumber()})).append("\n");
            }
        }
        for (Map.Entry entry : spuAndSkusMap.entrySet()) {
            List skus = (List)entry.getValue();
            for (Sku sku : skus) {
                error.append(ResManager.loadKDString((String)"{0}\uff1aSPU\u5df2\u88ab\u5220\u9664\u3002", (String)"EntProdManageAuditServiceImpl_5", (String)"scm-ent-business", (Object[])new Object[]{sku.getNumber()})).append("\n");
            }
        }
        SaveServiceHelper.save((DynamicObject[])spus);
        for (DynamicObject prod : prods = BusinessDataServiceHelper.load((String)"ent_prodmanage", (String)"spunumber", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)skuList.stream().map(Sku::getId).toArray())})) {
            prod.set("spunumber", (Object)" ");
        }
        SaveServiceHelper.save((DynamicObject[])prods);
        if (error.length() > 0) {
            res.put("msg", error);
        }
        return res;
    }

    private void RemoveSkuDifferentFromSpu(List<Sku> skus, DynamicObject spu, StringBuilder error) {
        long spuOrgId = spu.getLong("orgfield_id");
        long spuSupId = spu.getLong("supplier_id");
        List<Long> spuBaseAttributeValues = spu.getDynamicObjectCollection("baseattributeentry").stream().map(entry -> entry.getLong("prodattributevalue_id")).collect(Collectors.toList());
        Iterator<Sku> iterator = skus.iterator();
        while (iterator.hasNext()) {
            Sku sku = iterator.next();
            if (spuOrgId != sku.getCreateOrg()) {
                error.append(ResManager.loadKDString((String)"{0}\uff1aSKU\u7684\u91c7\u8d2d\u7ec4\u7ec7\u4e0eSPU\u5ba1\u6279\u7ec4\u7ec7\u4e0d\u4e00\u81f4\u3002", (String)"EntProdManageAuditServiceImpl_0", (String)"scm-ent-business", (Object[])new Object[]{sku.getNumber()})).append("\n");
                iterator.remove();
                continue;
            }
            if (spuSupId != sku.getSupplier()) {
                error.append(ResManager.loadKDString((String)"{0}\uff1aSKU\u7684\u91c7\u8d2d\u7ec4\u7ec7\u4e0eSPU\u6240\u5c5e\u5546\u5bb6\u4e0d\u4e00\u81f4\u3002", (String)"EntProdManageAuditServiceImpl_1", (String)"scm-ent-business", (Object[])new Object[]{sku.getNumber()})).append("\n");
                iterator.remove();
                continue;
            }
            if (this.skuCheckSpuBaseAttribute(spuBaseAttributeValues, sku.getBaseAttributeValues())) continue;
            error.append(ResManager.loadKDString((String)"{0}\uff1aSKU\u5546\u54c1\u53c2\u6570\u672a\u5305\u542bSPU\u5546\u54c1\u5c5e\u6027\u3002", (String)"EntProdManageAuditServiceImpl_2", (String)"scm-ent-business", (Object[])new Object[]{sku.getNumber()})).append("\n");
            iterator.remove();
        }
    }

    private void setSkuToSkuEntryOrRemove(List<Sku> skus, DynamicObject spu, StringBuilder error) {
        DynamicObjectCollection spuskumapentry = spu.getDynamicObjectCollection("spuskumapentry");
        for (DynamicObject entry : spuskumapentry) {
            DynamicObjectCollection spuatrdetailentry = entry.getDynamicObjectCollection("spuatrdetailentry");
            List spuEntryAttributeValues = spuatrdetailentry.stream().map(k -> k.getLong("saleprodattributevalueid_id")).collect(Collectors.toList());
            Iterator<Sku> iterator = skus.iterator();
            while (iterator.hasNext()) {
                Sku sku = iterator.next();
                Set<Long> skuSaleAttributeValues = sku.getSaleAttributeValues();
                boolean isContain = true;
                for (Long spuEntryAttributeValue : spuEntryAttributeValues) {
                    if (skuSaleAttributeValues.contains(spuEntryAttributeValue)) continue;
                    isContain = false;
                    break;
                }
                if (!isContain) continue;
                if (entry.getDynamicObject("goods") != null) {
                    error.append(ResManager.loadKDString((String)"{0}\uff1a\u5173\u8054SKU\u5206\u5f55\u5df2\u5173\u8054\u5176\u4ed6SKU\u3002", (String)"EntProdManageAuditServiceImpl_3", (String)"scm-ent-business", (Object[])new Object[]{sku.getNumber()})).append("\n");
                } else {
                    entry.set("goods_id", (Object)sku.getId());
                }
                iterator.remove();
            }
        }
    }

    private boolean skuCheckSpuBaseAttribute(List<Long> spuBaseAttributeValues, Set<Long> skuBaseAttributeValues) {
        for (Long spuBaseAttributeValue : spuBaseAttributeValues) {
            if (skuBaseAttributeValues.contains(spuBaseAttributeValue)) continue;
            return false;
        }
        return true;
    }
}

