/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.opplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.BizPartnerUtil;

public class EntInventoryImport
implements IImportPlugin {
    private static final Log logger = LogFactory.getLog(EntInventoryImport.class);

    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        boolean flag = true;
        Object goods = data.get("goods");
        DynamicObject goodsFull = null;
        HashSet<Long> pkIds = new HashSet<Long>();
        if (goods instanceof JSONObject) {
            pkIds.addAll(this.checkGoodsInv((JSONObject)goods));
        }
        if (pkIds.size() > 0) {
            ImportLogger.ImportLog importLog = new ImportLogger.ImportLog("id", ResManager.loadKDString((String)"\u672c\u5546\u54c1\u5df2\u7ecf\u5728\u5e93\u5b58\u5217\u8868\u5b58\u5728\uff0c\u8bf7\u4f7f\u7528\u5e93\u5b58\u8c03\u6574\u4fee\u6539\u5e93\u5b58\u91cf\u3002", (String)"EntInventoryImport_0", (String)"scm-ent-opplugin", (Object[])new Object[0]));
            importlogs.add(importLog);
            flag = false;
            return flag;
        }
        if (goods instanceof JSONObject) {
            goodsFull = this.checkGoods((JSONObject)goods);
        }
        if (goodsFull != null && flag) {
            Long category_id = goodsFull.getLong("category_id");
            HashMap<String, Long> classData = new HashMap<String, Long>(1);
            classData.put("id", category_id);
            data.put("goodsclass", classData);
            Long unit_id = goodsFull.getLong("unit_id");
            HashMap<String, Long> unitData = new HashMap<String, Long>(1);
            unitData.put("id", unit_id);
            data.put("unit", unitData);
            Long bizpartner_id = goodsFull.getLong("bizpartner_id");
            Long supplier_id = goodsFull.getLong("supplier_id");
            HashMap<String, Long> supplierData = new HashMap<String, Long>(1);
            HashMap<String, Long> bizPartnerData = new HashMap<String, Long>(1);
            supplierData.put("id", supplier_id);
            data.put("supplier", supplierData);
            bizPartnerData.put("id", bizpartner_id);
            data.put("bizpartner", bizPartnerData);
        } else {
            ImportLogger.ImportLog importLog = new ImportLogger.ImportLog("id", ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u6ca1\u6709\u8be5\u5546\u54c1\u6216\u8005\u4f60\u7684\u516c\u53f8\u672a\u6ce8\u518c\u8be5\u5546\u54c1\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u5e93\u5b58\u3002", (String)"EntInventoryImport_1", (String)"scm-ent-opplugin", (Object[])new Object[0]));
            importlogs.add(importLog);
            flag = false;
        }
        return flag;
    }

    private DynamicObject checkGoods(JSONObject goods) {
        QFilter qFilter = new QFilter("bizpartner", "in", (Object)BizPartnerUtil.getBizPartnerIds());
        JSONObject jsonObject = goods;
        if (jsonObject.containsKey((Object)"name")) {
            qFilter.and(new QFilter("name", "=", (Object)jsonObject.getString("name")));
        }
        if (jsonObject.containsKey((Object)"number")) {
            qFilter.and(new QFilter("number", "=", (Object)jsonObject.getString("number")));
        }
        ArrayList pkIds = new ArrayList(1);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"EntInventoryImport", (String)"ent_prodmanage", (String)"id", (QFilter[])new QFilter[]{qFilter}, (String)"id", (int)1);){
            dataSet.forEach(row -> pkIds.add(row.getLong("id")));
        }
        DynamicObject ent_prodmanage = null;
        if (!pkIds.isEmpty()) {
            ent_prodmanage = BusinessDataServiceHelper.loadSingle(pkIds.get(0), (String)"ent_prodmanage");
        }
        return ent_prodmanage;
    }

    private Set<Long> checkGoodsInv(JSONObject goods) {
        QFilter qFilter = null;
        JSONObject jsonObject = goods;
        if (jsonObject.containsKey((Object)"name")) {
            qFilter = new QFilter("goods.name", "=", (Object)jsonObject.getString("name"));
        }
        if (jsonObject.containsKey((Object)"number")) {
            qFilter = new QFilter("goods.number", "=", (Object)jsonObject.getString("number"));
        }
        HashSet<Long> pkIds = new HashSet<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"EntInventoryImport", (String)"ent_inventory", (String)"id", (QFilter[])new QFilter[]{qFilter}, (String)"id");){
            dataSet.forEach(row -> pkIds.add(row.getLong("id")));
        }
        return pkIds;
    }
}

