/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.scm.ent.opplugin.validator.EntPriceReqSubmitValidator;

public class EntPriceRequestSubmitPlugin
extends AbstractOperationServicePlugIn {
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        String key = e.getOperationKey();
        DynamicObject[] objs = e.getDataEntities();
        if (objs.length == 0) {
            return;
        }
        if ("submit".equalsIgnoreCase(key)) {
            for (DynamicObject obj : objs) {
                obj.set("cfmstatus", (Object)"A");
                long id = obj.getLong("id");
                if (id == 0L) {
                    objs[0].set("cfmstatus", (Object)"A");
                    return;
                }
                DynamicObjectCollection entrys = obj.getDynamicObjectCollection("entryentity");
                for (DynamicObject row : entrys) {
                    if (!"A".equals(row.getString("pricetype"))) continue;
                    DynamicObjectCollection subentryentity = row.getDynamicObjectCollection("subentryentity");
                    subentryentity.clear();
                    row.set("subentryentity", (Object)subentryentity);
                }
            }
            this.updatePriceChange(objs);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new EntPriceReqSubmitValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("goods");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("cfmstatus");
        e.getFieldKeys().add("number");
        e.getFieldKeys().add("entryentity.goods.number");
        e.getFieldKeys().add("entryentity.prodpool");
        e.getFieldKeys().add("entryentity.prodpool.mallstatus");
        e.getFieldKeys().add("entryentity.seq");
        e.getFieldKeys().add("entryentity.pricetype");
        e.getFieldKeys().add("subentryentity.qtyfrom");
    }

    private void updatePriceChange(DynamicObject[] objs) {
        HashMap<Long, List> prodPoolIdAndEntryDynMap = new HashMap<Long, List>(1024);
        for (DynamicObject obj : objs) {
            DynamicObjectCollection col = obj.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : col) {
                DynamicObject prodPool = entry.getDynamicObject("prodpool");
                List dynamicObjects = prodPoolIdAndEntryDynMap.computeIfAbsent(prodPool.getLong("id"), s -> new ArrayList(col.size()));
                dynamicObjects.add(entry);
            }
        }
        QFilter qFilter = new QFilter("id", "in", prodPoolIdAndEntryDynMap.keySet());
        DynamicObjectCollection prodPools = QueryServiceHelper.query((String)"ent_prodpool", (String)"id,taxprice,price,taxrate", (QFilter[])qFilter.toArray());
        for (DynamicObject prodPool : prodPools) {
            List dynamicObjects = (List)prodPoolIdAndEntryDynMap.get(prodPool.getLong("id"));
            for (DynamicObject entry : dynamicObjects) {
                entry.set("taxprice_old", (Object)prodPool.getBigDecimal("taxprice"));
                entry.set("price_old", (Object)prodPool.getBigDecimal("price"));
                entry.set("shopprice_old", (Object)prodPool.getBigDecimal("taxprice"));
                entry.set("taxrate", (Object)prodPool.getBigDecimal("taxrate"));
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String operationKey = e.getOperationKey();
        if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"submit")) {
            Object id = e.getDataEntities()[0].get("id");
            WorkflowServiceHelper.tryTriggerProcess((String)id.toString(), (String)"submit", (String)"pmm_priceaudit", null);
        }
    }
}

