/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.opplugin;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.cal.CalculateUtils;

public class EntProdImport
implements IImportPlugin {
    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        boolean flag = false;
        if (null != data.get("category")) {
            String catNumber = String.valueOf(((Map)data.get("category")).get("number"));
            String longNumber = this.getCatLongnumber(catNumber);
            if (StringUtils.isNotBlank((CharSequence)longNumber)) {
                data.put("catlongnumber", longNumber);
                flag = true;
            } else {
                importlogs.add(new ImportLogger.ImportLog("\u5546\u54c1\u5206\u7c7b\u5e94\u4e3a\u4e09\u7ea7\u5206\u7c7b"));
            }
        }
        Object taxprice = data.get("taxprice");
        BigDecimal bigtaxprice = new BigDecimal(String.valueOf(taxprice));
        data.put("shopprice", bigtaxprice);
        DynamicObject taxrateDyo = null;
        Map taxrateNumber = (Map)data.get("taxrateid");
        if (taxrateNumber != null) {
            taxrateDyo = QueryServiceHelper.queryOne((String)"bd_taxrate", (String)"taxrate", (QFilter[])new QFilter[]{new QFilter("number", "=", taxrateNumber.get("number"))});
        } else {
            importlogs.add(new ImportLogger.ImportLog("\u8bf7\u586b\u5199\u7a0e\u7387\u7f16\u7801"));
        }
        if (null != taxrateDyo) {
            BigDecimal bigtaxrate = taxrateDyo.getBigDecimal("taxrate");
            BigDecimal calPrice = CalculateUtils.calPrice((BigDecimal)bigtaxprice, (BigDecimal)bigtaxrate, (int)2);
            data.put("price", calPrice);
            data.put("taxrate", bigtaxrate);
        } else {
            data.put("price", bigtaxprice);
        }
        Object origin = data.get("origin");
        if (StringUtils.isBlank((Object)origin)) {
            data.put("origin", "1");
        }
        return flag;
    }

    public String getCatLongnumber(String catNumber) {
        QFilter numberFilter = new QFilter("number", "=", (Object)catNumber);
        QFilter levelFilter = new QFilter("level", "=", (Object)3);
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"mdr_goodsclass", (String)"longnumber", (QFilter[])new QFilter[]{numberFilter, levelFilter});
        return dyn != null ? dyn.getString("longnumber") : "";
    }
}

