/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.ent.opplugin.validator.EntProdProtocolValidator;
import kd.scm.ent.opplugin.validator.EntProdRequestBarcodeValidator;
import kd.scm.ent.opplugin.validator.EntProdRequestProtocolUniqueValidator;
import kd.scm.ent.opplugin.validator.EntProdRequestProtocolValidator;
import kd.scm.ent.opplugin.validator.EntProdRequestSubmitValidator;

public class EntProdRequestSubmitPlugin
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(EntProdRequestSubmitPlugin.class);

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        String key = e.getOperationKey();
        DynamicObject[] objs = e.getDataEntities();
        if (objs.length == 0) {
            return;
        }
        if ("submit".equalsIgnoreCase(key)) {
            for (DynamicObject obj : objs) {
                Long id = obj.getLong("id");
                if (id == 0L) {
                    objs[0].set("cfmstatus", (Object)"A");
                    return;
                }
                DynamicObjectCollection entrys = obj.getDynamicObjectCollection("entryentity");
                for (DynamicObject row : entrys) {
                    if (!"A".equals(row.getString("pricetype"))) continue;
                    DynamicObjectCollection subentryentity = row.getDynamicObjectCollection("subentryentity");
                    subentryentity.clear();
                    row.set("subentryentity", (Object)subentryentity);
                }
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String operationKey = e.getOperationKey();
        if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"submit")) {
            Object id = e.getDataEntities()[0].get("id");
            WorkflowServiceHelper.tryTriggerProcess((String)id.toString(), (String)"submit", (String)"pmm_prodaudit", null);
        }
        DynamicObject[] objs = e.getDataEntities();
        ArrayList<Long> ids = new ArrayList<Long>((int)((double)objs.length / 0.75));
        HashMap<Long, DynamicObject> goodsMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject obj : objs) {
            long id = obj.getLong("id");
            DynamicObjectCollection entries = obj.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entries) {
                DynamicObject goods = entry.getDynamicObject("goods");
                if (goods == null || !"A".equals(goods.getString("status"))) continue;
                goodsMap.put(goods.getLong("id"), entry);
            }
            if (id == 0L) {
                objs[0].set("cfmstatus", (Object)"A");
                return;
            }
            ids.add(id);
        }
        this.setCfmstatus(ids, goodsMap);
    }

    public void setCfmstatus(List ids, HashMap<Long, DynamicObject> goodsMap) {
        DynamicObject[] sups;
        QFilter filter = new QFilter("id", "in", (Object)ids);
        QFilter[] filters = new QFilter[]{filter};
        for (DynamicObject sup : sups = BusinessDataServiceHelper.load((String)"ent_prodrequest", (String)"cfmstatus,entryentity.goods", (QFilter[])filters)) {
            sup.set("cfmstatus", (Object)"A");
        }
        this.setProductTaxprice(goodsMap);
        SaveServiceHelper.save((DynamicObject[])sups);
    }

    public void setProductTaxprice(HashMap<Long, DynamicObject> goodsMap) {
        DynamicObject[] goodses;
        QFilter goodsfilter1 = new QFilter("id", "in", goodsMap.keySet());
        QFilter goodsfilter2 = new QFilter("status", "=", (Object)"A");
        QFilter[] goodsfilters = new QFilter[]{goodsfilter1.and(goodsfilter2)};
        String sectlors = DynamicObjectUtil.getSelectfields((String)"ent_prodmanage", (boolean)false);
        sectlors = DynamicObjectUtil.getEntrySelectfields((String)sectlors, (String)"ent_prodmanage", (String)"protocolentry", (boolean)false);
        for (DynamicObject goods : goodses = BusinessDataServiceHelper.load((String)"ent_prodmanage", (String)sectlors, (QFilter[])goodsfilters)) {
            DynamicObject billGoods = goodsMap.get(goods.getLong("id"));
            if (billGoods == null) continue;
            goods.set("taxprice", billGoods.get("taxprice"));
            goods.set("price", billGoods.get("price"));
            goods.set("shopprice", billGoods.get("shopprice"));
        }
        if (goodses.length > 0) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", String.valueOf(true));
            option.setVariableValue("isStrict", String.valueOf(false));
            OperationResult saveOpRes = OperationServiceHelper.executeOperate((String)"save", (String)"ent_prodmanage", (DynamicObject[])goodses, (OperateOption)option);
            if (!saveOpRes.isSuccess()) {
                log.info(ExceptionUtil.getErrorInfoDetails((List)saveOpRes.getAllErrorOrValidateInfo()));
            }
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new EntProdRequestSubmitValidator());
        e.addValidator((AbstractValidator)new EntProdRequestProtocolValidator());
        e.addValidator((AbstractValidator)new EntProdProtocolValidator());
        e.addValidator((AbstractValidator)new EntProdRequestProtocolUniqueValidator());
        e.addValidator((AbstractValidator)new EntProdRequestBarcodeValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("goods");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("cfmstatus");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("protocolid");
        e.getFieldKeys().add("protocolid.differentarea");
        e.getFieldKeys().add("biztype");
        e.getFieldKeys().add("protocolid.billno");
        e.getFieldKeys().add("protocolid.name");
        e.getFieldKeys().add("protocolid.protocolstatus");
        e.getFieldKeys().add("entryentity.goods");
        e.getFieldKeys().add("entryentity.goods.name");
        e.getFieldKeys().add("entryentity.goods.status");
        e.getFieldKeys().add("entryentity.class");
        e.getFieldKeys().add("entryentity.taxprice");
        e.getFieldKeys().add("entryentity.price");
        e.getFieldKeys().add("entryentity.shopprice");
        e.getFieldKeys().add("entryentity.protocolentry");
        e.getFieldKeys().add("entryentity.goods.number");
        e.getFieldKeys().add("entryentity.goods.thumbnail");
        e.getFieldKeys().add("entryentity.priceeffectdate");
        e.getFieldKeys().add("entryentity.priceinvaliddate");
        e.getFieldKeys().add("subentryentity.qtyfrom");
        e.getFieldKeys().add("entryentity.pricetype");
        e.getFieldKeys().add("entryentity.seq");
        e.getFieldKeys().add("entryentity.barcode");
        e.getFieldKeys().add("supplier");
        e.getFieldKeys().add("entryentity.protocolentry.purplanid.id");
    }
}

