/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.opplugin;

import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.ent.opplugin.validator.EntProdUnAuditValidator;

public class EntProdUnauditPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("auditor");
        fieldKeys.add("auditdate");
        fieldKeys.add("number");
        fieldKeys.add("origin");
        fieldKeys.add("spunumber");
        fieldKeys.add("protocolentry.prodpool");
        fieldKeys.add("protocolentry.prodpool.mallstatus");
        fieldKeys.add("protocolentry.protocol");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new EntProdUnAuditValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            dataEntity.set("auditor", null);
            dataEntity.set("auditdate", null);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        this.deleteProdPoolRelation(dataEntities);
    }

    private void deleteProdPoolRelation(DynamicObject[] dataEntities) {
        DynamicObject[] prodPools;
        HashSet<Long> prodPoolAndProdMap = new HashSet<Long>(dataEntities.length);
        for (DynamicObject dynamicObject : dataEntities) {
            DynamicObjectCollection protocolEntry = dynamicObject.getDynamicObjectCollection("protocolentry");
            for (DynamicObject entry : protocolEntry) {
                prodPoolAndProdMap.add(entry.getDynamicObject("prodpool").getLong("id"));
            }
        }
        for (DynamicObject prodPool : prodPools = BusinessDataServiceHelper.load((String)"pmm_prodpool", (String)"id,goods", (QFilter[])new QFilter[]{new QFilter("id", "in", prodPoolAndProdMap)})) {
            prodPool.set("goods", null);
        }
        SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])prodPools);
    }
}

