/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.opplugin;

import java.util.Date;
import java.util.HashSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.DateUtil;

public class EntProtocolConfirmOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("protocolstatus");
        e.getFieldKeys().add("confirmstatus");
        e.getFieldKeys().add("effectdate");
        e.getFieldKeys().add("invaliddate");
        e.getFieldKeys().add("confirmor");
        e.getFieldKeys().add("confirmdate");
        e.getFieldKeys().add("prosource");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities;
        super.afterExecuteOperationTransaction(e);
        HashSet<Long> idSet = new HashSet<Long>(1024);
        for (DynamicObject dyn : dataEntities = e.getDataEntities()) {
            idSet.add(dyn.getLong("id"));
        }
        QFilter qFilter = new QFilter("id", "in", idSet);
        String selectors = "effectdate,invaliddate,protocolstatus,confirmstatus,confirmor,confirmdate,prosource";
        DynamicObject[] priceprotocols = BusinessDataServiceHelper.load((String)"ent_protocol", (String)selectors, (QFilter[])qFilter.toArray());
        Date curDate = TimeServiceHelper.now();
        for (DynamicObject dyn : priceprotocols) {
            Date effectdate = dyn.getDate("effectdate");
            Date invaliddate = dyn.getDate("invaliddate");
            String prosource = dyn.getString("prosource");
            if ("2".equals(prosource) || effectdate.before(curDate) && (null == invaliddate || null != invaliddate && DateUtil.string2date((String)DateUtil.getFormatEndDate((Date)invaliddate), (String)"yyyy-MM-dd HH:mm:ss").after(curDate))) {
                dyn.set("protocolstatus", (Object)"B");
            }
            if (!"2".equals(prosource) && DateUtil.string2date((String)DateUtil.getFormatEndDate((Date)invaliddate), (String)"yyyy-MM-dd HH:mm:ss").before(curDate)) {
                dyn.set("protocolstatus", (Object)"C");
            }
            dyn.set("confirmstatus", (Object)"C");
            dyn.set("confirmor", (Object)RequestContext.get().getCurrUserId());
            dyn.set("confirmdate", (Object)curDate);
        }
        if (priceprotocols.length > 0) {
            SaveServiceHelper.save((DynamicObject[])priceprotocols);
        }
    }
}

