/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.opplugin.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.malcore.domain.GoodsInventory;
import kd.scm.malcore.domain.GoodsInventoryHandleSku;

public class EntInstackSubmitValidator
extends AbstractValidator {
    public void validate() {
        Object entryentity;
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        HashMap<Long, ExtendedDataEntity> goodsIdAndDynMap = new HashMap<Long, ExtendedDataEntity>(extendedDataEntities.length);
        HashMap<Long, GoodsInventoryHandleSku> goodsIdAndQtyMap = new HashMap<Long, GoodsInventoryHandleSku>(extendedDataEntities.length);
        HashMap<Long, BigDecimal> goodsIdAndCurrentQtyMap = new HashMap<Long, BigDecimal>(extendedDataEntities.length);
        ArrayList<GoodsInventoryHandleSku> skuList = new ArrayList<GoodsInventoryHandleSku>(extendedDataEntities.length);
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dynamicObject = extendedDataEntity.getDataEntity();
            entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            Iterator iterator = entryentity.iterator();
            while (iterator.hasNext()) {
                DynamicObject entry = (DynamicObject)iterator.next();
                DynamicObject goods = entry.getDynamicObject("goods");
                if (goods == null) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u90e8\u5206\u5546\u54c1\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"EntInstackSubmitValidator_1", (String)"scm-ent-opplugin", (Object[])new Object[0]));
                    return;
                }
                if (!BillStatusEnum.AUDIT.getVal().equals(goods.getString("status"))) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5546\u54c1{0}\u6570\u636e\u72b6\u6001\u4e0d\u662f\u5df2\u5ba1\u6838\uff0c\u4e0d\u80fd\u8fdb\u884c\u5e93\u5b58\u8c03\u6574\u3002", (String)"EntInstackSubmitValidator_2", (String)"scm-ent-opplugin", (Object[])new Object[]{goods.getString("number")}));
                }
                long goodsId = entry.getLong("goods_id");
                GoodsInventoryHandleSku sku = new GoodsInventoryHandleSku();
                sku.setGoodsId(Long.valueOf(goodsId));
                sku.setGoodsNumber(goods.getString("number"));
                sku.setQty(entry.getBigDecimal("newqty"));
                skuList.add(sku);
                goodsIdAndDynMap.put(goodsId, extendedDataEntity);
                goodsIdAndQtyMap.put(goodsId, sku);
                goodsIdAndCurrentQtyMap.put(goodsId, entry.getBigDecimal("currentqty"));
            }
        }
        List goodsInventories = (List)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pmm", (String)"IPmmGoodsInventoryService", (String)"queryGoodsInventory", (Object[])new Object[]{skuList});
        List noInventoryGoodsIds = goodsInventories.stream().filter(GoodsInventory::isUnlimited).map(GoodsInventory::getGoodsId).collect(Collectors.toList());
        HashMap goodsIdAndMalOrderQtyMap = new HashMap(noInventoryGoodsIds.size());
        QFilter qFilter = new QFilter("entryentity.goods", "in", noInventoryGoodsIds);
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.SUBMIT.getVal());
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mal_order", (String)"entryentity.goods goods,entryentity.qty qty", (QFilter[])qFilter.toArray(), null);
        entryentity = null;
        try {
            dataSet.forEach(row -> {
                BigDecimal qty = goodsIdAndMalOrderQtyMap.getOrDefault(row.getLong("goods"), BigDecimal.ZERO);
                qty = qty.add(row.getBigDecimal("qty"));
                goodsIdAndMalOrderQtyMap.put(row.getLong("goods"), qty);
            });
        }
        catch (Throwable throwable) {
            entryentity = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (entryentity != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)entryentity).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        for (GoodsInventory goodsInventory : goodsInventories) {
            GoodsInventoryHandleSku sku = (GoodsInventoryHandleSku)goodsIdAndQtyMap.get(goodsInventory.getGoodsId());
            ExtendedDataEntity extendedDataEntity = (ExtendedDataEntity)goodsIdAndDynMap.get(goodsInventory.getGoodsId());
            BigDecimal lockedQty = goodsInventory.isUnlimited() ? goodsIdAndMalOrderQtyMap.getOrDefault(goodsInventory.getGoodsId(), BigDecimal.ZERO) : goodsInventory.getLockedQty();
            if (sku.getQty().compareTo(lockedQty) < 0) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5546\u54c1{0}\u8c03\u6574\u540e\u6570\u91cf\u987b>=\u9501\u5b9a\u5e93\u5b58\u91cf\u3002", (String)"EntInstackSubmitValidator_0", (String)"scm-ent-opplugin", (Object[])new Object[]{sku.getGoodsNumber(), lockedQty}));
            }
            BigDecimal currentqty = (BigDecimal)goodsIdAndCurrentQtyMap.get(goodsInventory.getGoodsId());
            if (goodsInventory.getCurrentQty().compareTo(currentqty) == 0) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5546\u54c1{0}\u73b0\u6709\u5e93\u5b58\u91cf\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", (String)"EntInstackSubmitValidator_3", (String)"scm-ent-opplugin", (Object[])new Object[]{sku.getGoodsNumber()}));
        }
    }
}

