/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.opplugin.validator;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.malcore.enums.MallStatusEnum;

public class EntProdProtocolValidator
extends AbstractValidator {
    private static String BIZTYPE_UPLOAD = "1";
    private static String BIZTYPE_DOWNLOAD = "2";

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        HashSet<Long> uploadProdIds = new HashSet<Long>(1024);
        HashSet<Long> downloadProdIds = new HashSet<Long>(1024);
        HashSet<Long> uploadProtocolIds = new HashSet<Long>(1024);
        HashSet<Long> downloadProtocolIds = new HashSet<Long>(1024);
        for (ExtendedDataEntity extendedDataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject dynamicObject = extendedDataEntity.getDataEntity();
            String biztype = dynamicObject.getString("biztype");
            Long protocolid = dynamicObject.getLong("protocolid_id");
            if (BIZTYPE_UPLOAD.equals(biztype)) {
                uploadProtocolIds.add(protocolid);
            } else if (BIZTYPE_DOWNLOAD.equals(biztype)) {
                downloadProtocolIds.add(protocolid);
            }
            DynamicObjectCollection entryCol = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject row : entryCol) {
                if (null == row.getDynamicObject("goods")) continue;
                Long goods = row.getDynamicObject("goods").getLong("id");
                if (BIZTYPE_UPLOAD.equals(biztype)) {
                    uploadProdIds.add(goods);
                    continue;
                }
                if (!BIZTYPE_DOWNLOAD.equals(biztype)) continue;
                downloadProdIds.add(goods);
            }
        }
        if (!uploadProdIds.isEmpty()) {
            this.check(uploadProdIds, uploadProtocolIds, BIZTYPE_UPLOAD);
        }
        if (!downloadProdIds.isEmpty()) {
            this.check(downloadProdIds, downloadProtocolIds, BIZTYPE_DOWNLOAD);
        }
    }

    private void check(Set<Long> prodIds, Set<Long> protocolIds, String biztype) {
        HashMap<String, Integer> progoodCountMap = new HashMap<String, Integer>(1024);
        QFilter qFilter = new QFilter("goods", "in", prodIds);
        qFilter.and(new QFilter("protocol", "in", protocolIds));
        if (BIZTYPE_UPLOAD.equals(biztype)) {
            qFilter.and(new QFilter("mallstatus", "=", (Object)MallStatusEnum.SOLD.getVal()).or("mallstatus", "=", (Object)MallStatusEnum.UNSOLD.getVal()));
        } else {
            qFilter.and("mallstatus", "not in", Arrays.asList(MallStatusEnum.SOLD.getVal(), MallStatusEnum.UNSOLD.getVal()));
        }
        DynamicObjectCollection prodPools = QueryServiceHelper.query((String)"ent_prodpool", (String)"goods,protocol,protocolentry", (QFilter[])qFilter.toArray());
        QFilter qfilter = new QFilter("entryentity.goods", "in", prodIds);
        qfilter.and(new QFilter("protocolid", "in", protocolIds));
        qfilter.and(new QFilter("cfmstatus", "=", (Object)"A"));
        if (BIZTYPE_UPLOAD.equals(biztype)) {
            qfilter.and("biztype", "=", (Object)BIZTYPE_UPLOAD);
        } else {
            qfilter.and("biztype", "=", (Object)BIZTYPE_DOWNLOAD);
        }
        DynamicObjectCollection prodRequests = QueryServiceHelper.query((String)"ent_prodrequest", (String)"entryentity.goods goods,protocolid protocol,entryentity.protocolentry protocolentry", (QFilter[])qfilter.toArray());
        prodPools.addAll((Collection)prodRequests);
        StringBuilder strBuffer = new StringBuilder();
        for (DynamicObject info : prodPools) {
            strBuffer.setLength(0);
            strBuffer.append(info.getLong("goods")).append('-').append(info.getLong("protocol")).append('-').append(info.getLong("protocolentry"));
            int count = 0;
            if (progoodCountMap.containsKey(strBuffer.toString())) {
                count = (Integer)progoodCountMap.get(strBuffer.toString());
            }
            progoodCountMap.put(strBuffer.toString(), ++count);
        }
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject dynamicObject = extendedDataEntity.getDataEntity();
            if (null != dynamicObject.getString("cfmstatus") && !dynamicObject.getString("cfmstatus").equals("E")) continue;
            String protocolName = "";
            if (dynamicObject.getDynamicObject("protocolid") != null) {
                protocolName = dynamicObject.getDynamicObject("protocolid").getString("billno");
            }
            Long protocolid = dynamicObject.getLong("protocolid_id");
            DynamicObjectCollection entryCol = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject row : entryCol) {
                int count;
                strBuffer.setLength(0);
                if (null == row.getDynamicObject("goods")) continue;
                Long goods = row.getDynamicObject("goods").getLong("id");
                String goodName = row.getDynamicObject("goods").getString("name");
                Long protocolentryId = row.getLong("protocolentry_id");
                strBuffer.append(goods).append('-').append(protocolid).append('-').append(protocolentryId);
                if (!progoodCountMap.containsKey(strBuffer.toString()) || (count = ((Integer)progoodCountMap.get(strBuffer.toString())).intValue()) < 1) continue;
                if (StringUtils.isNotBlank((CharSequence)protocolName) && BIZTYPE_UPLOAD.equals(biztype)) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5546\u54c1{0}\u5df2\u5173\u8054\u5546\u57ce\u534f\u8bae{1}\u6216\u6b63\u5728\u4e0a\u67b6\u7533\u8bf7\u4e2d", (String)"PmmProdProtocolValidator_0", (String)"scm-pmm-opplugin", (Object[])new Object[]{goodName, protocolName}));
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)protocolName) && BIZTYPE_UPLOAD.equals(biztype)) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5546\u54c1{0}\u5df2\u4e0a\u67b6\u6216\u6b63\u5728\u4e0a\u67b6\u7533\u8bf7\u4e2d", (String)"PmmProdProtocolValidator_1", (String)"scm-pmm-opplugin", (Object[])new Object[]{goodName}));
                    continue;
                }
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5546\u54c1{0}\u5df2\u4e0b\u67b6\u6216\u6b63\u5728\u4e0b\u67b6\u7533\u8bf7\u4e2d", (String)"PmmProdProtocolValidator_2", (String)"scm-pmm-opplugin", (Object[])new Object[]{goodName}));
            }
        }
    }
}

