/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.opplugin.validator;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class EntProdRequestSubmitValidator
extends AbstractValidator {
    public void validate() {
        HashMap<Long, String> prodMap = new HashMap<Long, String>();
        HashMap<String, Object> prodNumbers = new HashMap<String, Object>(this.dataEntities.length);
        HashMap<Long, Object> prodIdAndDynMap = new HashMap<Long, Object>(this.dataEntities.length);
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryEntity) {
                DynamicObject goods = entry.getDynamicObject("goods");
                if (goods == null || !dataEntity.getString("billstatus").equals("A")) continue;
                long prod_id = goods.getLong("id");
                prodNumbers.put(goods.getString("number"), extendedDataEntity);
                prodIdAndDynMap.put(prod_id, extendedDataEntity);
            }
        }
        QFilter prodQFilter = new QFilter("number", "in", prodNumbers.keySet());
        DynamicObjectCollection prods = QueryServiceHelper.query((String)"pmm_prodmanage", (String)"number", (QFilter[])prodQFilter.toArray());
        HashSet<String> numberCheck = new HashSet<String>(prods.size());
        for (DynamicObject prod : prods) {
            String number = prod.getString("number");
            if (numberCheck.contains(number)) {
                String message = ResManager.loadKDString((String)"\u5546\u54c1\u7f16\u7801\u201c%s\u201d\u5728\u5546\u54c1\u7ba1\u7406\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"PmmProdAuditcfm_3", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                this.addErrorMessage((ExtendedDataEntity)prodNumbers.get(number), String.format(message, number));
                continue;
            }
            numberCheck.add(number);
        }
        QFilter qFilter = new QFilter("prod", "in", prodIdAndDynMap.keySet());
        qFilter.and(new QFilter("billstatus", "=", (Object)"B").or("cfmstatus", "=", (Object)"A"));
        DynamicObjectCollection prodChgs = QueryServiceHelper.query((String)"ent_prodchange_manage", (String)"prod.id prod,prod.number prodnumber", (QFilter[])qFilter.toArray());
        for (DynamicObject prodChg : prodChgs) {
            String message = ResManager.loadKDString((String)"\u5546\u54c1%s\u5b58\u5728\u8fdb\u884c\u4e2d\u7684\u53d8\u66f4\u5355\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"EntProdRequestSubmitValidator_2", (String)"scm-ent-opplugin", (Object[])new Object[0]);
            this.addErrorMessage((ExtendedDataEntity)prodIdAndDynMap.get(prodChg.getLong("prod")), String.format(message, prodChg.getString("prodnumber")));
        }
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            DynamicObject prodReqBill = rowDataEntity.getDataEntity();
            if (null != prodReqBill.getString("cfmstatus") && (prodReqBill.getString("cfmstatus").equals("C") || prodReqBill.getString("cfmstatus").equals("D"))) {
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u4e0d\u540c\u610f\u7684\u4e0a\u67b6\u7533\u8bf7\u4e0d\u5141\u8bb8\u518d\u6b21\u63d0\u4ea4\u3002", (String)"EntProdRequestSubmitValidator_0", (String)"scm-ent-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (!prodReqBill.getString("billstatus").equals("A") && !prodReqBill.getString("billstatus").equals("D")) {
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u6b64\u5355\u636e\u5df2\u63d0\u4ea4\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u63d0\u4ea4\u3002", (String)"EntProdRequestSubmitValidator_1", (String)"scm-ent-opplugin", (Object[])new Object[0]));
                continue;
            }
            DynamicObjectCollection entries = prodReqBill.getDynamicObjectCollection("entryentity");
            DynamicObject protocol = prodReqBill.getDynamicObject("protocolid");
            for (DynamicObject entry : entries) {
                DynamicObjectCollection subEntry;
                DynamicObject prod = entry.getDynamicObject("goods");
                int seq = entry.getInt("seq");
                String pricetype = entry.getString("pricetype");
                if ("B".equals(pricetype) && (subEntry = entry.getDynamicObjectCollection("subentryentity")).size() == 0) {
                    this.addErrorMessage(rowDataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u6ca1\u6709\u8bbe\u7f6e\u9636\u68af\u4ef7\u3002", (String)"EntProdRequestSubmitValidator_5", (String)"scm-ent-opplugin", (Object[])new Object[0]), seq));
                    continue;
                }
                if (null == prod) continue;
                Long prodid = prod.getLong("id");
                if (!(null == prodMap.get(prodid) || null != protocol && protocol.getBoolean("differentarea"))) {
                    this.addErrorMessage(rowDataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u5355\u636e\u201c{0}\u201d\u548c\u5355\u636e\u201c{1}\u201d\u6709\u76f8\u540c\u7684\u5546\u54c1\u201c{2}\u201d\uff0c\u4e0d\u80fd\u540c\u65f6\u63d0\u4ea4\u3002", (String)"EntProdRequestSubmitValidator_3", (String)"scm-ent-opplugin", (Object[])new Object[0]), prodReqBill.getString("billno"), prodMap.get(prodid), prod.getString("number")));
                    continue;
                }
                prodMap.put(prodid, prodReqBill.getString("billno"));
            }
        }
    }
}

