/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.opplugin.validator;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.scm.malcore.constant.ProdTypeConstant;

public class EntProductCombineSubmitValidator
extends AbstractValidator {
    public static final String BILL_NUMBER = "billno";
    public static final String BILL_ENTRY = "entryentity";
    public static final String ENTRY_PRODUCT = "product";
    public static final String PRODUCT_TYPE = "prodtype";

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        DynamicObject model = null;
        DynamicObjectCollection entryColl = null;
        DynamicObject productModel = null;
        DynamicObject productTypeModel = null;
        for (ExtendedDataEntity dataEntity : dataEntities) {
            model = dataEntity.getDataEntity();
            entryColl = model.getDynamicObjectCollection(BILL_ENTRY);
            boolean containsNormal = false;
            for (DynamicObject entry : entryColl) {
                if (null != entry.getDynamicObject(ENTRY_PRODUCT)) continue;
                return;
            }
            for (DynamicObject entry : entryColl) {
                productModel = entry.getDynamicObject(ENTRY_PRODUCT);
                productTypeModel = productModel.getDynamicObject(PRODUCT_TYPE);
                if (null == productTypeModel || !ProdTypeConstant.PRODUCT_TYPE_NORMAL_ID.equals(productTypeModel.getPkValue())) continue;
                containsNormal = true;
                break;
            }
            if (containsNormal) continue;
            String msg = ResManager.loadKDString((String)"\u7ec4\u5408\u5546\u54c1\u7f16\u7801{0}\u5173\u8054\u5546\u54c1\u4fe1\u606f\u4e2d\u5e94\u5b58\u5728\u81f3\u5c11\u4e00\u4e2a\u666e\u901a\u5546\u54c1\u3002", (String)"EntProductCombineSubmitValidator_0", (String)"scm-ent-opplugin", (Object[])new Object[]{model.getString(BILL_NUMBER)});
            this.addErrorMessage(dataEntity, msg);
        }
    }
}

