/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.common.helper;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.servicehelper.attachment.AttachmentFieldServiceHelper;

public class SourcingFileHelper {
    public static boolean checkFileExpire(IFormView view, String fileFieldName, String pcEntity) {
        StringBuilder expireFileName = new StringBuilder();
        boolean checkResult = SourcingFileHelper.setAttachment(expireFileName, view, fileFieldName, pcEntity);
        if (checkResult) {
            return true;
        }
        String errorMsg = ResManager.loadKDString((String)"\u9644\u4ef6%s\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"SupFileEntryPlugin_0", (String)"scm-mobsp-form", (Object[])new Object[]{expireFileName});
        view.showErrorNotification(errorMsg);
        return false;
    }

    public static boolean setAttachment(StringBuilder expireAttachName, IFormView view, String fileFieldName, String pcEntity) {
        DynamicObjectCollection files = (DynamicObjectCollection)view.getModel().getValue(fileFieldName);
        boolean hasExpireFile = false;
        Iterator iterator = files.iterator();
        TempFileCache downLoad = CacheFactory.getCommonCacheFactory().getTempFileCache();
        while (iterator.hasNext()) {
            String urlRemoveParam;
            DynamicObject file = (DynamicObject)iterator.next();
            DynamicObject fileData = file.getDynamicObject("fbasedataid");
            String url = fileData.getString("url");
            if (!StringUtils.isNotBlank((CharSequence)url) || !url.contains("configKey") || !url.contains("&kdedcba") || downLoad.exists(urlRemoveParam = url.substring(0, url.indexOf("&kdedcba")))) continue;
            expireAttachName.append(fileData.get("name")).append("\r\n");
            hasExpireFile = true;
            iterator.remove();
        }
        List<Map<String, Object>> filesWaitingToSave = SourcingFileHelper.buildAttachmentDataFromEdit(files, view);
        List savedFiles = AttachmentFieldServiceHelper.saveAttachments((String)pcEntity, (String)view.getPageId(), filesWaitingToSave);
        ArrayList fileIdList = new ArrayList();
        savedFiles.forEach(attach -> fileIdList.add(attach.getLong("id")));
        HashMap<String, String> attachmentFieldMap = new HashMap<String, String>(2);
        attachmentFieldMap.put("PageId", view.getPageId());
        attachmentFieldMap.put("PkId", view.getPageCache().get("pkId"));
        AttachmentFieldServiceHelper.saveTempAttachments((String)SerializationUtils.toJsonString(attachmentFieldMap));
        view.getModel().setValue(fileFieldName, (Object)fileIdList.toArray(new Long[0]));
        return !hasExpireFile;
    }

    private static List<Map<String, Object>> buildAttachmentDataFromEdit(DynamicObjectCollection sourceAttachCol, IFormView view) {
        ArrayList<Map<String, Object>> attachDataList = new ArrayList<Map<String, Object>>();
        sourceAttachCol.forEach(attach -> {
            DynamicObject attachObj = attach.getDynamicObject("fbasedataid");
            HashMap<String, Object> attachMap = new HashMap<String, Object>();
            attachMap.put("description", attachObj.getString("description"));
            attachMap.put("type", attachObj.getString("type"));
            attachMap.put("url", attachObj.getString("url"));
            String uid = attachObj.getString("uid");
            String newUid = "rc-upload-" + System.currentTimeMillis() + "-" + new SecureRandom().nextInt(100);
            attachMap.put("uid", uid == null || "".equals(uid) ? newUid : uid);
            attachMap.put("name", attachObj.getString("name"));
            attachMap.put("size", attachObj.get("size"));
            attachMap.put("fattachmentpanel", "attachmentpanel");
            attachMap.put("entityNum", view.getEntityId());
            attachMap.put("lastModified", System.currentTimeMillis());
            attachMap.put("status", "success");
            attachMap.put("client", null);
            attachDataList.add(attachMap);
        });
        return attachDataList;
    }
}

