/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.opplugin.scp;

import java.util.HashMap;
import java.util.HashSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scmc.msmob.business.helper.BotpHelper;
import kd.scmc.msmob.pojo.PushParams;

public class BillPushOp
extends AbstractOperationServicePlugIn {
    private static final String ENTRYRCVORG = "entryrcvorg";
    private static final String PUSH_RESULT = "pushResult";
    private static final String MATERIALENTRY = "materialentry";

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        RequestContext requestContext = RequestContext.get();
        long currUserId = requestContext.getCurrUserId();
        DynamicObject[] dataEntities = e.getDataEntities();
        DynamicObject dataEntity = dataEntities[0];
        DynamicObjectCollection materialEntry = dataEntities[0].getDynamicObjectCollection("entryentity");
        DynamicObject mainOrg = dataEntity.getDynamicObject("org");
        Long orgId = mainOrg.getLong("id");
        int perm = PermissionServiceHelper.checkPermission((Long)currUserId, (Long)orgId, (String)"15", (String)"scp", (String)"scp_order", (String)"4730fc9f000002ae");
        OperateOption option = this.getOption();
        if (perm != 1) {
            String tip = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u91c7\u8d2d\u8ba2\u5355\u201d\u7684\u201c\u53d1\u8d27\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"BillPushOp_0", (String)"scm-mobsp-form", (Object[])new Object[0]);
            throw new KDBizException(tip);
        }
        if (materialEntry != null && materialEntry.size() > 0) {
            HashSet<Long> ids = new HashSet<Long>(materialEntry.size());
            for (DynamicObject dy : materialEntry) {
                DynamicObject org = dy.getDynamicObject(ENTRYRCVORG);
                Long id = org.getLong("id");
                ids.add(id);
            }
            if (ids.size() > 1) {
                String tip = ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u591a\u6536\u8d27\u65b9\u7684\u53d1\u8d27\u64cd\u4f5c\uff0c\u8bf7\u5728PC\u7aef\u64cd\u4f5c\u3002", (String)"BillPushOp_1", (String)"scm-mobsp-form", (Object[])new Object[0]);
                throw new KDBizException(tip);
            }
        }
        PushParams pushParams = this.getPushParams(dataEntity);
        ConvertOperationResult convertResult = BotpHelper.singlePushBill((PushParams)pushParams);
        HashMap<String, ConvertOperationResult> customParams = new HashMap<String, ConvertOperationResult>(16);
        customParams.put("convertResult", convertResult);
        String pushResult = SerializationUtils.toJsonString(customParams);
        option.setVariableValue(PUSH_RESULT, pushResult);
    }

    private PushParams getPushParams(DynamicObject dataEntity) {
        PushParams pushParams = new PushParams();
        String billNo = dataEntity.getString("billno");
        QFilter srcFilter = new QFilter("billno", "=", (Object)billNo);
        pushParams.setSrcEntityKey("scp_order");
        pushParams.setSrcMainEntryKey(MATERIALENTRY);
        pushParams.setSrcEntityFilter(srcFilter);
        pushParams.setTargetEntityKey("scp_saloutstock");
        pushParams.setTargetMobFormKey("mobsp_saloutstockedit");
        return pushParams;
    }
}

