/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.opplugin.scp.register;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scmc.msmob.pojo.DataSourceConfig;
import kd.scmc.msmob.pojo.PropertyNode;
import kd.scmc.msmob.service.mservice.baseset.impl.DataSourceConfigServiceImpl;

public abstract class AbstractRegisterOperationPlugin
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(AbstractRegisterOperationPlugin.class);
    private static final DataSourceConfigServiceImpl dataSourceConfigService = new DataSourceConfigServiceImpl();

    public abstract String getOperationKey();

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        String operationKey = this.getOperationKey();
        DynamicObject mobileData = dataEntities[0];
        String mobFormKey = mobileData.getDynamicObjectType().getName();
        DataSourceConfig dataSourceConfig = dataSourceConfigService.getDataSourceConfig(mobFormKey);
        OperationResult operationResult = this.executeWithEntity(operationKey, dataSourceConfig, dataEntities);
        this.processOperationResult(operationResult);
    }

    protected void processOperationResult(OperationResult operationResult) {
        if (operationResult != null) {
            this.operationResult.setInteractionContext(operationResult.getInteractionContext());
            this.operationResult.setSponsor(operationResult.getSponsor());
            this.operationResult.setFinishedTime(operationResult.getFinishedTime());
            this.operationResult.setStartTime(operationResult.getStartTime());
            this.operationResult.setValidateResult(operationResult.getValidateResult());
            this.operationResult.setAllErrorInfo(operationResult.getAllErrorInfo());
            this.operationResult.setBillCount(operationResult.getBillCount());
            this.operationResult.setBillNos(operationResult.getBillNos());
            this.operationResult.setClearText(operationResult.getClearText());
            this.operationResult.setMessage(operationResult.getMessage());
            this.operationResult.setSuccessPkIds(operationResult.getSuccessPkIds());
            this.operationResult.setSuccess(operationResult.isSuccess());
        }
    }

    private OperationResult executeWithEntity(String operationKey, DataSourceConfig dataSourceConfig, DynamicObject[] dataEntities) {
        String pcEntityKey = dataSourceConfig.getMobFormKey();
        ArrayList<DynamicObject> pcEntityList = new ArrayList<DynamicObject>(dataEntities.length + 1);
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObject pcEntity = AbstractRegisterOperationPlugin.getPcEntity(dataEntity, dataSourceConfig);
            if (pcEntity == null) continue;
            pcEntityList.add(pcEntity);
        }
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)operationKey, (String)pcEntityKey, (DynamicObject[])pcEntityList.toArray(new DynamicObject[pcEntityList.size()]), (OperateOption)this.operateOption);
        return operationResult;
    }

    public static DynamicObject getPcEntity(DynamicObject dataEntity, DataSourceConfig dataSourceConfig) {
        String number = dataEntity.getString("number");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)dataSourceConfig.getPcEntityKey(), (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
        DynamicObject pcDynamicObject = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.getPkValue(), (String)dataSourceConfig.getPcEntityKey());
        Map fieldMapping = dataSourceConfig.getFieldMapping();
        HashMap<String, List<String>> entryFiledMap = new HashMap<String, List<String>>(16);
        for (Map.Entry<String, PropertyNode> entry : fieldMapping.entrySet()) {
            PropertyNode pcField = (PropertyNode)entry.getValue();
            AbstractRegisterOperationPlugin.setMainValue(entry, pcField, pcDynamicObject, dataEntity, entryFiledMap);
        }
        DynamicObjectCollection pcSaveDynamicObjectCollection = new DynamicObjectCollection();
        for (Map.Entry entryFieldMappingItem : entryFiledMap.entrySet()) {
            DynamicObjectCollection pcEntryCollection = pcDynamicObject.getDynamicObjectCollection((String)entryFieldMappingItem.getKey());
            DynamicObjectCollection mobEntryCollection = dataEntity.getDynamicObjectCollection("entry_bank");
            if (mobEntryCollection == null) {
                mobEntryCollection = new DynamicObjectCollection();
            }
            for (int k = 0; k < mobEntryCollection.size(); ++k) {
                DynamicObject pcItem;
                DynamicObject mobItem = (DynamicObject)mobEntryCollection.get(k);
                Long mobPkValue = mobItem.getLong("mobentryid");
                if (mobItem.getPkValue() == null || (Long)mobItem.getPkValue() == 0L) {
                    pcItem = new DynamicObject(pcEntryCollection.getDynamicObjectType());
                } else {
                    Optional<DynamicObject> pcObject = pcEntryCollection.stream().filter(pc -> pc.getPkValue().equals(mobPkValue)).findFirst();
                    pcItem = pcObject.orElse(null);
                }
                if (pcItem == null) continue;
                List entryFieldList = (List)entryFieldMappingItem.getValue();
                for (String entryField : entryFieldList) {
                    PropertyNode propertyNode = (PropertyNode)fieldMapping.get(entryField);
                    String fieldKey = propertyNode.getFieldKey();
                    Object value = mobItem.get(entryField);
                    pcItem.set(StringUtils.substringAfter((String)fieldKey, (String)((String)entryFieldMappingItem.getKey() + ".")), value);
                }
                pcSaveDynamicObjectCollection.add((Object)pcItem);
            }
            pcDynamicObject.set((String)entryFieldMappingItem.getKey(), (Object)pcSaveDynamicObjectCollection);
        }
        log.info("\u8c03\u7528\u4fdd\u5b58\u670d\u52a1\u64cd\u4f5c\u7684\u5355\u636e\u5bf9\u8c61\u4fe1\u606f\uff1a\u3010{}\u3011", (Object)pcDynamicObject.toString());
        return pcDynamicObject;
    }

    private static void setMainValue(Map.Entry<String, PropertyNode> fieldMappingItem, PropertyNode pcField, DynamicObject dataEntity, DynamicObject billData, Map<String, List<String>> entryFiledMap) {
        PropertyNode parentNode = pcField.getParentNode();
        if (parentNode.getType() instanceof MainEntityType) {
            dataEntity.set(fieldMappingItem.getValue().getFieldKey(), billData.get(fieldMappingItem.getKey()));
            return;
        }
        if (parentNode.getType() instanceof EntityType) {
            List<String> newKey = entryFiledMap.get(parentNode.getFieldKey());
            if (newKey == null) {
                ArrayList<String> keys = new ArrayList<String>();
                keys.add(fieldMappingItem.getKey());
                entryFiledMap.put(parentNode.getFieldKey(), keys);
            } else {
                newKey.add(fieldMappingItem.getKey());
                entryFiledMap.put(parentNode.getFieldKey(), newKey);
            }
            return;
        }
        AbstractRegisterOperationPlugin.setMainValue(fieldMappingItem, pcField.getParentNode(), dataEntity, billData, entryFiledMap);
    }
}

