/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.plugin.form.scp.deliver;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.scm.mobsp.business.helper.SaloutStockChangedHandler;
import kd.scm.mobsp.common.utils.MobileControlUtils;
import kd.scm.mobsp.plugin.form.scp.deliver.ISaleOutStockPagePlugin;
import kd.scm.mobsp.plugin.form.scp.tpl.MobScpBillInfoTplPlugin;
import kd.scm.scp.common.util.ScpBillUtil;
import kd.scmc.msmob.business.helper.AttachedFileHelper;
import kd.scmc.msmob.plugin.tpl.basetpl.IMobBillEditable;

public class SaloutStockBillEditPlugin
extends MobScpBillInfoTplPlugin
implements IMobBillEditable,
ISaleOutStockPagePlugin {
    public static final String CFM_CALLBACK_CHECKQTY = "cfm_callback_checkqty";

    public SaloutStockBillEditPlugin() {
        this.registerPropertyChangedHandler(new SaloutStockChangedHandler());
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setBtnVisible();
        Control saveButton = this.getControl("buttonsave");
        Control deleteButton = this.getControl("buttondelete");
        MobileControlUtils.controlSetFrontAndBackColor(saveButton, "#000000", "#FFFFFF");
        MobileControlUtils.controlSetFrontAndBackColor(deleteButton, "#000000", "#FFFFFF");
    }

    public void setBtnVisible() {
        super.setBtnVisible();
        IFormView view = this.getView();
        if (this.isSaved()) {
            view.setVisible(Boolean.FALSE, new String[]{"buttonclose"});
            view.setVisible(Boolean.TRUE, new String[]{"buttondelete"});
        } else {
            view.setVisible(Boolean.TRUE, new String[]{"buttonclose"});
            view.setVisible(Boolean.FALSE, new String[]{"buttondelete"});
            Control closeButton = this.getControl("buttonclose");
            MobileControlUtils.controlSetFrontAndBackColor(closeButton, "#000000", "#FFFFFF");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "delete": {
                MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
                IFormView parentView = this.getView().getParentView();
                if (parentView == null) {
                    mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
                    this.goListForm(mobileFormShowParameter);
                    break;
                }
                this.closeCurrentForm();
                break;
            }
        }
    }

    public String getListFormKey() {
        return "mobsp_saloutstocklist";
    }

    public void afterSubmit(String pcId) {
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("attachmentpanelap");
        AttachedFileHelper.saveAttacheFile((AttachmentPanel)attachmentPanel, (String)this.getPcEntityKey(), (String)pcId);
        String successMsg = ResManager.loadKDString((String)"\u786e\u8ba4\u53d1\u8d27\u6210\u529f\u3002", (String)"SaloutStockBillEditPlugin_1", (String)"scm-mobsp-form", (Object[])new Object[0]);
        this.getView().showSuccessNotification(successMsg);
        MobileFormShowParameter formShowParameter = this.createShowParameter(this.getViewFormId(), false);
        this.goUrl(formShowParameter, true);
    }

    public String getEntryFormKey() {
        String entryKey = this.getEntryEntity();
        return this.getEntryEditFormKey(entryKey);
    }

    public String getViewFormId() {
        return "mobsp_saloutstockview";
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String propKey;
        super.propertyChanged(e);
        switch (propKey = e.getProperty().getName()) {
            case "qty": {
                this.qtyChanged(e);
                break;
            }
        }
    }

    private void qtyChanged(PropertyChangedArgs e) {
        Long billId = this.getBillId();
        if (billId == null) {
            return;
        }
        DynamicObject bill = this.getPcEntityById(billId.toString());
        DynamicObjectCollection entryColl = bill.getDynamicObjectCollection("materialentry");
        for (ChangeData changeData : e.getChangeSet()) {
            BigDecimal newQty = (BigDecimal)changeData.getNewValue();
            int rowIndex = changeData.getRowIndex();
            DynamicObject entryRow = (DynamicObject)entryColl.get(rowIndex);
            entryRow.set("qty", (Object)newQty);
            if (!ScpBillUtil.compareQtyAndSumQty((DynamicObject)bill, (int)rowIndex)) continue;
            this.getPageCache().put("rowIndex", String.valueOf(rowIndex));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u7d2f\u8ba1\u53d1\u8d27\u6570\u91cf\u5c06\u5927\u4e8e\u6e90\u8ba2\u5355\u6570\u91cf\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u8d85\u989d\u3002", (String)"MaterialEntryEditPlugin_checkQuantity_0", (String)"scm-mobsp-form", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CFM_CALLBACK_CHECKQTY));
        }
    }

    protected String getMainEntryTitle() {
        String entryKey = this.getEntryEntity();
        int entryRowCount = this.getModel().getEntryRowCount(entryKey);
        return String.valueOf(entryRowCount);
    }
}

