/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.plugin.form.scp.enroll;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.mobsp.plugin.form.scp.enroll.handler.CancelBtnClickHandler;
import kd.scm.mobsp.plugin.form.scp.enroll.handler.ConfirmBtnClickHandler;
import kd.scm.mobsp.plugin.form.scp.enroll.vo.EnrollRegVo;
import kd.scmc.msmob.mvccore.IMobileApiPage;
import kd.scmc.msmob.mvccore.IMobileApiSearch;
import kd.scmc.msmob.mvccore.MobileApiRendererUtils;
import kd.scmc.msmob.mvccore.MobileSearchParameter;
import kd.scmc.msmob.mvccore.MobileViewModelUtils;
import kd.scmc.msmob.mvccore.OpenApiDataSource;

public class EnrollRegPlugin
extends AbstractMobBillPlugIn
implements IMobileApiSearch<EnrollRegVo>,
IMobileApiPage,
BeforeF7SelectListener {
    private static final String CONFIRM_BTN = "confirmbtn";
    private static final String CANCEL_BTN = "cancelbtn";
    private static final String TOOL_BAR = "mtoolbarap";
    private static final String SUPPLIER = "supplierfield";
    private static final String SUPPLIER_ADDRESS = "bizpartner_address";
    private static final String SUPPLIER_PHONE = "bizpartner_phone";
    private static final String LINKMAN = "linkman";
    private static final String ADDRESS = "address";
    private static final String PHONE = "phone";
    private static final String ENROLL_END_DATE = "enrollenddate";
    private static final String PACKAGE_SET = "packageset";
    private String[] fields = new String[]{"enrollenddate", "supplierfield", "linkman", "duty", "phone", "email", "address", "enrolldescfield", "packageset"};

    public void initialize() {
        super.initialize();
        MobileApiRendererUtils.addDataModelChangeListener((AbstractFormPlugin)this);
    }

    public OpenApiDataSource<EnrollRegVo> getDatasourceConfig() {
        return new OpenApiDataSource("/v2/tnd/tnd_apply/getEntrollInfo", EnrollRegVo.class, false);
    }

    public MobileSearchParameter getApiSearchParameters(MobileSearchParameter parameter) {
        Long billId = (Long)this.getView().getFormShowParameter().getCustomParam("billId");
        parameter.put((Object)"billId", (Object)billId);
        return parameter;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        MobileViewModelUtils.addClickListener((IFormView)this.getView(), (String)CONFIRM_BTN, (ClickListener)new ConfirmBtnClickHandler(this.getView()));
        MobileViewModelUtils.addClickListener((IFormView)this.getView(), (String)CANCEL_BTN, (ClickListener)new CancelBtnClickHandler(this.getView()));
        BasedataEdit packageSet = (BasedataEdit)this.getView().getControl(PACKAGE_SET);
        BasedataEdit supplier = (BasedataEdit)this.getView().getControl(SUPPLIER);
        packageSet.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setViewFromData();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String changedPropertyName = e.getProperty().getName();
        if (SUPPLIER.equals(changedPropertyName)) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            String address = ((OrmLocaleValue)newValue.get(SUPPLIER_ADDRESS)).getLocaleValue();
            Object phone = newValue.get(SUPPLIER_PHONE);
            String linkman = ((OrmLocaleValue)newValue.get(LINKMAN)).getLocaleValue();
            this.getView().getModel().setValue(ADDRESS, (Object)address);
            this.getView().getModel().setValue(PHONE, phone);
            this.getView().getModel().setValue(LINKMAN, (Object)linkman);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key;
        switch (key = beforeF7SelectEvent.getProperty().getName()) {
            case "supplierfield": {
                List supplierIds = BizPartnerUtil.getSupplierByUserOfBizPartner();
                QFilter supplierFilter = new QFilter("id", "in", (Object)supplierIds);
                ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().setFilter(supplierFilter);
                break;
            }
            case "packageset": {
                Long[] packageIds = this.getPackageIds();
                QFilter packageFilter = new QFilter("id", "in", (Object)packageIds);
                ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().setFilter(packageFilter);
                break;
            }
        }
    }

    public void setViewFromData() {
        EnrollRegVo detailVo = (EnrollRegVo)((Object)MobileApiRendererUtils.renderSingDataPage((AbstractFormPlugin)this, null));
        this.setPackageIds(detailVo);
        this.setFieldVisible(detailVo);
        this.setViewOrModify();
    }

    public void setFieldVisible(EnrollRegVo value) {
        IFormView view = this.getView();
        Date endDate = value.getReplyDate();
        String manageType = value.getManageType();
        if (endDate == null) {
            view.setVisible(Boolean.valueOf(false), new String[]{ENROLL_END_DATE});
        }
        view.setVisible(Boolean.valueOf("2".equals(manageType)), new String[]{PACKAGE_SET});
    }

    public void setViewOrModify() {
        IFormView view = this.getView();
        String pageStatus = (String)view.getFormShowParameter().getCustomParam("modify_or_view");
        if ("modify".equals(pageStatus)) {
            view.setEnable(Boolean.valueOf(true), this.fields);
            view.setVisible(Boolean.valueOf(true), new String[]{TOOL_BAR});
        } else {
            view.setEnable(Boolean.valueOf(false), this.fields);
            view.setVisible(Boolean.valueOf(false), new String[]{TOOL_BAR});
        }
    }

    private void setPackageIds(EnrollRegVo value) {
        Long[] ids = value.getIds();
        StringBuilder idsStrBuilder = new StringBuilder();
        for (Long id : ids) {
            idsStrBuilder.append(id).append(",");
        }
        String idsStr = idsStrBuilder.toString();
        this.getView().getPageCache().put(PACKAGE_SET, idsStr);
    }

    private Long[] getPackageIds() {
        String idsStr = this.getView().getPageCache().get(PACKAGE_SET);
        String[] split = idsStr.split(",");
        Long[] ids = new Long[split.length];
        for (int i = 0; i < split.length; ++i) {
            ids[i] = Long.parseLong(split[i]);
        }
        return ids;
    }
}

