/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.plugin.form.scp.enroll.handler;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.openapi.common.result.OpenApiResult;
import kd.scm.mobsp.common.entity.componentvo.BillTemplateEntry;
import kd.scm.mobsp.common.entity.componentvo.SrcPurListStandResult;
import kd.scm.mobsp.plugin.form.scp.enroll.component.AbstractEnrollBillComponent;
import kd.scm.mobsp.plugin.form.scp.enroll.component.EnrollPurListStandComponent;
import kd.scm.mobsp.plugin.form.scp.enroll.vo.EnrollBillDetailVo;
import kd.scm.mobsp.plugin.form.scp.enroll.vo.EnrollStatus;
import kd.scm.mobsp.plugin.form.scp.enroll.vo.EnrollStatusQueryParameter;
import kd.scmc.msmob.mvccore.IMobileApiResultHandler;
import kd.scmc.msmob.mvccore.IMobileApiSearch;
import kd.scmc.msmob.mvccore.JsonUtils;
import kd.scmc.msmob.mvccore.MobileApiCRUDUtils;
import kd.scmc.msmob.mvccore.MobileApiUtils;
import kd.scmc.msmob.mvccore.MobileReflectionUtils;

public class EnrollBillComponentHandler
implements IMobileApiResultHandler<EnrollBillDetailVo> {
    private static final Map<String, Class<? extends AbstractEnrollBillComponent>> components = new HashMap<String, Class<? extends AbstractEnrollBillComponent>>();

    private void getEnrollStatus(EnrollBillDetailVo enrollBillDetailVo) {
        EnrollStatusQueryParameter queryParameter = new EnrollStatusQueryParameter(enrollBillDetailVo.getId());
        OpenApiResult openApiResult = MobileApiCRUDUtils.callCRUDApi((Object)queryParameter, (String)"/v2/tnd/tnd_apply/getEntrollStatus", (boolean)false);
        List statusList = JsonUtils.deserializeList((String)JsonUtils.serialize((Object)openApiResult.getData()), EnrollStatus.class);
        if (statusList == null || statusList.isEmpty()) {
            return;
        }
        enrollBillDetailVo.setEnrollStatus(((EnrollStatus)((Object)statusList.get(0))).getEnrollstatus());
    }

    public void handle(EnrollBillDetailVo value) {
        this.getEnrollStatus(value);
        List<BillTemplateEntry> tplentry = value.getTplentry();
        if (tplentry == null) {
            return;
        }
        for (BillTemplateEntry entry : tplentry) {
            Class<? extends AbstractEnrollBillComponent> enrollBillComponentClass = components.get(entry.getTmp_bizobject());
            if (enrollBillComponentClass == null) continue;
            AbstractEnrollBillComponent abstractEnrollBillComponent = (AbstractEnrollBillComponent)MobileReflectionUtils.newInstance(enrollBillComponentClass);
            abstractEnrollBillComponent.setTemplateEntry(entry);
            abstractEnrollBillComponent.setDetailVo(value);
            List resultList = MobileApiUtils.getDataListFromOpenApi((IMobileApiSearch)abstractEnrollBillComponent);
            Optional<SrcPurListStandResult> any = resultList.stream().filter(srcPurlistStandResult -> srcPurlistStandResult.getEntitykey().equals(entry.getTmp_bizobject())).findAny();
            if (!any.isPresent()) continue;
            abstractEnrollBillComponent.handleResult(any.get());
        }
    }

    static {
        components.put("src_purlist_stand", EnrollPurListStandComponent.class);
    }
}

