/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.plugin.form.scp.notice;

import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.scm.mobsp.common.helper.DateRangeFilterHelper;
import kd.scm.mobsp.common.helper.PermissionHelper;
import kd.scm.mobsp.common.helper.SourcingAPIQueryParamHelper;
import kd.scm.mobsp.common.helper.StatusConsistencyHelper;
import kd.scm.mobsp.plugin.form.scp.notice.enumeration.ReplyStatusEnum;
import kd.scm.mobsp.plugin.form.scp.notice.vo.NoticeDetailVo;
import kd.scm.mobsp.plugin.form.scp.notice.vo.NoticeListVo;
import kd.scmc.msmob.mvccore.IMobileApiPage;
import kd.scmc.msmob.mvccore.IMobileApiSearch;
import kd.scmc.msmob.mvccore.MobileApiRendererUtils;
import kd.scmc.msmob.mvccore.MobileOpenApiPluginHelper;
import kd.scmc.msmob.mvccore.MobileSearchParameter;
import kd.scmc.msmob.mvccore.MobileViewModelUtils;
import kd.scmc.msmob.mvccore.OpenApiDataSource;

public class NoticeListPlugin
extends AbstractMobBillPlugIn
implements IMobileApiSearch<NoticeListVo>,
IMobileApiPage,
IDataModelChangeListener {
    private static final String TIME_FILTER_START_TIME = "daterange_start";
    private static final String TIME_FILTER_END_TIME = "daterange_end";
    private static final String STATUS_FILTER = "statusfilter";
    private static final String LETTER_TYPE_FILTER = "typefilter";
    private static final String MODIFY = "modify";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        IFormView view = this.getView();
        MobileOpenApiPluginHelper.addEntryPageListener((AbstractFormPlugin)this);
        MobileOpenApiPluginHelper.addMobileSearchTextListener((AbstractFormPlugin)this);
        MobileOpenApiPluginHelper.addRowClickListener((AbstractFormPlugin)this, (value, mobileFormShowParameter) -> {
            boolean checkMutex;
            boolean consistency = StatusConsistencyHelper.checkConsistency(this, view, value, new NoticeDetailVo(), "/v2/tnd/tnd_winnotice/getDetail", "replyStatus");
            if (!consistency) {
                return null;
            }
            String replyStatus = value.getReplyStatus();
            if (ReplyStatusEnum.A.getFieldValue().equals(replyStatus) && !(checkMutex = PermissionHelper.checkMutex(this, this.getPcEntity(), replyStatus, ReplyStatusEnum.A, value.getId(), value.getPurOrgId()))) {
                this.getView().getPageCache().put("cached_id", String.valueOf(value.getId()));
                return null;
            }
            mobileFormShowParameter.setFormId("mobsp_sourcing_noticebill");
            mobileFormShowParameter.setCustomParam("id", (Object)value.getId());
            return mobileFormShowParameter;
        });
        this.addPullRefreshListener();
    }

    public void afterCreateNewData(EventObject e) {
        DateRangeFilterHelper.setDefaultDateRangeThisWeek(this.getModel());
        super.afterCreateNewData(e);
        MobileApiRendererUtils.renderListPage((AbstractFormPlugin)this);
    }

    public OpenApiDataSource<NoticeListVo> getDatasourceConfig() {
        return new OpenApiDataSource("/v2/tnd/tnd_query/getList", NoticeListVo.class, false);
    }

    public MobileSearchParameter getApiSearchParameters(MobileSearchParameter parameter) {
        Date dateRangeStart = (Date)this.getModel().getValue(TIME_FILTER_START_TIME);
        Date dateRangeEnd = (Date)this.getModel().getValue(TIME_FILTER_END_TIME);
        String selectedBillStatus = (String)this.getModel().getValue(STATUS_FILTER);
        String selectedLetterType = (String)this.getModel().getValue(LETTER_TYPE_FILTER);
        return new SourcingAPIQueryParamHelper((AbstractFormPlugin)this).setSearchParameter().setReplyStatus(selectedBillStatus).setLetterType(selectedLetterType).setDateRange(dateRangeStart, dateRangeEnd).setFormId(this.getPcEntity()).buildWrap();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (TIME_FILTER_START_TIME.equals(propName) || TIME_FILTER_END_TIME.equals(propName) || STATUS_FILTER.equals(propName) || LETTER_TYPE_FILTER.equals(propName)) {
            MobileApiRendererUtils.renderListPage((AbstractFormPlugin)this);
        }
    }

    public String getPcEntity() {
        return "tnd_winnotice";
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        PermissionHelper.mutexConfirmCallBack(this.getView(), messageBoxClosedEvent, () -> {
            MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
            mobileFormShowParameter.setCustomParam("id", (Object)this.getPageCache().get("cached_id"));
            mobileFormShowParameter.setFormId("mobsp_sourcing_noticebill");
            mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
            this.getView().showForm((FormShowParameter)mobileFormShowParameter);
        });
    }

    private void addPullRefreshListener() {
        CardEntry card = (CardEntry)this.getView().getControl(MobileViewModelUtils.getFirstEntryName((AbstractFormPlugin)this));
        NoticeListPlugin plugin = this;
        card.addPullRefreshlisteners(evt -> MobileApiRendererUtils.renderListPage((AbstractFormPlugin)plugin));
    }
}

