/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.plugin.form.scp.order;

import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.MobileFormShowParameter;
import kd.scm.mobsp.plugin.form.scp.tpl.MobScpBillListTplPlugin;
import kd.scm.scp.common.util.ScpBizPersonUtil;
import kd.scmc.msmob.pojo.FilterCondition;

public class OrderChangeBillListPlugin
extends MobScpBillListTplPlugin {
    public void setViewPageShowParameter(MobileFormShowParameter showParameter) {
        super.setViewPageShowParameter(showParameter);
        showParameter.setFormId("mobsp_orderchange_view");
    }

    public void setEditPageShowParameter(MobileFormShowParameter showParameter) {
        super.setEditPageShowParameter(showParameter);
        showParameter.setFormId("mobsp_orderchange_view");
    }

    @Override
    public List<FilterCondition> getFilters() {
        List<FilterCondition> filters = super.getFilters();
        this.addFilters(filters);
        return filters;
    }

    private void addFilters(List<FilterCondition> qFilters) {
        this.setBillStatusFilter(qFilters);
        DynamicObjectCollection bizpersons = ScpBizPersonUtil.getOrgScopeList((String[])new String[]{"purorgscope", "rcvorgscope"});
        HashSet<Long> purorgscopes = new HashSet<Long>();
        HashSet<Long> rcvorgscopes = new HashSet<Long>();
        for (DynamicObject bizperson : bizpersons) {
            String rcvorgscope;
            String purorgscope = bizperson.getString("purorgscope");
            if (!"0".equals(purorgscope)) {
                purorgscopes.add(Long.parseLong(purorgscope));
            }
            if ("0".equals(rcvorgscope = bizperson.getString("rcvorgscope"))) continue;
            rcvorgscopes.add(Long.parseLong(rcvorgscope));
        }
        if (purorgscopes.size() > 0) {
            qFilters.add(new FilterCondition("org", "in", purorgscopes));
        }
        if (rcvorgscopes.size() > 0) {
            qFilters.add(new FilterCondition("rcvorg", "in", rcvorgscopes).or(new FilterCondition("materialentry.entryrcvorg", "in", rcvorgscopes)));
        }
    }

    public void setBillStatusFilter(List<FilterCondition> filterArrayList) {
        if (null == filterArrayList) {
            return;
        }
        for (int i = 0; i < filterArrayList.size(); ++i) {
            if (!filterArrayList.get(i).toString().contains("billstatus")) continue;
            filterArrayList.remove(i);
            filterArrayList.add(new FilterCondition("origin", "=", (Object)"2").and(new FilterCondition("billstatus", "in", (Object)new String[]{"A", "B", "C", "D", "E"})).or(new FilterCondition("origin", "=", (Object)"1")));
        }
    }

    public void setModelValue() {
        super.setModelValue();
        this.summaryFields(new String[]{"material"});
    }
}

