/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.plugin.form.scp.order;

import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.scm.mobsp.common.enums.ConfirmStatusEnum;
import kd.scm.mobsp.plugin.form.scp.tpl.MobScpBillInfoTplPlugin;
import kd.scmc.msmob.common.enums.CfmStatusEnum;

public class OrderChangeBillViewPlugin
extends MobScpBillInfoTplPlugin {
    protected static final String CFM_STATUS = "cfmstatus";
    protected static final String BUTTON_CONFIRM = "buttonconfirm";
    protected static final String MTOOL_BAR_AP = "mtoolbarap";
    protected static final String CONFIRM = "agreeorderchange";

    public String getEditFormId() {
        return "mobsp_orderchange_entryv";
    }

    public String getEntryFormKey() {
        return "mobsp_orderchange_entryv";
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        this.preOpenFormByLink(e);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        boolean success = operationResult.isSuccess();
        if (success && CONFIRM.equalsIgnoreCase(operateKey)) {
            this.getModel().setValue(CFM_STATUS, (Object)CfmStatusEnum.CONFIRM.getValue());
        }
        this.setVisible();
    }

    @Override
    public void initBillInfo() {
        super.initBillInfo();
        String confirmStatus = this.curData[0].getString(CFM_STATUS);
        if (!ConfirmStatusEnum.UNCONFIRM.getValue().equals(confirmStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{MTOOL_BAR_AP});
        }
    }

    private void setVisible() {
        this.setCfmStatusVisible();
        this.setButtonVisible();
    }

    private void setCfmStatusVisible() {
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        Object cfmStatus = model.getValue(CFM_STATUS);
        view.setVisible(Boolean.FALSE, new String[]{"labelunconfirm", "labelconfirm", "labelreject", "labelchanging"});
        if (CfmStatusEnum.UNCONFIRM.getValue().equals(cfmStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{"labelunconfirm"});
        } else if (CfmStatusEnum.CONFIRM.getValue().equals(cfmStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{"labelconfirm"});
        } else if (CfmStatusEnum.REJECT.getValue().equals(cfmStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{"labelreject"});
        } else if (CfmStatusEnum.CHANGING.getValue().equals(cfmStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{"labelchanging"});
        }
    }

    private void setButtonVisible() {
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        Object cfmStatus = model.getValue(CFM_STATUS);
        if (!CfmStatusEnum.UNCONFIRM.getValue().equals(cfmStatus)) {
            view.setVisible(Boolean.FALSE, new String[]{MTOOL_BAR_AP});
        } else {
            view.setVisible(Boolean.TRUE, new String[]{BUTTON_CONFIRM, MTOOL_BAR_AP});
        }
        view.updateView(MTOOL_BAR_AP);
    }

    protected String getMainEntryTitle() {
        IDataModel model = this.getModel();
        String entryKey = this.getEntryEntity();
        int entryRowCount = model.getEntryRowCount(entryKey);
        return String.valueOf(entryRowCount);
    }
}

