/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.plugin.form.scp.purorder;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.MobileFormShowParameter;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.ConfirmStatusEnum;
import kd.scm.common.enums.LogisticsStatusEnum;
import kd.scm.mobsp.common.enums.LogStatusEnum;
import kd.scm.mobsp.plugin.form.scp.tpl.MobScpBillListTplPlugin;
import kd.scm.scp.common.util.ScpBillOfBizPersonFilter;
import kd.scmc.msmob.common.enums.CfmStatusEnum;
import kd.scmc.msmob.common.utils.ConverterUtils;
import kd.scmc.msmob.pojo.FilterCondition;

public class PurOrderListPlugin
extends MobScpBillListTplPlugin {
    private static final String ACTIVE_TAB = "activeTab";
    private static final String UNCONFIRM = "unconfirm";
    private static final String NO_SHIPMENT = "noShipment";

    @Override
    public void afterCreateNewData(EventObject e) {
        MobileFormShowParameter param = (MobileFormShowParameter)this.getView().getFormShowParameter();
        String customParam = (String)param.getCustomParam(ACTIVE_TAB);
        if (StringUtils.isNotEmpty((CharSequence)customParam)) {
            if (UNCONFIRM.equals(customParam)) {
                this.getModel().setValue("combofield2", (Object)CfmStatusEnum.UNCONFIRM.getValue());
            }
            if (NO_SHIPMENT.equals(customParam)) {
                this.getModel().setValue("combofield2", (Object)CfmStatusEnum.CONFIRM.getValue());
                this.getModel().setValue("logstatusfield", (Object)LogStatusEnum.NO_SHIPMENT.getValue());
            }
        }
        super.afterCreateNewData(e);
    }

    public void setModelValue() {
        super.setModelValue();
        this.summaryFields(new String[]{"material"});
    }

    public void setViewPageShowParameter(MobileFormShowParameter showParameter) {
        super.setViewPageShowParameter(showParameter);
        showParameter.setFormId("mobsp_purorderview");
    }

    @Override
    public List<FilterCondition> getFilters() {
        List<FilterCondition> filters = super.getFilters();
        this.addFilters(filters);
        return filters;
    }

    private void addFilters(List<FilterCondition> qFilters) {
        MobileFormShowParameter param;
        String customParam;
        List orderFilters = ScpBillOfBizPersonFilter.orderFilter();
        List filterConditions = ConverterUtils.getFilterConditionList((List)orderFilters);
        if (!filterConditions.isEmpty()) {
            qFilters.addAll(filterConditions);
        }
        if (StringUtils.isEmpty((CharSequence)(customParam = (String)(param = (MobileFormShowParameter)this.getView().getFormShowParameter()).getCustomParam(ACTIVE_TAB)))) {
            return;
        }
        if (UNCONFIRM.equals(customParam)) {
            qFilters.add(new FilterCondition("cfmstatus", "=", (Object)ConfirmStatusEnum.UNCONFIRM.getVal()));
            qFilters.add(new FilterCondition("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal()));
        } else if (NO_SHIPMENT.equals(customParam)) {
            qFilters.add(new FilterCondition("logstatus", "=", (Object)LogisticsStatusEnum.CONFIRM.getVal()));
            qFilters.add(new FilterCondition("cfmstatus", "=", (Object)CfmStatusEnum.CONFIRM.getValue()));
        }
    }

    public boolean isAddModificationMutex(String billStatus) {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject entryObject = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(rowIndex);
        String cfmStatus = entryObject.getString("cfmstatus");
        return ConfirmStatusEnum.UNCONFIRM.getVal().equals(cfmStatus);
    }
}

