/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.plugin.form.scp.purorder;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.SupplierDataPermHelper;
import kd.scm.mobsp.common.enums.LogStatusEnum;
import kd.scmc.msmob.business.helper.PermissionHelper;
import kd.scmc.msmob.common.enums.CfmStatusEnum;
import kd.scmc.msmob.common.utils.MetaUtils;
import kd.scmc.msmob.common.utils.PageUtils;
import kd.scmc.msmob.plugin.tpl.basetpl.scbill.ScBillInfoTplPlugin;

public class PurOrderViewPlugin
extends ScBillInfoTplPlugin {
    private static final Log LOG = LogFactory.getLog(PurOrderViewPlugin.class);
    protected static final String BUTTONCONFIRM = "buttonconfirm";
    protected static final String BUTTONREJECT = "buttonreject";
    protected static final String BUTTONUNCONFIRM = "buttonunconfirm";
    protected static final String BUTTONPUSH = "buttonpush";
    protected static final String CFMSTATUS = "cfmstatus";
    protected static final String LOGSTATUS = "logstatus";
    private static final String PUSH_RESULT = "pushResult";
    private static final String PC_ID = "pcId";
    private static final String PC_ENTITY = "pcentity";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        this.preOpenFormByLink(e);
    }

    private void preOpenFormByLink(PreOpenFormEventArgs e) {
        Object pkId;
        FormShowParameter formShowParameter = e.getFormShowParameter();
        String formKey = formShowParameter.getFormId();
        if (StringUtils.isEmpty((CharSequence)formKey)) {
            e.setCancel(true);
            String errMsg = ResManager.loadKDString((String)"\u79fb\u52a8\u8868\u5355\u6807\u8bc6\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MobScpBillInfoTplPlugin_3", (String)"scm-mobsp-form", (Object[])new Object[0]);
            e.setCancelMessage(errMsg);
            return;
        }
        Object pkIdFromLink = formShowParameter.getCustomParam("pkId");
        Object pkIdFromList = formShowParameter.getCustomParam("billid");
        Object object = pkId = pkIdFromLink == null ? pkIdFromList : pkIdFromLink;
        if (pkId == null || "".equals(pkId.toString())) {
            e.setCancel(true);
            String errMsg = ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u4e0d\u5b58\u5728\u6216\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MobScpBillInfoTplPlugin_2", (String)"scm-mobsp-form", (Object[])new Object[0]);
            e.setCancelMessage(errMsg);
            return;
        }
        String pcEntityKey = this.getDataSourceConfigService().getDataSourceConfig(formKey).getPcEntityKey();
        DynamicObject pcEntityDy = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)pcEntityKey);
        DynamicObject mainOrg = pcEntityDy.getDynamicObject("org");
        String billNo = pcEntityDy.getString("billno");
        if (mainOrg == null) {
            e.setCancel(true);
            String errMsg = String.format(ResManager.loadKDString((String)"PC\u7aef\u5355\u636e\u201c%1$s-%2$s\u201d\u7684\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MobScpBillInfoTplPlugin_0", (String)"scm-mobsp-form", (Object[])new Object[0]), pcEntityKey, billNo);
            e.setCancelMessage(errMsg);
            return;
        }
        String pcAppId = MetaUtils.getPcAppId((String)pcEntityKey);
        Long orgId = mainOrg.getLong("id");
        boolean hasViewPerm = PermissionHelper.checkPermission((Long)orgId, (String)pcAppId, (String)pcEntityKey, (String)"47150e89000000ac");
        if (hasViewPerm) {
            Map resultMap = SupplierDataPermHelper.verifySupplierDataPerm((String)pcEntityKey, (Object)pkId);
            LOG.info("\u3010PurOrderViewPlugin.preOpenFormByLink\u3011\u8c03\u7528PC\u7aef\u3010kd.scm.common.util.SupplierDataPermHelper.verifySupplierDataPerm\u3011\u63a5\u53e3\u7684\u8fd4\u56de\u503c\uff1a{}", (Object)resultMap);
            Boolean isSucceed = (Boolean)resultMap.get("succed");
            if (isSucceed.booleanValue()) {
                formShowParameter.setCustomParam("billid", (Object)Long.valueOf(pkId.toString()));
            } else {
                Object message = resultMap.get("message");
                e.setCancel(true);
                e.setCancelMessage(message.toString());
            }
        } else {
            LocaleString displayName = pcEntityDy.getDataEntityType().getDisplayName();
            String billName = displayName == null ? "" : displayName.getLocaleValue();
            String errMsg = String.format(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u67e5\u8be2\u6743\u9650\uff0c \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MobScpBillInfoTplPlugin_1", (String)"scm-mobsp-form", (Object[])new Object[0]), billName);
            e.setCancel(true);
            e.setCancelMessage(errMsg);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BUTTONREJECT});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setVisible();
    }

    private void setVisible() {
        this.setLogStatusVisible();
        this.setCfmStatusVisible();
        this.setButtonVisible();
    }

    private void setButtonVisible() {
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        Object cfmStatus = model.getValue(CFMSTATUS);
        Object logStatus = model.getValue(LOGSTATUS);
        view.setVisible(Boolean.FALSE, new String[]{BUTTONCONFIRM, BUTTONREJECT, BUTTONUNCONFIRM, BUTTONPUSH});
        if (null == cfmStatus) {
            return;
        }
        if (CfmStatusEnum.UNCONFIRM.getValue().equals(cfmStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{BUTTONCONFIRM, BUTTONREJECT});
        } else if (CfmStatusEnum.CONFIRM.getValue().equals(cfmStatus) && LogStatusEnum.NO_SHIPMENT.getValue().equals(logStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{BUTTONUNCONFIRM});
        }
        if (CfmStatusEnum.CONFIRM.getValue().equals(cfmStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{BUTTONPUSH});
        }
        view.updateView("mtoolbarap");
    }

    public void click(EventObject e) {
        super.click(e);
        Control control = (Control)e.getSource();
        String key = control.getKey();
        if (BUTTONREJECT.equals(key)) {
            IPageCache pageCache = this.getPageCache();
            String pcId = pageCache.get(PC_ID);
            MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
            formShowParameter.setFormId("mobsp_confirmreject");
            formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "reject"));
            formShowParameter.setCustomParam("id", (Object)pcId);
            formShowParameter.setCustomParam(PC_ENTITY, (Object)this.getPcEntityKey());
            this.getView().showForm((FormShowParameter)formShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String returnData = (String)closedCallBackEvent.getReturnData();
        if ("reject".equals(returnData) && closedCallBackEvent.getActionId().equals("reject")) {
            String tips = ResManager.loadKDString((String)"\u5355\u636e\u5df2\u6253\u56de\u6210\u529f\u3002", (String)"PurOrderViewPlugin_0", (String)"scm-mobsp-form", (Object[])new Object[0]);
            this.getView().showSuccessNotification(tips);
            this.getView().close();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        this.getModel().setValue(CFMSTATUS, this.getBill().get(CFMSTATUS));
        this.getModel().setValue(LOGSTATUS, this.getBill().get(LOGSTATUS));
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        boolean success = operationResult.isSuccess();
        FormOperate formOperate = (FormOperate)args.getSource();
        OperateOption option = formOperate.getOption();
        if ("push".equals(operateKey) && success) {
            String pushResult = option.getVariableValue(PUSH_RESULT);
            Map pushMap = (Map)SerializationUtils.fromJsonString((String)pushResult, HashMap.class);
            PageUtils.showFormPage((IFormView)this.getView(), (String)"mobsp_saloutstockedit", (Map)pushMap, null);
        }
        if (success && "agreeorder".equals(operateKey)) {
            this.getModel().setValue(LOGSTATUS, (Object)LogStatusEnum.NO_SHIPMENT.getValue());
        }
        this.setVisible();
    }

    private void setCfmStatusVisible() {
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        Object cfmStatus = model.getValue(CFMSTATUS);
        view.setVisible(Boolean.FALSE, new String[]{"labelunconfirm", "labelconfirm", "labelreject", "labelchanging", "labelautoconfirm"});
        if (CfmStatusEnum.UNCONFIRM.getValue().equals(cfmStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{"labelunconfirm"});
        } else if (CfmStatusEnum.CONFIRM.getValue().equals(cfmStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{"labelconfirm"});
        } else if (CfmStatusEnum.REJECT.getValue().equals(cfmStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{"labelreject"});
        } else if (CfmStatusEnum.CHANGING.getValue().equals(cfmStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{"labelchanging"});
        } else if (CfmStatusEnum.AUTO_CONFIRM.getValue().equals(cfmStatus)) {
            view.setVisible(Boolean.valueOf(false), new String[]{"scbilltpl_layoutflex1"});
            view.setVisible(Boolean.TRUE, new String[]{"labelautoconfirm"});
        }
    }

    private void setLogStatusVisible() {
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        Object logStatus = model.getValue(LOGSTATUS);
        view.setVisible(Boolean.FALSE, new String[]{"noshipment", "partialshipment", "shipped", "partialreceipt", "received", "partialstorage", "storage"});
        if (LogStatusEnum.NO_SHIPMENT.getValue().equals(logStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{"noshipment"});
        }
        if (LogStatusEnum.PARTIAL_SHIPMENT.getValue().equals(logStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{"partialshipment"});
        }
        if (LogStatusEnum.SHIPPED.getValue().equals(logStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{"shipped"});
        }
        if (LogStatusEnum.PARTIAL_RECEIPT.getValue().equals(logStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{"partialreceipt"});
        }
        if (LogStatusEnum.SHIPPED.getValue().equals(logStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{"shipped"});
        }
        if (LogStatusEnum.PARTIAL_RECEIPT.getValue().equals(logStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{"partialreceipt"});
        }
        if (LogStatusEnum.RECEIVED.getValue().equals(logStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{"received"});
        }
        if (LogStatusEnum.PARTIAL_STORAGE.getValue().equals(logStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{"partialstorage"});
        }
        if (LogStatusEnum.STORAGE.getValue().equals(logStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{"storage"});
        }
    }

    public String getEntryFormKey() {
        return "";
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        String myLock = this.getPageCache().get("myLock");
        if ("true".equals(myLock)) {
            String billId = this.getPageCache().get(PC_ID);
            MutexHelper.release((String)this.getPcEntityKey(), (String)"modify", (String)billId);
        }
    }

    protected String getMainEntryTitle() {
        IDataModel model = this.getModel();
        String entryKey = this.getEntryEntity();
        int entryRowCount = model.getEntryRowCount(entryKey);
        return String.valueOf(entryRowCount);
    }
}

