/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.plugin.form.scp.quote;

import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.scm.mobsp.common.helper.PermissionHelper;
import kd.scm.mobsp.common.helper.SourcingAPIQueryParamHelper;
import kd.scm.mobsp.common.helper.StatusConsistencyHelper;
import kd.scm.mobsp.plugin.form.scp.quote.enumeration.BillStatusEnum;
import kd.scm.mobsp.plugin.form.scp.quote.vo.QuoteBillDetailVo;
import kd.scm.mobsp.plugin.form.scp.quote.vo.QuoteListResult;
import kd.scmc.msmob.mvccore.IMobileApiPage;
import kd.scmc.msmob.mvccore.IMobileApiSearch;
import kd.scmc.msmob.mvccore.MobileApiRendererUtils;
import kd.scmc.msmob.mvccore.MobileOpenApiPluginHelper;
import kd.scmc.msmob.mvccore.MobileSearchParameter;
import kd.scmc.msmob.mvccore.MobileViewModelUtils;
import kd.scmc.msmob.mvccore.OpenApiDataSource;

public class MobSpQuoteBillListPlugin
extends AbstractMobBillPlugIn
implements IMobileApiSearch<QuoteListResult>,
IDataModelChangeListener,
IMobileApiPage {
    private static final String TIME_FILTER_START_TIME = "daterange_start";
    private static final String TIME_FILTER_END_TIME = "daterange_end";
    private static final String STATUS_FILTER = "statusfilter";
    private static final String OPEN_STATUS_FILTER = "openstatusfilter";
    private static final String[] DEFAULT_PARAMS = new String[]{"id", "ispuragent", "billdate", "turns", "bizstatus", "suppliertype", "bizpartner_number", "supplier_number", "supplier_id"};
    private static final String MODIFY = "modify";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        IFormView view = this.getView();
        MobileOpenApiPluginHelper.addEntryPageListener((AbstractFormPlugin)this);
        MobileOpenApiPluginHelper.addMobileSearchTextListener((AbstractFormPlugin)this);
        MobileOpenApiPluginHelper.addRowClickListener((AbstractFormPlugin)this, (value, mobileFormShowParameter) -> {
            boolean checkMutex;
            boolean consistency = StatusConsistencyHelper.checkConsistency(this, view, value, new QuoteBillDetailVo(), "/v2/tnd/tnd_quotebill/getDetail", "billstatus");
            if (!consistency) {
                return null;
            }
            if (BillStatusEnum.SAVE.getFieldValue().equals(value.getBillstatus()) && !(checkMutex = PermissionHelper.checkMutex(this, this.getPcEntity(), value.getBillstatus(), BillStatusEnum.SAVE, value.getId(), value.getOrgId()))) {
                this.getView().getPageCache().put("valueId", String.valueOf(value.getId()));
                return null;
            }
            mobileFormShowParameter.setFormId("mobsp_sourcing_quotebill");
            mobileFormShowParameter.setCustomParam("id", (Object)value.getId());
            return mobileFormShowParameter;
        });
        this.addPullRefreshListener();
    }

    private void addPullRefreshListener() {
        CardEntry card = (CardEntry)this.getView().getControl(MobileViewModelUtils.getFirstEntryName((AbstractFormPlugin)this));
        MobSpQuoteBillListPlugin plugin = this;
        card.addPullRefreshlisteners(evt -> MobileApiRendererUtils.renderListPage((AbstractFormPlugin)plugin));
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        MobileApiRendererUtils.renderListPage((AbstractFormPlugin)this);
    }

    public OpenApiDataSource<QuoteListResult> getDatasourceConfig() {
        return new OpenApiDataSource("/v2/tnd/tnd_quotebill/getList", QuoteListResult.class);
    }

    public MobileSearchParameter getApiSearchParameters(MobileSearchParameter parameter) {
        Date dateRangeStart = (Date)this.getModel().getValue(TIME_FILTER_START_TIME);
        Date dateRangeEnd = (Date)this.getModel().getValue(TIME_FILTER_END_TIME);
        String selectedBillStatus = (String)this.getModel().getValue(STATUS_FILTER);
        String selectedOpenStatus = (String)this.getModel().getValue(OPEN_STATUS_FILTER);
        return new SourcingAPIQueryParamHelper((AbstractFormPlugin)this).setBillStatus(selectedBillStatus).setOpenStatus(selectedOpenStatus).setDateRange(dateRangeStart, dateRangeEnd).setDefaultParams(DEFAULT_PARAMS).setSearchParameter().build();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (TIME_FILTER_START_TIME.equals(propName) || TIME_FILTER_END_TIME.equals(propName) || STATUS_FILTER.equals(propName) || OPEN_STATUS_FILTER.equals(propName)) {
            MobileApiRendererUtils.renderListPage((AbstractFormPlugin)this);
        }
    }

    public String getPcEntity() {
        return "tnd_quotebill";
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        PermissionHelper.mutexConfirmCallBack(this.getView(), messageBoxClosedEvent, () -> {
            MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
            mobileFormShowParameter.setCustomParam("id", (Object)this.getPageCache().get("valueId"));
            mobileFormShowParameter.setFormId("mobsp_sourcing_quotebill");
            mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
            this.getView().showForm((FormShowParameter)mobileFormShowParameter);
        });
    }
}

