/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.plugin.form.scp.quote;

import java.util.EventObject;
import java.util.function.Consumer;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.scm.mobsp.common.entity.componentvo.SrcPurListStandEntryResult;
import kd.scm.mobsp.common.handler.PreviousAndNextClickHandler;
import kd.scm.mobsp.common.helper.ConfigHelper;
import kd.scm.mobsp.common.helper.SourcingFileHelper;
import kd.scm.mobsp.plugin.form.scp.quote.enumeration.BidStatusEnum;
import kd.scm.mobsp.plugin.form.scp.quote.enumeration.BillStatusEnum;
import kd.scm.mobsp.plugin.form.scp.quote.handler.QuoteEntryPropertyChangedHandler;
import kd.scm.mobsp.plugin.form.scp.quote.vo.QuoteBillDetailVo;
import kd.scmc.msmob.business.helper.AttachmentHelper;
import kd.scmc.msmob.mvccore.IMobileApiEntryPage;
import kd.scmc.msmob.mvccore.MobileApiRendererUtils;
import kd.scmc.msmob.mvccore.MobileViewModelUtils;

public class QuoteEntryViewPlugin
extends AbstractMobBillPlugIn
implements IMobileApiEntryPage<QuoteBillDetailVo, SrcPurListStandEntryResult, SrcPurListStandEntryResult> {
    private static final String[] ENTRY_FIELDS = new String[]{"qty", "unit_id", "price", "taxitem_id", "currency_id", "taxprice", "note", "amount", "taxamount", "sup_attach", "brand"};
    private static final String PREVIOUS_BTN = "previous";
    private static final String NEXT_BTN = "next";
    private static final String CLOSE_BTN = "close";
    private static final String RETURN_BTN = "retun_btn";
    private static final String CURRENCY_FIELD = "currency_id";
    private static final String[] DISABLED_FIELDS = new String[]{"amount", "locamount", "taxamount"};

    public void initialize() {
        super.initialize();
        MobileApiRendererUtils.addDataModelChangeListener((AbstractFormPlugin)this);
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        model.addDataModelChangeListener((IDataModelChangeListener)new QuoteEntryPropertyChangedHandler(view, this.getCachedObjectStorageView()));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{PREVIOUS_BTN, NEXT_BTN, CLOSE_BTN});
        MobileViewModelUtils.addPreviousAndNextListener((AbstractFormPlugin)this, (String)PREVIOUS_BTN, (String)NEXT_BTN);
        Button previousBtn = (Button)this.getControl(PREVIOUS_BTN);
        Button nextBtn = (Button)this.getControl(NEXT_BTN);
        QuoteEntryViewPlugin plugin = this;
        Consumer<Object> operation = detailVo -> {
            if (!(detailVo instanceof QuoteBillDetailVo)) {
                return;
            }
            plugin.setEditable((QuoteBillDetailVo)((Object)((Object)detailVo)));
            plugin.setButtonVisible((QuoteBillDetailVo)((Object)((Object)detailVo)));
            plugin.setNewTargetLabelVisible((QuoteBillDetailVo)((Object)((Object)detailVo)));
        };
        previousBtn.addClickListener((ClickListener)new PreviousAndNextClickHandler(this.getView(), operation));
        nextBtn.addClickListener((ClickListener)new PreviousAndNextClickHandler(this.getView(), operation));
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        QuoteBillDetailVo quoteBillDetailVo = (QuoteBillDetailVo)((Object)MobileApiRendererUtils.renderEntryPage((AbstractFormPlugin)this));
        this.setEditable(quoteBillDetailVo);
        this.setButtonVisible(quoteBillDetailVo);
        this.setNewTargetLabelVisible(quoteBillDetailVo);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (SourcingFileHelper.checkFileExpire(this.getView(), "sup_attach", "tnd_quotebill")) {
            return;
        }
        e.setCancel(true);
        this.getView().updateView();
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        if (AttachmentHelper.checkAttachmentSaveOrNot((IFormView)this.getView())) {
            evt.setCancel(true);
        }
    }

    public void setButtonVisible(QuoteBillDetailVo quoteBillDetailVo) {
        String billStatus = quoteBillDetailVo.getBillstatus();
        if (BillStatusEnum.AUDIT.getFieldValue().equals(billStatus) || BillStatusEnum.SUBMIT.getFieldValue().equals(billStatus)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{CLOSE_BTN});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{RETURN_BTN});
        }
    }

    public void setNewTargetLabelVisible(QuoteBillDetailVo quoteBillDetailVo) {
        SrcPurListStandEntryResult entryData = this.getCurrentEntryData(quoteBillDetailVo);
        this.getView().setVisible(entryData.getIsnew(), new String[]{"new_target_label"});
    }

    private SrcPurListStandEntryResult getCurrentEntryData(QuoteBillDetailVo quoteBillDetailVo) {
        int currentRowIndex = this.getCurrentEntryIndex();
        return quoteBillDetailVo.getEntryentity().get(currentRowIndex);
    }

    public void setEditable(QuoteBillDetailVo detailVo) {
        IFormView view = this.getView();
        ConfigHelper.beginSetByConfig(view).setMulti(detailVo.getEntryentity(), detailVo.getId(), "tnd_quotebill").setPrice(detailVo.getTaxtype(), detailVo.getDecisiontype()).setDiscard(detailVo.getEntryentity(), this.getCurrentEntryIndex()).finishSet();
        String openStatus = (String)view.getFormShowParameter().getCustomParam("open_status");
        if (BidStatusEnum.STATUS5.getFieldValue().equals(openStatus)) {
            view.setEnable(Boolean.valueOf(false), new String[]{CURRENCY_FIELD});
        }
        this.setEditableByBillStatus(detailVo);
    }

    private void setEditableByBillStatus(QuoteBillDetailVo quoteBillDetailVo) {
        IFormView view = this.getView();
        String entryDisplayMode = (String)view.getFormShowParameter().getCustomParam("entry_display_mode");
        if (entryDisplayMode.equals("can_not_modify")) {
            view.setEnable(Boolean.valueOf(false), ENTRY_FIELDS);
        } else {
            SrcPurListStandEntryResult currentEntryData = this.getCurrentEntryData(quoteBillDetailVo);
            if (currentEntryData.getIsnew().booleanValue()) {
                view.setEnable(Boolean.valueOf(true), new String[]{"materialnane", "materialmodel", "note", "brand"});
            } else {
                view.setEnable(Boolean.valueOf(false), new String[]{"materialnane", "materialmodel", "brand"});
            }
        }
    }
}

