/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.plugin.form.scp.quote.handler;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.scm.common.util.cal.CalculateUtils;
import kd.scm.mobsp.plugin.form.scp.quote.vo.QuoteBillDetailVo;
import kd.scmc.msmob.mvccore.MobileApiRendererUtils;

public class QuoteEntryPropertyChangedHandler
implements IDataModelChangeListener {
    private final IDataModel model;
    private final IFormView view;
    private final IFormView cachedObjectStorageView;
    private static final String PRICE = "price";
    private static final String TAX_PRICE = "taxprice";
    private static final String QTY = "qty";
    private static final String TAX_ITEM = "taxitem_id";
    private static final String AMOUNT = "amount";
    private static final String TAX_AMOUNT = "taxamount";
    private static final String CURRENCY_ID = "currency_id";
    private static final String TAX_RATE = "taxrate";
    private static final String PRICE_PRECISION = "priceprecision";
    private static final String AMTP_PRECISION = "amtprecision";

    public QuoteEntryPropertyChangedHandler(IFormView view, IFormView cachedObjectStorageView) {
        this.cachedObjectStorageView = cachedObjectStorageView;
        this.view = view;
        this.model = view.getModel();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        BigDecimal taxrate;
        IDataEntityProperty property = e.getProperty();
        String propertyName = property.getName();
        QuoteBillDetailVo quoteBillDetailVo = (QuoteBillDetailVo)((Object)MobileApiRendererUtils.getCachedObject((IFormView)this.cachedObjectStorageView));
        DynamicObject dataEntity = this.model.getDataEntity();
        DynamicObject currency = (DynamicObject)this.model.getValue(CURRENCY_ID);
        int pricePrecision = currency == null ? 0 : currency.getInt(PRICE_PRECISION);
        int amountPrecision = currency == null ? 0 : currency.getInt(AMTP_PRECISION);
        DynamicObject taxitem = (DynamicObject)this.model.getValue(TAX_ITEM);
        BigDecimal bigDecimal = taxrate = taxitem == null ? new BigDecimal(0) : taxitem.getBigDecimal(TAX_RATE);
        if (taxrate == null) {
            taxrate = BigDecimal.ZERO;
        }
        BigDecimal taxprice = dataEntity.getBigDecimal(TAX_PRICE);
        BigDecimal price = dataEntity.getBigDecimal(PRICE);
        BigDecimal qty = dataEntity.getBigDecimal(QTY);
        BigDecimal taxamount = dataEntity.getBigDecimal(TAX_AMOUNT);
        BigDecimal amount = dataEntity.getBigDecimal(AMOUNT);
        String taxtype = quoteBillDetailVo.getTaxtype();
        String decisionType = quoteBillDetailVo.getDecisiontype();
        BigDecimal rate = taxrate.divide(new BigDecimal(100)).add(new BigDecimal(1));
        if ("1".equals(decisionType)) {
            if ("1".equals(taxtype) && (propertyName.equals(TAX_PRICE) || propertyName.equals(TAX_ITEM))) {
                price = CalculateUtils.calPrice((BigDecimal)taxprice, (BigDecimal)taxrate, (int)pricePrecision);
                taxamount = taxprice.multiply(qty).setScale(amountPrecision, RoundingMode.HALF_UP);
                amount = taxamount.divide(rate, amountPrecision, RoundingMode.HALF_UP);
            } else if ("2".equals(taxtype) && (propertyName.equals(PRICE) || propertyName.equals(TAX_ITEM))) {
                taxprice = CalculateUtils.calTaxPrice((BigDecimal)price, (BigDecimal)taxrate, (int)pricePrecision);
                amount = price.multiply(qty).setScale(amountPrecision, RoundingMode.HALF_UP);
                taxamount = amount.multiply(rate).setScale(amountPrecision, RoundingMode.HALF_UP);
            }
            if (propertyName.equals(QTY)) {
                amount = price.multiply(qty).setScale(amountPrecision, RoundingMode.HALF_UP);
                taxamount = amount.multiply(rate).setScale(amountPrecision, RoundingMode.HALF_UP);
            }
        } else if ("2".equals(decisionType)) {
            if ("1".equals(taxtype) && (propertyName.equals(TAX_AMOUNT) || propertyName.equals(TAX_ITEM))) {
                amount = taxamount.divide(rate, amountPrecision, RoundingMode.HALF_UP);
                taxprice = taxamount.divide(qty, pricePrecision, RoundingMode.HALF_UP);
                price = taxprice.divide(rate, pricePrecision, RoundingMode.HALF_UP);
            } else if ("2".equals(taxtype) && (propertyName.equals(AMOUNT) || propertyName.equals(TAX_ITEM))) {
                BigDecimal tax = CalculateUtils.calTax((BigDecimal)amount, (BigDecimal)taxrate, (int)pricePrecision);
                taxamount = CalculateUtils.calTaxAmount((BigDecimal)amount, (BigDecimal)tax, (int)amountPrecision);
                price = amount.divide(qty, pricePrecision, RoundingMode.HALF_UP);
                taxprice = price.multiply(rate).setScale(pricePrecision, RoundingMode.HALF_UP);
            }
            if (propertyName.equals(QTY)) {
                price = amount.divide(qty, pricePrecision, RoundingMode.HALF_UP);
                taxprice = price.multiply(rate).setScale(pricePrecision, RoundingMode.HALF_UP);
            }
        }
        this.setPriceAndAmount(price, taxprice, amount, taxamount);
    }

    private void setPriceAndAmount(BigDecimal price, BigDecimal taxPrice, BigDecimal amount, BigDecimal taxAmount) {
        this.model.setValue(PRICE, (Object)price);
        this.model.setValue(TAX_PRICE, (Object)taxPrice);
        this.model.setValue(AMOUNT, (Object)amount);
        this.model.setValue(TAX_AMOUNT, (Object)taxAmount);
    }
}

