/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.plugin.form.scp.register;

import java.net.URLEncoder;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.scm.adm.common.utils.SrmSupplierRegisterInfo;
import kd.scm.adm.common.utils.SupplierRegisterUtils;
import kd.scm.mobsp.business.helper.RegisterAgreementResult;
import kd.scm.mobsp.business.helper.RegisterHelper;
import kd.scm.mobsp.business.helper.RegisterValidateCodeResult;
import kd.scm.mobsp.plugin.form.scp.register.RegisterPluginHelper;
import kd.scm.mobsp.plugin.form.scp.register.ValidateCodeSupportHelper;
import kd.scmc.msmob.common.utils.PropertyValueUtils;

public class RegisterPlugin
extends AbstractMobBillPlugIn {
    private static final String URL = "url";
    private static final String CUSTOM_PARAM = "customParam";
    private static final String LOGIN_BUTTON = "login_btn";
    private static final String REGISTER_CHECK_BUTTON = "register_check_button";
    private static final String REGISTER_CHECK_PAGE = "mobsp_register_check";
    private static final String AGREEMENT_CLOSED_EVENT = "agreementClosed_event";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (RegisterHelper.isForceReadAgreement()) {
            CloseCallBack agreementClosed = new CloseCallBack((IFormPlugin)this, AGREEMENT_CLOSED_EVENT);
            this.goToAgreementPage(agreementClosed);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "agreementClosed_event": {
                this.getView().updateView("isagreed");
                break;
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"agreement", "btn_submit", LOGIN_BUTTON, REGISTER_CHECK_BUTTON});
        ValidateCodeSupportHelper.registerCaptchaButtonListener((AbstractFormPlugin)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        RegisterPluginHelper.setLogoImage((AbstractFormPlugin)this);
        ValidateCodeSupportHelper.setInvisibleOnPageInit((AbstractFormPlugin)this);
        this.setSubmitEnable();
        ValidateCodeSupportHelper.setGetMsgEnable((AbstractFormPlugin)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        block12: for (int i = 0; i < valueSet.length; ++i) {
            if (!PropertyValueUtils.isValueChanged((PropertyChangedArgs)e, (int)0)) continue;
            switch (propName) {
                case "number": {
                    this.setSubmitEnable();
                    ValidateCodeSupportHelper.setGetMsgEnable((AbstractFormPlugin)this);
                    continue block12;
                }
                case "creditno": 
                case "enterprise": 
                case "isagreed": 
                case "name": 
                case "validatecode": {
                    this.setSubmitEnable();
                    continue block12;
                }
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        String key;
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "getmsg": {
                this.getCode();
                break;
            }
            case "btn_submit": {
                boolean success = ValidateCodeSupportHelper.checkValidateCode((AbstractFormPlugin)this);
                if (success) break;
                evt.setCancel(true);
                break;
            }
        }
    }

    private void getCode() {
        HashMap<String, String> param = this.assemblyParam();
        RegisterValidateCodeResult code = RegisterHelper.getCode(param);
        ValidateCodeSupportHelper.handleCaptchaCode(param.get("number"), (AbstractFormPlugin)this, code, ResManager.loadKDString((String)"\u6ce8\u518c\u8d44\u6599\u4e0d\u7b26\u5408\u8981\u6c42\u3002", (String)"RegisterPlugin_2", (String)"scm-mobsp-form", (Object[])new Object[0]));
    }

    private HashMap<String, String> assemblyParam() {
        HashMap<String, String> param = new HashMap<String, String>(8);
        IDataModel model = this.getModel();
        Object name = model.getValue("name");
        Object num = model.getValue("number");
        Object creditNo = model.getValue("creditno");
        Object enterprise = model.getValue("enterprise");
        Object isAgreed = model.getValue("isagreed");
        param.put("name", String.valueOf(name));
        param.put("number", String.valueOf(num));
        param.put("creditno", String.valueOf(creditNo));
        param.put("enterprise", String.valueOf(enterprise));
        param.put("isagreed", String.valueOf(isAgreed));
        return param;
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "register_check_button": {
                this.goPage(REGISTER_CHECK_PAGE, null, null);
                break;
            }
            case "login_btn": {
                RegisterPlugin.goToLoginPage(this);
                break;
            }
            case "agreement": {
                this.goToAgreementPage(null);
                break;
            }
            case "btn_submit": {
                this.submitClick();
                break;
            }
        }
    }

    private void goToAgreementPage(CloseCallBack agreementClosed) {
        RegisterAgreementResult agreementContent = RegisterHelper.getAgreementContent();
        if (agreementContent == null || !agreementContent.hasPublishedAgreement()) {
            String tips = ResManager.loadKDString((String)"\u6ce8\u518c\u534f\u8bae\u672a\u53d1\u5e03\uff0c\u8bf7\u4e0e\u91c7\u8d2d\u65b9\u8054\u7cfb\u3002", (String)"RegisterPlugin_8", (String)"scm-mobsp-form", (Object[])new Object[0]);
            this.getView().showErrorNotification(tips);
            return;
        }
        this.goPage("mobsp_registerprotocol", null, agreementClosed);
    }

    private void setSubmitEnable() {
        Object code;
        Object isAgreed;
        OrmLocaleValue localeValue;
        String value;
        Object enterprise;
        Object creditNo;
        Object num;
        OrmLocaleValue localeValue2;
        String value2;
        IDataModel model = this.getModel();
        boolean isEnable = true;
        Object name = model.getValue("name");
        if (name == null || ((OrmLocaleValue)name).size() <= 0) {
            isEnable = false;
        }
        if (name != null && ((value2 = (localeValue2 = (OrmLocaleValue)name).getLocaleValue()) == null || StringUtils.isEmpty((CharSequence)value2.trim()))) {
            isEnable = false;
        }
        if ((num = model.getValue("number")) == null || StringUtils.isEmpty((CharSequence)String.valueOf(num).trim())) {
            isEnable = false;
        }
        if ((creditNo = model.getValue("creditno")) == null || StringUtils.isEmpty((CharSequence)String.valueOf(creditNo).trim())) {
            isEnable = false;
        }
        if ((enterprise = model.getValue("enterprise")) == null || ((OrmLocaleValue)enterprise).size() <= 0) {
            isEnable = false;
        }
        if (enterprise != null && ((value = (localeValue = (OrmLocaleValue)enterprise).getLocaleValue()) == null || StringUtils.isEmpty((CharSequence)value.trim()))) {
            isEnable = false;
        }
        if ((isAgreed = model.getValue("isagreed")) == null || !((Boolean)isAgreed).booleanValue()) {
            isEnable = false;
        }
        if ((code = model.getValue("validatecode")) == null || StringUtils.isEmpty((CharSequence)String.valueOf(code).trim())) {
            isEnable = false;
        }
        this.getView().setEnable(Boolean.valueOf(isEnable), new String[]{"btn_submit"});
    }

    private void submitClick() {
        HashMap<String, String> param = this.assemblyParam();
        RegisterValidateCodeResult result = RegisterHelper.submit(param);
        if (result.isSuccess()) {
            SrmSupplierRegisterInfo registerInfo = SupplierRegisterUtils.getSupplierRegisterInfo((String)param.get("number"));
            this.goToProgressPage(registerInfo.getNumber());
        } else {
            String msg = result.getErrorMsg();
            if (StringUtils.isNotEmpty((CharSequence)msg)) {
                String tips = ResManager.loadKDString((String)"\u6ce8\u518c\u8d44\u6599\u4e0d\u7b26\u5408\u8981\u6c42\u3002", (String)"RegisterPlugin_2", (String)"scm-mobsp-form", (Object[])new Object[0]);
                this.getView().showConfirm(tips, msg, MessageBoxOptions.None, ConfirmTypes.Fail, null);
            }
        }
    }

    private void goToProgressPage(String number) {
        RegisterPluginHelper.goToRegisterProgressPage(this, number, false);
    }

    public static void goToLoginPage(AbstractMobBillPlugIn abstractMobBillPlugIn) {
        String clientFullContextPath = RequestContext.get().getClientFullContextPath();
        abstractMobBillPlugIn.getView().openUrl("login.html?redirect=" + URLEncoder.encode(clientFullContextPath + "mobile.html?form=mobsp_apphomepage_new"));
    }

    private void goPage(String pageNum, String param, CloseCallBack callBack) {
        MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
        formShowParameter.setFormId(pageNum);
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        if (StringUtils.isNotEmpty((CharSequence)param)) {
            formShowParameter.setCustomParam(CUSTOM_PARAM, (Object)param);
        }
        if (callBack != null) {
            formShowParameter.setCloseCallBack(callBack);
        }
        this.getView().showForm((FormShowParameter)formShowParameter);
    }
}

