/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.plugin.form.scp.register.input;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;

public abstract class AbstractItemInput {
    private final String itemTitle;
    private final String targetPage;
    private final boolean fieldRequired;
    protected final Set<String> INPUT_CHECK_FIELDS = new HashSet<String>();

    public AbstractItemInput(String itemTitle, String targetPage, boolean fieldRequired, String ... inputCheckFields) {
        this.itemTitle = itemTitle;
        this.targetPage = targetPage;
        this.fieldRequired = fieldRequired;
        this.INPUT_CHECK_FIELDS.addAll(Arrays.asList(inputCheckFields));
    }

    private Object getFieldValueFromDataEntity(DynamicObject dataEntity, String fieldName) {
        return dataEntity.get(fieldName);
    }

    private boolean checkFieldValueInput(DynamicObject dataEntity, String fieldName) {
        if (dataEntity == null) {
            return false;
        }
        Object fieldValue = this.getFieldValueFromDataEntity(dataEntity, fieldName);
        if (fieldValue == null) {
            return false;
        }
        if (fieldValue instanceof String) {
            String textContent = (String)fieldValue;
            return !StringUtils.isEmpty((CharSequence)textContent);
        }
        if (fieldValue instanceof Collection) {
            Collection collection = (Collection)fieldValue;
            return !collection.isEmpty();
        }
        return true;
    }

    private boolean checkHasAnyInputByFields(DynamicObject dataEntity) {
        if (this.fieldRequired) {
            return this.INPUT_CHECK_FIELDS.stream().allMatch(fieldName -> this.checkFieldValueInput(dataEntity, (String)fieldName));
        }
        return this.INPUT_CHECK_FIELDS.stream().anyMatch(fieldName -> this.checkFieldValueInput(dataEntity, (String)fieldName));
    }

    protected boolean hasAnyInput(DynamicObject dataEntity) {
        return this.checkHasAnyInputByFields(dataEntity);
    }

    protected String getTargetPage() {
        return this.targetPage;
    }

    public String getItemTitle() {
        return this.itemTitle;
    }

    public boolean isFieldRequired() {
        return this.fieldRequired;
    }
}

