/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.plugin.form.scp.register.input;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.scmc.msmob.business.helper.BaseDataFieldBizHelper;

public abstract class AbstractItemInputEntryPlugin
extends AbstractMobFormPlugin {
    private static final String OK_BUTTON = "ok_button";
    protected final List<String> FIELD_KEYS = new ArrayList<String>();

    public abstract String getEntryName();

    private Integer getEntryIndex() {
        Integer index = (Integer)this.getView().getFormShowParameter().getCustomParam("entryIndex");
        return index;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{OK_BUTTON});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey()) {
            case "ok_button": {
                this.saveDataToParentPage();
                break;
            }
        }
    }

    protected void saveDataToParentPage() {
        IFormView parentView = this.getView().getParentView();
        IDataModel parentModel = parentView.getModel();
        Integer entryIndex = this.getEntryIndex();
        parentModel.beginInit();
        if (this.getEntryIndex() == null) {
            entryIndex = parentModel.createNewEntryRow(this.getEntryName());
        }
        for (String fieldKey : this.FIELD_KEYS) {
            parentModel.setValue(fieldKey, this.getModel().getValue(fieldKey), entryIndex.intValue());
        }
        parentModel.endInit();
        parentView.updateView();
        this.getView().close();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setValuesFromParentPage();
    }

    private void setValuesFromParentPage() {
        if (this.getEntryIndex() != null) {
            List<String> fieldKeys = this.FIELD_KEYS;
            for (String fieldKey : fieldKeys) {
                this.setFieldValueFromParentPage(fieldKey);
            }
        }
    }

    protected void setFieldValueFromParentPage(String fieldKey) {
        IDataModel model = this.getModel();
        IDataModel parentModel = this.getView().getParentView().getModel();
        Object fieldValue = parentModel.getValue(fieldKey);
        model.beginInit();
        IDataEntityProperty property = parentModel.getProperty(fieldKey);
        if (property instanceof MulBasedataProp) {
            Object[] multiBaseDataIdArr = BaseDataFieldBizHelper.getMultiBaseDataIdArr((Object)fieldValue);
            model.setValue(fieldKey, (Object)multiBaseDataIdArr);
        } else {
            model.setValue(fieldKey, fieldValue);
        }
        model.endInit();
    }
}

