/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.plugin.form.scp.register.input;

import java.util.Collection;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.scm.mobsp.common.utils.BankCardUtils;
import kd.scm.mobsp.plugin.form.scp.register.input.AbstractItemInputWithEntryPlugin;
import kd.scm.mobsp.plugin.form.scp.register.input.anonymous.AnonymousDeclare;
import kd.scm.mobsp.plugin.form.scp.register.input.anonymous.AnonymousParentPageInterceptor;
import kd.scm.mobsp.plugin.form.scp.register.input.anonymous.InvoiceHandler;
import kd.scm.mobsp.plugin.form.scp.register.input.anonymous.PayConditionHandler;
import kd.scm.mobsp.plugin.form.scp.register.input.anonymous.SettlementTypeHandler;
import kd.scm.mobsp.plugin.form.scp.register.input.anonymous.TaxRateHandler;
import kd.scmc.msmob.common.utils.FormUtils;

public class FinancialInfoItemInputPlugin
extends AbstractItemInputWithEntryPlugin {
    private static final String TAX_RATE_ID = "taxrateid";
    private static final String TAX_RATE = "taxrate";
    private static final String ENTRY_BANK = "entry_bank";
    public static final String INVOICE_TYPE_ID = "invoicetypeid";
    private static final String NON_DATA_TIP = "non_data_tip";
    private static final String ACCOUNT = "account";
    private static final String ACCOUNT_DISPLAY = "account_display";

    public FinancialInfoItemInputPlugin() {
        this.addEntryButton = "add_bank_card";
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setAccountDisplay();
        this.setBankEntryVisibility();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addClickListener((AbstractFormPlugin)this, (String[])new String[]{TAX_RATE_ID});
        AnonymousParentPageInterceptor.registerF7Interceptor(this, new AnonymousDeclare().addField(INVOICE_TYPE_ID, InvoiceHandler.class).addField(TAX_RATE_ID, TaxRateHandler.class).addField("settletype", SettlementTypeHandler.class).addField("paycond", PayConditionHandler.class));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        block6: for (int i = 0; i < valueSet.length; ++i) {
            switch (propName) {
                case "taxrateid": {
                    this.setTaxRate((DynamicObject)e.getChangeSet()[0].getNewValue());
                    continue block6;
                }
            }
        }
    }

    private void setAccountDisplay() {
        DynamicObjectCollection bankCards = this.getModel().getDataEntity().getDynamicObjectCollection(ENTRY_BANK);
        bankCards.forEach(dynamicObject -> dynamicObject.set(ACCOUNT_DISPLAY, (Object)BankCardUtils.setBankCard(dynamicObject.getString(ACCOUNT))));
        this.updateData();
        this.getView().updateView(ENTRY_BANK);
    }

    private void setTaxRate(DynamicObject newTax) {
        IDataModel model = this.getModel();
        model.beginInit();
        model.setValue(TAX_RATE, newTax == null ? null : newTax.getBigDecimal(TAX_RATE));
        model.endInit();
        this.getView().updateView(TAX_RATE);
    }

    @Override
    public String getEntryName() {
        return ENTRY_BANK;
    }

    @Override
    public String getEditPageName() {
        return "mobsp_register_bank_edit";
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        this.setBankEntryVisibility();
        this.setAccountDisplay();
    }

    @Override
    protected void deleteEntry() {
        super.deleteEntry();
        this.setBankEntryVisibility();
    }

    private void setBankEntryVisibility() {
        this.getView().updateView(ENTRY_BANK);
        DynamicObjectCollection banks = this.getModel().getEntryEntity(ENTRY_BANK);
        IFormView view = this.getView();
        boolean isEmpty = CollectionUtils.isEmpty((Collection)banks);
        view.setVisible(Boolean.valueOf(!isEmpty), new String[]{ENTRY_BANK});
        view.setVisible(Boolean.valueOf(isEmpty), new String[]{NON_DATA_TIP});
    }
}

