/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.plugin.form.scp.register.input.anonymous;

import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.MobileSearchCancelListener;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.PagerClickEvent;
import kd.bos.form.events.PagerClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.MobileSearch;
import kd.scm.mobsp.plugin.form.scp.register.input.anonymous.AnonymousInfoDisplayItem;
import kd.scm.mobsp.plugin.form.scp.register.input.anonymous.AnonymousPageHandler;

public class AnonymousF7PagePlugin
extends AbstractMobBillPlugIn
implements MobileSearchTextChangeListener,
MobileSearchCancelListener,
RowClickEventListener,
PagerClickListener {
    private static final String ENTRY = "entryentity";
    public static final String ANONYMOUS_PAGE_HANDLER_CLASS = "ANONYMOUS_PAGE_HANDLER_CLASS";
    public static final String ANONYMOUS_PAGE_SELECTED_ID = "ANONYMOUS_PAGE_SELECTED_ID";
    public static final String ANONYMOUS_FIELD_ID = "ANONYMOUS_FIELD_ID";
    public static final String CLEAR_SELECTED = "clear_selected";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CLEAR_SELECTED});
        MobileSearch search = (MobileSearch)this.getControl("mobilesearchap");
        search.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
        search.addMobileSearchCancelListener((MobileSearchCancelListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        entryGrid.addPagerClickListener((PagerClickListener)this);
    }

    public List<? extends AnonymousInfoDisplayItem> getDisplayItems(String searchText) {
        AnonymousPageHandler anonymousPageHandler = this.getAnonymousPageHandler();
        List<? extends AnonymousInfoDisplayItem> displayItems = anonymousPageHandler.getDisplayItems(searchText, (AbstractFormPlugin)this);
        return displayItems;
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "clear_selected": {
                AnonymousPageHandler anonymousPageHandler = this.getAnonymousPageHandler();
                anonymousPageHandler.onSelected(null, (String)this.getView().getFormShowParameter().getCustomParam(ANONYMOUS_FIELD_ID), (AbstractBillPlugIn)this);
                this.getView().close();
            }
        }
    }

    private AnonymousPageHandler getAnonymousPageHandler() {
        AnonymousPageHandler anonymousPageHandler;
        String className = (String)this.getView().getFormShowParameter().getCustomParam(ANONYMOUS_PAGE_HANDLER_CLASS);
        try {
            Class<?> handlerClass = Class.forName(className);
            anonymousPageHandler = (AnonymousPageHandler)handlerClass.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        return anonymousPageHandler;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.fulfillEntry(null);
    }

    private void fulfillEntry(String searchText) {
        Object customParam = this.getView().getFormShowParameter().getCustomParam(ANONYMOUS_PAGE_SELECTED_ID);
        Long selectedId = customParam == null ? null : (customParam instanceof Integer ? Long.valueOf(((Integer)customParam).intValue()) : (Long)customParam);
        List<? extends AnonymousInfoDisplayItem> displayItems = this.getDisplayItems(searchText);
        IDataModel model = this.getModel();
        int size = displayItems.size();
        model.deleteEntryData(ENTRY);
        if (size > 0) {
            model.batchCreateNewEntryRow(ENTRY, size);
            for (int i = 0; i < size; ++i) {
                AnonymousInfoDisplayItem displayItem = displayItems.get(i);
                model.setValue("display_text", (Object)displayItem.getDisplayText(), i);
                model.setValue("mobid", (Object)displayItem.getId(), i);
                if (selectedId == null || !displayItem.getId().equals(selectedId)) continue;
                model.setValue("option_selected", (Object)true, i);
            }
        }
        this.getView().updateView();
    }

    public void click(MobileSearchTextChangeEvent mobileSearchTextChangeEvent) {
        this.fulfillEntry(mobileSearchTextChangeEvent.getText());
    }

    public void cancel() {
        this.fulfillEntry(null);
    }

    public void entryRowClick(RowClickEvent rowClickEvent) {
        IDataModel model = this.getModel();
        int row = rowClickEvent.getRow();
        DynamicObject dynamicObject = model.getEntryRowEntity(ENTRY, row);
        long mobid = dynamicObject.getLong("mobid");
        String displayText = dynamicObject.getString("display_text");
        AnonymousPageHandler anonymousPageHandler = this.getAnonymousPageHandler();
        AnonymousInfoDisplayItem item = new AnonymousInfoDisplayItem();
        item.setId(mobid);
        item.setDisplayText(displayText);
        anonymousPageHandler.onSelected(item, (String)this.getView().getFormShowParameter().getCustomParam(ANONYMOUS_FIELD_ID), (AbstractBillPlugIn)this);
        this.getView().close();
    }

    public void pagerClick(PagerClickEvent pagerClickEvent) {
        pagerClickEvent.getPageRows();
        int maxPage = 25;
        int currentPageIndex = pagerClickEvent.getCurrentPageIndex();
        if (currentPageIndex == maxPage) {
            String totalTips = String.format(ResManager.loadKDString((String)"\u6700\u591a\u663e\u793a500\u6761\u6570\u636e\u3002", (String)"AnonymousF7PagePlugin_0", (String)"scm-mobsp-form", (Object[])new Object[0]), new Object[0]);
            this.getView().showTipNotification(totalTips);
        }
    }
}

