/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.plugin.form.scp.register.portal;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Steps;
import kd.bos.form.control.StepsOption;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.MobileListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.msmob.common.utils.FormUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;

public class RegisterProgressPlugin
extends AbstractMobBillPlugIn
implements RowClickEventListener {
    protected static final String FULFILL_BUTTON = "buttonap";
    public static final String INPUT_PAGE = "mobsp_register_input";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addClickListener((AbstractFormPlugin)this, (String[])new String[]{FULFILL_BUTTON});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject supplier = this.getSupplier();
        this.setId(supplier);
        this.setProgressBar(supplier);
        this.setButtonVisibility(supplier);
    }

    private void setId(DynamicObject supplier) {
        this.getModel().beginInit();
        this.getModel().setValue("number", supplier.get("number"));
        this.getModel().endInit();
    }

    public void setButtonVisibility(DynamicObject supplier) {
        SupplierAuditStatus auditStatus = SupplierAuditStatus.getAuditStatus(supplier);
        this.getView().setVisible(Boolean.valueOf(auditStatus == SupplierAuditStatus.A || auditStatus == SupplierAuditStatus.F), new String[]{FULFILL_BUTTON});
    }

    public void setProgressBar(DynamicObject supplier) {
        Steps steps = (Steps)this.getControl("stepsap");
        SupplierAuditStatus auditStatus = SupplierAuditStatus.getAuditStatus(supplier);
        if (auditStatus == null) {
            return;
        }
        List stepsOptions = steps.getStepsOptions();
        stepsOptions.clear();
        StepsOption stepsOption = new StepsOption();
        stepsOption.setTitle(new LocaleString(ResManager.loadKDString((String)"\u6ce8\u518c", (String)"RegisterProgressPlugin_0", (String)"scm-mobsp-form", (Object[])new Object[0])));
        stepsOption.setDescription(new LocaleString(new DateTime((Object)supplier.getDate("createtime")).toString("yyyy-MM-dd HH:mm:ss")));
        stepsOption.setStatus("create");
        stepsOptions.add(stepsOption);
        stepsOption = new StepsOption();
        stepsOption.setTitle(new LocaleString(ResManager.loadKDString((String)"\u8d44\u6599\u63d0\u4ea4", (String)"RegisterProgressPlugin_1", (String)"scm-mobsp-form", (Object[])new Object[0])));
        Date createDate = supplier.getDate("createtime");
        Date auditDate = supplier.getDate("auditdate");
        String applyTimeText = auditStatus.ordinal() >= SupplierAuditStatus.B.ordinal() && createDate != null ? new DateTime((Object)createDate).toString("yyyy-MM-dd HH:mm:ss") : ResManager.loadKDString((String)"\u672a\u5f00\u59cb", (String)"RegisterProgressPlugin_2", (String)"scm-mobsp-form", (Object[])new Object[0]);
        String auditTimeText = auditStatus.ordinal() == SupplierAuditStatus.C.ordinal() && auditDate != null ? new DateTime((Object)auditDate).toString("yyyy-MM-dd HH:mm:ss") : ResManager.loadKDString((String)"\u672a\u5f00\u59cb", (String)"RegisterProgressPlugin_2", (String)"scm-mobsp-form", (Object[])new Object[0]);
        String description = String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u65e5\u671f\uff1a\u3010%1$s\u3011\uff0c\u5ba1\u6279\u65e5\u671f\uff1a\u3010%2$s\u3011", (String)"RegisterProgressPlugin_6", (String)"scm-mobsp-form", (Object[])new Object[0]), applyTimeText, auditTimeText);
        stepsOption.setDescription(new LocaleString(description));
        stepsOption.setStatus("edit");
        stepsOptions.add(stepsOption);
        stepsOption = new StepsOption();
        stepsOption.setTitle(new LocaleString(ResManager.loadKDString((String)"\u5ba1\u6838", (String)"RegisterProgressPlugin_5", (String)"scm-mobsp-form", (Object[])new Object[0])));
        stepsOption.setDescription(new LocaleString(""));
        stepsOption.setStatus("audit");
        stepsOptions.add(stepsOption);
        steps.setClientStepsOptions(stepsOptions);
        HashMap<String, Object> currentStepMap = new HashMap<String, Object>();
        currentStepMap.put("currentStep", 1);
        currentStepMap.put("currentStatus", "edit");
        steps.setCurrentStep(currentStepMap);
    }

    private DynamicObject getSupplier() {
        String number = (String)this.getView().getFormShowParameter().getCustomParam("number");
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)number)};
        String fieldIds = StringUtils.joinWith((String)",", (Object[])new Object[]{"id,createtime,auditdate,number,pkId", "status", "auditstatus", "auditdate"});
        DynamicObject supplier = BusinessDataServiceHelper.loadSingle((String)"adm_supplierreg", (String)fieldIds, (QFilter[])filters);
        return supplier;
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "buttonap": {
                this.goToFulfillPage();
                break;
            }
        }
    }

    private void goToFulfillPage() {
        MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        MobileListShowParameter showParameter = new MobileListShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        formShowParameter.setCustomParam("number", this.getModel().getValue("number"));
        formShowParameter.setFormId(INPUT_PAGE);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private static enum SupplierAuditStatus {
        A,
        B,
        C,
        D,
        E,
        F;


        static SupplierAuditStatus getAuditStatus(DynamicObject supplier) {
            String status = supplier.getString("auditstatus");
            if (status == null) {
                return null;
            }
            return SupplierAuditStatus.valueOf(status.toUpperCase());
        }
    }
}

