/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.plugin.form.scp.register.portal;

import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.RefreshResultType;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.MobileListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.MobileFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scm.mobsp.common.helper.SupplierPortalQuoNoticeHelper;
import kd.scm.mobsp.plugin.form.scp.register.RegisterPluginHelper;
import kd.scmc.msmob.common.utils.FormUtils;

public class SupplierPortalPlugin
extends AbstractMobBillPlugIn
implements RowClickEventListener {
    private static final Log LOG = LogFactory.getLog(SupplierPortalPlugin.class);
    private static final String ORG = "org";
    private static final String BILLDATE = "billdate";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String MOB_ID = "mobid";
    private static final String BILL_STATUS = "billstatus";
    private static final String BILL_NO = "billno";
    private static final String MOBSP_QUONOTICE_VIEW = "mobsp_quonotice_view";
    private static final String REGISTER_LINK = "register_link";
    private static final String REGISTER_PAGE = "mobsp_register";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addClickListener((AbstractFormPlugin)this, (String[])new String[]{"mobsp_quonotice_list", "announcementlinktorfm", "announcementlinktorfmlab", REGISTER_LINK});
        EntryGrid control = (EntryGrid)this.getControl(ENTRY_ENTITY);
        control.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        RegisterPluginHelper.setLogoImage((AbstractFormPlugin)this);
        this.setBottomEnterpriseInfo();
        this.displayQuoNotice();
    }

    private void setBottomEnterpriseInfo() {
        DynamicObject enterpriseInfo = BusinessDataServiceHelper.loadSingle((String)"srm_enterprise", (String)"entryentity,entryentity.information", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"srm_enterprise")});
        DynamicObjectCollection entryentity = enterpriseInfo.getDynamicObjectCollection(ENTRY_ENTITY);
        DynamicObject dynamicObject = (DynamicObject)entryentity.get(entryentity.size() - 1);
        String text = dynamicObject.getString("information");
        Label label = (Label)this.getControl("bottomenterpriseinfo");
        label.setText(text);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        MobileListShowParameter showParameter = new MobileListShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        switch (key) {
            case "announcementlinktorfmflex": 
            case "announcementlinktorfm": 
            case "announcementlinktorfmlab": {
                formShowParameter.setFormId("mobsp_quonotice_list");
                formShowParameter.setCustomParam("isFromSupplierPortal", (Object)true);
                this.getView().showForm((FormShowParameter)formShowParameter);
                break;
            }
            case "register_link": {
                formShowParameter.setFormId(REGISTER_PAGE);
                this.getView().showForm((FormShowParameter)formShowParameter);
                break;
            }
        }
    }

    public void entryRowClick(RowClickEvent e) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Control source = (Control)e.getSource();
        String entryKey = source.getKey();
        if (ENTRY_ENTITY.equals(entryKey)) {
            MobileFormShowParameter showParameter = new MobileFormShowParameter();
            int rowIndex = e.getRow();
            Long billId = (Long)model.getValue(MOB_ID, rowIndex);
            String billNo = (String)model.getValue(BILL_NO, rowIndex);
            if (billId == null && StringUtils.isEmpty((CharSequence)billNo)) {
                String errMsg = String.format(ResManager.loadKDString((String)"%s\uff1a\u5f53\u524d\u5355\u636e\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5355\u636e\u3002", (String)"AppHomeNewPlugin_9", (String)"scm-mobsp-form", (Object[])new Object[0]), billNo);
                view.showErrorNotification(errMsg);
                this.displayQuoNotice();
                return;
            }
            showParameter.setCustomParam("billid", (Object)billId);
            showParameter.setCustomParam("visibleOfOtherInformation", (Object)false);
            showParameter.setCustomParam(BILL_NO, (Object)billNo);
            showParameter.setFormId(MOBSP_QUONOTICE_VIEW);
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            view.showForm((FormShowParameter)showParameter);
        }
    }

    public void refreshData() {
        this.displayQuoNotice();
        MobileFormView view = (MobileFormView)this.getView();
        view.setRefreshResult(ResManager.loadKDString((String)"\u5237\u65b0\u6210\u529f", (String)"AppHomeNewPlugin_1", (String)"scm-mobsp-form", (Object[])new Object[0]), Integer.valueOf(3000), RefreshResultType.Success);
    }

    private void displayQuoNotice() {
        List quoFilter = (List)DispatchServiceHelper.invokeBizService((String)"scm", (String)"quo", (String)"IQuoFilterService", (String)"getNoticeListFilter", (Object[])new Object[0]);
        QFilter qFilter = new QFilter("supscope", "=", (Object)"1");
        quoFilter.add(qFilter);
        DynamicObject[] queryQuoNotice = SupplierPortalQuoNoticeHelper.getQueryQuoNotice(quoFilter);
        this.setQuoNoticeEntry(queryQuoNotice);
    }

    private void setQuoNoticeEntry(DynamicObject[] quoNoticeResult) {
        IDataModel model = this.getModel();
        if (quoNoticeResult != null && quoNoticeResult.length != 0) {
            model.deleteEntryData(ENTRY_ENTITY);
            model.batchCreateNewEntryRow(ENTRY_ENTITY, quoNoticeResult.length);
            for (int i = 0; i < quoNoticeResult.length; ++i) {
                model.setValue(MOB_ID, quoNoticeResult[i].get("id"), i);
                model.setValue(BILL_STATUS, quoNoticeResult[i].get(BILL_STATUS), i);
                model.setValue(BILL_NO, quoNoticeResult[i].get(BILL_NO), i);
                model.setValue("noticetitle", quoNoticeResult[i].get("noticetitle"), i);
                model.setValue("quoorg", quoNoticeResult[i].get(ORG), i);
                model.setValue("biztime", quoNoticeResult[i].get(BILLDATE), i);
                model.setValue("biztype", quoNoticeResult[i].get("biztype"), i);
                model.setValue("istop", (Object)quoNoticeResult[i].getBoolean("istop"), i);
            }
        } else {
            model.deleteEntryData(ENTRY_ENTITY);
        }
        this.getView().updateView();
    }
}

